/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.query.parser;

import com.hp.hpl.jena.rdf.query.Constraint;
import com.hp.hpl.jena.rdf.query.Environment;
import com.hp.hpl.jena.rdf.query.EvalFailureException;
import com.hp.hpl.jena.rdf.query.Query;
import com.hp.hpl.jena.rdf.query.Sys;
import com.hp.hpl.jena.rdf.query.parser.Expr;

public class ConstraintExpr
implements Constraint {
    Expr expr;

    ConstraintExpr(Expr expr) {
        this.expr = expr;
    }

    public boolean isSatified(Query query, Environment environment) {
        if (this.expr == null) {
            return false;
        }
        try {
            return this.expr.eval(query, environment).getBoolean();
        }
        catch (EvalFailureException evalFailureException) {
            return false;
        }
        catch (Exception exception) {
            Sys.unhandledException(exception, "ConstraintExpr", "isSatified");
            return false;
        }
    }

    public String toString() {
        return this.expr.asInfixString();
    }
}

