/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.query;

import com.hp.hpl.jena.rdf.query.RDQL_InternalErrorException;
import com.hp.hpl.jena.rdf.query.Sys;
import com.hp.hpl.jena.rdf.query.Value;
import com.hp.hpl.jena.rdf.query.WorkingVar;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import java.util.ArrayList;
import java.util.List;

public class Environment {
    Environment parent = null;
    List varNames = new ArrayList();
    List values = new ArrayList();

    public int add(String string, Value value) {
        Sys.assert(string != null, "Null variable name", "Environment", "add");
        Sys.assert(this.varNames.size() == this.values.size(), "Lists out of step", "Environment", "add");
        this.varNames.add(string);
        this.values.add(value);
        this.check();
        return this.varNames.size() - 1;
    }

    public int add(String string, RDFNode rDFNode) {
        Sys.assert(string != null, "Null variable name", "Environment", "add");
        Sys.assert(this.varNames.size() == this.values.size(), "Lists out of step", "Environment", "add");
        this.varNames.add(string);
        this.values.add(rDFNode);
        this.check();
        return this.varNames.size() - 1;
    }

    public Object get(String string) {
        Sys.assert(string != null, "Null variable name", "Environment", "get");
        Sys.assert(this.varNames.size() == this.values.size(), "Lists out of step", "Environment", "get");
        return this.lookup(string, 0);
    }

    private Object lookup(String string, int n) {
        int n2 = n;
        while (n2 < this.varNames.size()) {
            if (string.equals((String)this.varNames.get(n2))) {
                Object e = this.values.get(n2);
                return this.values.get(n2);
            }
            ++n2;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.lookup(string, 0);
    }

    public Value getValue(String string) {
        Object object = this.get(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Value) {
            return (Value)object;
        }
        if (object instanceof Resource) {
            String string2 = ((Resource)object).getURI();
            WorkingVar workingVar = new WorkingVar();
            if (string2 == null || string2.length() == 0) {
                try {
                    string2 = "anon:" + ((Resource)object).getId();
                }
                catch (RDFException rDFException) {
                    throw new RDQL_InternalErrorException("Environment: error on anon resource");
                }
            }
            workingVar.setURI(string2);
            return workingVar;
        }
        if (object instanceof RDFNode) {
            WorkingVar workingVar = new WorkingVar();
            workingVar.setString(object.toString());
            return workingVar;
        }
        throw new RDQL_InternalErrorException("Environment: unexpected object class: " + object.getClass().getName());
    }

    public void setParent(Environment environment) {
        Sys.assert(this.parent == null, "Attempt to change parent", "Environment", "setParent");
        this.parent = environment;
    }

    public int size() {
        int n = this.varNames.size();
        if (this.parent != null) {
            n += this.parent.size();
        }
        return n;
    }

    public void check() {
        int n = 0;
        while (n < this.varNames.size()) {
            String string = (String)this.varNames.get(n);
            Object object = this.lookup(string, n + 1);
            Sys.assert(object == null, "Duplicate binding: " + this, "Environment", "check");
            ++n;
        }
    }

    public String toString() {
        String string;
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        while (n < this.varNames.size()) {
            if (n != 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append("(" + this.varNames.get(n) + ", " + this.values.get(n) + ")");
            ++n;
        }
        if (this.parent != null && (string = this.parent.toString()) != null && string.length() != 0) {
            stringBuffer.append(" ");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

