/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.rdf.arp.ARPErrorNumbers;
import com.hp.hpl.jena.rdf.arp.ARPFilter;
import com.hp.hpl.jena.rdf.arp.ARPQname;
import com.hp.hpl.jena.rdf.arp.ARPResource;
import com.hp.hpl.jena.rdf.arp.ARPString;
import com.hp.hpl.jena.rdf.arp.AResource;
import com.hp.hpl.jena.rdf.arp.DAML;
import com.hp.hpl.jena.rdf.arp.ParseException;
import com.hp.hpl.jena.rdf.arp.ParserSupport;
import com.hp.hpl.jena.rdf.arp.RDFParserConstants;
import com.hp.hpl.jena.rdf.arp.StrToken;
import com.hp.hpl.jena.rdf.arp.Token;
import com.hp.hpl.jena.rdf.arp.TokenManager;
import com.hp.hpl.jena.rdf.arp.TokenPipe;
import com.hp.hpl.jena.rdf.arp.URIReference;
import com.hp.hpl.jena.rdf.arp.Warn;
import com.hp.hpl.jena.rdf.arp.WrappedException;
import com.hp.hpl.jena.rdf.arp.XMLContext;
import com.hp.hpl.jena.util.URIref;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import org.xml.sax.SAXException;

class RDFParser
implements ARPErrorNumbers,
RDFParserConstants {
    ARPFilter arp;
    ParserSupport X;
    int topLevelLiCounter;
    Token startAttr;
    public TokenManager token_source;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[65];
    private final int[] jj_la1_0 = new int[]{57364, 2, 57360, 224, 256, 6656, 57344, 57360, 224, 0x800000, 0x800000, 0x800000, 0x800000, 0x800000, 0x800000, 6656, 0x800000, 57344, 6656, 6656, 32, 0x800000, 0x800000, 0x800000, 57344, 256, 6656, 6656, 6656, 0x111B00, 57360, 224, 256, 6656, 57344, 57344, 57362, 0x800000, 2, 0x800000, 0x800000, 0x200000, 0x800000, 0x400000, 0x800000, 1121248, 57366, 0x800000, 0x800000, 0x800000, 0x200000, 0x800000, 0x400000, 57366, 57360, 57364, 7412704, 1121248, 918528, 0x800000, 7412704, 57366, 0x800000, 57366, 57366};
    private final JJCalls[] jj_2_rtns = new JJCalls[5];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    RDFParser(TokenPipe tokenPipe, ARPFilter aRPFilter) {
        this(tokenPipe);
        this.arp = aRPFilter;
        this.X = new ParserSupport(aRPFilter);
    }

    public final void rdfFile(XMLContext xMLContext) throws ParseException {
        this.topLevelLiCounter = 1;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 2: {
                this.rdf(xMLContext);
                break;
            }
            case 4: 
            case 13: 
            case 14: 
            case 15: {
                this.obj(xMLContext, true);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void white() throws ParseException {
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block3;
                }
            }
            Token token = this.jj_consume_token(1);
            this.X.checkWhite((StrToken)token);
        }
    }

    public final void rdf(XMLContext xMLContext) throws ParseException {
        this.topLevelLiCounter = 1;
        this.jj_consume_token(2);
        xMLContext = this.xmlAttrs(xMLContext);
        this.white();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 4: 
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block3;
                }
            }
            this.obj(xMLContext, true);
            this.white();
        }
        this.jj_consume_token(3);
    }

    public final ARPResource obj(XMLContext xMLContext, boolean bl) throws ParseException {
        ARPResource aRPResource = new ARPResource(this.arp);
        this.description(xMLContext, aRPResource, bl);
        return aRPResource;
    }

    public final void description(XMLContext xMLContext, ARPResource aRPResource, boolean bl) throws ParseException {
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 4: {
                    this.jj_consume_token(4);
                    xMLContext = this.xmlAttrs(xMLContext);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 5: 
                        case 6: 
                        case 7: {
                            this.idAboutAttr(xMLContext, aRPResource, bl);
                            break;
                        }
                        default: {
                            this.jj_la1[3] = this.jj_gen;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 8: {
                            this.bagIdAttr(xMLContext, aRPResource);
                            break;
                        }
                        default: {
                            this.jj_la1[4] = this.jj_gen;
                            break;
                        }
                    }
                    block18: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 9: 
                            case 11: 
                            case 12: {
                                break;
                            }
                            default: {
                                this.jj_la1[5] = this.jj_gen;
                                break block18;
                            }
                        }
                        this.propAttr(xMLContext, aRPResource);
                    }
                    this.white();
                    block19: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 13: 
                            case 14: 
                            case 15: {
                                break;
                            }
                            default: {
                                this.jj_la1[6] = this.jj_gen;
                                break block19;
                            }
                        }
                        this.propertyElt(xMLContext, aRPResource);
                        this.white();
                    }
                    this.jj_consume_token(3);
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    this.typedNode(xMLContext, aRPResource, bl);
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (ParseException parseException) {
            this.error_recovery(parseException);
        }
    }

    public final void idAboutAttr(XMLContext xMLContext, ARPResource aRPResource, boolean bl) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                String string = this.idAttr(xMLContext);
                aRPResource.setAbout(string);
                break;
            }
            case 6: {
                this.aboutAttr(xMLContext, aRPResource);
                break;
            }
            case 7: {
                this.aboutEachAttr(xMLContext, aRPResource, bl);
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final String idAttr(XMLContext xMLContext) throws ParseException {
        this.jj_consume_token(5);
        String string = this.idSymbol(xMLContext);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 23: {
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    break block3;
                }
            }
            this.warning();
        }
        return string;
    }

    public final void aboutAttr(XMLContext xMLContext, ARPResource aRPResource) throws ParseException {
        this.jj_consume_token(6);
        URIReference uRIReference = this.uriReference(xMLContext);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 23: {
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    break block3;
                }
            }
            this.warning();
        }
        aRPResource.setAbout(uRIReference);
    }

    public final void aboutEachAttr(XMLContext xMLContext, ARPResource aRPResource, boolean bl) throws ParseException {
        Token token = this.jj_consume_token(7);
        if (!bl) {
            this.arp.parseWarning(203, token.location, "rdf:aboutEach may only be used at the top level.");
        }
        URIReference uRIReference = this.uriReference(xMLContext);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 23: {
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                    break block3;
                }
            }
            this.warning();
        }
        aRPResource.setAboutEach(uRIReference);
    }

    public final void bagIdAttr(XMLContext xMLContext, ARPResource aRPResource) throws ParseException {
        this.jj_consume_token(8);
        String string = this.idSymbol(xMLContext);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 23: {
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    break block3;
                }
            }
            this.warning();
        }
        aRPResource.setBagId(string);
    }

    public final void propAttr(XMLContext xMLContext, ARPResource aRPResource) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: {
                this.typeAttr(xMLContext, aRPResource);
                break;
            }
            case 9: {
                Token token = this.jj_consume_token(9);
                Token token2 = this.jj_consume_token(10);
                block11: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 23: {
                            break;
                        }
                        default: {
                            this.jj_la1[13] = this.jj_gen;
                            break block11;
                        }
                    }
                    this.warning();
                }
                aRPResource.setPredicateObject(((ARPQname)token).asURIReference(this.arp), new ARPString((StrToken)token2, xMLContext.getLang()));
                break;
            }
            case 11: {
                Token token = this.jj_consume_token(11);
                Token token3 = this.jj_consume_token(10);
                block12: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 23: {
                            break;
                        }
                        default: {
                            this.jj_la1[14] = this.jj_gen;
                            break block12;
                        }
                    }
                    this.warning();
                }
                aRPResource.setMemberObject(((ARPQname)token).asURIReference(this.arp), new ARPString((StrToken)token3, xMLContext.getLang()));
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void typeAttr(XMLContext xMLContext, ARPResource aRPResource) throws ParseException {
        this.jj_consume_token(12);
        URIReference uRIReference = this.uriReference(xMLContext);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 23: {
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    break block3;
                }
            }
            this.warning();
        }
        aRPResource.setType(uRIReference);
    }

    public final void propertyElt(XMLContext xMLContext, ARPResource aRPResource) throws ParseException {
        try {
            Token token = this.propertyEltTag();
            token = (Token)token.clone();
            token.next = null;
            xMLContext = this.xmlAttrs(xMLContext);
            this.propertyEltIdAndValue(xMLContext, aRPResource, token);
            this.jj_consume_token(3);
        }
        catch (ParseException parseException) {
            this.error_recovery(parseException);
        }
    }

    public final Token propertyEltTag() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: {
                Token token = this.jj_consume_token(13);
                return token;
            }
            case 14: {
                Token token = this.jj_consume_token(14);
                return token;
            }
            case 15: {
                Token token = this.jj_consume_token(15);
                return token;
            }
        }
        this.jj_la1[17] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void propertyEltIdAndValue(XMLContext xMLContext, ARPResource aRPResource, Token token) throws ParseException {
        String string = null;
        if (this.jj_2_1(Integer.MAX_VALUE)) {
            String string2 = this.idAttr(xMLContext);
            ARPResource aRPResource2 = new ARPResource(this.arp);
            aRPResource2.setAbout(string2);
            this.bagIdAttr(xMLContext, aRPResource2);
            block9: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 9: 
                    case 11: 
                    case 12: {
                        break;
                    }
                    default: {
                        this.jj_la1[18] = this.jj_gen;
                        break block9;
                    }
                }
                this.propAttr(xMLContext, aRPResource2);
            }
            this.X.createTriple(aRPResource, token, aRPResource2, string);
        } else if (this.jj_2_2(Integer.MAX_VALUE)) {
            String string3 = this.idAttr(xMLContext);
            ARPResource aRPResource3 = new ARPResource(this.arp);
            aRPResource3.setAbout(string3);
            block10: while (true) {
                this.propAttr(xMLContext, aRPResource3);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 9: 
                    case 11: 
                    case 12: {
                        continue block10;
                    }
                }
                break;
            }
            this.jj_la1[19] = this.jj_gen;
            this.X.createTriple(aRPResource, token, aRPResource3, string);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: {
                    string = this.idAttr(xMLContext);
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                }
            }
            Object object = this.propEltValue(xMLContext);
            this.X.createTriple(aRPResource, token, object, string);
        }
    }

    public final Object propEltValue(XMLContext xMLContext) throws ParseException {
        if (this.jj_2_3(2)) {
            this.jj_consume_token(16);
            Token token = this.jj_consume_token(17);
            String string = ((StrToken)token).value;
            token = null;
            block30: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 23: {
                        break;
                    }
                    default: {
                        this.jj_la1[21] = this.jj_gen;
                        break block30;
                    }
                }
                this.warning();
            }
            String string2 = this.litValue();
            return new ARPString(string2, xMLContext.getLang(), string);
        }
        if (this.jj_2_4(2)) {
            this.jj_consume_token(16);
            this.jj_consume_token(18);
            block31: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 23: {
                        break;
                    }
                    default: {
                        this.jj_la1[22] = this.jj_gen;
                        break block31;
                    }
                }
                this.warning();
            }
            this.white();
            AResource aResource = this.damlCollection(xMLContext);
            return aResource;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 16: {
                this.jj_consume_token(16);
                this.jj_consume_token(19);
                block32: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 23: {
                            break;
                        }
                        default: {
                            this.jj_la1[23] = this.jj_gen;
                            break block32;
                        }
                    }
                    this.warning();
                }
                ARPResource aRPResource = new ARPResource(this.arp);
                this.white();
                block33: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 13: 
                        case 14: 
                        case 15: {
                            break;
                        }
                        default: {
                            this.jj_la1[24] = this.jj_gen;
                            break block33;
                        }
                    }
                    this.propertyElt(xMLContext, aRPResource);
                    this.white();
                }
                return aRPResource;
            }
            case 20: {
                ARPResource aRPResource = new ARPResource(this.arp);
                this.resourceAttr(xMLContext, aRPResource);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: {
                        this.bagIdAttr(xMLContext, aRPResource);
                        break;
                    }
                    default: {
                        this.jj_la1[25] = this.jj_gen;
                        break;
                    }
                }
                block34: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 9: 
                        case 11: 
                        case 12: {
                            break;
                        }
                        default: {
                            this.jj_la1[26] = this.jj_gen;
                            break block34;
                        }
                    }
                    this.propAttr(xMLContext, aRPResource);
                }
                return aRPResource;
            }
            case 9: 
            case 11: 
            case 12: {
                ARPResource aRPResource = new ARPResource(this.arp);
                block35: while (true) {
                    this.propAttr(xMLContext, aRPResource);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 9: 
                        case 11: 
                        case 12: {
                            continue block35;
                        }
                    }
                    break;
                }
                this.jj_la1[27] = this.jj_gen;
                return aRPResource;
            }
            case 8: {
                ARPResource aRPResource = new ARPResource(this.arp);
                this.bagIdAttr(xMLContext, aRPResource);
                block36: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 9: 
                        case 11: 
                        case 12: {
                            break;
                        }
                        default: {
                            this.jj_la1[28] = this.jj_gen;
                            break block36;
                        }
                    }
                    this.propAttr(xMLContext, aRPResource);
                }
                return aRPResource;
            }
        }
        this.jj_la1[29] = this.jj_gen;
        Object object = this.value(xMLContext);
        return object;
    }

    public final AResource damlCollection(XMLContext xMLContext) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: 
            case 13: 
            case 14: 
            case 15: {
                ARPResource aRPResource = new ARPResource(this.arp);
                ARPResource aRPResource2 = this.obj(xMLContext, false);
                this.white();
                AResource aResource = this.damlCollection(xMLContext);
                aRPResource.setPredicateObject(DAML.first, aRPResource2, null);
                aRPResource.setPredicateObject(DAML.rest, aResource, null);
                aRPResource.setType(DAML.List);
                return aRPResource;
            }
        }
        this.jj_la1[30] = this.jj_gen;
        return DAML.nil;
    }

    public final void typedNode(XMLContext xMLContext, ARPResource aRPResource, boolean bl) throws ParseException {
        Token token = this.typedNodeTag(bl);
        token = (Token)token.clone();
        token.next = null;
        xMLContext = this.xmlAttrs(xMLContext);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 6: 
            case 7: {
                this.idAboutAttr(xMLContext, aRPResource, bl);
                break;
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                this.bagIdAttr(xMLContext, aRPResource);
                break;
            }
            default: {
                this.jj_la1[32] = this.jj_gen;
                break;
            }
        }
        block12: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 9: 
                case 11: 
                case 12: {
                    break;
                }
                default: {
                    this.jj_la1[33] = this.jj_gen;
                    break block12;
                }
            }
            this.propAttr(xMLContext, aRPResource);
        }
        this.white();
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
                default: {
                    this.jj_la1[34] = this.jj_gen;
                    break block13;
                }
            }
            this.propertyElt(xMLContext, aRPResource);
            this.white();
        }
        aRPResource.setType(((ARPQname)token).asURIReference(this.arp));
        this.jj_consume_token(3);
    }

    public final Token typedNodeTag(boolean bl) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: {
                Token token = this.jj_consume_token(13);
                return token;
            }
            case 15: {
                Token token = this.jj_consume_token(15);
                this.arp.parseWarning(114, token.location, ((ARPQname)token).qName + " is being used as a type.");
                return token;
            }
            case 14: {
                int n;
                Token token = this.jj_consume_token(14);
                this.arp.parseWarning(114, token.location, ((ARPQname)token).qName + " is being used as a type.");
                if (bl) {
                    int n2 = this.topLevelLiCounter;
                    n = n2;
                    this.topLevelLiCounter = n2 + 1;
                } else {
                    n = 1;
                }
                int n3 = n;
                return new ARPQname(15, token.location, ARPFilter.rdfns, "_" + n3, "rdf:_" + n3);
            }
        }
        this.jj_la1[35] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Object value(XMLContext xMLContext) throws ParseException {
        if (this.jj_2_5(Integer.MAX_VALUE)) {
            ARPString aRPString = this.string(xMLContext);
            return aRPString;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 4: 
            case 13: 
            case 14: 
            case 15: {
                this.white();
                ARPResource aRPResource = this.obj(xMLContext, false);
                this.white();
                return aRPResource;
            }
        }
        this.jj_la1[36] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void resourceAttr(XMLContext xMLContext, ARPResource aRPResource) throws ParseException {
        this.jj_consume_token(20);
        URIReference uRIReference = this.uriReference(xMLContext);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 23: {
                    break;
                }
                default: {
                    this.jj_la1[37] = this.jj_gen;
                    break block3;
                }
            }
            this.warning();
        }
        aRPResource.setAbout(uRIReference);
    }

    public final URIReference uriReference(XMLContext xMLContext) throws ParseException {
        Token token = this.jj_consume_token(10);
        return this.X.makeURIReference(xMLContext, token);
    }

    public final String idSymbol(XMLContext xMLContext) throws ParseException {
        Token token = this.jj_consume_token(10);
        StrToken strToken = (StrToken)token;
        this.X.checkIdSymbol(xMLContext, strToken);
        return xMLContext.getBase() + "#" + URIref.encode(strToken.value);
    }

    public final ARPString string(XMLContext xMLContext) throws ParseException {
        String string = xMLContext.getLang();
        ARPString aRPString = new ARPString("", string);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: {
                    break;
                }
                default: {
                    this.jj_la1[38] = this.jj_gen;
                    break block3;
                }
            }
            ARPString aRPString2 = this.string1(string);
            aRPString = aRPString.quickConcatenate(aRPString2);
        }
        return aRPString;
    }

    public final ARPString string1(String string) throws ParseException {
        Token token = this.jj_consume_token(1);
        return new ARPString((StrToken)token, string);
    }

    public final XMLContext xmlAttrs(XMLContext xMLContext) throws ParseException {
        this.startAttr = this.getToken(1);
        block15: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 23: {
                    break;
                }
                default: {
                    this.jj_la1[39] = this.jj_gen;
                    break block15;
                }
            }
            this.warning();
        }
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 21: {
                xMLContext = this.xmlBase(xMLContext);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 23: {
                            break;
                        }
                        default: {
                            this.jj_la1[40] = this.jj_gen;
                            break block3;
                        }
                    }
                    this.warning();
                }
            }
            default: {
                this.jj_la1[41] = this.jj_gen;
            }
        }
        block9 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 22: {
                xMLContext = this.xmlLang(xMLContext);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 23: {
                            break;
                        }
                        default: {
                            this.jj_la1[42] = this.jj_gen;
                            break block9;
                        }
                    }
                    this.warning();
                }
            }
            default: {
                this.jj_la1[43] = this.jj_gen;
            }
        }
        return xMLContext;
    }

    public final XMLContext xmlBase(XMLContext xMLContext) throws ParseException {
        this.jj_consume_token(21);
        Token token = this.jj_consume_token(10);
        return this.X.changeXMLBase(xMLContext, token);
    }

    public final XMLContext xmlLang(XMLContext xMLContext) throws ParseException {
        this.jj_consume_token(22);
        Token token = this.jj_consume_token(10);
        StrToken strToken = (StrToken)token;
        this.X.checkXMLLang(strToken);
        return xMLContext.withLang(strToken.value);
    }

    public final void warning() throws ParseException {
        Token token = this.jj_consume_token(23);
        this.arp.parseWarning((Warn)token);
    }

    public final void entity(XMLContext xMLContext) throws ParseException {
        this.startEntity();
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 23: {
                    break;
                }
                default: {
                    this.jj_la1[44] = this.jj_gen;
                    break block9;
                }
            }
            this.nowarning();
        }
        xMLContext = this.xmlAttrsNoWarnings(xMLContext);
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 11: 
                case 12: 
                case 16: 
                case 20: {
                    break;
                }
                default: {
                    this.jj_la1[45] = this.jj_gen;
                    break block10;
                }
            }
            this.attr();
        }
        block11: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 2: 
                case 4: 
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
                default: {
                    this.jj_la1[46] = this.jj_gen;
                    break block11;
                }
            }
            this.content(xMLContext);
        }
        this.jj_consume_token(3);
    }

    public final void attr() throws ParseException {
        this.attrName();
        this.attrValue();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 23: {
                    break;
                }
                default: {
                    this.jj_la1[47] = this.jj_gen;
                    break block3;
                }
            }
            this.nowarning();
        }
    }

    public final void nowarning() throws ParseException {
        this.jj_consume_token(23);
    }

    public final XMLContext xmlAttrsNoWarnings(XMLContext xMLContext) throws ParseException {
        this.startAttr = this.getToken(1);
        block15: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 23: {
                    break;
                }
                default: {
                    this.jj_la1[48] = this.jj_gen;
                    break block15;
                }
            }
            this.warning();
        }
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 21: {
                xMLContext = this.xmlBase(xMLContext);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 23: {
                            break;
                        }
                        default: {
                            this.jj_la1[49] = this.jj_gen;
                            break block3;
                        }
                    }
                    this.nowarning();
                }
            }
            default: {
                this.jj_la1[50] = this.jj_gen;
            }
        }
        block9 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 22: {
                xMLContext = this.xmlLang(xMLContext);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 23: {
                            break;
                        }
                        default: {
                            this.jj_la1[51] = this.jj_gen;
                            break block9;
                        }
                    }
                    this.nowarning();
                }
            }
            default: {
                this.jj_la1[52] = this.jj_gen;
            }
        }
        return xMLContext;
    }

    public final void content(XMLContext xMLContext) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 2: {
                this.rdf(xMLContext);
                break;
            }
            case 1: {
                this.jj_consume_token(1);
                break;
            }
            case 4: 
            case 13: 
            case 14: 
            case 15: {
                this.entity(xMLContext);
                break;
            }
            default: {
                this.jj_la1[53] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void startEntity() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: {
                this.jj_consume_token(4);
                break;
            }
            case 14: {
                this.jj_consume_token(14);
                break;
            }
            case 13: {
                this.jj_consume_token(13);
                break;
            }
            case 15: {
                this.jj_consume_token(15);
                break;
            }
            default: {
                this.jj_la1[54] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final Token litStartEntity() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: {
                Token token = this.jj_consume_token(4);
                return token;
            }
            case 14: {
                Token token = this.jj_consume_token(14);
                return token;
            }
            case 13: {
                Token token = this.jj_consume_token(13);
                return token;
            }
            case 15: {
                Token token = this.jj_consume_token(15);
                return token;
            }
            case 2: {
                Token token = this.jj_consume_token(2);
                return token;
            }
        }
        this.jj_la1[55] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Token litAttrName() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                Token token = this.jj_consume_token(6);
                return token;
            }
            case 7: {
                Token token = this.jj_consume_token(7);
                return token;
            }
            case 8: {
                Token token = this.jj_consume_token(8);
                return token;
            }
            case 5: {
                Token token = this.jj_consume_token(5);
                return token;
            }
            case 9: {
                Token token = this.jj_consume_token(9);
                return token;
            }
            case 16: {
                Token token = this.jj_consume_token(16);
                return token;
            }
            case 11: {
                Token token = this.jj_consume_token(11);
                return token;
            }
            case 20: {
                Token token = this.jj_consume_token(20);
                return token;
            }
            case 12: {
                Token token = this.jj_consume_token(12);
                return token;
            }
            case 21: {
                Token token = this.jj_consume_token(21);
                return token;
            }
            case 22: {
                Token token = this.jj_consume_token(22);
                return token;
            }
        }
        this.jj_la1[56] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void attrName() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                this.jj_consume_token(6);
                break;
            }
            case 7: {
                this.jj_consume_token(7);
                break;
            }
            case 8: {
                this.jj_consume_token(8);
                break;
            }
            case 5: {
                this.jj_consume_token(5);
                break;
            }
            case 9: {
                this.jj_consume_token(9);
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                break;
            }
            case 11: {
                this.jj_consume_token(11);
                break;
            }
            case 20: {
                this.jj_consume_token(20);
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                break;
            }
            default: {
                this.jj_la1[57] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final Token attrValue() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                Token token = this.jj_consume_token(10);
                return token;
            }
            case 17: {
                Token token = this.jj_consume_token(17);
                return token;
            }
            case 18: {
                Token token = this.jj_consume_token(18);
                return token;
            }
            case 19: {
                Token token = this.jj_consume_token(19);
                return token;
            }
        }
        this.jj_la1[58] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void litEntity(StringBuffer stringBuffer, Map map) throws ParseException {
        Token token = this.litStartEntity();
        map = this.X.startLitEnt(stringBuffer, token, map);
        token = (Token)token.clone();
        token.next = null;
        this.startAttr = this.getToken(1);
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 23: {
                    break;
                }
                default: {
                    this.jj_la1[59] = this.jj_gen;
                    break block9;
                }
            }
            this.nowarning();
        }
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 11: 
                case 12: 
                case 16: 
                case 20: 
                case 21: 
                case 22: {
                    break;
                }
                default: {
                    this.jj_la1[60] = this.jj_gen;
                    break block10;
                }
            }
            map = this.litAttr(stringBuffer, map);
        }
        stringBuffer.append('>');
        block11: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 2: 
                case 4: 
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
                default: {
                    this.jj_la1[61] = this.jj_gen;
                    break block11;
                }
            }
            this.litContent(stringBuffer, map);
        }
        this.jj_consume_token(3);
        this.X.endLitEnt(stringBuffer, token);
    }

    public final Map litAttr(StringBuffer stringBuffer, Map map) throws ParseException {
        Token token = this.litAttrName();
        map = this.X.litAttrName(stringBuffer, token, map);
        token = this.attrValue();
        this.X.litAttrValue(stringBuffer, token);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 23: {
                    break;
                }
                default: {
                    this.jj_la1[62] = this.jj_gen;
                    break block3;
                }
            }
            this.nowarning();
        }
        return map;
    }

    public final void litContent(StringBuffer stringBuffer, Map map) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: {
                Token token = this.jj_consume_token(1);
                this.X.litText(stringBuffer, token);
                break;
            }
            case 2: 
            case 4: 
            case 13: 
            case 14: 
            case 15: {
                this.litEntity(stringBuffer, map);
                break;
            }
            default: {
                this.jj_la1[63] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final String litValue() throws ParseException {
        StringBuffer stringBuffer = new StringBuffer();
        Map map = this.X.xmlNameSpace();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 2: 
                case 4: 
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
                default: {
                    this.jj_la1[64] = this.jj_gen;
                    break block3;
                }
            }
            this.litContent(stringBuffer, map);
        }
        return stringBuffer.toString();
    }

    void error_recovery(ParseException parseException) throws ParseException, ParseException {
        parseException.setStartAttribute(this.startAttr);
        if (parseException.getFatal()) {
            throw parseException;
        }
        try {
            this.arp.getErrorHandler().error(parseException);
        }
        catch (SAXException sAXException) {
            if (sAXException == parseException) {
                parseException.setFatal(true);
                throw parseException;
            }
            throw new WrappedException(sAXException);
        }
        int n = 1;
        do {
            Token token = this.getNextToken();
            switch (token.kind) {
                case 0: {
                    ParseException parseException2 = new ParseException(300, "Error recovery failed.");
                    parseException2.setFatal(true);
                    throw parseException2;
                }
                case 3: {
                    --n;
                    break;
                }
                case 2: 
                case 4: 
                case 13: 
                case 14: 
                case 15: {
                    ++n;
                }
            }
        } while (n > 0);
    }

    private final boolean jj_2_1(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_1();
        this.jj_save(0, n);
        return bl;
    }

    private final boolean jj_2_2(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_2();
        this.jj_save(1, n);
        return bl;
    }

    private final boolean jj_2_3(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_3();
        this.jj_save(2, n);
        return bl;
    }

    private final boolean jj_2_4(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_4();
        this.jj_save(3, n);
        return bl;
    }

    private final boolean jj_2_5(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_5();
        this.jj_save(4, n);
        return bl;
    }

    private final boolean jj_3_5() {
        Token token;
        block3: {
            do {
                token = this.jj_scanpos;
                if (this.jj_3R_43()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = token;
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_54() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_40() {
        Token token;
        block5: {
            if (this.jj_scan_token(5)) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            if (this.jj_3R_44()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                token = this.jj_scanpos;
                if (this.jj_3R_45()) break block5;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3_4() {
        if (this.jj_scan_token(16)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(18)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_46() {
        if (this.jj_3R_50()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_41() {
        Token token;
        block5: {
            if (this.jj_scan_token(8)) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            if (this.jj_3R_44()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                token = this.jj_scanpos;
                if (this.jj_3R_46()) break block5;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3_2() {
        if (this.jj_3R_40()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_42()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_55() {
        if (this.jj_3R_50()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_51() {
        Token token;
        block5: {
            if (this.jj_scan_token(12)) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            if (this.jj_3R_54()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                token = this.jj_scanpos;
                if (this.jj_3R_55()) break block5;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3_1() {
        if (this.jj_3R_40()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_41()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_3() {
        if (this.jj_scan_token(16)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(17)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_50() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_53() {
        if (this.jj_3R_50()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_49() {
        Token token;
        block5: {
            if (this.jj_scan_token(11)) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            if (this.jj_scan_token(10)) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                token = this.jj_scanpos;
                if (this.jj_3R_53()) break block5;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3R_52() {
        if (this.jj_3R_50()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_44() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_48() {
        Token token;
        block5: {
            if (this.jj_scan_token(9)) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            if (this.jj_scan_token(10)) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                token = this.jj_scanpos;
                if (this.jj_3R_52()) break block5;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3R_42() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_47()) {
            this.jj_scanpos = token;
            if (this.jj_3R_48()) {
                this.jj_scanpos = token;
                if (this.jj_3R_49()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_47() {
        if (this.jj_3R_51()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_43() {
        if (this.jj_scan_token(1)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_45() {
        if (this.jj_3R_50()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    public RDFParser(TokenManager tokenManager) {
        this.token_source = tokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 65) {
            this.jj_la1[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[n2] = new JJCalls();
            ++n2;
        }
    }

    public void ReInit(TokenManager tokenManager) {
        this.token_source = tokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 65) {
            this.jj_la1[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[n2] = new JJCalls();
            ++n2;
        }
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                int n2 = 0;
                while (n2 < this.jj_2_rtns.length) {
                    JJCalls jJCalls = this.jj_2_rtns[n2];
                    while (jJCalls != null) {
                        if (jJCalls.gen < this.jj_gen) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                    ++n2;
                }
            }
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int n) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int n2 = 0;
            Token token = this.token;
            while (token != null && token != this.jj_scanpos) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                this.jj_add_error_token(n, n2);
            }
        }
        return this.jj_scanpos.kind != n;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.lookingAhead ? this.jj_scanpos : this.token;
        int n2 = 0;
        while (n2 < n) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
            ++n2;
        }
        return token;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = n;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            int n3 = 0;
            while (n3 < this.jj_endpos) {
                this.jj_expentry[n3] = this.jj_lasttokens[n3];
                ++n3;
            }
            boolean bl = false;
            Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] nArray = (int[])enumeration.nextElement();
                if (nArray.length != this.jj_expentry.length) continue;
                bl = true;
                int n4 = 0;
                while (n4 < this.jj_expentry.length) {
                    if (nArray[n4] != this.jj_expentry[n4]) {
                        bl = false;
                        break;
                    }
                    ++n4;
                }
                if (bl) break;
            }
            if (!bl) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (n2 != 0) {
                this.jj_endpos = n2;
                this.jj_lasttokens[this.jj_endpos - 1] = n;
            }
        }
    }

    public final ParseException generateParseException() {
        int n;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[24];
        int n2 = 0;
        while (n2 < 24) {
            blArray[n2] = false;
            ++n2;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        int n3 = 0;
        while (n3 < 65) {
            if (this.jj_la1[n3] == this.jj_gen) {
                n = 0;
                while (n < 32) {
                    if ((this.jj_la1_0[n3] & 1 << n) != 0) {
                        blArray[n] = true;
                    }
                    ++n;
                }
            }
            ++n3;
        }
        n = 0;
        while (n < 24) {
            if (blArray[n]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = n;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++n;
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        int n4 = 0;
        while (n4 < this.jj_expentries.size()) {
            nArrayArray[n4] = (int[])this.jj_expentries.elementAt(n4);
            ++n4;
        }
        return new ParseException(this.token, nArrayArray, RDFParserConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        int n = 0;
        while (n < 5) {
            JJCalls jJCalls = this.jj_2_rtns[n];
            do {
                if (jJCalls.gen <= this.jj_gen) continue;
                this.jj_la = jJCalls.arg;
                this.jj_lastpos = this.jj_scanpos = jJCalls.first;
                switch (n) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                    case 1: {
                        this.jj_3_2();
                        break;
                    }
                    case 2: {
                        this.jj_3_3();
                        break;
                    }
                    case 3: {
                        this.jj_3_4();
                        break;
                    }
                    case 4: {
                        this.jj_3_5();
                    }
                }
            } while ((jJCalls = jJCalls.next) != null);
            ++n;
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int n, int n2) {
        JJCalls jJCalls = this.jj_2_rtns[n];
        while (jJCalls.gen > this.jj_gen) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = this.jj_gen + n2 - this.jj_la;
        jJCalls.first = this.token;
        jJCalls.arg = n2;
    }

    static {
        RDFParserConstants.tokenImage[6] = "attribute rdf:about";
        RDFParserConstants.tokenImage[7] = "attribute rdf:aboutEach";
        RDFParserConstants.tokenImage[8] = "attribute rdf:bagID";
        RDFParserConstants.tokenImage[5] = "attribute rdf:ID";
        RDFParserConstants.tokenImage[9] = "property attributes";
        RDFParserConstants.tokenImage[16] = "rdf:parseType";
        RDFParserConstants.tokenImage[20] = "attribute rdf:resource";
        RDFParserConstants.tokenImage[12] = "attribute rdf:type";
        RDFParserConstants.tokenImage[11] = "attribute rdf:rdf_NNN";
        RDFParserConstants.tokenImage[22] = "attribute xml:lang";
        RDFParserConstants.tokenImage[21] = "attribute xml:base";
        RDFParserConstants.tokenImage[19] = "'Resource'";
        RDFParserConstants.tokenImage[17] = "'Literal'";
        RDFParserConstants.tokenImage[10] = "attribute value";
        RDFParserConstants.tokenImage[1] = "XML ELEMENT CONTENT";
        RDFParserConstants.tokenImage[4] = "start element rdf:Description";
        RDFParserConstants.tokenImage[3] = "end element tag";
        RDFParserConstants.tokenImage[14] = "start element rdf:li";
        RDFParserConstants.tokenImage[13] = "general start element tag";
        RDFParserConstants.tokenImage[2] = "start element rdf:RDF";
        RDFParserConstants.tokenImage[15] = "start element rdf:rdf_NNN";
        RDFParserConstants.tokenImage[18] = "'daml:Collection'";
        RDFParserConstants.tokenImage[23] = "";
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

