/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.daml.common;

import com.hp.hpl.jena.daml.DAMLModel;
import com.hp.hpl.jena.daml.DAMLProperty;
import com.hp.hpl.jena.daml.PropertyAccessor;
import com.hp.hpl.jena.daml.common.DAMLCommonImpl;
import com.hp.hpl.jena.daml.common.PropertyAccessorImpl;
import com.hp.hpl.jena.daml.common.PropertyIterator;
import com.hp.hpl.jena.util.ConcatenatedIterator;
import com.hp.hpl.jena.vocabulary.DAMLVocabulary;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.mesa.rdf.jena.vocabulary.RDF;
import com.hp.hpl.mesa.rdf.jena.vocabulary.RDFS;
import java.util.Iterator;

public class DAMLPropertyImpl
extends DAMLCommonImpl
implements DAMLProperty {
    private PropertyAccessor m_propDomain = null;
    private PropertyAccessor m_propRange = null;
    private PropertyAccessor m_propSubPropertyOf = null;
    private PropertyAccessor m_propSamePropertyAs = null;

    public DAMLPropertyImpl(String string, String string2, DAMLModel dAMLModel, DAMLVocabulary dAMLVocabulary) {
        super(string, string2, dAMLModel, dAMLVocabulary);
    }

    public DAMLPropertyImpl(String string, DAMLModel dAMLModel, DAMLVocabulary dAMLVocabulary) {
        super(string, dAMLModel, dAMLVocabulary);
    }

    public String toString() {
        String string = this.getClass().getName();
        int n = string.indexOf("Impl");
        int n2 = string.lastIndexOf(".") + 1;
        string = n > 0 ? string.substring(n2, n) : string.substring(n2);
        String string2 = this.isUnique() ? "unique " : "";
        return this.getURI() == null ? "<" + string2 + "Anonymous " + string + "@" + Integer.toHexString(this.hashCode()) + ">" : "<" + string2 + string + " " + this.getURI() + ">";
    }

    public void setIsUnique(boolean bl) {
        if (bl) {
            this.setRDFType(this.getVocabulary().UniqueProperty(), false);
        } else {
            this.removeProperty(RDF.type, this.getVocabulary().UniqueProperty());
        }
    }

    public boolean isUnique() {
        return this.hasRDFType(this.getVocabulary().UniqueProperty());
    }

    public PropertyAccessor prop_domain() {
        if (this.m_propDomain == null) {
            this.m_propDomain = new PropertyAccessorImpl(this.getVocabulary().domain(), this);
        }
        return this.m_propDomain;
    }

    public PropertyAccessor prop_subPropertyOf() {
        if (this.m_propSubPropertyOf == null) {
            this.m_propSubPropertyOf = new PropertyAccessorImpl(this.getVocabulary().subPropertyOf(), this);
        }
        return this.m_propSubPropertyOf;
    }

    public PropertyAccessor prop_samePropertyAs() {
        if (this.m_propSamePropertyAs == null) {
            this.m_propSamePropertyAs = new PropertyAccessorImpl(this.getVocabulary().samePropertyAs(), this);
        }
        return this.m_propSamePropertyAs;
    }

    public PropertyAccessor prop_range() {
        if (this.m_propRange == null) {
            this.m_propRange = new PropertyAccessorImpl(RDFS.range, this);
        }
        return this.m_propRange;
    }

    public Iterator getSameProperties() {
        return new PropertyIterator(this, this.getVocabulary().samePropertyAs(), this.getVocabulary().samePropertyAs(), true, true);
    }

    public Iterator getEquivalentValues() {
        ConcatenatedIterator concatenatedIterator = new ConcatenatedIterator(super.getEquivalentValues(), new PropertyIterator(this, this.getVocabulary().samePropertyAs(), this.getVocabulary().samePropertyAs(), true, false, false));
        concatenatedIterator.setDefaultValue(this);
        return concatenatedIterator;
    }

    public Iterator getSuperProperties() {
        return new ConcatenatedIterator(new PropertyIterator(this, RDFS.subPropertyOf, null, true, false), new PropertyIterator(this, this.getVocabulary().subPropertyOf(), null, true, false));
    }

    public Iterator getSubProperties() {
        return new ConcatenatedIterator(new PropertyIterator(this, null, RDFS.subPropertyOf, true, false), new PropertyIterator(this, null, this.getVocabulary().subPropertyOf(), true, false));
    }

    public Iterator getDomainClasses() {
        ConcatenatedIterator concatenatedIterator = new ConcatenatedIterator(this.getSelfIterator(), this.getSuperProperties());
        return new PropertyIterator(concatenatedIterator, RDFS.domain, null, false, false);
    }

    public Iterator getRangeClasses() {
        ConcatenatedIterator concatenatedIterator = new ConcatenatedIterator(this.getSelfIterator(), this.getSuperProperties());
        return new PropertyIterator(concatenatedIterator, RDFS.range, null, false, false);
    }

    public int getOrdinal() {
        return 0;
    }

    Object getKey() {
        return DAML_OIL.Property.getURI();
    }
}

