/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.svg;

import com.xerox.VTM.engine.VirtualSpace;
import com.xerox.VTM.engine.VirtualSpaceManager;
import com.xerox.VTM.glyphs.BooleanOps;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.Transparent;
import com.xerox.VTM.glyphs.VBoolShape;
import com.xerox.VTM.glyphs.VCircle;
import com.xerox.VTM.glyphs.VDiamond;
import com.xerox.VTM.glyphs.VEllipse;
import com.xerox.VTM.glyphs.VImage;
import com.xerox.VTM.glyphs.VOctagon;
import com.xerox.VTM.glyphs.VPath;
import com.xerox.VTM.glyphs.VPoint;
import com.xerox.VTM.glyphs.VRectangle;
import com.xerox.VTM.glyphs.VSegment;
import com.xerox.VTM.glyphs.VShape;
import com.xerox.VTM.glyphs.VText;
import com.xerox.VTM.glyphs.VTriangle;
import java.awt.Color;
import java.awt.Image;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGWriter {
    public static final String svgURI = "http://www.w3.org/2000/svg";
    public static final String xlinkURI = "http://www.w3.org/1999/xlink";
    long farWest = 0L;
    long farNorth = 0L;
    Document svgDoc;
    File destinationDir;

    static String abl2c(float f) {
        String string = String.valueOf(f);
        return string.substring(0, string.length() - 2);
    }

    public Document exportVirtualSpace(VirtualSpace virtualSpace, DOMImplementation dOMImplementation, File file) {
        this.destinationDir = file;
        if (dOMImplementation != null) {
            this.svgDoc = dOMImplementation.createDocument(svgURI, "svg", null);
            Element element = this.svgDoc.getDocumentElement();
            long[] lArray = VirtualSpaceManager.findFarmostGlyphCoords(virtualSpace);
            this.farWest = -lArray[0];
            this.farNorth = -lArray[3];
            element.setAttribute("xmlns", svgURI);
            element.setAttribute("xmlns:xlink", xlinkURI);
            element.setAttribute("width", "800");
            element.setAttribute("height", "600");
            element.setAttribute("viewBox", "0 0 " + String.valueOf(lArray[2] - lArray[0]) + " " + String.valueOf(lArray[1] - lArray[3]));
            Vector vector = virtualSpace.getVisibleGlyphs();
            int n = 0;
            while (n < vector.size()) {
                Element element2 = this.processGlyph(vector.elementAt(n));
                element.appendChild(element2);
                ++n;
            }
            return this.svgDoc;
        }
        return null;
    }

    private Element processGlyph(Object object) {
        if (object instanceof VEllipse) {
            return this.createEllipse((VEllipse)object);
        }
        if (object instanceof VRectangle) {
            return this.createRect((VRectangle)object);
        }
        if (object instanceof VPath) {
            return this.createPath((VPath)object);
        }
        if (object instanceof VText) {
            return this.createText((VText)object);
        }
        if (object instanceof VTriangle) {
            return this.createPolygon((VTriangle)object);
        }
        if (object instanceof VCircle) {
            return this.createCircle((VCircle)object);
        }
        if (object instanceof VDiamond) {
            return this.createPolygon((VDiamond)object);
        }
        if (object instanceof VOctagon) {
            return this.createPolygon((VOctagon)object);
        }
        if (object instanceof VPoint) {
            return this.createPoint((VPoint)object);
        }
        if (object instanceof VSegment) {
            return this.createLine((VSegment)object);
        }
        if (object instanceof VShape) {
            return this.createPolygon((VShape)object);
        }
        if (object instanceof VImage) {
            return this.createImage((VImage)object);
        }
        if (object instanceof VBoolShape) {
            return this.createPath((VBoolShape)object);
        }
        System.err.println("There is currently no support for outputing this glyph as SVG: " + object);
        return null;
    }

    private String shapeColors(Glyph glyph) {
        Color color = glyph.getColor();
        Color color2 = glyph.getColorb();
        String string = glyph.getFillStatus() ? "fill:rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")" : "fill:none";
        string = glyph.getPaintBorderStatus() ? string + ";stroke:rgb(" + color2.getRed() + "," + color2.getGreen() + "," + color2.getBlue() + ")" : string + ";stroke:none";
        if (glyph instanceof Transparent) {
            string = string + ";fill-opacity:" + String.valueOf(((Transparent)((Object)glyph)).getTransparencyValue());
        }
        return string;
    }

    private Element shapeText(Glyph glyph) {
        Element element = this.svgDoc.createElementNS(svgURI, "text");
        element.setAttribute("x", String.valueOf(glyph.vx + this.farWest));
        element.setAttribute("y", String.valueOf(-glyph.vy + this.farNorth));
        element.appendChild(this.svgDoc.createTextNode(glyph.getText()));
        Color color = glyph.getColorb();
        String string = "stroke:rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ");fill:rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
        element.setAttribute("style", "font-family:" + glyph.getFont().getFamily() + ";font-size:" + glyph.getFont().getSize() + ";" + string);
        return element;
    }

    private Element createGroup() {
        Element element = this.svgDoc.createElementNS(svgURI, "g");
        return element;
    }

    private Element createEllipse(VEllipse vEllipse) {
        Element element = this.svgDoc.createElementNS(svgURI, "ellipse");
        element.setAttribute("cx", String.valueOf(vEllipse.vx + this.farWest));
        element.setAttribute("cy", String.valueOf(-vEllipse.vy + this.farNorth));
        element.setAttribute("rx", String.valueOf(vEllipse.getWidth()));
        element.setAttribute("ry", String.valueOf(vEllipse.getHeight()));
        element.setAttribute("style", this.shapeColors(vEllipse));
        if (vEllipse.getText() != null) {
            Element element2 = this.createGroup();
            Element element3 = this.shapeText(vEllipse);
            element2.appendChild(element);
            element2.appendChild(element3);
            return element2;
        }
        return element;
    }

    private Element createCircle(VCircle vCircle) {
        Element element = this.svgDoc.createElementNS(svgURI, "circle");
        element.setAttribute("cx", String.valueOf(vCircle.vx + this.farWest));
        element.setAttribute("cy", String.valueOf(-vCircle.vy + this.farNorth));
        element.setAttribute("r", String.valueOf(Math.round(vCircle.getSize())));
        element.setAttribute("style", this.shapeColors(vCircle));
        if (vCircle.getText() != null) {
            Element element2 = this.createGroup();
            Element element3 = this.shapeText(vCircle);
            element2.appendChild(element);
            element2.appendChild(element3);
            return element2;
        }
        return element;
    }

    private Element createRect(VRectangle vRectangle) {
        if (vRectangle.getOrient() == 0.0f) {
            Element element = this.svgDoc.createElementNS(svgURI, "rect");
            element.setAttribute("x", String.valueOf(vRectangle.vx - vRectangle.getWidth() + this.farWest));
            element.setAttribute("y", String.valueOf(-vRectangle.vy - vRectangle.getHeight() + this.farNorth));
            element.setAttribute("width", String.valueOf(2L * vRectangle.getWidth()));
            element.setAttribute("height", String.valueOf(2L * vRectangle.getHeight()));
            element.setAttribute("style", this.shapeColors(vRectangle));
            if (vRectangle.getText() != null) {
                Element element2 = this.createGroup();
                Element element3 = this.shapeText(vRectangle);
                element2.appendChild(element);
                element2.appendChild(element3);
                return element2;
            }
            return element;
        }
        Element element = this.svgDoc.createElementNS(svgURI, "polygon");
        double d = -vRectangle.getWidth();
        double d2 = -vRectangle.getHeight();
        double d3 = vRectangle.getWidth();
        double d4 = vRectangle.getHeight();
        long[] lArray = new long[4];
        long[] lArray2 = new long[4];
        lArray[0] = Math.round(d3 * Math.cos(Math.PI - (double)vRectangle.getOrient()) + d2 * Math.sin(Math.PI - (double)vRectangle.getOrient()) + (double)vRectangle.vx) + this.farWest;
        lArray[1] = Math.round(d * Math.cos(Math.PI - (double)vRectangle.getOrient()) + d2 * Math.sin(Math.PI - (double)vRectangle.getOrient()) + (double)vRectangle.vx) + this.farWest;
        lArray[2] = Math.round(d * Math.cos(Math.PI - (double)vRectangle.getOrient()) + d4 * Math.sin(Math.PI - (double)vRectangle.getOrient()) + (double)vRectangle.vx) + this.farWest;
        lArray[3] = Math.round(d3 * Math.cos(Math.PI - (double)vRectangle.getOrient()) + d4 * Math.sin(Math.PI - (double)vRectangle.getOrient()) + (double)vRectangle.vx) + this.farWest;
        lArray2[0] = -Math.round(d2 * Math.cos(Math.PI - (double)vRectangle.getOrient()) - d3 * Math.sin(Math.PI - (double)vRectangle.getOrient()) + (double)vRectangle.vy) + this.farNorth;
        lArray2[1] = -Math.round(d2 * Math.cos(Math.PI - (double)vRectangle.getOrient()) - d * Math.sin(Math.PI - (double)vRectangle.getOrient()) + (double)vRectangle.vy) + this.farNorth;
        lArray2[2] = -Math.round(d4 * Math.cos(Math.PI - (double)vRectangle.getOrient()) - d * Math.sin(Math.PI - (double)vRectangle.getOrient()) + (double)vRectangle.vy) + this.farNorth;
        lArray2[3] = -Math.round(d4 * Math.cos(Math.PI - (double)vRectangle.getOrient()) - d3 * Math.sin(Math.PI - (double)vRectangle.getOrient()) + (double)vRectangle.vy) + this.farNorth;
        element.setAttribute("points", String.valueOf(lArray[0]) + "," + String.valueOf(lArray2[0]) + " " + String.valueOf(lArray[1]) + "," + String.valueOf(lArray2[1]) + " " + String.valueOf(lArray[2]) + "," + String.valueOf(lArray2[2]) + " " + String.valueOf(lArray[3]) + "," + String.valueOf(lArray2[3]));
        element.setAttribute("style", this.shapeColors(vRectangle));
        if (vRectangle.getText() != null) {
            Element element4 = this.createGroup();
            Element element5 = this.shapeText(vRectangle);
            element4.appendChild(element);
            element4.appendChild(element5);
            return element4;
        }
        return element;
    }

    public String getSVGPathCoordinates(VPath vPath) {
        StringBuffer stringBuffer = new StringBuffer();
        PathIterator pathIterator = vPath.getJava2DPathIterator();
        float[] fArray = new float[6];
        int n = 90;
        while (!pathIterator.isDone()) {
            int n2 = pathIterator.currentSegment(fArray);
            switch (n2) {
                case 0: {
                    if (n != 77) {
                        stringBuffer.append('M');
                    } else {
                        stringBuffer.append(' ');
                    }
                    n = 77;
                    stringBuffer.append(SVGWriter.abl2c(fArray[0] + (float)this.farWest) + " " + SVGWriter.abl2c(fArray[1] + (float)this.farNorth));
                    break;
                }
                case 1: {
                    if (n != 76) {
                        stringBuffer.append('L');
                    } else {
                        stringBuffer.append(' ');
                    }
                    n = 76;
                    stringBuffer.append(SVGWriter.abl2c(fArray[0] + (float)this.farWest) + " " + SVGWriter.abl2c(fArray[1] + (float)this.farNorth));
                    break;
                }
                case 2: {
                    if (n != 81) {
                        stringBuffer.append('Q');
                    } else {
                        stringBuffer.append(' ');
                    }
                    n = 81;
                    stringBuffer.append(SVGWriter.abl2c(fArray[0] + (float)this.farWest) + " " + SVGWriter.abl2c(fArray[1] + (float)this.farNorth) + " " + SVGWriter.abl2c(fArray[2] + (float)this.farWest) + " " + SVGWriter.abl2c(fArray[3] + (float)this.farNorth));
                    break;
                }
                case 3: {
                    if (n != 67) {
                        stringBuffer.append('C');
                    } else {
                        stringBuffer.append(' ');
                    }
                    n = 67;
                    stringBuffer.append(SVGWriter.abl2c(fArray[0] + (float)this.farWest) + " " + SVGWriter.abl2c(fArray[1] + (float)this.farNorth) + " " + SVGWriter.abl2c(fArray[2] + (float)this.farWest) + " " + SVGWriter.abl2c(fArray[3] + (float)this.farNorth) + " " + SVGWriter.abl2c(fArray[4] + (float)this.farWest) + " " + SVGWriter.abl2c(fArray[5] + (float)this.farNorth));
                }
            }
            pathIterator.next();
        }
        return stringBuffer.toString();
    }

    private Element createPath(VPath vPath) {
        Element element = this.svgDoc.createElementNS(svgURI, "path");
        element.setAttribute("d", this.getSVGPathCoordinates(vPath));
        Color color = vPath.getColor();
        String string = "stroke:rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
        element.setAttribute("style", "fill:none;" + string);
        if (vPath.getText() != null) {
            Element element2 = this.createGroup();
            element2.appendChild(element);
            element2.appendChild(this.shapeText(vPath));
            return element2;
        }
        return element;
    }

    private Element createText(VText vText) {
        Element element = this.svgDoc.createElementNS(svgURI, "text");
        element.setAttribute("x", String.valueOf(vText.vx + this.farWest));
        element.setAttribute("y", String.valueOf(-vText.vy + this.farNorth));
        element.appendChild(this.svgDoc.createTextNode(vText.getText()));
        Color color = vText.getColor();
        String string = "stroke:rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ");fill:rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
        element.setAttribute("style", "font-family:" + vText.getFont().getFamily() + ";font-size:" + vText.getFont().getSize() + ";" + string);
        return element;
    }

    private Element createPolygon(VTriangle vTriangle) {
        Element element = this.svgDoc.createElementNS(svgURI, "polygon");
        long[] lArray = new long[3];
        long[] lArray2 = new long[3];
        long l = Math.round(0.866f * vTriangle.getSize());
        long l2 = Math.round(0.5f * vTriangle.getSize());
        lArray[0] = Math.round((double)vTriangle.vx - (double)vTriangle.getSize() * Math.sin(Math.PI - (double)vTriangle.getOrient())) + this.farWest;
        lArray[1] = Math.round((double)vTriangle.vx - (double)l * Math.cos(Math.PI - (double)vTriangle.getOrient()) + (double)l2 * Math.sin(Math.PI - (double)vTriangle.getOrient())) + this.farWest;
        lArray[2] = Math.round((double)vTriangle.vx + (double)l * Math.cos(Math.PI - (double)vTriangle.getOrient()) + (double)l2 * Math.sin(Math.PI - (double)vTriangle.getOrient())) + this.farWest;
        lArray2[0] = -Math.round((double)vTriangle.vy - (double)vTriangle.getSize() * Math.cos(Math.PI - (double)vTriangle.getOrient())) + this.farNorth;
        lArray2[1] = -Math.round((double)vTriangle.vy + (double)l2 * Math.cos(Math.PI - (double)vTriangle.getOrient()) + (double)l * Math.sin(Math.PI - (double)vTriangle.getOrient())) + this.farNorth;
        lArray2[2] = -Math.round((double)vTriangle.vy + (double)l2 * Math.cos(Math.PI - (double)vTriangle.getOrient()) - (double)l * Math.sin(Math.PI - (double)vTriangle.getOrient())) + this.farNorth;
        element.setAttribute("points", String.valueOf(lArray[0]) + "," + String.valueOf(lArray2[0]) + " " + String.valueOf(lArray[1]) + "," + String.valueOf(lArray2[1]) + " " + String.valueOf(lArray[2]) + "," + String.valueOf(lArray2[2]));
        element.setAttribute("style", this.shapeColors(vTriangle));
        if (vTriangle.getText() != null) {
            Element element2 = this.createGroup();
            Element element3 = this.shapeText(vTriangle);
            element2.appendChild(element);
            element2.appendChild(element3);
            return element2;
        }
        return element;
    }

    private Element createPolygon(VDiamond vDiamond) {
        Element element = this.svgDoc.createElementNS(svgURI, "polygon");
        long[] lArray = new long[4];
        long[] lArray2 = new long[4];
        lArray[0] = Math.round((double)vDiamond.vx + (double)vDiamond.getSize() * Math.cos(Math.PI - (double)vDiamond.getOrient())) + this.farWest;
        lArray[1] = Math.round((double)vDiamond.vx - (double)vDiamond.getSize() * Math.sin(Math.PI - (double)vDiamond.getOrient())) + this.farWest;
        lArray[2] = Math.round((double)vDiamond.vx - (double)vDiamond.getSize() * Math.cos(Math.PI - (double)vDiamond.getOrient())) + this.farWest;
        lArray[3] = Math.round((double)vDiamond.vx + (double)vDiamond.getSize() * Math.sin(Math.PI - (double)vDiamond.getOrient())) + this.farWest;
        lArray2[0] = -Math.round((double)vDiamond.vy - (double)vDiamond.getSize() * Math.sin(Math.PI - (double)vDiamond.getOrient())) + this.farNorth;
        lArray2[1] = -Math.round((double)vDiamond.vy - (double)vDiamond.getSize() * Math.cos(Math.PI - (double)vDiamond.getOrient())) + this.farNorth;
        lArray2[2] = -Math.round((double)vDiamond.vy + (double)vDiamond.getSize() * Math.sin(Math.PI - (double)vDiamond.getOrient())) + this.farNorth;
        lArray2[3] = -Math.round((double)vDiamond.vy + (double)vDiamond.getSize() * Math.cos(Math.PI - (double)vDiamond.getOrient())) + this.farNorth;
        element.setAttribute("points", String.valueOf(lArray[0]) + "," + String.valueOf(lArray2[0]) + " " + String.valueOf(lArray[1]) + "," + String.valueOf(lArray2[1]) + " " + String.valueOf(lArray[2]) + "," + String.valueOf(lArray2[2]) + " " + String.valueOf(lArray[3]) + "," + String.valueOf(lArray2[3]));
        element.setAttribute("style", this.shapeColors(vDiamond));
        if (vDiamond.getText() != null) {
            Element element2 = this.createGroup();
            Element element3 = this.shapeText(vDiamond);
            element2.appendChild(element);
            element2.appendChild(element3);
            return element2;
        }
        return element;
    }

    private Element createPolygon(VOctagon vOctagon) {
        Element element = this.svgDoc.createElementNS(svgURI, "polygon");
        long[] lArray = new long[8];
        long[] lArray2 = new long[8];
        float f = vOctagon.getSize() / 2.0f;
        lArray[0] = Math.round((double)vOctagon.getSize() * Math.cos(Math.PI - (double)vOctagon.getOrient()) - (double)f * Math.sin(Math.PI - (double)vOctagon.getOrient()) + (double)vOctagon.vx) + this.farWest;
        lArray[1] = Math.round((double)f * Math.cos(Math.PI - (double)vOctagon.getOrient()) - (double)vOctagon.getSize() * Math.sin(Math.PI - (double)vOctagon.getOrient()) + (double)vOctagon.vx) + this.farWest;
        lArray[2] = Math.round((double)(-f) * Math.cos(Math.PI - (double)vOctagon.getOrient()) - (double)vOctagon.getSize() * Math.sin(Math.PI - (double)vOctagon.getOrient()) + (double)vOctagon.vx) + this.farWest;
        lArray[3] = Math.round((double)(-vOctagon.getSize()) * Math.cos(Math.PI - (double)vOctagon.getOrient()) - (double)f * Math.sin(Math.PI - (double)vOctagon.getOrient()) + (double)vOctagon.vx) + this.farWest;
        lArray[4] = Math.round((double)(-vOctagon.getSize()) * Math.cos(Math.PI - (double)vOctagon.getOrient()) + (double)f * Math.sin(Math.PI - (double)vOctagon.getOrient()) + (double)vOctagon.vx) + this.farWest;
        lArray[5] = Math.round((double)(-f) * Math.cos(Math.PI - (double)vOctagon.getOrient()) + (double)vOctagon.getSize() * Math.sin(Math.PI - (double)vOctagon.getOrient()) + (double)vOctagon.vx) + this.farWest;
        lArray[6] = Math.round((double)f * Math.cos(Math.PI - (double)vOctagon.getOrient()) + (double)vOctagon.getSize() * Math.sin(Math.PI - (double)vOctagon.getOrient()) + (double)vOctagon.vx) + this.farWest;
        lArray[7] = Math.round((double)vOctagon.getSize() * Math.cos(Math.PI - (double)vOctagon.getOrient()) + (double)f * Math.sin(Math.PI - (double)vOctagon.getOrient()) + (double)vOctagon.vx) + this.farWest;
        lArray2[0] = -Math.round((double)(-f) * Math.cos(Math.PI - (double)vOctagon.getOrient()) - (double)vOctagon.getSize() * Math.sin(Math.PI - (double)vOctagon.getOrient()) + (double)vOctagon.vy) + this.farNorth;
        lArray2[1] = -Math.round((double)(-vOctagon.getSize()) * Math.cos(Math.PI - (double)vOctagon.getOrient()) - (double)f * Math.sin(Math.PI - (double)vOctagon.getOrient()) + (double)vOctagon.vy) + this.farNorth;
        lArray2[2] = -Math.round((double)(-vOctagon.getSize()) * Math.cos(Math.PI - (double)vOctagon.getOrient()) + (double)f * Math.sin(Math.PI - (double)vOctagon.getOrient()) + (double)vOctagon.vy) + this.farNorth;
        lArray2[3] = -Math.round((double)(-f) * Math.cos(Math.PI - (double)vOctagon.getOrient()) + (double)vOctagon.getSize() * Math.sin(Math.PI - (double)vOctagon.getOrient()) + (double)vOctagon.vy) + this.farNorth;
        lArray2[4] = -Math.round((double)f * Math.cos(Math.PI - (double)vOctagon.getOrient()) + (double)vOctagon.getSize() * Math.sin(Math.PI - (double)vOctagon.getOrient()) + (double)vOctagon.vy) + this.farNorth;
        lArray2[5] = -Math.round((double)vOctagon.getSize() * Math.cos(Math.PI - (double)vOctagon.getOrient()) + (double)f * Math.sin(Math.PI - (double)vOctagon.getOrient()) + (double)vOctagon.vy) + this.farNorth;
        lArray2[6] = -Math.round((double)vOctagon.getSize() * Math.cos(Math.PI - (double)vOctagon.getOrient()) - (double)f * Math.sin(Math.PI - (double)vOctagon.getOrient()) + (double)vOctagon.vy) + this.farNorth;
        lArray2[7] = -Math.round((double)f * Math.cos(Math.PI - (double)vOctagon.getOrient()) - (double)vOctagon.getSize() * Math.sin(Math.PI - (double)vOctagon.getOrient()) + (double)vOctagon.vy) + this.farNorth;
        element.setAttribute("points", String.valueOf(lArray[0]) + "," + String.valueOf(lArray2[0]) + " " + String.valueOf(lArray[1]) + "," + String.valueOf(lArray2[1]) + " " + String.valueOf(lArray[2]) + "," + String.valueOf(lArray2[2]) + " " + String.valueOf(lArray[3]) + "," + String.valueOf(lArray2[3]) + " " + String.valueOf(lArray[4]) + "," + String.valueOf(lArray2[4]) + " " + String.valueOf(lArray[5]) + "," + String.valueOf(lArray2[5]) + " " + String.valueOf(lArray[6]) + "," + String.valueOf(lArray2[6]) + " " + String.valueOf(lArray[7]) + "," + String.valueOf(lArray2[7]));
        element.setAttribute("style", this.shapeColors(vOctagon));
        if (vOctagon.getText() != null) {
            Element element2 = this.createGroup();
            Element element3 = this.shapeText(vOctagon);
            element2.appendChild(element);
            element2.appendChild(element3);
            return element2;
        }
        return element;
    }

    private Element createPoint(VPoint vPoint) {
        Element element = this.svgDoc.createElementNS(svgURI, "rect");
        element.setAttribute("x", String.valueOf(vPoint.vx + this.farWest));
        element.setAttribute("y", String.valueOf(-vPoint.vy + this.farNorth));
        element.setAttribute("width", "1");
        element.setAttribute("height", "1");
        Color color = vPoint.getColor();
        element.setAttribute("style", "stroke:rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")");
        if (vPoint.getText() != null) {
            Element element2 = this.createGroup();
            Element element3 = this.shapeText(vPoint);
            element2.appendChild(element);
            element2.appendChild(element3);
            return element2;
        }
        return element;
    }

    private Element createLine(VSegment vSegment) {
        Element element = this.svgDoc.createElementNS(svgURI, "line");
        element.setAttribute("x1", String.valueOf(vSegment.vx - vSegment.getWidth() + this.farWest));
        element.setAttribute("y1", String.valueOf(-vSegment.vy - vSegment.getHeight() + this.farNorth));
        element.setAttribute("x2", String.valueOf(vSegment.vx + vSegment.getWidth() + this.farWest));
        element.setAttribute("y2", String.valueOf(-vSegment.vy + vSegment.getHeight() + this.farNorth));
        Color color = vSegment.getColor();
        element.setAttribute("style", "stroke:rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")");
        if (vSegment.getText() != null) {
            Element element2 = this.createGroup();
            Element element3 = this.shapeText(vSegment);
            element2.appendChild(element);
            element2.appendChild(element3);
            return element2;
        }
        return element;
    }

    private Element createPolygon(VShape vShape) {
        Element element = this.svgDoc.createElementNS(svgURI, "polygon");
        float[] fArray = vShape.getVertices();
        double d = -vShape.getOrient();
        long[] lArray = new long[fArray.length];
        long[] lArray2 = new long[fArray.length];
        int n = 0;
        while (n < fArray.length) {
            lArray[n] = Math.round((double)vShape.vx + (double)vShape.getSize() * Math.cos(d) * (double)fArray[n]) + this.farWest;
            lArray2[n] = -Math.round((double)vShape.vy - (double)vShape.getSize() * Math.sin(d) * (double)fArray[n]) + this.farNorth;
            d -= Math.PI * 2 / (double)fArray.length;
            ++n;
        }
        String string = "";
        int n2 = 0;
        while (n2 < fArray.length - 1) {
            string = string + String.valueOf(lArray[n2]) + "," + String.valueOf(lArray2[n2]) + " ";
            ++n2;
        }
        string = string + String.valueOf(lArray[fArray.length - 1]) + "," + String.valueOf(lArray2[fArray.length - 1]);
        element.setAttribute("points", string);
        element.setAttribute("style", this.shapeColors(vShape));
        if (vShape.getText() != null) {
            Element element2 = this.createGroup();
            Element element3 = this.shapeText(vShape);
            element2.appendChild(element);
            element2.appendChild(element3);
            return element2;
        }
        return element;
    }

    private Element createImage(VImage vImage) {
        Object object;
        Element element = this.svgDoc.createElementNS(svgURI, "image");
        element.setAttribute("x", String.valueOf(vImage.vx - vImage.getWidth() + this.farWest));
        element.setAttribute("y", String.valueOf(-vImage.vy - vImage.getHeight() + this.farNorth));
        element.setAttribute("width", String.valueOf(2L * vImage.getWidth()));
        element.setAttribute("height", String.valueOf(2L * vImage.getHeight()));
        Image image = vImage.getImage();
        ImageWriter imageWriter = ImageIO.getImageWritersByFormatName("png").next();
        File file = null;
        try {
            file = File.createTempFile("vtm", ".png", this.destinationDir);
            imageWriter.setOutput(ImageIO.createImageOutputStream(file));
            object = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
            ((BufferedImage)object).createGraphics().drawImage(image, null, null);
            imageWriter.write((RenderedImage)object);
        }
        catch (Exception exception) {
            System.err.println("An error occured while exporting " + vImage.toString() + "to PNG.\n" + exception);
        }
        element.setAttributeNS(xlinkURI, "xlink:href", file.getName());
        if (vImage.getText() != null) {
            object = this.createGroup();
            Element element2 = this.shapeText(vImage);
            object.appendChild(element);
            object.appendChild(element2);
            return object;
        }
        return element;
    }

    private Element createPath(VBoolShape vBoolShape) {
        Area area;
        Element element = this.svgDoc.createElementNS(svgURI, "path");
        switch (vBoolShape.getMainShapeType()) {
            case 1: {
                area = new Area(new Ellipse2D.Float(vBoolShape.vx - vBoolShape.getWidth() / 2L, -vBoolShape.vy - vBoolShape.getHeight() / 2L, vBoolShape.getWidth(), vBoolShape.getHeight()));
                break;
            }
            case 2: {
                area = new Area(new Rectangle2D.Float(vBoolShape.vx - vBoolShape.getWidth() / 2L, -vBoolShape.vy - vBoolShape.getHeight() / 2L, vBoolShape.getWidth(), vBoolShape.getHeight()));
                break;
            }
            default: {
                area = new Area(new Ellipse2D.Float(vBoolShape.vx - vBoolShape.getWidth() / 2L, -vBoolShape.vy - vBoolShape.getHeight() / 2L, vBoolShape.getWidth(), vBoolShape.getHeight()));
            }
        }
        BooleanOps[] booleanOpsArray = vBoolShape.getOperations();
        int n = 0;
        while (n < booleanOpsArray.length) {
            switch (booleanOpsArray[n].opType) {
                case 1: {
                    area.add(this.getJ2DShape(booleanOpsArray[n], vBoolShape.vx, -vBoolShape.vy));
                    break;
                }
                case 2: {
                    area.subtract(this.getJ2DShape(booleanOpsArray[n], vBoolShape.vx, -vBoolShape.vy));
                    break;
                }
                case 3: {
                    area.intersect(this.getJ2DShape(booleanOpsArray[n], vBoolShape.vx, -vBoolShape.vy));
                    break;
                }
                case 4: {
                    area.exclusiveOr(this.getJ2DShape(booleanOpsArray[n], vBoolShape.vx, -vBoolShape.vy));
                }
            }
            ++n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        PathIterator pathIterator = area.getPathIterator(null);
        float[] fArray = new float[6];
        int n2 = 90;
        while (!pathIterator.isDone()) {
            int n3 = pathIterator.currentSegment(fArray);
            switch (n3) {
                case 0: {
                    if (n2 != 77) {
                        stringBuffer.append('M');
                    } else {
                        stringBuffer.append(' ');
                    }
                    n2 = 77;
                    stringBuffer.append(SVGWriter.abl2c(fArray[0] + (float)this.farWest) + " " + SVGWriter.abl2c(fArray[1] + (float)this.farNorth));
                    break;
                }
                case 1: {
                    if (n2 != 76) {
                        stringBuffer.append('L');
                    } else {
                        stringBuffer.append(' ');
                    }
                    n2 = 76;
                    stringBuffer.append(SVGWriter.abl2c(fArray[0] + (float)this.farWest) + " " + SVGWriter.abl2c(fArray[1] + (float)this.farNorth));
                    break;
                }
                case 2: {
                    if (n2 != 81) {
                        stringBuffer.append('Q');
                    } else {
                        stringBuffer.append(' ');
                    }
                    n2 = 81;
                    stringBuffer.append(SVGWriter.abl2c(fArray[0] + (float)this.farWest) + " " + SVGWriter.abl2c(fArray[1] + (float)this.farNorth) + " " + SVGWriter.abl2c(fArray[2] + (float)this.farWest) + " " + SVGWriter.abl2c(fArray[3] + (float)this.farNorth));
                    break;
                }
                case 3: {
                    if (n2 != 67) {
                        stringBuffer.append('C');
                    } else {
                        stringBuffer.append(' ');
                    }
                    n2 = 67;
                    stringBuffer.append(SVGWriter.abl2c(fArray[0] + (float)this.farWest) + " " + SVGWriter.abl2c(fArray[1] + (float)this.farNorth) + " " + SVGWriter.abl2c(fArray[2] + (float)this.farWest) + " " + SVGWriter.abl2c(fArray[3] + (float)this.farNorth) + " " + SVGWriter.abl2c(fArray[4] + (float)this.farWest) + " " + SVGWriter.abl2c(fArray[5] + (float)this.farNorth));
                    break;
                }
                case 4: {
                    stringBuffer.append('Z');
                }
            }
            pathIterator.next();
        }
        element.setAttribute("d", stringBuffer.toString());
        element.setAttribute("style", this.shapeColors(vBoolShape));
        if (vBoolShape.getText() != null) {
            Element element2 = this.createGroup();
            element2.appendChild(element);
            element2.appendChild(this.shapeText(vBoolShape));
            return element2;
        }
        return element;
    }

    private Area getJ2DShape(BooleanOps booleanOps, long l, long l2) {
        switch (booleanOps.shapeType) {
            case 1: {
                return new Area(new Ellipse2D.Float(l + (booleanOps.ox - booleanOps.szx / 2L), l2 - (booleanOps.oy + booleanOps.szy / 2L), booleanOps.szx, booleanOps.szy));
            }
            case 2: {
                return new Area(new Rectangle2D.Float(l + (booleanOps.ox - booleanOps.szx / 2L), l2 - (booleanOps.oy + booleanOps.szy / 2L), booleanOps.szx, booleanOps.szy));
            }
        }
        return new Area(new Ellipse2D.Float(l + (booleanOps.ox - booleanOps.szx / 2L), l2 - (booleanOps.oy + booleanOps.szy / 2L), booleanOps.szx, booleanOps.szy));
    }
}

