/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.ViewPanel;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.ProjPoint;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;

public class VPoint
extends Glyph {
    ProjPoint[] pc;

    public VPoint() {
        this.vx = 0L;
        this.vy = 0L;
        this.size = 1.0f;
        this.setRGBColor(Color.white);
        this.setRGBBorderColor(Color.black);
    }

    public VPoint(long l, long l2, Color color) {
        this.vx = l;
        this.vy = l2;
        this.size = 1.0f;
        this.setRGBColor(color);
        this.setRGBBorderColor(Color.black);
    }

    public void initCams(int n) {
        this.pc = new ProjPoint[n];
        int n2 = 0;
        while (n2 < n) {
            this.pc[n2] = new ProjPoint();
            ++n2;
        }
    }

    public void addCamera(int n) {
        if (this.pc != null) {
            if (n == this.pc.length) {
                ProjPoint[] projPointArray = this.pc;
                this.pc = new ProjPoint[projPointArray.length + 1];
                int n2 = 0;
                while (n2 < projPointArray.length) {
                    this.pc[n2] = projPointArray[n2];
                    ++n2;
                }
                this.pc[this.pc.length - 1] = new ProjPoint();
            } else {
                System.err.println("VPoint:Error while adding camera " + n);
            }
        } else if (n == 0) {
            this.pc = new ProjPoint[1];
            this.pc[0] = new ProjPoint();
        } else {
            System.err.println("VPoint:Error while adding camera " + n);
        }
    }

    public void removeCamera(int n) {
        this.pc[n] = null;
    }

    public void resetMouseIn(int n) {
        if (this.pc[n] != null) {
            this.pc[n].prevMouseIn = false;
        }
    }

    public void sizeTo(float f) {
    }

    public void sizeToNS(float f) {
    }

    public void orientTo(float f) {
    }

    public void orientToNS(float f) {
    }

    public float getSize() {
        return 1.0f;
    }

    public float getOrient() {
        return 0.0f;
    }

    public boolean fillsView(long l, long l2, int n) {
        return false;
    }

    boolean coordInside(int n, int n2, int n3) {
        return n == this.pc[n3].cx && n2 == this.pc[n3].cy;
    }

    public int mouseInOut(int n, int n2, int n3) {
        if (this.coordInside(n, n2, n3)) {
            if (!this.pc[n3].prevMouseIn) {
                this.pc[n3].prevMouseIn = true;
                return 1;
            }
            return 0;
        }
        if (this.pc[n3].prevMouseIn) {
            this.pc[n3].prevMouseIn = false;
            return -1;
        }
        return 0;
    }

    public void project(Camera camera, ViewPanel viewPanel) {
        int n = camera.getIndex();
        this.coef = camera.focal / (camera.focal + camera.altitude);
        this.pc[n].cx = Math.round((float)(this.vx - camera.posx) * this.coef);
        this.pc[n].cy = Math.round((float)(this.vy - camera.posy) * this.coef);
        this.pc[n].cx = viewPanel.getSize().width / 2 + this.pc[n].cx;
        this.pc[n].cy = viewPanel.getSize().height / 2 - this.pc[n].cy;
    }

    public void draw(Graphics2D graphics2D, int n, int n2, int n3, Stroke stroke, AffineTransform affineTransform) {
        graphics2D.setColor(this.color);
        graphics2D.fillRect(this.pc[n3].cx, this.pc[n3].cy, 1, 1);
    }
}

