/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.engine;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.View;
import com.xerox.VTM.engine.ViewPanel;
import com.xerox.VTM.engine.VirtualSpaceManager;
import com.xerox.VTM.glyphs.Glyph;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import java.util.Vector;

public class StdViewPanel
extends ViewPanel
implements Runnable {
    BufferedImage buffImg;

    protected BufferedImage getImage() {
        return this.buffImg;
    }

    public StdViewPanel(Vector vector, View view) {
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if (StdViewPanel.this.isShowing()) {
                    StdViewPanel.this.start();
                } else {
                    StdViewPanel.this.stop();
                }
            }
        });
        this.parent = view;
        this.cams = new Camera[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            this.cams[n] = (Camera)vector.get(n);
            ++n;
        }
        this.setBackground(Color.lightGray);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.start();
        this.setAWTCursor(-1);
        if (this.parent.parent.debug) {
            System.out.println("View refresh time set to " + this.frameTime + "ms");
        }
    }

    public void start() {
        Dimension dimension = this.getSize();
        this.runView = new Thread(this);
        this.runView.setPriority(1);
        this.runView.start();
    }

    public synchronized void stop() {
        this.runView = null;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread thread = Thread.currentThread();
        while (this.getSize().width <= 0) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                if (this.parent.parent.debug) {
                    System.err.println("viewpanel.run.runview.sleep " + interruptedException);
                }
                return;
            }
        }
        Graphics graphics = null;
        Graphics graphics2 = null;
        Dimension dimension = this.getSize();
        while (this.runView == thread) {
            if (this.active) {
                if (this.repaintNow) {
                    Dimension dimension2 = this.getSize();
                    if (dimension2.width != dimension.width || dimension2.height != dimension.height) {
                        this.buffImg = null;
                        if (graphics2 != null) {
                            graphics2.dispose();
                            graphics2 = null;
                        }
                        if (this.parent.parent.debug) {
                            System.out.println("Resizing JPanel: (" + dimension.width + "x" + dimension.height + ") -> (" + dimension2.width + "x" + dimension2.height + ")");
                        }
                        dimension = dimension2;
                    }
                    if (this.buffImg == null) {
                        this.buffImg = (BufferedImage)this.createImage(dimension2.width, dimension2.height);
                    }
                    if (graphics2 == null) {
                        graphics2 = this.buffImg.createGraphics();
                        graphics2.setFont(VirtualSpaceManager.mainFont);
                    }
                    if (this.updateFont) {
                        graphics2.setFont(VirtualSpaceManager.mainFont);
                        this.updateFont = false;
                    }
                    if (this.updateAntialias) {
                        if (this.antialias) {
                            ((Graphics2D)graphics2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        } else {
                            ((Graphics2D)graphics2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                        }
                        this.updateAntialias = false;
                    }
                    graphics = graphics2;
                    StdViewPanel stdViewPanel = this;
                    synchronized (stdViewPanel) {
                        this.standardStroke = ((Graphics2D)graphics).getStroke();
                        this.standardTransform = ((Graphics2D)graphics).getTransform();
                        ((Graphics2D)graphics).setBackground(this.backColor);
                        graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
                        int n = 0;
                        while (n < this.cams.length) {
                            if (this.cams[n] != null && this.cams[n].enabled) {
                                Enumeration enumeration;
                                this.camIndex = this.cams[n].getIndex();
                                this.cams[n].parentSpace.drawnList.removeAllElements();
                                this.uncoef = (this.cams[n].focal + this.cams[n].altitude) / this.cams[n].focal;
                                this.viewW = this.getSize().width;
                                this.viewH = this.getSize().height;
                                this.viewWHu = (long)((float)this.cams[n].posx + (float)(this.getSize().width / 2) * this.uncoef);
                                this.viewHHu = (long)((float)this.cams[n].posy + (float)(this.getSize().height / 2) * this.uncoef);
                                this.viewWLu = (long)((float)this.cams[n].posx - (float)(this.getSize().width / 2) * this.uncoef);
                                this.viewHLu = (long)((float)this.cams[n].posy - (float)(this.getSize().height / 2) * this.uncoef);
                                if (this.parent.detectMultipleFullFills) {
                                    enumeration = this.cams[n].parentSpace.getVisibleGlyphs().elements();
                                    while (enumeration.hasMoreElements()) {
                                        this.gl = (Glyph)enumeration.nextElement();
                                        if (!this.gl.drawMe(this.viewWHu, this.viewHHu, this.viewWLu, this.viewHLu, this.camIndex)) continue;
                                        this.cams[n].parentSpace.drawnList.add(this.gl);
                                        this.gl.project(this.cams[n], this);
                                    }
                                    this.drawnGlyphs = this.cams[n].parentSpace.getDrawnGlyphs();
                                    this.beginAt = 0;
                                    int n2 = this.drawnGlyphs.size() - 1;
                                    while (n2 >= 0) {
                                        if (((Glyph)this.drawnGlyphs.elementAt(n2)).fillsView(this.viewW, this.viewH, this.cams[n].getIndex())) {
                                            this.beginAt = n2;
                                            break;
                                        }
                                        --n2;
                                    }
                                    int n3 = this.beginAt;
                                    while (n3 < this.drawnGlyphs.size()) {
                                        this.gl = (Glyph)this.drawnGlyphs.elementAt(n3);
                                        if (this.gl.isVisible()) {
                                            this.gl.draw((Graphics2D)graphics, dimension2.width, dimension2.height, this.cams[n].getIndex(), this.standardStroke, this.standardTransform);
                                        }
                                        ++n3;
                                    }
                                } else {
                                    enumeration = this.cams[n].parentSpace.getVisibleGlyphs().elements();
                                    while (enumeration.hasMoreElements()) {
                                        this.gl = (Glyph)enumeration.nextElement();
                                        if (!this.gl.drawMe(this.viewWHu, this.viewHHu, this.viewWLu, this.viewHLu, this.camIndex)) continue;
                                        StdViewPanel stdViewPanel2 = this;
                                        synchronized (stdViewPanel2) {
                                            this.gl.project(this.cams[n], this);
                                            if (this.gl.isVisible()) {
                                                this.gl.draw((Graphics2D)graphics, dimension2.width, dimension2.height, this.cams[n].getIndex(), this.standardStroke, this.standardTransform);
                                            }
                                        }
                                        this.cams[n].parentSpace.drawnList.add(this.gl);
                                    }
                                }
                            }
                            ++n;
                        }
                        if (this.inside) {
                            block52: {
                                if (this.drawDrag) {
                                    graphics.setColor(this.parent.mouse.color);
                                    graphics.drawLine(this.origDragx, this.origDragy, this.curDragx, this.curDragy);
                                } else if (this.drawRect) {
                                    graphics.setColor(this.parent.mouse.color);
                                    graphics.drawRect(Math.min(this.origDragx, this.curDragx), Math.min(this.origDragy, this.curDragy), Math.max(this.origDragx, this.curDragx) - Math.min(this.origDragx, this.curDragx), Math.max(this.origDragy, this.curDragy) - Math.min(this.origDragy, this.curDragy));
                                }
                                try {
                                    if (this.computeListAtEachRepaint && this.parent.mouse.isSensitive()) {
                                        System.err.print(".");
                                        this.parent.mouse.computeMouseOverList(this.evH, this.cams[this.activeLayer]);
                                    }
                                    this.parent.mouse.unProject(this.cams[this.activeLayer], this);
                                }
                                catch (NullPointerException nullPointerException) {
                                    if (!this.parent.parent.debug) break block52;
                                    System.err.println("viewpanel.run.drawdrag " + nullPointerException);
                                }
                            }
                            if (this.drawVTMcursor) {
                                this.parent.mouse.draw((Graphics2D)graphics);
                            }
                        }
                        if (graphics == graphics2) {
                            this.repaint();
                        }
                        this.repaintNow = false;
                        try {
                            Thread.sleep(this.frameTime);
                        }
                        catch (InterruptedException interruptedException) {
                            if (this.parent.parent.debug) {
                                System.err.println("viewpanel.run.runview.sleep2 " + interruptedException);
                            }
                            return;
                        }
                    }
                }
                try {
                    Thread.sleep(this.btwChecksTime);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    if (this.parent.parent.debug) {
                        System.err.println("viewpanel.run.runview.sleep3 " + interruptedException);
                    }
                    return;
                }
            }
            try {
                Thread.sleep(this.deactiveTime);
            }
            catch (InterruptedException interruptedException) {
                if (this.parent.parent.debug) {
                    System.err.println("viewpanel.run.runview.sleep4 " + interruptedException);
                }
                return;
            }
        }
        if (graphics != null) {
            graphics.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        StdViewPanel stdViewPanel = this;
        synchronized (stdViewPanel) {
            this.g2 = (Graphics2D)graphics;
            if (this.buffImg != null) {
                this.g2.drawImage(this.buffImg, null, 0, 0);
            }
        }
    }
}

