/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.engine;

import com.xerox.VTM.engine.AnimParams;
import com.xerox.VTM.engine.CAnimation;
import com.xerox.VTM.engine.CTransZoom;
import com.xerox.VTM.engine.CTranslation;
import com.xerox.VTM.engine.CZoom;
import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.GAnimation;
import com.xerox.VTM.engine.GCbCurveCtrl;
import com.xerox.VTM.engine.GColoration;
import com.xerox.VTM.engine.GCurveCtrl;
import com.xerox.VTM.engine.GQdCurveCtrl;
import com.xerox.VTM.engine.GResize;
import com.xerox.VTM.engine.GRotate;
import com.xerox.VTM.engine.GTranslation;
import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.engine.PolarCoords;
import com.xerox.VTM.engine.VirtualSpaceManager;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.VCbCurve;
import com.xerox.VTM.glyphs.VQdCurve;
import java.util.Hashtable;
import java.util.Vector;

public class AnimManager
implements Runnable {
    public static short GL_TRANS_LIN = 0;
    public static short GL_TRANS_PAR = 1;
    public static short GL_TRANS_SIG = (short)2;
    public static short GL_SZ_LIN = (short)3;
    public static short GL_SZ_PAR = (short)4;
    public static short GL_SZ_SIG = (short)5;
    public static short GL_ROT_LIN = (short)6;
    public static short GL_ROT_PAR = (short)7;
    public static short GL_ROT_SIG = (short)8;
    public static short GL_COLOR_SIG = (short)9;
    public static short GL_CP_TRANS_LIN = 0;
    public static short GL_CP_TRANS_PAR = 1;
    public static short GL_CP_TRANS_SIG = (short)2;
    public static short CA_TRANS_LIN = 0;
    public static short CA_TRANS_PAR = 1;
    public static short CA_TRANS_SIG = (short)2;
    public static short CA_ALT_LIN = (short)3;
    public static short CA_ALT_PAR = (short)4;
    public static short CA_ALT_SIG = (short)5;
    public static short CA_ALT_TRANS_SIG = (short)6;
    VirtualSpaceManager parent;
    Thread runAnim;
    boolean started = false;
    int frameTime;
    boolean shouldRepaint = false;
    int sigFactor = 4;
    Vector animCameraBag;
    Vector animGlyphBag;
    Hashtable pendingGAnims;
    Hashtable pendingCAnims;
    Hashtable animatedGlyphs;
    Hashtable animatedCameras;
    public long Xspeed;
    public long Yspeed;
    public long Aspeed;
    Camera activeCam;

    public AnimManager(VirtualSpaceManager virtualSpaceManager) {
        this.parent = virtualSpaceManager;
        this.animCameraBag = new Vector();
        this.animGlyphBag = new Vector();
        this.pendingGAnims = new Hashtable();
        this.pendingCAnims = new Hashtable();
        this.animatedGlyphs = new Hashtable();
        this.animatedCameras = new Hashtable();
        this.frameTime = 10;
        this.Xspeed = 0L;
        this.Yspeed = 0L;
        this.Aspeed = 0L;
    }

    public void start() {
        this.started = true;
        this.runAnim = new Thread(this);
        this.runAnim.setPriority(1);
        this.runAnim.start();
    }

    public synchronized void stop() {
        this.started = false;
        this.runAnim = null;
        this.notify();
    }

    public void run() {
        Thread thread = Thread.currentThread();
        while (this.parent.activeView == null) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                if (this.parent.debug) {
                    System.err.println("animmanager.run.sleep0 " + interruptedException);
                }
                return;
            }
        }
        while (this.runAnim == thread) {
            block20: {
                try {
                    this.activeCam = this.parent.getActiveCamera();
                    if (this.Xspeed != 0L) {
                        this.activeCam.posx -= this.Xspeed;
                        this.shouldRepaint = true;
                    }
                    if (this.Yspeed != 0L) {
                        this.activeCam.posy -= this.Yspeed;
                        this.shouldRepaint = true;
                    }
                    if (this.Aspeed != 0L) {
                        this.activeCam.altitudeOffset(-this.Aspeed);
                        this.shouldRepaint = true;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    if (!this.parent.debug) break block20;
                    System.err.println("animmanager.run.activecam " + nullPointerException);
                }
            }
            int n = 0;
            while (n < this.animCameraBag.size()) {
                block21: {
                    CAnimation cAnimation = (CAnimation)this.animCameraBag.get(n);
                    try {
                        cAnimation.animate();
                    }
                    catch (NullPointerException nullPointerException) {
                        if (!this.parent.debug) break block21;
                        System.err.println("animmanager.run.camera anim stopped " + nullPointerException);
                    }
                }
                this.shouldRepaint = true;
                ++n;
            }
            int n2 = 0;
            while (n2 < this.animGlyphBag.size()) {
                block22: {
                    GAnimation gAnimation = (GAnimation)this.animGlyphBag.get(n2);
                    try {
                        gAnimation.animate();
                    }
                    catch (NullPointerException nullPointerException) {
                        if (!this.parent.debug) break block22;
                        System.err.println("animmanager.run.glyph anim stopped " + nullPointerException);
                    }
                }
                this.shouldRepaint = true;
                ++n2;
            }
            if (this.shouldRepaint) {
                this.parent.repaintNow();
                this.shouldRepaint = false;
            }
            try {
                Thread.sleep(this.frameTime);
            }
            catch (InterruptedException interruptedException) {
                if (this.parent.debug) {
                    System.err.println("animmanager.run.sleep " + interruptedException);
                }
                return;
            }
        }
    }

    public void createGlyphAnimation(long l, int n, Object object, Long l2) {
        Glyph glyph = this.parent.getGlyph(l2);
        switch (n) {
            case 0: {
                Object object2;
                if (this.animatedGlyphs.containsKey(l2) && ((int[])this.animatedGlyphs.get(l2))[0] == 1) {
                    this.putAsPendingGAnimation(l2, "pos", l, n, object);
                    break;
                }
                if (this.animatedGlyphs.containsKey(l2)) {
                    ((int[])this.animatedGlyphs.get((Object)l2))[0] = 1;
                } else {
                    object2 = new int[]{0, 0, 0, 0};
                    object2[0] = true;
                    this.animatedGlyphs.put(l2, object2);
                }
                object2 = new GTranslation(glyph, this, l);
                long l3 = glyph.vx;
                long l4 = glyph.vy;
                long l5 = ((LongPoint)object).x;
                long l6 = ((LongPoint)object).y;
                double d = Math.round(l / (long)this.frameTime);
                double d2 = (double)l5 / d;
                double d3 = (double)l6 / d;
                ((GTranslation)object2).steps = new LongPoint[(int)d];
                int n2 = 0;
                while ((double)n2 < d - 1.0) {
                    ((GTranslation)object2).steps[n2] = new LongPoint((long)((double)l3 + (double)n2 * d2), (long)((double)l4 + (double)n2 * d3));
                    ++n2;
                }
                ((GTranslation)object2).steps[(int)d - 1] = new LongPoint(l3 + l5, l4 + l6);
                this.animGlyphBag.add(object2);
                ((GTranslation)object2).start();
                break;
            }
            case 1: {
                Object object3;
                if (this.animatedGlyphs.containsKey(l2) && ((int[])this.animatedGlyphs.get(l2))[0] == 1) {
                    this.putAsPendingGAnimation(l2, "pos", l, n, object);
                    break;
                }
                if (this.animatedGlyphs.containsKey(l2)) {
                    ((int[])this.animatedGlyphs.get((Object)l2))[0] = 1;
                } else {
                    object3 = new int[]{0, 0, 0, 0};
                    object3[0] = true;
                    this.animatedGlyphs.put(l2, object3);
                }
                object3 = new GTranslation(glyph, this, l);
                long l7 = glyph.vx;
                long l8 = glyph.vy;
                long l9 = ((LongPoint)object).x;
                long l10 = ((LongPoint)object).y;
                double d = Math.round((double)(l / (long)this.frameTime));
                ((GTranslation)object3).steps = new LongPoint[(int)d];
                int n3 = 0;
                while ((double)n3 < d - 1.0) {
                    double d4 = Math.pow((double)(n3 + 1) / d, 4.0);
                    long l11 = Math.round((double)l9 * d4);
                    long l12 = Math.round((double)l10 * d4);
                    ((GTranslation)object3).steps[n3++] = new LongPoint(l7 + l11, l8 + l12);
                }
                ((GTranslation)object3).steps[(int)d - 1] = new LongPoint(l7 + l9, l8 + l10);
                this.animGlyphBag.add(object3);
                ((GTranslation)object3).start();
                break;
            }
            case 2: {
                Object object4;
                if (this.animatedGlyphs.containsKey(l2) && ((int[])this.animatedGlyphs.get(l2))[0] == 1) {
                    this.putAsPendingGAnimation(l2, "pos", l, n, object);
                    break;
                }
                if (this.animatedGlyphs.containsKey(l2)) {
                    ((int[])this.animatedGlyphs.get((Object)l2))[0] = 1;
                } else {
                    object4 = new int[]{0, 0, 0, 0};
                    object4[0] = true;
                    this.animatedGlyphs.put(l2, object4);
                }
                object4 = new GTranslation(glyph, this, l);
                long l13 = glyph.vx;
                long l14 = glyph.vy;
                long l15 = ((LongPoint)object).x;
                long l16 = ((LongPoint)object).y;
                double d = Math.round((double)(l / (long)this.frameTime));
                ((GTranslation)object4).steps = new LongPoint[(int)d];
                int n4 = 0;
                while ((double)n4 < d - 1.0) {
                    double d5 = this.computeSigmoid(this.sigFactor, (double)(n4 + 1) / d);
                    long l17 = Math.round((double)l15 * d5);
                    long l18 = Math.round((double)l16 * d5);
                    ((GTranslation)object4).steps[n4++] = new LongPoint(l13 + l17, l14 + l18);
                }
                ((GTranslation)object4).steps[(int)d - 1] = new LongPoint(l13 + l15, l14 + l16);
                this.animGlyphBag.add(object4);
                ((GTranslation)object4).start();
                break;
            }
            case 3: {
                Object object5;
                if (this.animatedGlyphs.containsKey(l2) && ((int[])this.animatedGlyphs.get(l2))[1] == 1) {
                    this.putAsPendingGAnimation(l2, "sz", l, n, object);
                    break;
                }
                if (this.animatedGlyphs.containsKey(l2)) {
                    ((int[])this.animatedGlyphs.get((Object)l2))[1] = 1;
                } else {
                    object5 = new int[]{0, 0, 0, 0};
                    object5[1] = true;
                    this.animatedGlyphs.put(l2, object5);
                }
                object5 = new GResize(glyph, this, l);
                float f = glyph.getSize();
                float f2 = ((Float)object).floatValue() * f;
                float f3 = Math.round(l / (long)this.frameTime);
                float f4 = (f2 - f) / f3;
                ((GResize)object5).steps = new float[(int)f3];
                int n5 = 0;
                while ((float)n5 < f3 - 1.0f) {
                    ((GResize)object5).steps[n5] = f + (float)n5 * f4;
                    ++n5;
                }
                ((GResize)object5).steps[(int)f3 - 1] = f2;
                this.animGlyphBag.add(object5);
                ((GResize)object5).start();
                break;
            }
            case 4: {
                Object object6;
                if (this.animatedGlyphs.containsKey(l2) && ((int[])this.animatedGlyphs.get(l2))[1] == 1) {
                    this.putAsPendingGAnimation(l2, "sz", l, n, object);
                    break;
                }
                if (this.animatedGlyphs.containsKey(l2)) {
                    ((int[])this.animatedGlyphs.get((Object)l2))[1] = 1;
                } else {
                    object6 = new int[]{0, 0, 0, 0};
                    object6[1] = true;
                    this.animatedGlyphs.put(l2, object6);
                }
                object6 = new GResize(glyph, this, l);
                float f = glyph.getSize();
                float f5 = ((Float)object).floatValue() * f;
                float f6 = Math.round(l / (long)this.frameTime);
                ((GResize)object6).steps = new float[(int)f6];
                int n6 = 0;
                while ((float)n6 < f6 - 1.0f) {
                    float f7 = (float)Math.pow((float)(n6 + 1) / f6, 4.0);
                    float f8 = (f5 - f) * f7;
                    ((GResize)object6).steps[n6] = f + f8;
                    ++n6;
                }
                ((GResize)object6).steps[(int)f6 - 1] = f5;
                this.animGlyphBag.add(object6);
                ((GResize)object6).start();
                break;
            }
            case 5: {
                Object object7;
                if (this.animatedGlyphs.containsKey(l2) && ((int[])this.animatedGlyphs.get(l2))[1] == 1) {
                    this.putAsPendingGAnimation(l2, "sz", l, n, object);
                    break;
                }
                if (this.animatedGlyphs.containsKey(l2)) {
                    ((int[])this.animatedGlyphs.get((Object)l2))[1] = 1;
                } else {
                    object7 = new int[]{0, 0, 0, 0};
                    object7[1] = true;
                    this.animatedGlyphs.put(l2, object7);
                }
                object7 = new GResize(glyph, this, l);
                float f = glyph.getSize();
                float f9 = ((Float)object).floatValue() * f;
                float f10 = Math.round(l / (long)this.frameTime);
                ((GResize)object7).steps = new float[(int)f10];
                int n7 = 0;
                while ((float)n7 < f10 - 1.0f) {
                    float f11 = (float)this.computeSigmoid(this.sigFactor, (float)(n7 + 1) / f10);
                    float f12 = (f9 - f) * f11;
                    ((GResize)object7).steps[n7] = f + f12;
                    ++n7;
                }
                ((GResize)object7).steps[(int)f10 - 1] = f9;
                this.animGlyphBag.add(object7);
                ((GResize)object7).start();
                break;
            }
            case 6: {
                Object object8;
                if (this.animatedGlyphs.containsKey(l2) && ((int[])this.animatedGlyphs.get(l2))[2] == 1) {
                    this.putAsPendingGAnimation(l2, "or", l, n, object);
                    break;
                }
                if (this.animatedGlyphs.containsKey(l2)) {
                    ((int[])this.animatedGlyphs.get((Object)l2))[2] = 1;
                } else {
                    object8 = new int[]{0, 0, 0, 0};
                    object8[2] = true;
                    this.animatedGlyphs.put(l2, object8);
                }
                object8 = new GRotate(glyph, this, l);
                float f = glyph.getOrient();
                float f13 = ((Float)object).floatValue() + f;
                float f14 = Math.round(l / (long)this.frameTime);
                float f15 = (f13 - f) / f14;
                ((GRotate)object8).steps = new float[(int)f14];
                int n8 = 0;
                while ((float)n8 < f14 - 1.0f) {
                    ((GRotate)object8).steps[n8] = f + (float)n8 * f15;
                    ++n8;
                }
                if ((double)Math.abs(f13) >= Math.PI * 2) {
                    f13 %= (float)Math.PI * 2;
                }
                ((GRotate)object8).steps[(int)f14 - 1] = f13;
                this.animGlyphBag.add(object8);
                ((GRotate)object8).start();
                break;
            }
            case 7: {
                Object object9;
                if (this.animatedGlyphs.containsKey(l2) && ((int[])this.animatedGlyphs.get(l2))[2] == 1) {
                    this.putAsPendingGAnimation(l2, "or", l, n, object);
                    break;
                }
                if (this.animatedGlyphs.containsKey(l2)) {
                    ((int[])this.animatedGlyphs.get((Object)l2))[2] = 1;
                } else {
                    object9 = new int[]{0, 0, 0, 0};
                    object9[2] = true;
                    this.animatedGlyphs.put(l2, object9);
                }
                object9 = new GRotate(glyph, this, l);
                float f = glyph.getOrient();
                float f16 = ((Float)object).floatValue() + f;
                float f17 = Math.round(l / (long)this.frameTime);
                ((GRotate)object9).steps = new float[(int)f17];
                int n9 = 0;
                while ((float)n9 < f17 - 1.0f) {
                    float f18 = (float)Math.pow((float)(n9 + 1) / f17, 4.0);
                    float f19 = (f16 - f) * f18;
                    ((GRotate)object9).steps[n9] = f + f19;
                    ++n9;
                }
                if ((double)Math.abs(f16) >= Math.PI * 2) {
                    f16 %= (float)Math.PI * 2;
                }
                ((GRotate)object9).steps[(int)f17 - 1] = f16;
                this.animGlyphBag.add(object9);
                ((GRotate)object9).start();
                break;
            }
            case 8: {
                Object object10;
                if (this.animatedGlyphs.containsKey(l2) && ((int[])this.animatedGlyphs.get(l2))[2] == 1) {
                    this.putAsPendingGAnimation(l2, "or", l, n, object);
                    break;
                }
                if (this.animatedGlyphs.containsKey(l2)) {
                    ((int[])this.animatedGlyphs.get((Object)l2))[2] = 1;
                } else {
                    object10 = new int[]{0, 0, 0, 0};
                    object10[2] = true;
                    this.animatedGlyphs.put(l2, object10);
                }
                object10 = new GRotate(glyph, this, l);
                float f = glyph.getOrient();
                float f20 = ((Float)object).floatValue() + f;
                float f21 = Math.round(l / (long)this.frameTime);
                ((GRotate)object10).steps = new float[(int)f21];
                int n10 = 0;
                while ((float)n10 < f21 - 1.0f) {
                    float f22 = (float)this.computeSigmoid(this.sigFactor, (float)(n10 + 1) / f21);
                    float f23 = (f20 - f) * f22;
                    ((GRotate)object10).steps[n10] = f + f23;
                    ++n10;
                }
                if ((double)Math.abs(f20) >= Math.PI * 2) {
                    f20 %= (float)Math.PI * 2;
                }
                ((GRotate)object10).steps[(int)f21 - 1] = f20;
                this.animGlyphBag.add(object10);
                ((GRotate)object10).start();
                break;
            }
            case 9: {
                if (this.animatedGlyphs.containsKey(l2) && ((int[])this.animatedGlyphs.get(l2))[3] == 1) {
                    this.putAsPendingGAnimation(l2, "col", l, n, object);
                    break;
                }
                if (this.animatedGlyphs.containsKey(l2)) {
                    ((int[])this.animatedGlyphs.get((Object)l2))[3] = 1;
                } else {
                    int[] nArray = new int[]{0, 0, 0, 0};
                    nArray[3] = 1;
                    this.animatedGlyphs.put(l2, nArray);
                }
                boolean bl = (Boolean)((Vector)object).elementAt(3);
                GColoration gColoration = new GColoration(glyph, this, l, bl);
                float[] fArray = !bl ? glyph.getHSVColor() : glyph.getHSVbColor();
                float[] fArray2 = new float[3];
                int n11 = 0;
                while (n11 < 3) {
                    fArray2[n11] = ((Float)((Vector)object).elementAt(n11)).floatValue();
                    ++n11;
                }
                double d = Math.round(l / (long)this.frameTime);
                double d6 = (double)fArray2[0] / d;
                double d7 = (double)fArray2[1] / d;
                double d8 = (double)fArray2[2] / d;
                gColoration.steps = new float[(int)d][3];
                int n12 = 0;
                while ((double)n12 < d - 1.0) {
                    gColoration.steps[n12][0] = fArray[0] + (float)n12 * (float)d6;
                    gColoration.steps[n12][1] = fArray[1] + (float)n12 * (float)d7;
                    gColoration.steps[n12][2] = fArray[2] + (float)n12 * (float)d8;
                    ++n12;
                }
                gColoration.steps[(int)d - 1][0] = fArray[0] + fArray2[0];
                gColoration.steps[(int)d - 1][1] = fArray[1] + fArray2[1];
                gColoration.steps[(int)d - 1][2] = fArray[2] + fArray2[2];
                this.animGlyphBag.add(gColoration);
                gColoration.start();
                break;
            }
            default: {
                System.err.println("Error : AnimManager.createGlyphAnimation : unknown animation type");
            }
        }
    }

    void putAsPendingGAnimation(Long l, String string, long l2, int n, Object object) {
        if (this.pendingGAnims.containsKey(l)) {
            Hashtable hashtable = (Hashtable)this.pendingGAnims.get(l);
            Vector vector = hashtable.containsKey(string) ? (Vector)hashtable.get(string) : new Vector();
            vector.add(new AnimParams(l2, n, object));
            hashtable.put(string, vector);
        } else {
            Vector<AnimParams> vector = new Vector<AnimParams>();
            vector.add(new AnimParams(l2, n, object));
            Hashtable<String, Vector<AnimParams>> hashtable = new Hashtable<String, Vector<AnimParams>>();
            hashtable.put(string, vector);
            this.pendingGAnims.put(l, hashtable);
        }
    }

    void killGAnim(GAnimation gAnimation, String string) {
        Object object;
        Long l = gAnimation.target.getID();
        this.animGlyphBag.remove(gAnimation);
        if (this.animatedGlyphs.containsKey(l)) {
            object = (int[])this.animatedGlyphs.get(l);
            if (string.equals("pos")) {
                object[0] = 0;
            } else if (string.equals("sz")) {
                object[1] = false;
            } else if (string.equals("or")) {
                object[2] = false;
            } else if (string.equals("col")) {
                object[3] = false;
            }
            if (this.allValuesEqualZero((int[])object)) {
                this.animatedGlyphs.remove(l);
            }
        }
        if (this.pendingGAnims.containsKey(l) && ((Hashtable)(object = (Object)((Hashtable)this.pendingGAnims.get(l)))).containsKey(string)) {
            Vector vector = (Vector)((Hashtable)object).get(string);
            AnimParams animParams = (AnimParams)vector.elementAt(0);
            vector.removeElementAt(0);
            if (vector.isEmpty()) {
                ((Hashtable)object).remove(string);
            }
            this.createGlyphAnimation(animParams.duration, animParams.type, animParams.data, l);
        }
    }

    public void createQdCurveCtrlPtAnimation(long l, int n, Object object, Long l2) {
        Glyph glyph = this.parent.getGlyph(l2);
        if (glyph instanceof VQdCurve) {
            if (this.animatedGlyphs.containsKey(l2) && ((int[])this.animatedGlyphs.get(l2)).length < 5) {
                this.animatedGlyphs.put(l2, this.addElementsToIntArray((int[])this.animatedGlyphs.get(l2), 1));
            }
            if (this.animatedGlyphs.containsKey(l2) && ((int[])this.animatedGlyphs.get(l2))[4] == 1) {
                this.putAsPendingGAnimation(l2, "ctrl", l, n, object);
            } else {
                Object object2;
                if (this.animatedGlyphs.containsKey(l2)) {
                    ((int[])this.animatedGlyphs.get((Object)l2))[4] = 1;
                } else {
                    object2 = new int[]{0, 0, 0, 0, 0};
                    object2[4] = true;
                    this.animatedGlyphs.put(l2, object2);
                }
                object2 = new GQdCurveCtrl((VQdCurve)glyph, this, l);
                long l3 = ((VQdCurve)glyph).getCtrlPointRadius();
                float f = ((VQdCurve)glyph).getCtrlPointAngle();
                long l4 = ((PolarCoords)object).r;
                float f2 = ((PolarCoords)object).theta;
                double d = Math.round(l / (long)this.frameTime);
                ((GQdCurveCtrl)object2).steps = new PolarCoords[(int)d];
                switch (n) {
                    case 0: {
                        double d2 = (double)l4 / d;
                        double d3 = (double)f2 / d;
                        int n2 = 0;
                        while ((double)n2 < d - 1.0) {
                            ((GQdCurveCtrl)object2).steps[n2] = new PolarCoords((long)((double)l3 + (double)n2 * d2), (float)((double)f + (double)n2 * d3));
                            ++n2;
                        }
                        ((GQdCurveCtrl)object2).steps[(int)d - 1] = new PolarCoords(l3 + l4, f + f2);
                        this.animGlyphBag.add(object2);
                        ((GCurveCtrl)object2).start();
                        break;
                    }
                    case 1: {
                        int n3 = 0;
                        while ((double)n3 < d - 1.0) {
                            double d4 = Math.pow((double)(n3 + 1) / d, 4.0);
                            ((GQdCurveCtrl)object2).steps[n3++] = new PolarCoords(l3 + Math.round((double)l4 * d4), (float)((double)f + (double)f2 * d4));
                        }
                        ((GQdCurveCtrl)object2).steps[(int)d - 1] = new PolarCoords(l3 + l4, f + f2);
                        this.animGlyphBag.add(object2);
                        ((GCurveCtrl)object2).start();
                        break;
                    }
                    case 2: {
                        int n4 = 0;
                        while ((double)n4 < d - 1.0) {
                            double d5 = this.computeSigmoid(this.sigFactor, (double)(n4 + 1) / d);
                            ((GQdCurveCtrl)object2).steps[n4++] = new PolarCoords(l3 + Math.round((double)l4 * d5), (float)((double)f + (double)f2 * d5));
                        }
                        ((GQdCurveCtrl)object2).steps[(int)d - 1] = new PolarCoords(l3 + l4, f + f2);
                        this.animGlyphBag.add(object2);
                        ((GCurveCtrl)object2).start();
                        break;
                    }
                    default: {
                        System.err.println("Error : AnimManager.createQdCurveCtrlPtAnimation : unknown animation type");
                        break;
                    }
                }
            }
        } else {
            System.err.println("Error : AnimManager.createQdCurveCtrlPtAnimation : glyph is not a curve");
        }
    }

    public void createCbCurveCtrlPtAnimation(long l, int n, Object object, Long l2) {
        Glyph glyph = this.parent.getGlyph(l2);
        if (glyph instanceof VCbCurve) {
            if (this.animatedGlyphs.containsKey(l2) && ((int[])this.animatedGlyphs.get(l2)).length < 6) {
                this.animatedGlyphs.put(l2, this.addElementsToIntArray((int[])this.animatedGlyphs.get(l2), 2));
            }
            if (this.animatedGlyphs.containsKey(l2) && (((int[])this.animatedGlyphs.get(l2))[4] == 1 || ((int[])this.animatedGlyphs.get(l2))[5] == 1)) {
                this.putAsPendingGAnimation(l2, "ctrl", l, n, object);
            } else {
                Object object2;
                if (this.animatedGlyphs.containsKey(l2)) {
                    ((int[])this.animatedGlyphs.get((Object)l2))[4] = 1;
                } else {
                    object2 = new int[]{0, 0, 0, 0, 0};
                    object2[4] = true;
                    this.animatedGlyphs.put(l2, object2);
                }
                object2 = new GCbCurveCtrl((VCbCurve)glyph, this, l);
                long l3 = ((VCbCurve)glyph).getCtrlPointRadius1();
                float f = ((VCbCurve)glyph).getCtrlPointAngle1();
                long l4 = ((VCbCurve)glyph).getCtrlPointRadius2();
                float f2 = ((VCbCurve)glyph).getCtrlPointAngle2();
                long l5 = ((PolarCoords)((Vector)object).elementAt((int)0)).r;
                float f3 = ((PolarCoords)((Vector)object).elementAt((int)0)).theta;
                long l6 = ((PolarCoords)((Vector)object).elementAt((int)1)).r;
                float f4 = ((PolarCoords)((Vector)object).elementAt((int)1)).theta;
                double d = Math.round(l / (long)this.frameTime);
                switch (n) {
                    case 0: {
                        int n2;
                        double d2;
                        double d3;
                        if (l5 != 0L || f3 != 0.0f) {
                            ((GCbCurveCtrl)object2).steps = new PolarCoords[(int)d];
                            d3 = (double)l5 / d;
                            d2 = (double)f3 / d;
                            n2 = 0;
                            while ((double)n2 < d - 1.0) {
                                ((GCbCurveCtrl)object2).steps[n2] = new PolarCoords((long)((double)l3 + (double)n2 * d3), (float)((double)f + (double)n2 * d2));
                                ++n2;
                            }
                            ((GCbCurveCtrl)object2).steps[(int)d - 1] = new PolarCoords(l3 + l5, f + f3);
                        } else {
                            ((GCbCurveCtrl)object2).steps = null;
                        }
                        if (l6 != 0L || f4 != 0.0f) {
                            ((GCbCurveCtrl)object2).steps2 = new PolarCoords[(int)d];
                            d3 = (double)l6 / d;
                            d2 = (double)f4 / d;
                            n2 = 0;
                            while ((double)n2 < d - 1.0) {
                                ((GCbCurveCtrl)object2).steps2[n2] = new PolarCoords((long)((double)l4 + (double)n2 * d3), (float)((double)f2 + (double)n2 * d2));
                                ++n2;
                            }
                            ((GCbCurveCtrl)object2).steps2[(int)d - 1] = new PolarCoords(l4 + l6, f2 + f4);
                        } else {
                            ((GCbCurveCtrl)object2).steps2 = null;
                        }
                        this.animGlyphBag.add(object2);
                        ((GCurveCtrl)object2).start();
                        break;
                    }
                    case 1: {
                        double d4;
                        int n3;
                        if (l5 != 0L || f3 != 0.0f) {
                            ((GCbCurveCtrl)object2).steps = new PolarCoords[(int)d];
                            n3 = 0;
                            while ((double)n3 < d - 1.0) {
                                d4 = Math.pow((double)(n3 + 1) / d, 4.0);
                                ((GCbCurveCtrl)object2).steps[n3++] = new PolarCoords(l3 + Math.round((double)l5 * d4), f + (float)((double)f3 * d4));
                            }
                            ((GCbCurveCtrl)object2).steps[(int)d - 1] = new PolarCoords(l3 + l5, f + f3);
                        } else {
                            ((GCbCurveCtrl)object2).steps = null;
                        }
                        if (l6 != 0L || f4 != 0.0f) {
                            ((GCbCurveCtrl)object2).steps2 = new PolarCoords[(int)d];
                            n3 = 0;
                            while ((double)n3 < d - 1.0) {
                                d4 = Math.pow((double)(n3 + 1) / d, 4.0);
                                ((GCbCurveCtrl)object2).steps2[n3++] = new PolarCoords(l4 + Math.round((double)l6 * d4), (float)((double)f2 + (double)f4 * d4));
                            }
                            ((GCbCurveCtrl)object2).steps2[(int)d - 1] = new PolarCoords(l4 + l6, f2 + f4);
                        } else {
                            ((GCbCurveCtrl)object2).steps2 = null;
                        }
                        this.animGlyphBag.add(object2);
                        ((GCurveCtrl)object2).start();
                        break;
                    }
                    case 2: {
                        double d5;
                        int n4;
                        if (l5 != 0L || f3 != 0.0f) {
                            ((GCbCurveCtrl)object2).steps = new PolarCoords[(int)d];
                            n4 = 0;
                            while ((double)n4 < d - 1.0) {
                                d5 = this.computeSigmoid(this.sigFactor, (double)(n4 + 1) / d);
                                ((GCbCurveCtrl)object2).steps[n4++] = new PolarCoords(l3 + Math.round((double)l5 * d5), (float)((double)f + (double)f3 * d5));
                            }
                            ((GCbCurveCtrl)object2).steps[(int)d - 1] = new PolarCoords(l3 + l5, f + f3);
                        } else {
                            ((GCbCurveCtrl)object2).steps = null;
                        }
                        if (l6 != 0L || f4 != 0.0f) {
                            ((GCbCurveCtrl)object2).steps2 = new PolarCoords[(int)d];
                            n4 = 0;
                            while ((double)n4 < d - 1.0) {
                                d5 = this.computeSigmoid(this.sigFactor, (double)(n4 + 1) / d);
                                ((GCbCurveCtrl)object2).steps2[n4++] = new PolarCoords(l4 + Math.round((double)l6 * d5), (float)((double)f2 + (double)f4 * d5));
                            }
                            ((GCbCurveCtrl)object2).steps2[(int)d - 1] = new PolarCoords(l4 + l6, f2 + f4);
                        } else {
                            ((GCbCurveCtrl)object2).steps2 = null;
                        }
                        this.animGlyphBag.add(object2);
                        ((GCurveCtrl)object2).start();
                        break;
                    }
                    default: {
                        System.err.println("Error : AnimManager.createCbCurveCtrlPtAnimation : unknown animation type");
                        break;
                    }
                }
            }
        } else {
            System.err.println("Error : AnimManager.createCbCurveCtrlPtAnimation : glyph is not a curve");
        }
    }

    void killCurveAnim(GCurveCtrl gCurveCtrl) {
        Object object;
        Long l = gCurveCtrl.target.getID();
        this.animGlyphBag.remove(gCurveCtrl);
        if (this.animatedGlyphs.containsKey(l)) {
            object = (int[])this.animatedGlyphs.get(l);
            object[4] = 0;
            if (this.allValuesEqualZero((int[])object)) {
                this.animatedGlyphs.remove(l);
            }
        }
        if (this.pendingGAnims.containsKey(l) && ((Hashtable)(object = (Object)((Hashtable)this.pendingGAnims.get(l)))).containsKey("ctrl")) {
            Vector vector = (Vector)((Hashtable)object).get("ctrl");
            AnimParams animParams = (AnimParams)vector.elementAt(0);
            vector.removeElementAt(0);
            if (vector.isEmpty()) {
                ((Hashtable)object).remove("ctrl");
            }
            if (this.parent.getGlyph(l) instanceof VQdCurve) {
                this.createQdCurveCtrlPtAnimation(animParams.duration, animParams.type, animParams.data, l);
            } else if (this.parent.getGlyph(l) instanceof VCbCurve) {
                this.createCbCurveCtrlPtAnimation(animParams.duration, animParams.type, animParams.data, l);
            }
        }
    }

    public void createCameraAnimation(long l, int n, Object object, Integer n2) {
        Camera camera = this.parent.getCamera(n2);
        switch (n) {
            case 0: {
                Object object2;
                if (this.animatedCameras.containsKey(n2) && ((int[])this.animatedCameras.get(n2))[0] == 1) {
                    this.putAsPendingCAnimation(n2, "pos", l, n, object);
                    break;
                }
                if (this.animatedCameras.containsKey(n2)) {
                    ((int[])this.animatedCameras.get((Object)n2))[0] = 1;
                } else {
                    object2 = new int[]{1, 0};
                    this.animatedCameras.put(n2, object2);
                }
                object2 = new CTranslation(camera, this, l);
                long l2 = camera.posx;
                long l3 = camera.posy;
                long l4 = ((LongPoint)object).x;
                long l5 = ((LongPoint)object).y;
                double d = Math.round(l / (long)this.frameTime);
                double d2 = (double)l4 / d;
                double d3 = (double)l5 / d;
                ((CTranslation)object2).steps = new LongPoint[(int)d];
                int n3 = 0;
                while ((double)n3 < d - 1.0) {
                    ((CTranslation)object2).steps[n3] = new LongPoint((long)((double)l2 + (double)n3 * d2), (long)((double)l3 + (double)n3 * d3));
                    ++n3;
                }
                ((CTranslation)object2).steps[(int)d - 1] = new LongPoint(l2 + l4, l3 + l5);
                this.animCameraBag.add(object2);
                ((CTranslation)object2).start();
                break;
            }
            case 1: {
                Object object3;
                if (this.animatedCameras.containsKey(n2) && ((int[])this.animatedCameras.get(n2))[0] == 1) {
                    this.putAsPendingCAnimation(n2, "pos", l, n, object);
                    break;
                }
                if (this.animatedCameras.containsKey(n2)) {
                    ((int[])this.animatedCameras.get((Object)n2))[0] = 1;
                } else {
                    object3 = new int[]{1, 0};
                    this.animatedCameras.put(n2, object3);
                }
                object3 = new CTranslation(camera, this, l);
                long l6 = camera.posx;
                long l7 = camera.posy;
                long l8 = ((LongPoint)object).x;
                long l9 = ((LongPoint)object).y;
                double d = Math.round((double)(l / (long)this.frameTime));
                ((CTranslation)object3).steps = new LongPoint[(int)d];
                int n4 = 0;
                while ((double)n4 < d - 1.0) {
                    double d4 = Math.pow((double)(n4 + 1) / d, 4.0);
                    long l10 = Math.round((double)l8 * d4);
                    long l11 = Math.round((double)l9 * d4);
                    ((CTranslation)object3).steps[n4++] = new LongPoint(l6 + l10, l7 + l11);
                }
                ((CTranslation)object3).steps[(int)d - 1] = new LongPoint(l6 + l8, l7 + l9);
                this.animCameraBag.add(object3);
                ((CTranslation)object3).start();
                break;
            }
            case 2: {
                Object object4;
                if (this.animatedCameras.containsKey(n2) && ((int[])this.animatedCameras.get(n2))[0] == 1) {
                    this.putAsPendingCAnimation(n2, "pos", l, n, object);
                    break;
                }
                if (this.animatedCameras.containsKey(n2)) {
                    ((int[])this.animatedCameras.get((Object)n2))[0] = 1;
                } else {
                    object4 = new int[]{1, 0};
                    this.animatedCameras.put(n2, object4);
                }
                object4 = new CTranslation(camera, this, l);
                long l12 = camera.posx;
                long l13 = camera.posy;
                long l14 = ((LongPoint)object).x;
                long l15 = ((LongPoint)object).y;
                double d = Math.round((double)(l / (long)this.frameTime));
                ((CTranslation)object4).steps = new LongPoint[(int)d];
                int n5 = 0;
                while ((double)n5 < d - 1.0) {
                    double d5 = this.computeSigmoid(this.sigFactor, (double)(n5 + 1) / d);
                    long l16 = Math.round((double)l14 * d5);
                    long l17 = Math.round((double)l15 * d5);
                    ((CTranslation)object4).steps[n5++] = new LongPoint(l12 + l16, l13 + l17);
                }
                ((CTranslation)object4).steps[(int)d - 1] = new LongPoint(l12 + l14, l13 + l15);
                this.animCameraBag.add(object4);
                ((CTranslation)object4).start();
                break;
            }
            case 3: {
                float f;
                Object object5;
                if (this.animatedCameras.containsKey(n2) && ((int[])this.animatedCameras.get(n2))[1] == 1) {
                    this.putAsPendingCAnimation(n2, "alt", l, n, object);
                    break;
                }
                if (this.animatedCameras.containsKey(n2)) {
                    ((int[])this.animatedCameras.get((Object)n2))[1] = 1;
                } else {
                    object5 = new int[]{0, 1};
                    this.animatedCameras.put(n2, object5);
                }
                object5 = new CZoom(camera, this, l);
                float f2 = camera.altitude;
                float f3 = ((Float)object).floatValue();
                int n6 = Math.round(l / (long)this.frameTime);
                double d = f3 / (float)n6;
                ((CZoom)object5).steps = new float[n6];
                int n7 = 0;
                while (n7 < n6 - 1) {
                    f = (float)((double)f2 + (double)n7 * d);
                    if (f < 0.0f) {
                        f = 0.0f;
                    }
                    ((CZoom)object5).steps[n7] = f;
                    ++n7;
                }
                f = f2 + f3;
                if (f < 0.0f) {
                    f = 0.0f;
                }
                ((CZoom)object5).steps[n6 - 1] = f;
                this.animCameraBag.add(object5);
                ((CZoom)object5).start();
                break;
            }
            case 4: {
                float f;
                Object object6;
                if (this.animatedCameras.containsKey(n2) && ((int[])this.animatedCameras.get(n2))[1] == 1) {
                    this.putAsPendingCAnimation(n2, "alt", l, n, object);
                    break;
                }
                if (this.animatedCameras.containsKey(n2)) {
                    ((int[])this.animatedCameras.get((Object)n2))[1] = 1;
                } else {
                    object6 = new int[]{0, 1};
                    this.animatedCameras.put(n2, object6);
                }
                object6 = new CZoom(camera, this, l);
                float f4 = camera.altitude;
                float f5 = ((Float)object).floatValue();
                double d = Math.round((double)(l / (long)this.frameTime));
                ((CZoom)object6).steps = new float[(int)d];
                int n8 = 0;
                while ((double)n8 < d - 1.0) {
                    double d6 = Math.pow((double)(n8 + 1) / d, 4.0);
                    float f6 = f5 * (float)d6;
                    f = f4 + f6;
                    if (f < 0.0f) {
                        f = 0.0f;
                    }
                    ((CZoom)object6).steps[n8++] = f;
                }
                f = f4 + f5;
                if (f < 0.0f) {
                    f = 0.0f;
                }
                ((CZoom)object6).steps[(int)d - 1] = f;
                this.animCameraBag.add(object6);
                ((CZoom)object6).start();
                break;
            }
            case 5: {
                float f;
                Object object7;
                if (this.animatedCameras.containsKey(n2) && ((int[])this.animatedCameras.get(n2))[1] == 1) {
                    this.putAsPendingCAnimation(n2, "alt", l, n, object);
                    break;
                }
                if (this.animatedCameras.containsKey(n2)) {
                    ((int[])this.animatedCameras.get((Object)n2))[1] = 1;
                } else {
                    object7 = new int[]{0, 1};
                    this.animatedCameras.put(n2, object7);
                }
                object7 = new CZoom(camera, this, l);
                float f7 = camera.altitude;
                float f8 = ((Float)object).floatValue();
                double d = Math.round((double)(l / (long)this.frameTime));
                ((CZoom)object7).steps = new float[(int)d];
                int n9 = 0;
                while ((double)n9 < d - 1.0) {
                    double d7 = this.computeSigmoid(this.sigFactor, (double)(n9 + 1) / d);
                    float f9 = f8 * (float)d7;
                    f = f7 + f9;
                    if (f < 0.0f) {
                        f = 0.0f;
                    }
                    ((CZoom)object7).steps[n9++] = f;
                }
                f = f7 + f8;
                if (f < 0.0f) {
                    f = 0.0f;
                }
                ((CZoom)object7).steps[(int)d - 1] = f;
                this.animCameraBag.add(object7);
                ((CZoom)object7).start();
                break;
            }
            case 6: {
                float f;
                Object object8;
                if (this.animatedCameras.containsKey(n2) && (((int[])this.animatedCameras.get(n2))[0] == 1 || ((int[])this.animatedCameras.get(n2))[1] == 1)) {
                    this.putAsPendingCAnimation(n2, "both", l, n, object);
                    break;
                }
                if (this.animatedCameras.containsKey(n2)) {
                    ((int[])this.animatedCameras.get((Object)n2))[0] = 1;
                    ((int[])this.animatedCameras.get((Object)n2))[1] = 1;
                } else {
                    object8 = new int[]{1, 1};
                    this.animatedCameras.put(n2, object8);
                }
                object8 = new CTransZoom(camera, this, l);
                float f10 = camera.altitude;
                long l18 = camera.posx;
                long l19 = camera.posy;
                float f11 = ((Float)((Vector)object).elementAt(0)).floatValue();
                long l20 = ((LongPoint)((Vector)object).elementAt((int)1)).x;
                long l21 = ((LongPoint)((Vector)object).elementAt((int)1)).y;
                double d = Math.round((double)(l / (long)this.frameTime));
                ((CTransZoom)object8).zsteps = new float[(int)d];
                ((CTransZoom)object8).tsteps = new LongPoint[(int)d];
                int n10 = 0;
                while ((double)n10 < d - 1.0) {
                    double d8 = this.computeSigmoid(this.sigFactor, (double)(n10 + 1) / d);
                    float f12 = f11 * (float)d8;
                    long l22 = Math.round((double)l20 * d8);
                    long l23 = Math.round((double)l21 * d8);
                    f = f10 + f12;
                    if (f < 0.0f) {
                        f = 0.0f;
                    }
                    ((CTransZoom)object8).zsteps[n10] = f;
                    ((CTransZoom)object8).tsteps[n10++] = new LongPoint(l18 + l22, l19 + l23);
                }
                f = f10 + f11;
                if (f < 0.0f) {
                    f = 0.0f;
                }
                ((CTransZoom)object8).zsteps[(int)d - 1] = f;
                ((CTransZoom)object8).tsteps[(int)d - 1] = new LongPoint(l18 + l20, l19 + l21);
                this.animCameraBag.add(object8);
                ((CTransZoom)object8).start();
                break;
            }
            default: {
                System.err.println("Error : AnimManager.createCameraAnimation : unknown animation type");
            }
        }
    }

    void putAsPendingCAnimation(Integer n, String string, long l, int n2, Object object) {
        if (this.pendingCAnims.containsKey(n)) {
            Hashtable hashtable = (Hashtable)this.pendingCAnims.get(n);
            Vector vector = hashtable.containsKey(string) ? (Vector)hashtable.get(string) : new Vector();
            vector.add(new AnimParams(l, n2, object));
            hashtable.put(string, vector);
        } else {
            Vector<AnimParams> vector = new Vector<AnimParams>();
            vector.add(new AnimParams(l, n2, object));
            Hashtable<String, Vector<AnimParams>> hashtable = new Hashtable<String, Vector<AnimParams>>();
            hashtable.put(string, vector);
            this.pendingCAnims.put(n, hashtable);
        }
    }

    void killCAnim(CAnimation cAnimation, String string) {
        Object object;
        Integer n = cAnimation.target.getID();
        this.animCameraBag.remove(cAnimation);
        if (this.animatedCameras.containsKey(n)) {
            object = (int[])this.animatedCameras.get(n);
            if (string.equals("pos")) {
                object[0] = 0;
            } else if (string.equals("alt")) {
                object[1] = false;
            } else if (string.equals("both")) {
                object[0] = false;
                object[1] = false;
            }
            if (this.allValuesEqualZero((int[])object)) {
                this.animatedCameras.remove(n);
            }
        }
        if (this.pendingCAnims.containsKey(n) && ((Hashtable)(object = (Object)((Hashtable)this.pendingCAnims.get(n)))).containsKey(string)) {
            Vector vector = (Vector)((Hashtable)object).get(string);
            AnimParams animParams = (AnimParams)vector.elementAt(0);
            vector.removeElementAt(0);
            if (vector.isEmpty()) {
                ((Hashtable)object).remove(string);
            }
            this.createCameraAnimation(animParams.duration, animParams.type, animParams.data, n);
        }
    }

    double computeSigmoid(int n, double d) {
        return (Math.atan((double)n * (2.0 * d - 1.0)) / Math.atan(n) + 1.0) / 2.0;
    }

    boolean allValuesEqualZero(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] != 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    int[] addElementsToIntArray(int[] nArray, int n) {
        int[] nArray2 = new int[nArray.length + n];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray2[n2] = nArray[n2];
            ++n2;
        }
        int n3 = nArray.length;
        while (n3 < nArray2.length) {
            nArray2[n3] = 0;
            ++n3;
        }
        return nArray2;
    }

    private void printHSVArray(float[] fArray) {
        System.out.println(fArray[0] + "," + fArray[1] + "," + fArray[2]);
    }
}

