/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import com.hp.hpl.jena.rdf.arp.JenaReader;
import com.hp.hpl.mesa.rdf.jena.common.NTripleWriter;
import com.hp.hpl.mesa.rdf.jena.common.RDFReaderFImpl;
import com.hp.hpl.mesa.rdf.jena.common.RDFWriterFImpl;
import com.hp.hpl.mesa.rdf.jena.mem.ModelMem;
import com.hp.hpl.mesa.rdf.jena.model.Literal;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFErrorHandler;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.RDFReader;
import com.hp.hpl.mesa.rdf.jena.model.RDFWriter;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.model.Statement;
import com.hp.hpl.mesa.rdf.jena.model.StmtIterator;
import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.VEllipse;
import com.xerox.VTM.glyphs.VPath;
import com.xerox.VTM.glyphs.VRectangle;
import com.xerox.VTM.glyphs.VRectangleOr;
import com.xerox.VTM.glyphs.VText;
import com.xerox.VTM.glyphs.VTriangleOr;
import com.xerox.VTM.svg.SVGReader;
import java.awt.Color;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.w3c.IsaViz.ConfigManager;
import org.w3c.IsaViz.Editor;
import org.w3c.IsaViz.ILiteral;
import org.w3c.IsaViz.INode;
import org.w3c.IsaViz.IProperty;
import org.w3c.IsaViz.IResource;
import org.w3c.IsaViz.ProgPanel;
import org.w3c.IsaViz.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class RDFLoader
implements RDFErrorHandler {
    private static final String DOT_TITLE = "dotfile";
    static int RDF_XML_READER = 0;
    static int NTRIPLE_READER = 1;
    Editor application;
    RDFReader parser;
    File rdfF;
    URL rdfU;
    File dotF;
    File svgF;
    boolean dltOnExit;
    StringBuffer nextResID;
    StringBuffer nextPredID;
    StringBuffer nextLitID;

    RDFLoader(Editor editor) {
        this.application = editor;
        this.nextResID = new StringBuffer("0");
        this.nextPredID = new StringBuffer("0");
        this.nextLitID = new StringBuffer("0");
    }

    void reset() {
        this.rdfF = null;
        this.rdfU = null;
        this.dotF = null;
        this.svgF = null;
        this.nextResID = new StringBuffer("0");
        this.nextPredID = new StringBuffer("0");
        this.nextLitID = new StringBuffer("0");
    }

    void initParser(int n) {
        if (n == 0) {
            this.parser = new JenaReader();
            this.parser.setErrorHandler((RDFErrorHandler)this);
        } else if (n == 1) {
            try {
                this.parser = new RDFReaderFImpl().getReader("N-TRIPLE");
                this.parser.setErrorHandler((RDFErrorHandler)this);
            }
            catch (RDFException rDFException) {
                System.err.println("Error: RDFLoader.initParser(): " + (Object)((Object)rDFException));
            }
        }
    }

    void load(Object object, int n) {
        ProgPanel progPanel = new ProgPanel("Resetting...", "Loading RDF");
        PrintWriter printWriter = null;
        try {
            Object object2;
            progPanel.setPBValue(5);
            this.application.rdfModel = new ModelMem();
            if (object instanceof File) {
                this.rdfF = (File)object;
                progPanel.setLabel("Loading local file " + this.rdfF.toString() + " ...");
                object2 = new FileReader(this.rdfF);
                printWriter = this.createDOTFile();
                progPanel.setPBValue(10);
                progPanel.setLabel("Initializing ARP(Jena) ...");
                this.initParser(n);
                progPanel.setPBValue(20);
                progPanel.setLabel("Parsing RDF ...");
                this.parser.read(this.application.rdfModel, (Reader)object2, Editor.DEFAULT_NAMESPACE);
            } else if (object instanceof URL) {
                this.rdfU = (URL)object;
                progPanel.setLabel("Loading remote file " + this.rdfU.toString() + " ...");
                printWriter = this.createDOTFile();
                progPanel.setPBValue(10);
                progPanel.setLabel("Initializing ARP(Jena) ...");
                this.initParser(n);
                progPanel.setPBValue(20);
                progPanel.setLabel("Parsing RDF ...");
                this.parser.read(this.application.rdfModel, this.rdfU.toString());
            }
            object2 = this.application.rdfModel.listNameSpaces();
            while (object2.hasNext()) {
                this.application.addNamespaceBinding("", object2.next(), new Boolean(false), true, false);
            }
            SH sH = new SH(printWriter, this.application);
            StmtIterator stmtIterator = this.application.rdfModel.listStatements();
            while (stmtIterator.hasNext()) {
                Statement statement = stmtIterator.next();
                if (statement.getObject() instanceof Resource) {
                    sH.statement(statement.getSubject(), statement.getPredicate(), (Resource)statement.getObject());
                    continue;
                }
                if (statement.getObject() instanceof Literal) {
                    sH.statement(statement.getSubject(), statement.getPredicate(), (Literal)statement.getObject());
                    continue;
                }
                System.err.println("Error: RDFLoader.load(): unknown kind of object: " + statement.getObject());
            }
            stmtIterator.close();
            progPanel.setPBValue(50);
            progPanel.setLabel("Creating temporary SVG file ...");
            this.svgF = Utils.createTempFile(Editor.m_TmpDir.toString(), "isv", ".svg");
            progPanel.setPBValue(60);
            progPanel.setLabel("Calling GraphViz ...");
            this.callDOT(printWriter);
            progPanel.setPBValue(80);
            progPanel.setLabel("Parsing SVG ...");
            this.displaySVG(this.application.xmlMngr.parse(this.svgF.toString(), false));
            this.cleanMapIDs();
            ConfigManager.assignColorsToGraph();
            this.application.showAnonIds(Editor.SHOW_ANON_ID);
            this.application.showResourceLabels(Editor.DISP_AS_LABEL);
            progPanel.setPBValue(100);
            progPanel.setLabel("Deleting temporary files ...");
            if (Editor.dltOnExit) {
                this.deleteFiles();
            }
            Editor.vsm.getGlobalView(Editor.vsm.getVirtualSpace("rdfSpace").getCamera(0), 500);
            this.application.rdfModel = null;
        }
        catch (IOException iOException) {
            this.application.errorMessages.append("RDFLoader.load() " + iOException + "\n");
            this.application.reportError = true;
        }
        catch (RDFException rDFException) {
            this.application.errorMessages.append("RDFLoader.load() " + (Object)((Object)rDFException) + "\n");
            this.application.reportError = true;
        }
        if (this.application.reportError) {
            Editor.vsm.getView("Graph").setStatusBarText("There were error/warning messages ('Ctrl+E' to display error log)");
            this.application.reportError = false;
        }
        progPanel.destroy();
    }

    Model merge(Object object, int n) {
        ModelMem modelMem = new ModelMem();
        this.initParser(n);
        if (object instanceof File) {
            try {
                FileReader fileReader = new FileReader((File)object);
                this.parser.read((Model)modelMem, (Reader)fileReader, Editor.DEFAULT_NAMESPACE);
            }
            catch (IOException iOException) {
                this.application.errorMessages.append("RDFLoader.merge() " + iOException + "\n");
                this.application.reportError = true;
            }
            catch (RDFException rDFException) {
                this.application.errorMessages.append("RDFLoader.merge() " + (Object)((Object)rDFException) + "\n");
                this.application.reportError = true;
            }
        } else if (object instanceof URL) {
            URL uRL = (URL)object;
            try {
                this.parser.read((Model)modelMem, uRL.toString());
            }
            catch (RDFException rDFException) {
                this.application.errorMessages.append("RDFLoader.merge() " + (Object)((Object)rDFException) + "\n");
                this.application.reportError = true;
            }
        }
        return modelMem;
    }

    void loadProperties(File file) {
        try {
            FileReader fileReader = new FileReader(file);
            this.initParser(RDF_XML_READER);
            ModelMem modelMem = new ModelMem();
            this.parser.read((Model)modelMem, (Reader)fileReader, Editor.DEFAULT_NAMESPACE);
            StmtIterator stmtIterator = modelMem.listStatements();
            while (stmtIterator.hasNext()) {
                Property property = stmtIterator.next().getPredicate();
                this.application.addPropertyType(property.getNameSpace(), property.getLocalName(), true);
            }
            modelMem = null;
        }
        catch (IOException iOException) {
            this.application.errorMessages.append("RDFLoader.loadProperties() " + iOException + "\n");
            this.application.reportError = true;
        }
        catch (RDFException rDFException) {
            this.application.errorMessages.append("RDFLoader.loadProperties() " + (Object)((Object)rDFException) + "\n");
            this.application.reportError = true;
        }
        if (this.application.reportError) {
            Editor.vsm.getView("Graph").setStatusBarText("There were error/warning messages ('Ctrl+E' to display error log)");
            this.application.reportError = false;
        }
    }

    void deleteFiles() {
        this.dotF.deleteOnExit();
        this.svgF.deleteOnExit();
    }

    PrintWriter createDOTFile() {
        this.dotF = this.initGraphFile();
        PrintWriter printWriter = null;
        if (this.dotF == null) {
            return null;
        }
        try {
            FileWriter fileWriter = new FileWriter(this.dotF);
            if (fileWriter != null) {
                printWriter = new PrintWriter(fileWriter);
            }
            if (printWriter != null) {
                this.processDOTParameters(printWriter);
            }
        }
        catch (IOException iOException) {
            this.application.errorMessages.append("RDFLoader.createDOTFile() " + iOException + "\n");
            this.application.reportError = true;
        }
        return printWriter;
    }

    File initGraphFile() {
        try {
            if (Editor.m_TmpDir == null || Editor.m_GraphVizPath == null) {
                this.application.errorMessages.append("Temporary DOT file initialization failed\n");
                this.application.errorMessages.append("TMP_DIR = " + Editor.m_TmpDir + "\n");
                this.application.errorMessages.append("GRAPH_VIZ_PATH = " + Editor.m_GraphVizPath + "\n");
                this.application.reportError = true;
                return null;
            }
        }
        catch (Exception exception) {
            this.application.errorMessages.append("Unable to create a temporary graph file. A graph cannot be generated.\n");
            this.application.reportError = true;
            return null;
        }
        File file = null;
        file = Utils.createTempFile(Editor.m_TmpDir.toString(), "isv", ".dot");
        if (file == null) {
            this.application.errorMessages.append("Failed to create a temporary graph file. A graph cannot be generated.\n");
            this.application.reportError = true;
            return null;
        }
        return file;
    }

    void processDOTParameters(PrintWriter printWriter) {
        printWriter.println("digraph dotfile{ ");
        String string = "black";
        String string2 = "black";
        String string3 = "black";
        String string4 = "black";
        String string5 = Editor.GRAPH_ORIENTATION;
        printWriter.println("node [fontname=" + Editor.vtmFontName + ",fontsize=" + Editor.vtmFontSize + ",color=" + string + ",fontcolor=" + string2 + "];");
        printWriter.println("edge [fontname=" + Editor.vtmFontName + ",fontsize=" + Editor.vtmFontSize + ",color=" + string3 + ",fontcolor=" + string4 + "];");
        printWriter.println("rankdir=" + string5 + ";");
    }

    private void callDOT(PrintWriter printWriter) {
        try {
            printWriter.println(" }");
            printWriter.close();
            if (!this.generateSVGFile(this.dotF.getAbsolutePath(), this.svgF.getAbsolutePath())) {
                this.application.errorMessages.append("An attempt to create a graph failed.\n");
                this.dotF.delete();
                this.svgF.delete();
                return;
            }
        }
        catch (Exception exception) {
            this.application.errorMessages.append("Exception generating graph: " + exception.getMessage() + "\n");
            this.application.reportError = true;
        }
    }

    private boolean generateSVGFile(String string, String string2) {
        String[] stringArray = new String[]{Editor.m_GraphVizPath.toString(), "-Tsvg", "-o", string2, string};
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec(stringArray);
            process.waitFor();
        }
        catch (Exception exception) {
            this.application.errorMessages.append("Error: generating OutputFile.\n");
            this.application.reportError = true;
            return false;
        }
        return true;
    }

    void displaySVG(Document document) {
        int n;
        Enumeration enumeration;
        Element element = document.getDocumentElement();
        if (element.hasAttribute("width") && element.hasAttribute("height")) {
            enumeration = element.getAttribute("width");
            String string = element.getAttribute("height");
            try {
                long l = -new Long(((String)((Object)enumeration)).substring(0, ((String)((Object)enumeration)).length() - 2)).longValue() / 2L;
                long l2 = -new Long(string.substring(0, string.length() - 2)).longValue() / 2L;
                SVGReader.setPositionOffset((long)l, (long)l2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        if (Editor.GRAPHVIZ_VERSION == 0) {
            enumeration = element.getChildNodes();
            n = 0;
            while (n < enumeration.getLength()) {
                Node node = enumeration.item(n);
                if (node.getNodeType() == 1) {
                    this.processSVG176Node((Element)node);
                }
                ++n;
            }
        } else {
            enumeration = element.getElementsByTagName("g").item(0).getChildNodes();
            n = 0;
            while (n < enumeration.getLength()) {
                Node node = enumeration.item(n);
                if (node.getNodeType() == 1) {
                    this.processSVG1711Node((Element)node);
                }
                ++n;
            }
        }
        enumeration = this.application.resourcesByURI.elements();
        while (enumeration.hasMoreElements()) {
            this.application.geomMngr.correctResourceTextAndShape((IResource)enumeration.nextElement());
        }
        Enumeration enumeration2 = this.application.literals.elements();
        while (enumeration2.hasMoreElements()) {
            this.application.geomMngr.correctLiteralTextAndShape((ILiteral)enumeration2.nextElement());
        }
        SVGReader.setPositionOffset((long)0L, (long)0L);
    }

    void processSVG176Node(Element element) {
        String string = element.getLocalName();
        if (string.equals("a")) {
            NodeList nodeList = element.getElementsByTagName("ellipse");
            if (nodeList.getLength() > 0) {
                VEllipse vEllipse = SVGReader.createEllipse((Element)((Element)nodeList.item(0)));
                VText vText = SVGReader.createText((Element)((Element)element.getElementsByTagName("text").item(0)));
                Editor.vsm.addGlyph((Glyph)vEllipse, "rdfSpace");
                Editor.vsm.addGlyph((Glyph)vText, "rdfSpace");
                IResource iResource = this.getResourceByMapID(element.getAttribute("xlink:href"));
                iResource.setGlyph(vEllipse);
                iResource.setGlyphText(vText);
            } else {
                nodeList = element.getElementsByTagName("g");
                if (nodeList.getLength() > 0) {
                    VPath vPath = SVGReader.createPath((Element)((Element)((Element)nodeList.item(0)).getElementsByTagName("path").item(0)), (VPath)new VPath());
                    Editor.vsm.addGlyph((Glyph)vPath, "rdfSpace");
                    Element element2 = (Element)element.getElementsByTagName("polygon").item(0);
                    Vector vector = new Vector();
                    SVGReader.translateSVGPolygon((String)element2.getAttribute("points"), vector);
                    LongPoint longPoint = (LongPoint)vector.firstElement();
                    long l = longPoint.x;
                    long l2 = longPoint.x;
                    long l3 = longPoint.y;
                    long l4 = longPoint.y;
                    int n = 1;
                    while (n < vector.size()) {
                        longPoint = (LongPoint)vector.elementAt(n);
                        if (longPoint.x < l) {
                            l = longPoint.x;
                        }
                        if (longPoint.x > l2) {
                            l2 = longPoint.x;
                        }
                        if (longPoint.y < l3) {
                            l3 = longPoint.y;
                        }
                        if (longPoint.y > l4) {
                            l4 = longPoint.y;
                        }
                        ++n;
                    }
                    PathIterator pathIterator = vPath.getJava2DPathIterator();
                    double[] dArray = new double[6];
                    while (!pathIterator.isDone()) {
                        pathIterator.currentSegment(dArray);
                        pathIterator.next();
                    }
                    double d = 0.0;
                    Point2D point2D = Utils.computeStepValue(dArray[2], -dArray[3], dArray[4], -dArray[5]);
                    if (point2D.getX() == 0.0) {
                        d = 0.0;
                        if (point2D.getY() < 0.0) {
                            d = Math.PI;
                        }
                    } else {
                        d = Math.atan(point2D.getY() / point2D.getX());
                        d = point2D.getX() < 0.0 ? (d += 1.5707963267948966) : (d -= 1.5707963267948966);
                    }
                    VTriangleOr vTriangleOr = new VTriangleOr((l2 + l) / 2L, -(l4 + l3) / 2L, 0.0f, Math.max(l2 - l, l4 - l3) / 2L, Color.black, (float)d);
                    Editor.vsm.addGlyph((Glyph)vTriangleOr, "rdfSpace");
                    VText vText = SVGReader.createText((Element)((Element)element.getElementsByTagName("text").item(0)));
                    Editor.vsm.addGlyph((Glyph)vText, "rdfSpace");
                    Vector vector2 = this.application.getProperties(((Element)element.getElementsByTagName("text").item(0)).getFirstChild().getNodeValue());
                    IProperty iProperty = null;
                    String string2 = element.getAttribute("xlink:href");
                    int n2 = 0;
                    while (n2 < vector2.size()) {
                        iProperty = (IProperty)vector2.elementAt(n2);
                        if (iProperty.getMapID().equals(string2)) {
                            iProperty.setGlyph(vPath, vTriangleOr);
                            iProperty.setGlyphText(vText);
                            break;
                        }
                        ++n2;
                    }
                } else {
                    nodeList = element.getElementsByTagName("polygon");
                    if (nodeList.getLength() > 0) {
                        Element element3;
                        VRectangleOr vRectangleOr = SVGReader.createRectangleFromPolygon((Element)((Element)nodeList.item(0)));
                        VText vText = null;
                        if (vRectangleOr != null) {
                            Editor.vsm.addGlyph((Glyph)vRectangleOr, "rdfSpace");
                        }
                        if ((element3 = (Element)element.getElementsByTagName("text").item(0)) != null) {
                            vText = SVGReader.createText((Element)element3);
                            Editor.vsm.addGlyph((Glyph)vText, "rdfSpace");
                        }
                        String string3 = element.getAttribute("xlink:href");
                        int n = 0;
                        while (n < this.application.literals.size()) {
                            ILiteral iLiteral = (ILiteral)this.application.literals.elementAt(n);
                            if (iLiteral.getMapID().equals(string3)) {
                                iLiteral.setGlyph((VRectangle)vRectangleOr);
                                if (vText != null) {
                                    iLiteral.setGlyphText(vText);
                                }
                                break;
                            }
                            ++n;
                        }
                    } else {
                        JOptionPane.showMessageDialog(this.application.cmp, "An error occured when parsing the SVG file.\nThis might be caused by an incompatibility with the selected version of GraphViz.\nTry selecting another version of GraphViz in the Preferences window.");
                    }
                }
            }
        } else if (!string.equals("text")) {
            JOptionPane.showMessageDialog(this.application.cmp, "An error occured when parsing the SVG file.\nThis might be caused by an incompatibility with the selected version of GraphViz.\nTry selecting another version of GraphViz in the Preferences window.");
        }
    }

    void processSVG1711Node(Element element) {
        block16: {
            block17: {
                block18: {
                    Element element2;
                    Element element3;
                    NodeList nodeList;
                    block19: {
                        if (!element.getAttribute("class").equals("node")) break block17;
                        nodeList = element.getElementsByTagName("a");
                        if (nodeList.getLength() <= 0) break block18;
                        element3 = (Element)nodeList.item(0);
                        if ((nodeList = element3.getElementsByTagName("ellipse")).getLength() <= 0) break block19;
                        VEllipse vEllipse = SVGReader.createEllipse((Element)((Element)nodeList.item(0)));
                        Element element4 = (Element)element3.getElementsByTagName("text").item(0);
                        VText vText = SVGReader.createText((Element)element4);
                        Editor.vsm.addGlyph((Glyph)vEllipse, "rdfSpace");
                        Editor.vsm.addGlyph((Glyph)vText, "rdfSpace");
                        IResource iResource = this.getResourceByMapID(element3.getAttributeNS("http://www.w3.org/1999/xlink", "href"));
                        iResource.setGlyph(vEllipse);
                        iResource.setGlyphText(vText);
                        break block16;
                    }
                    nodeList = element3.getElementsByTagName("polygon");
                    if (nodeList.getLength() <= 0) break block16;
                    VRectangleOr vRectangleOr = SVGReader.createRectangleFromPolygon((Element)((Element)nodeList.item(0)));
                    VText vText = null;
                    if (vRectangleOr != null) {
                        Editor.vsm.addGlyph((Glyph)vRectangleOr, "rdfSpace");
                    }
                    if ((element2 = (Element)element3.getElementsByTagName("text").item(0)) != null) {
                        vText = SVGReader.createText((Element)element2);
                        Editor.vsm.addGlyph((Glyph)vText, "rdfSpace");
                    }
                    String string = element3.getAttributeNS("http://www.w3.org/1999/xlink", "href");
                    int n = 0;
                    while (n < this.application.literals.size()) {
                        ILiteral iLiteral = (ILiteral)this.application.literals.elementAt(n);
                        if (iLiteral.getMapID().equals(string)) {
                            iLiteral.setGlyph((VRectangle)vRectangleOr);
                            if (vText == null) break block16;
                            iLiteral.setGlyphText(vText);
                            break block16;
                        }
                        ++n;
                    }
                    break block16;
                }
                System.err.println("Error: processSVG1711Node: unknown tag in " + element);
                break block16;
            }
            if (element.getAttribute("class").equals("edge")) {
                Element element5 = (Element)element.getElementsByTagName("a").item(0);
                VPath vPath = SVGReader.createPath((Element)((Element)element5.getElementsByTagName("path").item(0)), (VPath)new VPath());
                Editor.vsm.addGlyph((Glyph)vPath, "rdfSpace");
                Element element6 = (Element)element5.getElementsByTagName("polygon").item(0);
                Vector vector = new Vector();
                SVGReader.translateSVGPolygon((String)element6.getAttribute("points"), vector);
                LongPoint longPoint = (LongPoint)vector.firstElement();
                long l = longPoint.x;
                long l2 = longPoint.x;
                long l3 = longPoint.y;
                long l4 = longPoint.y;
                int n = 1;
                while (n < vector.size()) {
                    longPoint = (LongPoint)vector.elementAt(n);
                    if (longPoint.x < l) {
                        l = longPoint.x;
                    }
                    if (longPoint.x > l2) {
                        l2 = longPoint.x;
                    }
                    if (longPoint.y < l3) {
                        l3 = longPoint.y;
                    }
                    if (longPoint.y > l4) {
                        l4 = longPoint.y;
                    }
                    ++n;
                }
                PathIterator pathIterator = vPath.getJava2DPathIterator();
                float[] fArray = new float[6];
                while (!pathIterator.isDone()) {
                    pathIterator.currentSegment(fArray);
                    pathIterator.next();
                }
                double d = 0.0;
                Point2D point2D = Utils.computeStepValue(fArray[2], -fArray[3], fArray[4], -fArray[5]);
                if (point2D.getX() == 0.0) {
                    d = 0.0;
                    if (point2D.getY() < 0.0) {
                        d = Math.PI;
                    }
                } else {
                    d = Math.atan(point2D.getY() / point2D.getX());
                    d = point2D.getX() < 0.0 ? (d += 1.5707963267948966) : (d -= 1.5707963267948966);
                }
                VTriangleOr vTriangleOr = new VTriangleOr((l2 + l) / 2L, -(l4 + l3) / 2L, 0.0f, Math.max(l2 - l, l4 - l3) / 2L, Color.black, (float)d);
                Editor.vsm.addGlyph((Glyph)vTriangleOr, "rdfSpace");
                VText vText = SVGReader.createText((Element)((Element)element5.getElementsByTagName("text").item(0)));
                Editor.vsm.addGlyph((Glyph)vText, "rdfSpace");
                Vector vector2 = this.application.getProperties(((Element)element5.getElementsByTagName("text").item(0)).getFirstChild().getNodeValue());
                String string = element5.getAttributeNS("http://www.w3.org/1999/xlink", "href");
                int n2 = 0;
                while (n2 < vector2.size()) {
                    IProperty iProperty = (IProperty)vector2.elementAt(n2);
                    if (iProperty.getMapID().equals(string)) {
                        iProperty.setGlyph(vPath, vTriangleOr);
                        iProperty.setGlyphText(vText);
                        break;
                    }
                    ++n2;
                }
            }
        }
    }

    void cleanMapIDs() {
        Enumeration<Object> enumeration;
        Enumeration enumeration2 = this.application.literals.elements();
        while (enumeration2.hasMoreElements()) {
            ((ILiteral)enumeration2.nextElement()).setMapID(null);
        }
        Enumeration enumeration3 = this.application.propertiesByURI.elements();
        while (enumeration3.hasMoreElements()) {
            Vector vector = (Vector)enumeration3.nextElement();
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ((IProperty)enumeration.nextElement()).setMapID(null);
            }
        }
        enumeration = this.application.resourcesByURI.elements();
        while (enumeration.hasMoreElements()) {
            ((IResource)enumeration.nextElement()).setMapID(null);
        }
    }

    IResource getResourceByMapID(String string) {
        IResource iResource = null;
        Enumeration enumeration = this.application.resourcesByURI.elements();
        while (enumeration.hasMoreElements()) {
            IResource iResource2 = (IResource)enumeration.nextElement();
            if (!iResource2.getMapID().equals(string)) continue;
            iResource = iResource2;
            break;
        }
        return iResource;
    }

    void incResID() {
        byte by;
        boolean bl = false;
        int n = 0;
        while (n < this.nextResID.length()) {
            by = (byte)this.nextResID.charAt(n);
            if (by < 122) {
                this.nextResID.setCharAt(n, (char)Utils.incByte(by));
                bl = true;
                int n2 = 0;
                while (n2 < n) {
                    this.nextResID.setCharAt(n2, '0');
                    ++n2;
                }
                break;
            }
            ++n;
        }
        if (!bl) {
            by = 0;
            while (by < this.nextResID.length()) {
                this.nextResID.setCharAt(by, '0');
                by = (byte)(by + 1);
            }
            this.nextResID.append('0');
        }
    }

    void incPredID() {
        byte by;
        boolean bl = false;
        int n = 0;
        while (n < this.nextPredID.length()) {
            by = (byte)this.nextPredID.charAt(n);
            if (by < 122) {
                this.nextPredID.setCharAt(n, (char)Utils.incByte(by));
                bl = true;
                int n2 = 0;
                while (n2 < n) {
                    this.nextPredID.setCharAt(n2, '0');
                    ++n2;
                }
                break;
            }
            ++n;
        }
        if (!bl) {
            by = 0;
            while (by < this.nextPredID.length()) {
                this.nextPredID.setCharAt(by, '0');
                by = (byte)(by + 1);
            }
            this.nextPredID.append('0');
        }
    }

    void incLitID() {
        byte by;
        boolean bl = false;
        int n = 0;
        while (n < this.nextLitID.length()) {
            by = (byte)this.nextLitID.charAt(n);
            if (by < 122) {
                this.nextLitID.setCharAt(n, (char)Utils.incByte(by));
                bl = true;
                int n2 = 0;
                while (n2 < n) {
                    this.nextLitID.setCharAt(n2, '0');
                    ++n2;
                }
                break;
            }
            ++n;
        }
        if (!bl) {
            by = 0;
            while (by < this.nextLitID.length()) {
                this.nextLitID.setCharAt(by, '0');
                by = (byte)(by + 1);
            }
            this.nextLitID.append('0');
        }
    }

    Vector processStatement(Resource resource, Property property, Resource resource2) {
        IResource iResource = this.addResource(resource);
        IProperty iProperty = this.addProperty(property);
        IResource iResource2 = this.addResource(resource2);
        iResource.addOutgoingPredicate(iProperty);
        iProperty.setSubject(iResource);
        iProperty.setObject(iResource2);
        iResource2.addIncomingPredicate(iProperty);
        Vector<INode> vector = new Vector<INode>();
        vector.add(iResource);
        vector.add(iProperty);
        vector.add(iResource2);
        return vector;
    }

    Vector processStatement(Resource resource, Property property, Literal literal) {
        IResource iResource = this.addResource(resource);
        IProperty iProperty = this.addProperty(property);
        ILiteral iLiteral = this.addLiteral(literal);
        iResource.addOutgoingPredicate(iProperty);
        iProperty.setSubject(iResource);
        iProperty.setObject(iLiteral);
        iLiteral.setIncomingPredicate(iProperty);
        Vector<INode> vector = new Vector<INode>();
        vector.add(iResource);
        vector.add(iProperty);
        vector.add(iLiteral);
        if (iProperty.getIdent().equals(Editor.RDFS_NAMESPACE_URI + "label")) {
            iResource.setLabel(iLiteral.getValue());
        }
        return vector;
    }

    IResource addResource(Resource resource) {
        IResource iResource = new IResource(resource);
        if (!this.application.resourcesByURI.containsKey(iResource.getIdent())) {
            this.application.resourcesByURI.put(iResource.getIdent(), iResource);
            return iResource;
        }
        return (IResource)this.application.resourcesByURI.get(iResource.getIdent());
    }

    IProperty addProperty(Property property) {
        IProperty iProperty = new IProperty(property);
        if (this.application.propertiesByURI.containsKey(iProperty.getIdent())) {
            Vector vector = (Vector)this.application.propertiesByURI.get(iProperty.getIdent());
            vector.add(iProperty);
        } else {
            Vector<IProperty> vector = new Vector<IProperty>();
            vector.add(iProperty);
            this.application.propertiesByURI.put(iProperty.getIdent(), vector);
        }
        this.application.addPropertyType(iProperty.getNamespace(), iProperty.getLocalname(), true);
        return iProperty;
    }

    ILiteral addLiteral(Literal literal) {
        ILiteral iLiteral = new ILiteral(literal);
        this.application.literals.add(iLiteral);
        return iLiteral;
    }

    void generateJenaModel() {
        this.application.rdfModel = new ModelMem();
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        Hashtable hashtable2 = new Hashtable();
        Enumeration enumeration = this.application.propertiesByURI.elements();
        while (enumeration.hasMoreElements()) {
            Enumeration enumeration2 = ((Vector)enumeration.nextElement()).elements();
            while (enumeration2.hasMoreElements()) {
                INode iNode;
                IProperty iProperty = (IProperty)enumeration2.nextElement();
                IResource iResource = iProperty.getSubject();
                INode iNode2 = iProperty.getObject();
                if (iResource == null || iNode2 == null || iProperty.isCommented()) continue;
                Resource resource = null;
                if (hashtable.containsKey(iResource)) {
                    resource = (Resource)hashtable.get(iResource);
                } else if (iResource.isAnon()) {
                    try {
                        resource = this.application.rdfModel.createResource();
                        hashtable.put(iResource, resource);
                    }
                    catch (RDFException rDFException) {
                        JOptionPane.showMessageDialog(this.application.cmp, "An error occured while creating anonymous resource\n" + iResource.toString() + "\n" + (Object)((Object)rDFException));
                    }
                } else {
                    try {
                        resource = this.application.rdfModel.createResource(iResource.getIdent());
                        hashtable.put(iResource, resource);
                    }
                    catch (RDFException rDFException) {
                        JOptionPane.showMessageDialog(this.application.cmp, "An error occured while creating resource\n" + iResource.toString() + "\n" + (Object)((Object)rDFException));
                    }
                }
                Property property = null;
                try {
                    if (hashtable2.containsKey(iProperty.getIdent())) {
                        property = (Property)hashtable2.get(iProperty.getIdent());
                    } else {
                        property = this.application.rdfModel.createProperty(iProperty.getNamespace(), iProperty.getLocalname());
                        hashtable.put(iProperty.getIdent(), property);
                    }
                }
                catch (RDFException rDFException) {
                    JOptionPane.showMessageDialog(this.application.cmp, "An error occured while creating property\n" + iProperty.toString() + "\n" + (Object)((Object)rDFException));
                }
                Resource resource2 = null;
                if (iNode2 instanceof IResource) {
                    iNode = (IResource)iNode2;
                    if (hashtable.containsKey(iNode)) {
                        resource2 = (Resource)hashtable.get(iNode);
                    } else if (((IResource)iNode).isAnon()) {
                        try {
                            resource2 = this.application.rdfModel.createResource();
                            hashtable.put(iNode, resource2);
                        }
                        catch (RDFException rDFException) {
                            JOptionPane.showMessageDialog(this.application.cmp, "An error occured while creating anonymous resource\n" + iResource.toString() + "\n" + (Object)((Object)rDFException));
                        }
                    } else {
                        try {
                            resource2 = this.application.rdfModel.createResource(((IResource)iNode).getIdent());
                            hashtable.put(iNode, resource2);
                        }
                        catch (RDFException rDFException) {
                            JOptionPane.showMessageDialog(this.application.cmp, "An error occured while creating resource\n" + iResource.toString() + "\n" + (Object)((Object)rDFException));
                        }
                    }
                } else {
                    iNode = (ILiteral)iNode2;
                    try {
                        String string;
                        if (!((ILiteral)iNode).escapesXMLChars()) {
                            if (((ILiteral)iNode).getLang() != null) {
                                resource2 = this.application.rdfModel.createLiteral(((ILiteral)iNode).getValue(), ((ILiteral)iNode).getLang(), false);
                            } else {
                                string = Editor.ALWAYS_INCLUDE_LANG_IN_LITERALS ? Editor.DEFAULT_LANGUAGE_IN_LITERALS : "";
                                resource2 = this.application.rdfModel.createLiteral(((ILiteral)iNode).getValue(), string, false);
                            }
                        } else if (((ILiteral)iNode).getLang() != null) {
                            resource2 = this.application.rdfModel.createLiteral(((ILiteral)iNode).getValue(), ((ILiteral)iNode).getLang());
                        } else {
                            string = Editor.ALWAYS_INCLUDE_LANG_IN_LITERALS ? Editor.DEFAULT_LANGUAGE_IN_LITERALS : "";
                            resource2 = this.application.rdfModel.createLiteral(((ILiteral)iNode).getValue(), string);
                        }
                    }
                    catch (RDFException rDFException) {
                        JOptionPane.showMessageDialog(this.application.cmp, "An error occured while creating literal\n" + iNode2.toString() + "\n" + (Object)((Object)rDFException));
                    }
                }
                try {
                    iNode = this.application.rdfModel.createStatement(resource, property, (RDFNode)resource2);
                    this.application.rdfModel.add((Statement)iNode);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this.application.cmp, "An error occured while creating the Jena model:\nadding statement " + iProperty.toString() + "(" + iResource.toString() + "," + iNode2.toString() + ")\n" + exception);
                }
            }
        }
    }

    public void save(Model model, File file) {
        Editor.vsm.getView("Graph").setStatusBarText("Exporting to RDF/XML " + file.toString() + " ...");
        try {
            RDFWriter rDFWriter = Editor.ABBREV_SYNTAX ? new RDFWriterFImpl().getWriter("RDF/XML-ABBREV") : new RDFWriterFImpl().getWriter("RDF/XML");
            int n = 0;
            while (n < this.application.tblp.nsTableModel.getRowCount()) {
                if (((String)this.application.tblp.nsTableModel.getValueAt(n, 0)).length() > 0) {
                    rDFWriter.setNsPrefix((String)this.application.tblp.nsTableModel.getValueAt(n, 0), (String)this.application.tblp.nsTableModel.getValueAt(n, 1));
                }
                ++n;
            }
            FileWriter fileWriter = new FileWriter(file);
            rDFWriter.write(model, (Writer)fileWriter, Editor.DEFAULT_NAMESPACE);
            Editor.vsm.getView("Graph").setStatusBarText("Exporting to RDF/XML " + file.toString() + " ...done");
        }
        catch (RDFException rDFException) {
            this.application.errorMessages.append("RDF exception in RDFLoader.save() " + (Object)((Object)rDFException) + "\n");
            this.application.reportError = true;
        }
        catch (IOException iOException) {
            this.application.errorMessages.append("I/O exception in RDFLoader.save() " + iOException + "\n");
            this.application.reportError = true;
        }
        if (this.application.reportError) {
            Editor.vsm.getView("Graph").setStatusBarText("There were error/warning messages ('Ctrl+E' to display error log)");
            this.application.reportError = false;
        }
    }

    public StringBuffer serialize(Model model) {
        try {
            RDFWriter rDFWriter = Editor.ABBREV_SYNTAX ? new RDFWriterFImpl().getWriter("RDF/XML-ABBREV") : new RDFWriterFImpl().getWriter("RDF/XML");
            int n = 0;
            while (n < this.application.tblp.nsTableModel.getRowCount()) {
                if (((String)this.application.tblp.nsTableModel.getValueAt(n, 0)).length() > 0) {
                    rDFWriter.setNsPrefix((String)this.application.tblp.nsTableModel.getValueAt(n, 0), (String)this.application.tblp.nsTableModel.getValueAt(n, 1));
                }
                ++n;
            }
            StringWriter stringWriter = new StringWriter();
            rDFWriter.write(model, (Writer)stringWriter, Editor.DEFAULT_NAMESPACE);
            return stringWriter.getBuffer();
        }
        catch (RDFException rDFException) {
            this.application.errorMessages.append("RDF exception in RDFLoader.save() " + (Object)((Object)rDFException) + "\n");
            this.application.reportError = true;
            if (this.application.reportError) {
                Editor.vsm.getView("Graph").setStatusBarText("There were error/warning messages ('Ctrl+E' to display error log)");
                this.application.reportError = false;
            }
            return new StringBuffer();
        }
    }

    public void saveAsTriples(Model model, File file) {
        Editor.vsm.getView("Graph").setStatusBarText("Exporting to N-Triples " + file.toString() + " ...");
        try {
            FileWriter fileWriter = new FileWriter(file);
            new NTripleWriter().write(model, (Writer)fileWriter, Editor.DEFAULT_NAMESPACE);
            Editor.vsm.getView("Graph").setStatusBarText("Exporting to N-Triples " + file.toString() + " ...done");
        }
        catch (Exception exception) {
            this.application.errorMessages.append("RDF exception in RDFLoader.saveAsTriples() " + exception + "\n");
            this.application.reportError = true;
        }
    }

    public void error(Exception exception) {
        this.application.errorMessages.append("RDFErrorHandler.error: " + exception + "\n");
        this.application.reportError = true;
    }

    public void fatalError(Exception exception) {
        this.application.errorMessages.append("RDFErrorHandler.fatalError: " + exception + "\n");
        this.application.reportError = true;
    }

    public void warning(Exception exception) {
        this.application.errorMessages.append("RDFErrorHandler.warning: " + exception + "\n");
        this.application.reportError = true;
    }

    private class SH {
        PrintWriter pw;
        Editor application;
        int numLiterals = 0;

        public SH(PrintWriter printWriter, Editor editor) {
            this.pw = printWriter;
            this.application = editor;
        }

        public void statement(Resource resource, Property property, Resource resource2) {
            Vector vector = RDFLoader.this.processStatement(resource, property, resource2);
            this.statementDotResource((IResource)vector.elementAt(0), resource, (IProperty)vector.elementAt(1), property, (IResource)vector.elementAt(2), resource2);
        }

        public void statement(Resource resource, Property property, Literal literal) {
            Vector vector = RDFLoader.this.processStatement(resource, property, literal);
            ++this.numLiterals;
            this.statementDotLiteral((IResource)vector.elementAt(0), resource, (IProperty)vector.elementAt(1), property, (ILiteral)vector.elementAt(2), literal);
        }

        public void statementDotResource(IResource iResource, Resource resource, IProperty iProperty, Property property, IResource iResource2, Resource resource2) {
            if (this.pw == null) {
                return;
            }
            this.printFirstPart(resource, iResource);
            this.pw.print("\" -> ");
            String string = this.application.rdfLdr.nextPredID.toString();
            iProperty.setMapID(string);
            this.application.rdfLdr.incPredID();
            boolean bl = true;
            if (iResource2.getMapID() == null) {
                String string2 = this.application.rdfLdr.nextResID.toString();
                iResource2.setMapID(string2);
                this.application.rdfLdr.incResID();
                bl = false;
            }
            if (resource2.isAnon()) {
                this.pw.println("\"" + iResource2.getIdent() + "\" [label=\"" + property.getURI() + "\\l\",URL=\"" + string + "\"];");
                if (!bl) {
                    this.pw.println("\"" + iResource2.getIdent() + "\" [URL=\"" + iResource2.getMapID() + "\"];");
                }
            } else {
                this.pw.println("\"" + resource2.getURI() + "\" [label=\"" + property.getURI() + "\\l\",URL=\"" + string + "\"];");
                if (!bl) {
                    this.pw.println("\"" + resource2.getURI() + "\" [URL=\"" + iResource2.getMapID() + "\"];");
                }
            }
        }

        public void statementDotLiteral(IResource iResource, Resource resource, IProperty iProperty, Property property, ILiteral iLiteral, Literal literal) {
            if (this.pw == null) {
                return;
            }
            this.printFirstPart(resource, iResource);
            try {
                String string = new String(literal.getString());
                string = string.replace('\n', ' ');
                string = string.replace('\f', ' ');
                string = string.replace('\r', ' ');
                if (string.indexOf(34) != -1) {
                    string = Utils.replaceString(string, "\"", "\\\"");
                }
                String string2 = string.length() >= Editor.MAX_LIT_CHAR_COUNT ? string.substring(0, Editor.MAX_LIT_CHAR_COUNT) + " ..." : string;
                String string3 = this.application.rdfLdr.nextPredID.toString();
                iProperty.setMapID(string3);
                this.application.rdfLdr.incPredID();
                String string4 = this.application.rdfLdr.nextLitID.toString();
                iLiteral.setMapID(string4);
                this.application.rdfLdr.incLitID();
                String string5 = "Literal_" + Integer.toString(this.numLiterals);
                this.pw.print("\" -> \"" + string5);
                this.pw.println("\" [label=\"" + property.getURI() + "\\l\",URL=\"" + string3 + "\"];");
                this.pw.println("\"" + string5 + "\" [shape=box,label=\"" + string2 + "\\l\",URL=\"" + string4 + "\"];");
            }
            catch (RDFException rDFException) {
                this.application.errorMessages.append("Error: SH.statementDotLiteral: " + (Object)((Object)rDFException) + "\n");
                this.application.reportError = true;
            }
        }

        public void printFirstPart(Resource resource, IResource iResource) {
            try {
                boolean bl = true;
                if (iResource.getMapID() == null) {
                    String string = this.application.rdfLdr.nextResID.toString();
                    iResource.setMapID(string);
                    this.application.rdfLdr.incResID();
                    bl = false;
                }
                if (resource.isAnon()) {
                    if (!bl) {
                        this.pw.println("\"" + Editor.ANON_NODE + IResource.getJenaAnonId(resource.getId()) + "\" [URL=\"" + iResource.getMapID() + "\"];");
                    }
                    this.pw.print("\"" + Editor.ANON_NODE + IResource.getJenaAnonId(resource.getId()));
                } else {
                    if (!bl) {
                        this.pw.println("\"" + resource.getURI() + "\" [URL=\"" + iResource.getMapID() + "\"];");
                    }
                    this.pw.print("\"" + resource.getURI());
                }
            }
            catch (RDFException rDFException) {
                this.application.errorMessages.append("Error: SH.printFirstPart(): " + (Object)((Object)rDFException) + "\n");
                this.application.reportError = true;
            }
        }
    }
}

