/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import com.hp.hpl.mesa.rdf.jena.model.Literal;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.xerox.VTM.engine.VirtualSpace;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.VRectangle;
import com.xerox.VTM.glyphs.VText;
import org.w3c.IsaViz.ConfigManager;
import org.w3c.IsaViz.Editor;
import org.w3c.IsaViz.INode;
import org.w3c.IsaViz.IProperty;
import org.w3c.IsaViz.ISVManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class ILiteral
extends INode {
    private boolean escapeXML = true;
    private String language;
    private String value;
    IProperty incomingPred;
    VRectangle gl1;
    VText gl2;
    String mapID;

    public ILiteral(Literal literal) {
        try {
            this.escapeXML = literal.getWellFormed();
            if (literal.getLanguage().length() > 0) {
                this.language = literal.getLanguage();
            }
            this.value = literal.getString();
        }
        catch (RDFException rDFException) {
            System.err.println("Error: ILiteral(Literal - Jena): " + (Object)((Object)rDFException));
        }
    }

    public ILiteral() {
    }

    void setLanguage(String string) {
        this.language = string;
    }

    public String getLang() {
        return this.language;
    }

    void setEscapeXMLChars(boolean bl) {
        this.escapeXML = bl;
    }

    public boolean escapesXMLChars() {
        return this.escapeXML;
    }

    void setValue(String string) {
        this.value = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setMapID(String string) {
        this.mapID = string;
    }

    public String getMapID() {
        return this.mapID;
    }

    public void setIncomingPredicate(IProperty iProperty) {
        this.incomingPred = iProperty;
    }

    public IProperty getIncomingPredicate() {
        return this.incomingPred;
    }

    public void setSelected(boolean bl) {
        super.setSelected(bl);
        if (this.selected) {
            this.gl1.setHSVColor(ConfigManager.selFh, ConfigManager.selFs, ConfigManager.selFv);
            this.gl1.setHSVbColor(ConfigManager.selTh, ConfigManager.selTs, ConfigManager.selTv);
            if (this.gl2 != null) {
                this.gl2.setHSVColor(ConfigManager.selTh, ConfigManager.selTs, ConfigManager.selTv);
            }
            VirtualSpace virtualSpace = Editor.vsm.getVirtualSpace("rdfSpace");
            virtualSpace.onTop((Glyph)this.gl1);
            virtualSpace.onTop((Glyph)this.gl2);
        } else if (this.commented) {
            this.gl1.setHSVColor(ConfigManager.comFh, ConfigManager.comFs, ConfigManager.comFv);
            this.gl1.setHSVbColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
            if (this.gl2 != null) {
                this.gl2.setHSVColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
            }
        } else {
            this.gl1.setHSVColor(ConfigManager.litFh, ConfigManager.litFs, ConfigManager.litFv);
            this.gl1.setHSVbColor(ConfigManager.litTBh, ConfigManager.litTBs, ConfigManager.litTBv);
            if (this.gl2 != null) {
                this.gl2.setHSVColor(ConfigManager.litTBh, ConfigManager.litTBs, ConfigManager.litTBv);
            }
        }
    }

    public void comment(boolean bl, Editor editor) {
        this.commented = bl;
        if (this.commented) {
            this.gl1.setHSVColor(ConfigManager.comFh, ConfigManager.comFs, ConfigManager.comFv);
            this.gl1.setHSVbColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
            if (this.gl2 != null) {
                this.gl2.setHSVColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
            }
            if (this.incomingPred != null) {
                editor.commentPredicate(this.incomingPred, true);
            }
        } else {
            this.gl1.setHSVColor(ConfigManager.litFh, ConfigManager.litFs, ConfigManager.litFv);
            this.gl1.setHSVbColor(ConfigManager.litTBh, ConfigManager.litTBs, ConfigManager.litTBv);
            if (this.gl2 != null) {
                this.gl2.setHSVColor(ConfigManager.litTBh, ConfigManager.litTBs, ConfigManager.litTBv);
            }
            if (this.incomingPred != null) {
                editor.commentPredicate(this.incomingPred, false);
            }
        }
    }

    public void setGlyph(VRectangle vRectangle) {
        this.gl1 = vRectangle;
        this.gl1.setType("litG");
        this.gl1.setOwner((Object)this);
    }

    public void setGlyphText(VText vText) {
        this.gl2 = vText;
        if (this.gl2 != null) {
            this.gl2.setType("litT");
            this.gl2.setOwner((Object)this);
        }
    }

    public Glyph getGlyph() {
        return this.gl1;
    }

    public VText getGlyphText() {
        return this.gl2;
    }

    public Element toISV(Document document, ISVManager iSVManager) {
        Element element = document.createElementNS(Editor.isavizURI, "isv:iliteral");
        if (this.gl2 != null) {
            Element element2 = document.createElementNS(Editor.isavizURI, "isv:value");
            element2.appendChild(document.createTextNode(this.getValue()));
            element2.setAttribute("x", String.valueOf(this.gl2.vx));
            element2.setAttribute("y", String.valueOf(this.gl2.vy));
            element.appendChild(element2);
            if (!this.escapeXML) {
                element.setAttribute("escapeXML", "false");
            }
        }
        if (this.language != null) {
            element.setAttribute("lang", this.language);
        }
        element.setAttribute("x", String.valueOf(this.gl1.vx));
        element.setAttribute("y", String.valueOf(this.gl1.vy));
        element.setAttribute("w", String.valueOf(this.gl1.getWidth()));
        element.setAttribute("h", String.valueOf(this.gl1.getHeight()));
        if (this.commented) {
            element.setAttribute("commented", "true");
        }
        element.setAttribute("id", iSVManager.getPrjId(this));
        return element;
    }

    public String toString() {
        return super.toString() + " " + this.getValue();
    }

    public String getText() {
        if (this.value != null) {
            return this.value.length() >= Editor.MAX_LIT_CHAR_COUNT ? this.value.substring(0, Editor.MAX_LIT_CHAR_COUNT) : this.value;
        }
        return "";
    }

    public void displayOnTop() {
        Editor.vsm.getVirtualSpace("rdfSpace").onTop((Glyph)this.gl1);
        if (this.gl2 != null) {
            Editor.vsm.getVirtualSpace("rdfSpace").onTop((Glyph)this.gl2);
        }
    }
}

