/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import com.xerox.VTM.engine.AppEventHandler;
import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.View;
import com.xerox.VTM.engine.VirtualSpace;
import com.xerox.VTM.glyphs.Glyph;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.UIManager;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.IsaViz.Editor;
import org.w3c.IsaViz.EditorEvtHdlr;
import org.w3c.IsaViz.INode;
import org.w3c.IsaViz.MainCmdPanel;
import org.w3c.IsaViz.PropsPanel;
import org.w3c.IsaViz.TablePanel;
import org.w3c.IsaViz.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class ConfigManager {
    static Color pastelBlue = new Color(156, 154, 206);
    static Color darkerPastelBlue = new Color(125, 123, 165);
    static Color resourceColorF = new Color(115, 191, 115);
    static Color resourceColorTB = new Color(66, 105, 66);
    static float resFh;
    static float resFs;
    static float resFv;
    static float resTBh;
    static float resTBs;
    static float resTBv;
    static Color propertyColorB;
    static Color propertyColorT;
    static float prpBh;
    static float prpBs;
    static float prpBv;
    static float prpTh;
    static float prpTs;
    static float prpTv;
    static Color literalColorF;
    static Color literalColorTB;
    static float litFh;
    static float litFs;
    static float litFv;
    static float litTBh;
    static float litTBs;
    static float litTBv;
    static Color selectionColorF;
    static float selFh;
    static float selFs;
    static float selFv;
    static float selTh;
    static float selTs;
    static float selTv;
    static Color selectionColorTB;
    static Color commentColorF;
    static float comFh;
    static float comFs;
    static float comFv;
    static float comTh;
    static float comTs;
    static float comTv;
    static Color commentColorTB;
    static Color mouseInsideColor;
    static Color bckgColor;
    static Color cursorColor;
    static Color searchColor;
    static float srhTh;
    static float srhTs;
    static float srhTv;
    static String COLOR_SCHEME;
    static boolean internalFrames;
    static int cmpX;
    static int cmpY;
    static int cmpW;
    static int cmpH;
    static int mainX;
    static int mainY;
    static int mainW;
    static int mainH;
    static int prpX;
    static int prpY;
    static int prpW;
    static int prpH;
    static int tabX;
    static int tabY;
    static int tabW;
    static int tabH;
    static boolean showEditWindow;
    static boolean showNSWindow;
    Editor application;
    static Vector lastURLs;
    static int URL_LIMIT;

    static void initLookAndFeel() {
        Enumeration enumeration = UIManager.getLookAndFeelDefaults().keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.endsWith(".font") && !string.endsWith("Font")) continue;
            UIManager.put(string, Editor.smallFont);
        }
        UIManager.put("ProgressBar.foreground", pastelBlue);
        UIManager.put("ProgressBar.background", Color.lightGray);
        UIManager.put("Label.foreground", Color.black);
    }

    ConfigManager(Editor editor) {
        this.application = editor;
    }

    void initWindows() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        cmpX = 0;
        cmpY = 0;
        cmpW = 250;
        cmpH = 240;
        this.application.cmp = new MainCmdPanel(this.application, cmpX, cmpY, cmpW, cmpH);
        mainX = cmpW;
        mainY = 0;
        mainW = dimension.width - cmpW;
        mainH = 600;
        prpX = 0;
        prpY = cmpH;
        prpW = cmpW;
        prpH = mainH - cmpH;
        tabX = 0;
        tabY = mainH;
        tabW = dimension.width;
        tabH = dimension.height - mainH;
        this.application.propsp = new PropsPanel(this.application, prpX, prpY, prpW, prpH);
        if (Utils.osIsWindows()) {
            tabH -= 28;
        }
        this.application.tblp = new TablePanel(this.application, tabX, tabY, tabW, tabH);
        Editor.vsm.addVirtualSpace("rdfSpace");
        Vector<Camera> vector = new Vector<Camera>();
        vector.add(Editor.vsm.addCamera("rdfSpace"));
        Editor.vsm.addView(vector, "Graph", mainW, mainH, true, false).setStatusBarFont(Editor.smallFont);
        Editor.vsm.getView("Graph").setLocation(mainX, mainY);
        this.application.eeh = new EditorEvtHdlr(this.application);
        Editor.vsm.getView("Graph").setEventHandler((AppEventHandler)this.application.eeh);
    }

    void layoutWindows() {
        this.application.cmp.setLocation(cmpX, cmpY);
        this.application.cmp.setSize(cmpW, cmpH);
        View view = Editor.vsm.getView("Graph");
        view.setLocation(mainX, mainY);
        view.setSize(mainW, mainH);
        this.application.propsp.setLocation(prpX, prpY);
        this.application.propsp.setSize(prpW, prpH);
        this.application.tblp.setLocation(tabX, tabY);
        this.application.tblp.setSize(tabW, tabH);
        this.application.cmp.setVisible(true);
        if (!showEditWindow) {
            this.application.cmp.showPropsMn.setSelected(false);
        } else {
            this.application.propsp.setVisible(true);
        }
        if (!showNSWindow) {
            this.application.cmp.showTablesMn.setSelected(false);
        } else {
            this.application.tblp.setVisible(true);
        }
        Editor.vsm.getView("Graph").setVisible(true);
    }

    void updateWindowVariables() {
        cmpX = this.application.cmp.getX();
        cmpY = this.application.cmp.getY();
        cmpW = this.application.cmp.getWidth();
        cmpH = this.application.cmp.getHeight();
        View view = Editor.vsm.getView("Graph");
        mainX = view.getFrame().getX();
        mainY = view.getFrame().getY();
        mainW = view.getFrame().getWidth();
        mainH = view.getFrame().getHeight();
        prpX = this.application.propsp.getX();
        prpY = this.application.propsp.getY();
        prpW = this.application.propsp.getWidth();
        prpH = this.application.propsp.getHeight();
        tabX = this.application.tblp.getX();
        tabY = this.application.tblp.getY();
        tabW = this.application.tblp.getWidth();
        tabH = this.application.tblp.getHeight();
    }

    void initConfig() {
        if (Editor.cfgFile.exists()) {
            try {
                Document document = this.application.xmlMngr.parse(Editor.cfgFile.toString(), true);
                document.normalize();
                Element element = document.getDocumentElement();
                Element element2 = (Element)element.getElementsByTagNameNS(Editor.isavizURI, "directories").item(0);
                try {
                    Editor.m_TmpDir = new File(element2.getElementsByTagNameNS(Editor.isavizURI, "tmpDir").item(0).getFirstChild().getNodeValue());
                    Editor.dltOnExit = new Boolean(((Element)element2.getElementsByTagNameNS(Editor.isavizURI, "tmpDir").item(0)).getAttribute("value"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    Editor.projectDir = new File(element2.getElementsByTagNameNS(Editor.isavizURI, "projDir").item(0).getFirstChild().getNodeValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    Editor.rdfDir = new File(element2.getElementsByTagNameNS(Editor.isavizURI, "rdfDir").item(0).getFirstChild().getNodeValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    Editor.m_GraphVizPath = new File(element2.getElementsByTagNameNS(Editor.isavizURI, "dotExec").item(0).getFirstChild().getNodeValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    Editor.m_GraphVizFontDir = new File(element2.getElementsByTagNameNS(Editor.isavizURI, "graphvizFontDir").item(0).getFirstChild().getNodeValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    element2 = (Element)element.getElementsByTagNameNS(Editor.isavizURI, "constants").item(0);
                    Editor.DEFAULT_NAMESPACE = element2.getAttribute("defaultNamespace");
                    Editor.ANON_NODE = element2.getAttribute("anonymousNodes");
                    Editor.ALWAYS_INCLUDE_LANG_IN_LITERALS = new Boolean(element2.getAttribute("alwaysIncludeLang"));
                    Editor.DEFAULT_LANGUAGE_IN_LITERALS = element2.getAttribute("defaultLang");
                    this.application.setAbbrevSyntax(new Boolean(element2.getAttribute("abbrevSyntax")));
                    Editor.SHOW_ANON_ID = new Boolean(element2.getAttribute("showAnonIds"));
                    Editor.DISP_AS_LABEL = new Boolean(element2.getAttribute("displayLabels"));
                    Editor.MAX_LIT_CHAR_COUNT = new Integer(element2.getAttribute("maxLitCharCount"));
                    Editor.GRAPH_ORIENTATION = element2.getAttribute("graphOrient");
                    Editor.GRAPHVIZ_VERSION = new Integer(element2.getAttribute("graphVizVersion"));
                    this.application.setAntialiasing(new Boolean(element2.getAttribute("antialiasing")));
                    Editor.SAVE_WINDOW_LAYOUT = new Boolean(element2.getAttribute("saveWindowLayout"));
                    if (Editor.SAVE_WINDOW_LAYOUT) {
                        try {
                            element2 = (Element)element.getElementsByTagNameNS(Editor.isavizURI, "windows").item(0);
                            cmpX = new Integer(element2.getAttribute("cmpX"));
                            cmpY = new Integer(element2.getAttribute("cmpY"));
                            cmpW = new Integer(element2.getAttribute("cmpW"));
                            cmpH = new Integer(element2.getAttribute("cmpH"));
                            mainX = new Integer(element2.getAttribute("mainX"));
                            mainY = new Integer(element2.getAttribute("mainY"));
                            mainW = new Integer(element2.getAttribute("mainW"));
                            mainH = new Integer(element2.getAttribute("mainH"));
                            prpX = new Integer(element2.getAttribute("prpX"));
                            prpY = new Integer(element2.getAttribute("prpY"));
                            prpW = new Integer(element2.getAttribute("prpW"));
                            prpH = new Integer(element2.getAttribute("prpH"));
                            tabX = new Integer(element2.getAttribute("tabX"));
                            tabY = new Integer(element2.getAttribute("tabY"));
                            tabW = new Integer(element2.getAttribute("tabW"));
                            tabH = new Integer(element2.getAttribute("tabH"));
                            showNSWindow = new Boolean(element2.getAttribute("showNSWindow"));
                            showEditWindow = new Boolean(element2.getAttribute("showEditWindow"));
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    element2 = (Element)element.getElementsByTagNameNS(Editor.isavizURI, "webBrowser").item(0);
                    Editor.autoDetectBrowser = new Boolean(element2.getAttribute("autoDetect"));
                    Editor.browserPath = new File(element2.getAttribute("path"));
                    Editor.browserOptions = element2.getAttribute("options");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    element2 = (Element)element.getElementsByTagNameNS(Editor.isavizURI, "proxy").item(0);
                    ConfigManager.updateProxy(new Boolean(element2.getAttribute("enable")), element2.getAttribute("host"), element2.getAttribute("port"));
                }
                catch (Exception exception) {
                    System.getProperties().put("proxySet", "false");
                }
                lastURLs = new Vector();
                try {
                    NodeList nodeList = ((Element)element.getElementsByTagNameNS(Editor.isavizURI, "urls").item(0)).getElementsByTagNameNS(Editor.isavizURI, "li");
                    int n = 0;
                    while (n < nodeList.getLength()) {
                        if (n < URL_LIMIT) {
                            lastURLs.add(nodeList.item(n).getFirstChild().getNodeValue());
                        }
                        ++n;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    ConfigManager.assignColorsToGraph(((Element)element.getElementsByTagNameNS(Editor.isavizURI, "colorScheme").item(0)).getAttribute("select"));
                }
                catch (NullPointerException nullPointerException) {}
            }
            catch (Exception exception) {
                this.application.errorMessages.append("Error while loading IsaViz configuration file (isaviz.cfg): " + exception + "\n");
                this.application.reportError = true;
            }
        }
        this.application.resetNamespaceBindings();
        this.application.initRDFMSProperties();
        this.application.initRDFSProperties();
        if (this.application.reportError) {
            Editor.vsm.getView("Graph").setStatusBarText("There were errors during initialization ('Ctrl+E' to display error log)");
            this.application.reportError = false;
        }
    }

    void saveConfig() {
        DOMImplementationImpl dOMImplementationImpl = new DOMImplementationImpl();
        Document document = dOMImplementationImpl.createDocument(Editor.isavizURI, "isv:config", null);
        Element element = document.getDocumentElement();
        element.setAttribute("xmlns:isv", Editor.isavizURI);
        Element element2 = document.createElementNS(Editor.isavizURI, "isv:directories");
        element.appendChild(element2);
        Element element3 = document.createElementNS(Editor.isavizURI, "isv:tmpDir");
        element3.appendChild(document.createTextNode(Editor.m_TmpDir.toString()));
        element3.setAttribute("value", String.valueOf(Editor.dltOnExit));
        element2.appendChild(element3);
        element3 = document.createElementNS(Editor.isavizURI, "isv:projDir");
        element3.appendChild(document.createTextNode(Editor.projectDir.toString()));
        element2.appendChild(element3);
        element3 = document.createElementNS(Editor.isavizURI, "isv:rdfDir");
        element3.appendChild(document.createTextNode(Editor.rdfDir.toString()));
        element2.appendChild(element3);
        element3 = document.createElementNS(Editor.isavizURI, "isv:dotExec");
        element3.appendChild(document.createTextNode(Editor.m_GraphVizPath.toString()));
        element2.appendChild(element3);
        element3 = document.createElementNS(Editor.isavizURI, "isv:graphvizFontDir");
        element3.appendChild(document.createTextNode(Editor.m_GraphVizFontDir.toString()));
        element2.appendChild(element3);
        Element element4 = document.createElementNS(Editor.isavizURI, "isv:constants");
        element.appendChild(element4);
        element4.setAttribute("defaultNamespace", Editor.DEFAULT_NAMESPACE);
        element4.setAttribute("anonymousNodes", Editor.ANON_NODE);
        element4.setAttribute("alwaysIncludeLang", String.valueOf(Editor.ALWAYS_INCLUDE_LANG_IN_LITERALS));
        element4.setAttribute("defaultLang", Editor.DEFAULT_LANGUAGE_IN_LITERALS);
        if (Editor.ABBREV_SYNTAX) {
            element4.setAttribute("abbrevSyntax", "true");
        } else {
            element4.setAttribute("abbrevSyntax", "false");
        }
        if (Editor.SHOW_ANON_ID) {
            element4.setAttribute("showAnonIds", "true");
        } else {
            element4.setAttribute("showAnonIds", "false");
        }
        if (Editor.DISP_AS_LABEL) {
            element4.setAttribute("displayLabels", "true");
        } else {
            element4.setAttribute("displayLabels", "false");
        }
        element4.setAttribute("graphOrient", Editor.GRAPH_ORIENTATION);
        element4.setAttribute("graphVizVersion", String.valueOf(Editor.GRAPHVIZ_VERSION));
        element4.setAttribute("maxLitCharCount", String.valueOf(Editor.MAX_LIT_CHAR_COUNT));
        element4.setAttribute("antialiasing", String.valueOf(Editor.ANTIALIASING));
        element4.setAttribute("saveWindowLayout", String.valueOf(Editor.SAVE_WINDOW_LAYOUT));
        element4 = document.createElementNS(Editor.isavizURI, "isv:webBrowser");
        element4.setAttribute("autoDetect", String.valueOf(Editor.autoDetectBrowser));
        element4.setAttribute("path", Editor.browserPath.toString());
        element4.setAttribute("options", Editor.browserOptions);
        element.appendChild(element4);
        element4 = document.createElementNS(Editor.isavizURI, "isv:proxy");
        element4.setAttribute("enable", String.valueOf(Editor.useProxy));
        element4.setAttribute("host", Editor.proxyHost);
        element4.setAttribute("port", Editor.proxyPort);
        element.appendChild(element4);
        if (Editor.SAVE_WINDOW_LAYOUT) {
            this.updateWindowVariables();
            element4 = document.createElementNS(Editor.isavizURI, "isv:windows");
            element4.setAttribute("cmpX", String.valueOf(cmpX));
            element4.setAttribute("cmpY", String.valueOf(cmpY));
            element4.setAttribute("cmpW", String.valueOf(cmpW));
            element4.setAttribute("cmpH", String.valueOf(cmpH));
            element4.setAttribute("mainX", String.valueOf(mainX));
            element4.setAttribute("mainY", String.valueOf(mainY));
            element4.setAttribute("mainW", String.valueOf(mainW));
            element4.setAttribute("mainH", String.valueOf(mainH));
            element4.setAttribute("prpX", String.valueOf(prpX));
            element4.setAttribute("prpY", String.valueOf(prpY));
            element4.setAttribute("prpW", String.valueOf(prpW));
            element4.setAttribute("prpH", String.valueOf(prpH));
            element4.setAttribute("tabX", String.valueOf(tabX));
            element4.setAttribute("tabY", String.valueOf(tabY));
            element4.setAttribute("tabW", String.valueOf(tabW));
            element4.setAttribute("tabH", String.valueOf(tabH));
            element4.setAttribute("showNSWindow", String.valueOf(showNSWindow));
            element4.setAttribute("showEditWindow", String.valueOf(showEditWindow));
            element.appendChild(element4);
        }
        element4 = document.createElementNS(Editor.isavizURI, "isv:colorScheme");
        element.appendChild(element4);
        element4.setAttribute("select", COLOR_SCHEME);
        element4 = document.createElementNS(Editor.isavizURI, "isv:urls");
        element.appendChild(element4);
        if (lastURLs != null) {
            int n = 0;
            while (n < lastURLs.size()) {
                Element element5 = document.createElementNS(Editor.isavizURI, "isv:li");
                element5.appendChild(document.createTextNode((String)lastURLs.elementAt(n)));
                element4.appendChild(element5);
                ++n;
            }
        }
        if (Editor.cfgFile.exists()) {
            Editor.cfgFile.delete();
        }
        this.application.xmlMngr.serialize(document, Editor.cfgFile);
    }

    void addLastURL(String string) {
        boolean bl = false;
        int n = 0;
        while (n < lastURLs.size()) {
            if (((String)lastURLs.elementAt(n)).equals(string)) {
                if (n > 0) {
                    String string2 = (String)lastURLs.firstElement();
                    lastURLs.setElementAt(string, 0);
                    lastURLs.setElementAt(string2, n);
                }
                return;
            }
            ++n;
        }
        lastURLs.insertElementAt(string, 0);
        if (lastURLs.size() > URL_LIMIT) {
            lastURLs.removeElementAt(URL_LIMIT);
        }
    }

    void saveURLs() {
        try {
            Element element;
            Element element2;
            Document document;
            if (Editor.cfgFile.exists()) {
                document = this.application.xmlMngr.parse(Editor.cfgFile.toString(), true);
                document.normalize();
                element2 = document.getDocumentElement();
                if (element2.getElementsByTagNameNS(Editor.isavizURI, "urls").getLength() > 0) {
                    element2.removeChild(element2.getElementsByTagNameNS(Editor.isavizURI, "urls").item(0));
                }
                element = document.createElementNS(Editor.isavizURI, "isv:urls");
                if (lastURLs != null) {
                    int n = 0;
                    while (n < lastURLs.size()) {
                        Element element3 = document.createElementNS(Editor.isavizURI, "isv:li");
                        element3.appendChild(document.createTextNode((String)lastURLs.elementAt(n)));
                        element.appendChild(element3);
                        ++n;
                    }
                }
            } else {
                DOMImplementationImpl dOMImplementationImpl = new DOMImplementationImpl();
                document = dOMImplementationImpl.createDocument(Editor.isavizURI, "isv:config", null);
                element2 = document.getDocumentElement();
                element = document.createElementNS(Editor.isavizURI, "isv:urls");
                if (lastURLs != null) {
                    int n = 0;
                    while (n < lastURLs.size()) {
                        Element element4 = document.createElementNS(Editor.isavizURI, "isv:li");
                        element4.appendChild(document.createTextNode((String)lastURLs.elementAt(n)));
                        element.appendChild(element4);
                        ++n;
                    }
                }
            }
            element2.appendChild(element);
            this.application.xmlMngr.serialize(document, Editor.cfgFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void assignColorsToGraph(String string) {
        if (!string.equals(COLOR_SCHEME)) {
            if (string.equals("b&w")) {
                resourceColorF = Color.white;
                resourceColorTB = Color.black;
                propertyColorB = Color.black;
                propertyColorT = Color.black;
                literalColorF = Color.white;
                literalColorTB = Color.black;
                selectionColorF = Color.white;
                selectionColorTB = Color.red;
                mouseInsideColor = Color.green;
                commentColorF = new Color(231, 231, 231);
                commentColorTB = new Color(150, 150, 150);
                bckgColor = Color.lightGray;
                searchColor = Color.red;
            } else {
                resourceColorF = new Color(115, 191, 115);
                resourceColorTB = new Color(66, 105, 66);
                propertyColorB = new Color(90, 89, 206);
                propertyColorT = new Color(90, 89, 206);
                literalColorF = new Color(255, 223, 123);
                literalColorTB = new Color(132, 117, 66);
                selectionColorF = new Color(255, 150, 150);
                selectionColorTB = new Color(255, 0, 0);
                mouseInsideColor = new Color(0, 0, 0);
                commentColorF = new Color(231, 231, 231);
                commentColorTB = new Color(180, 180, 180);
                bckgColor = new Color(231, 231, 231);
                searchColor = new Color(255, 0, 0);
            }
            cursorColor = Color.black;
            COLOR_SCHEME = string;
            ConfigManager.assignColorsToGraph();
        }
    }

    static void assignColorsToGraph() {
        Glyph glyph;
        VirtualSpace virtualSpace = Editor.vsm.getVirtualSpace("rdfSpace");
        float[] fArray = Color.RGBtoHSB(resourceColorF.getRed(), resourceColorF.getGreen(), resourceColorF.getBlue(), new float[3]);
        resFh = fArray[0];
        resFs = fArray[1];
        resFv = fArray[2];
        fArray = Color.RGBtoHSB(resourceColorTB.getRed(), resourceColorTB.getGreen(), resourceColorTB.getBlue(), new float[3]);
        resTBh = fArray[0];
        resTBs = fArray[1];
        resTBv = fArray[2];
        fArray = Color.RGBtoHSB(propertyColorB.getRed(), propertyColorB.getGreen(), propertyColorB.getBlue(), new float[3]);
        prpBh = fArray[0];
        prpBs = fArray[1];
        prpBv = fArray[2];
        fArray = Color.RGBtoHSB(propertyColorT.getRed(), propertyColorT.getGreen(), propertyColorT.getBlue(), new float[3]);
        prpTh = fArray[0];
        prpTs = fArray[1];
        prpTv = fArray[2];
        fArray = Color.RGBtoHSB(literalColorF.getRed(), literalColorF.getGreen(), literalColorF.getBlue(), new float[3]);
        litFh = fArray[0];
        litFs = fArray[1];
        litFv = fArray[2];
        fArray = Color.RGBtoHSB(literalColorTB.getRed(), literalColorTB.getGreen(), literalColorTB.getBlue(), new float[3]);
        litTBh = fArray[0];
        litTBs = fArray[1];
        litTBv = fArray[2];
        fArray = Color.RGBtoHSB(selectionColorF.getRed(), selectionColorF.getGreen(), selectionColorF.getBlue(), new float[3]);
        selFh = fArray[0];
        selFs = fArray[1];
        selFv = fArray[2];
        fArray = Color.RGBtoHSB(selectionColorTB.getRed(), selectionColorTB.getGreen(), selectionColorTB.getBlue(), new float[3]);
        selTh = fArray[0];
        selTs = fArray[1];
        selTv = fArray[2];
        fArray = Color.RGBtoHSB(commentColorF.getRed(), commentColorF.getGreen(), commentColorF.getBlue(), new float[3]);
        comFh = fArray[0];
        comFs = fArray[1];
        comFv = fArray[2];
        fArray = Color.RGBtoHSB(commentColorTB.getRed(), commentColorTB.getGreen(), commentColorTB.getBlue(), new float[3]);
        comTh = fArray[0];
        comTs = fArray[1];
        comTv = fArray[2];
        fArray = Color.RGBtoHSB(searchColor.getRed(), searchColor.getGreen(), searchColor.getBlue(), new float[3]);
        srhTh = fArray[0];
        srhTs = fArray[1];
        srhTv = fArray[2];
        Vector vector = virtualSpace.getGlyphsOfType("resG");
        int n = 0;
        while (n < vector.size()) {
            glyph = (Glyph)vector.elementAt(n);
            if (((INode)glyph.getOwner()).isSelected()) {
                glyph.setHSVColor(selFh, selFs, selFv);
                glyph.setHSVbColor(selTh, selTs, selTv);
            } else if (((INode)glyph.getOwner()).isCommented()) {
                glyph.setHSVColor(comFh, comFs, comFv);
                glyph.setHSVbColor(comTh, comTs, comTv);
            } else {
                glyph.setHSVColor(resFh, resFs, resFv);
                glyph.setHSVbColor(resTBh, resTBs, resTBv);
            }
            glyph.setMouseInsideColor(mouseInsideColor);
            ++n;
        }
        vector = virtualSpace.getGlyphsOfType("resT");
        int n2 = 0;
        while (n2 < vector.size()) {
            glyph = (Glyph)vector.elementAt(n2);
            if (((INode)glyph.getOwner()).isSelected()) {
                glyph.setHSVColor(selTh, selTs, selTv);
            } else if (((INode)glyph.getOwner()).isCommented()) {
                glyph.setHSVColor(comTh, comTs, comTv);
            } else {
                glyph.setHSVColor(resTBh, resTBs, resTBv);
            }
            ++n2;
        }
        vector = virtualSpace.getGlyphsOfType("prdG");
        int n3 = 0;
        while (n3 < vector.size()) {
            glyph = (Glyph)vector.elementAt(n3);
            if (((INode)glyph.getOwner()).isSelected()) {
                glyph.setHSVColor(selTh, selTs, selTv);
            } else if (((INode)glyph.getOwner()).isCommented()) {
                glyph.setHSVColor(comTh, comTs, comTv);
            } else {
                glyph.setHSVColor(prpBh, prpBs, prpBv);
            }
            ++n3;
        }
        vector = virtualSpace.getGlyphsOfType("prdH");
        int n4 = 0;
        while (n4 < vector.size()) {
            glyph = (Glyph)vector.elementAt(n4);
            if (((INode)glyph.getOwner()).isSelected()) {
                glyph.setHSVColor(selTh, selTs, selTv);
            } else if (((INode)glyph.getOwner()).isCommented()) {
                glyph.setHSVColor(comTh, comTs, comTv);
            } else {
                glyph.setHSVColor(prpBh, prpBs, prpBv);
            }
            ++n4;
        }
        vector = virtualSpace.getGlyphsOfType("prdT");
        int n5 = 0;
        while (n5 < vector.size()) {
            glyph = (Glyph)vector.elementAt(n5);
            if (((INode)glyph.getOwner()).isSelected()) {
                glyph.setHSVColor(selTh, selTs, selTv);
            } else if (((INode)glyph.getOwner()).isCommented()) {
                glyph.setHSVColor(comTh, comTs, comTv);
            } else {
                glyph.setHSVColor(prpTh, prpTs, prpTv);
            }
            ++n5;
        }
        vector = virtualSpace.getGlyphsOfType("litG");
        int n6 = 0;
        while (n6 < vector.size()) {
            glyph = (Glyph)vector.elementAt(n6);
            if (((INode)glyph.getOwner()).isSelected()) {
                glyph.setHSVColor(selFh, selFs, selFv);
                glyph.setHSVbColor(selTh, selTs, selTv);
            } else if (((INode)glyph.getOwner()).isCommented()) {
                glyph.setHSVColor(comFh, comFs, comFv);
                glyph.setHSVbColor(comTh, comTs, comTv);
            } else {
                glyph.setHSVColor(litFh, litFs, litFv);
                glyph.setHSVbColor(litTBh, litTBs, litTBv);
            }
            glyph.setMouseInsideColor(mouseInsideColor);
            ++n6;
        }
        vector = virtualSpace.getGlyphsOfType("litT");
        int n7 = 0;
        while (n7 < vector.size()) {
            glyph = (Glyph)vector.elementAt(n7);
            if (((INode)glyph.getOwner()).isSelected()) {
                glyph.setHSVColor(selTh, selTs, selTv);
            } else if (((INode)glyph.getOwner()).isCommented()) {
                glyph.setHSVColor(comTh, comTs, comTv);
            } else {
                glyph.setHSVColor(litTBh, litTBs, litTBv);
            }
            ++n7;
        }
        Editor.vsm.setSelectedGlyphColor(selectionColorTB);
        Editor.vsm.setMouseInsideGlyphColor(mouseInsideColor);
        Editor.vsm.getView("Graph").setBackgroundColor(bckgColor);
        Editor.vsm.getView((String)"Graph").mouse.setColor(cursorColor);
    }

    static void updateProxy(boolean bl, String string, String string2) {
        Editor.useProxy = bl;
        Editor.proxyHost = string;
        Editor.proxyPort = string2;
        if (Editor.useProxy) {
            System.getProperties().put("proxySet", "true");
            System.getProperties().put("proxyHost", Editor.proxyHost);
            System.getProperties().put("proxyPort", Editor.proxyPort);
        } else {
            System.getProperties().put("proxySet", "false");
        }
    }

    static {
        propertyColorB = new Color(90, 89, 206);
        propertyColorT = new Color(90, 89, 206);
        literalColorF = new Color(255, 223, 123);
        literalColorTB = new Color(132, 117, 66);
        selectionColorF = new Color(255, 150, 150);
        selectionColorTB = new Color(255, 0, 0);
        commentColorF = new Color(231, 231, 231);
        commentColorTB = new Color(180, 180, 180);
        mouseInsideColor = Color.white;
        bckgColor = new Color(231, 231, 231);
        cursorColor = Color.black;
        searchColor = new Color(255, 0, 0);
        COLOR_SCHEME = "default";
        internalFrames = false;
        showEditWindow = true;
        showNSWindow = true;
        URL_LIMIT = 5;
    }
}

