/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.engine;

import com.xerox.VTM.engine.AppEventHandler;
import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.VCursor;
import com.xerox.VTM.engine.View;
import com.xerox.VTM.glyphs.Glyph;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.JPanel;

public abstract class ViewPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    Thread runView;
    public Camera[] cams;
    public int activeLayer = 0;
    public View parent;
    AppEventHandler evH;
    boolean repaintNow = true;
    boolean alwaysRepaintMe = false;
    boolean computeListAtEachRepaint = false;
    int frameTime = 20;
    boolean inside = false;
    boolean active = true;
    int btwChecksTime = 50;
    int deactiveTime = 200;
    Color backColor = Color.lightGray;
    Stroke standardStroke;
    AffineTransform standardTransform;
    float uncoef;
    long viewW;
    long viewH;
    long viewWHu;
    long viewHHu;
    long viewWLu;
    long viewHLu;
    int camIndex;
    int beginAt = 0;
    Vector drawnGlyphs;
    Glyph gl;
    boolean updateFont = false;
    boolean updateAntialias = true;
    boolean antialias = false;
    protected int origDragx;
    protected int origDragy;
    protected int curDragx;
    protected int curDragy;
    boolean drawDrag = false;
    boolean drawRect = false;
    protected boolean drawVTMcursor = true;
    private Cursor awtCursor;
    Graphics2D g2;

    public abstract void stop();

    void setEventHandler(AppEventHandler appEventHandler) {
        this.evH = appEventHandler;
    }

    protected void setAWTCursor(int n) {
        block6: {
            if (n == -1) {
                BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
                try {
                    this.awtCursor = Toolkit.getDefaultToolkit().createCustomCursor(bufferedImage, new Point(0, 0), "myCursor");
                    this.drawVTMcursor = true;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    if (this.parent.parent.debug) {
                        System.err.println("Error while creating custom cursor " + indexOutOfBoundsException);
                        this.awtCursor = new Cursor(1);
                        this.drawVTMcursor = false;
                    }
                    break block6;
                }
            }
            this.drawVTMcursor = false;
            try {
                this.awtCursor = Cursor.getPredefinedCursor(n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (!this.parent.parent.debug) break block6;
                System.err.println("Error while creating AWT cursor " + indexOutOfBoundsException);
                this.awtCursor = new Cursor(0);
            }
        }
        this.setCursor(this.awtCursor);
    }

    public void setDrawDrag(boolean bl) {
        this.curDragx = this.origDragx;
        this.curDragy = this.origDragy;
        this.drawDrag = bl;
        if (this.drawDrag) {
            this.drawRect = false;
        }
        this.parent.parent.repaintNow();
    }

    public void setDrawSegment(boolean bl) {
        this.curDragx = this.origDragx;
        this.curDragy = this.origDragy;
        this.drawDrag = bl;
        if (this.drawDrag) {
            this.drawRect = false;
        }
        this.parent.parent.repaintNow();
    }

    public void setDrawRect(boolean bl) {
        this.curDragx = this.origDragx;
        this.curDragy = this.origDragy;
        this.drawRect = bl;
        if (this.drawRect) {
            this.drawDrag = false;
        }
        this.parent.parent.repaintNow();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.origDragx = mouseEvent.getX();
        this.origDragy = mouseEvent.getY();
        int n = mouseEvent.getModifiers();
        if ((n & 0x10) == 16) {
            if (mouseEvent.isShiftDown()) {
                if (mouseEvent.isControlDown()) {
                    this.evH.press1(this, 3, mouseEvent.getX(), mouseEvent.getY());
                } else {
                    this.evH.press1(this, 1, mouseEvent.getX(), mouseEvent.getY());
                }
            } else if (mouseEvent.isControlDown()) {
                this.evH.press1(this, 2, mouseEvent.getX(), mouseEvent.getY());
            } else {
                this.evH.press1(this, 0, mouseEvent.getX(), mouseEvent.getY());
            }
        } else if ((n & 8) == 8) {
            if (mouseEvent.isShiftDown()) {
                if (mouseEvent.isControlDown()) {
                    this.evH.press2(this, 3, mouseEvent.getX(), mouseEvent.getY());
                } else {
                    this.evH.press2(this, 1, mouseEvent.getX(), mouseEvent.getY());
                }
            } else if (mouseEvent.isControlDown()) {
                this.evH.press2(this, 2, mouseEvent.getX(), mouseEvent.getY());
            } else {
                this.evH.press2(this, 0, mouseEvent.getX(), mouseEvent.getY());
            }
        } else if ((n & 4) == 4) {
            if (mouseEvent.isShiftDown()) {
                if (mouseEvent.isControlDown()) {
                    this.evH.press3(this, 3, mouseEvent.getX(), mouseEvent.getY());
                } else {
                    this.evH.press3(this, 1, mouseEvent.getX(), mouseEvent.getY());
                }
            } else if (mouseEvent.isControlDown()) {
                this.evH.press3(this, 2, mouseEvent.getX(), mouseEvent.getY());
            } else {
                this.evH.press3(this, 0, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        if ((n & 0x10) == 16) {
            if (mouseEvent.isShiftDown()) {
                if (mouseEvent.isControlDown()) {
                    this.evH.click1(this, 3, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount());
                } else {
                    this.evH.click1(this, 1, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount());
                }
            } else if (mouseEvent.isControlDown()) {
                this.evH.click1(this, 2, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount());
            } else {
                this.evH.click1(this, 0, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount());
            }
        } else if ((n & 8) == 8) {
            if (mouseEvent.isShiftDown()) {
                if (mouseEvent.isControlDown()) {
                    this.evH.click2(this, 3, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount());
                } else {
                    this.evH.click2(this, 1, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount());
                }
            } else if (mouseEvent.isControlDown()) {
                this.evH.click2(this, 2, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount());
            } else {
                this.evH.click2(this, 0, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount());
            }
        } else if ((n & 4) == 4) {
            if (mouseEvent.isShiftDown()) {
                if (mouseEvent.isControlDown()) {
                    this.evH.click3(this, 3, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount());
                } else {
                    this.evH.click3(this, 1, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount());
                }
            } else if (mouseEvent.isControlDown()) {
                this.evH.click3(this, 2, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount());
            } else {
                this.evH.click3(this, 0, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount());
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        if ((n & 0x10) == 16) {
            if (mouseEvent.isShiftDown()) {
                if (mouseEvent.isControlDown()) {
                    this.evH.release1(this, 3, mouseEvent.getX(), mouseEvent.getY());
                } else {
                    this.evH.release1(this, 1, mouseEvent.getX(), mouseEvent.getY());
                }
            } else if (mouseEvent.isControlDown()) {
                this.evH.release1(this, 2, mouseEvent.getX(), mouseEvent.getY());
            } else {
                this.evH.release1(this, 0, mouseEvent.getX(), mouseEvent.getY());
            }
        } else if ((n & 8) == 8) {
            if (mouseEvent.isShiftDown()) {
                if (mouseEvent.isControlDown()) {
                    this.evH.release2(this, 3, mouseEvent.getX(), mouseEvent.getY());
                } else {
                    this.evH.release2(this, 1, mouseEvent.getX(), mouseEvent.getY());
                }
            } else if (mouseEvent.isControlDown()) {
                this.evH.release2(this, 2, mouseEvent.getX(), mouseEvent.getY());
            } else {
                this.evH.release2(this, 0, mouseEvent.getX(), mouseEvent.getY());
            }
        } else if ((n & 4) == 4) {
            if (mouseEvent.isShiftDown()) {
                if (mouseEvent.isControlDown()) {
                    this.evH.release3(this, 3, mouseEvent.getX(), mouseEvent.getY());
                } else {
                    this.evH.release3(this, 1, mouseEvent.getX(), mouseEvent.getY());
                }
            } else if (mouseEvent.isControlDown()) {
                this.evH.release3(this, 2, mouseEvent.getX(), mouseEvent.getY());
            } else {
                this.evH.release3(this, 0, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.active = true;
        this.repaintNow = true;
        this.inside = true;
        this.parent.parent.setActiveView(this.parent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.inside = false;
        if (!this.parent.isSelected() && !this.alwaysRepaintMe) {
            this.active = false;
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        block5: {
            try {
                if (this.parent.parent.mouseSync) {
                    this.parent.mouse.moveTo(mouseEvent.getX(), mouseEvent.getY());
                    this.parent.mouse.unProject(this.cams[this.activeLayer], this);
                    this.parent.mouse.propagateMove();
                    if (this.parent.notifyMouseMoved) {
                        this.evH.mouseMoved(this, mouseEvent.getX(), mouseEvent.getY());
                    }
                    this.parent.parent.repaintNow();
                    if (this.parent.mouse.isSensitive()) {
                        this.parent.mouse.computeMouseOverList(this.evH, this.cams[this.activeLayer]);
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                if (!this.parent.parent.debug) break block5;
                System.err.println("viewpanel.mousemoved " + nullPointerException);
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        block15: {
            int n = mouseEvent.getModifiers();
            int n2 = 0;
            try {
                if (this.parent.parent.mouseSync) {
                    this.parent.mouse.moveTo(mouseEvent.getX(), mouseEvent.getY());
                    this.parent.mouse.unProject(this.cams[this.activeLayer], this);
                    this.parent.mouse.propagateMove();
                    if ((n & 0x10) == 16) {
                        n2 = 1;
                    } else if ((n & 8) == 8) {
                        n2 = 2;
                    } else if ((n & 4) == 4) {
                        n2 = 3;
                    }
                    if (mouseEvent.isShiftDown()) {
                        if (mouseEvent.isControlDown()) {
                            this.evH.mouseDragged(this, 3, n2, mouseEvent.getX(), mouseEvent.getY());
                        } else {
                            this.evH.mouseDragged(this, 1, n2, mouseEvent.getX(), mouseEvent.getY());
                        }
                    } else if (mouseEvent.isControlDown()) {
                        this.evH.mouseDragged(this, 2, n2, mouseEvent.getX(), mouseEvent.getY());
                    } else {
                        this.evH.mouseDragged(this, 0, n2, mouseEvent.getX(), mouseEvent.getY());
                    }
                    this.curDragx = mouseEvent.getX();
                    this.curDragy = mouseEvent.getY();
                    this.parent.parent.repaintNow();
                    if (this.parent.mouse.isSensitive()) {
                        this.parent.mouse.computeMouseOverList(this.evH, this.cams[this.activeLayer]);
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                if (!this.parent.parent.debug) break block15;
                System.err.println("viewpanel.mousedragged " + nullPointerException);
            }
        }
    }

    public VCursor getMouse() {
        return this.parent.mouse;
    }

    public Glyph lastGlyphEntered() {
        return this.parent.mouse.lastGlyphEntered;
    }

    public Vector getGlyphsUnderMouse() {
        return this.parent.mouse.getGlyphsUnderMouse();
    }

    protected abstract BufferedImage getImage();
}

