/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.swing.JOptionPane;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.IsaViz.Editor;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

class XMLManager {
    Editor application;
    DOMParser parser;

    XMLManager(Editor editor) {
        this.application = editor;
    }

    Document parse(String string, boolean bl) {
        try {
            this.parser = new DOMParser();
            if (bl) {
                this.parser.setFeature("http://xml.org/sax/features/validation", true);
            } else {
                this.parser.setFeature("http://xml.org/sax/features/validation", false);
            }
            this.parser.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", false);
            try {
                this.parser.parse(string);
            }
            catch (SAXException sAXException) {
                this.application.errorMessages.append("XMLManager.parse(" + string + "): " + sAXException + "\n");
                JOptionPane.showMessageDialog(this.application.cmp, "The parsing might not be complete (The file is probably not well-formed XML).\n Some nodes and edges might be missing from the graph because of an error (check error log) in file " + string);
                this.application.reportError = true;
            }
            catch (IOException iOException) {
                this.application.errorMessages.append("XMLManager.parse(" + string + "): " + iOException + "\n");
                JOptionPane.showMessageDialog(this.application.cmp, "The parsing might not be complete (The file is probably not well-formed XML).\n Some nodes and edges might be missing from the graph because of an error (check error log) in file " + string);
                this.application.reportError = true;
            }
            Document document = this.parser.getDocument();
            document.normalize();
            return document;
        }
        catch (Exception exception) {
            this.application.errorMessages.append("XMLManager.parse(" + string + "): " + exception + "\n");
            JOptionPane.showMessageDialog(this.application.cmp, "The parsing might not be complete (The file is probably not well-formed XML).\n Some nodes and edges might be missing from the graph because of an error (check error log) in file " + string);
            this.application.reportError = true;
            return null;
        }
    }

    void serialize(Document document, File file) {
        if (file != null && document != null) {
            XMLSerializer xMLSerializer = new XMLSerializer();
            try {
                xMLSerializer.setOutputCharStream((Writer)new FileWriter(file.toString()));
                xMLSerializer.setOutputFormat(new OutputFormat(document, "UTF-8", true));
                xMLSerializer.serialize(document);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

