/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.w3c.IsaViz.Editor;

class SelectionPanel
extends JFrame
implements ActionListener,
KeyListener {
    Editor application;
    JButton selectBt;
    JButton unselectBt;
    JButton closeBt;
    JTextField resURI;
    JTextField prpNS;
    JTextField prpLN;
    JTextField litVal;

    SelectionPanel(Editor editor) {
        this.application = editor;
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        container.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel("Resources");
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 10, 25);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        container.add(jLabel);
        this.resURI = new JTextField();
        this.buildConstraints(gridBagConstraints, 1, 0, 2, 1, 80, 0);
        gridBagLayout.setConstraints(this.resURI, gridBagConstraints);
        this.selectBt = new JButton("Select");
        this.buildConstraints(gridBagConstraints, 3, 0, 1, 1, 10, 0);
        gridBagLayout.setConstraints(this.selectBt, gridBagConstraints);
        this.selectBt.addActionListener(this);
        this.selectBt.addKeyListener(this);
        JLabel jLabel2 = new JLabel("Literals");
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 10, 25);
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        container.add(jLabel2);
        this.litVal = new JTextField();
        this.buildConstraints(gridBagConstraints, 1, 1, 2, 1, 80, 0);
        gridBagLayout.setConstraints(this.litVal, gridBagConstraints);
        this.unselectBt = new JButton("Unselect All");
        this.unselectBt.addActionListener(this);
        this.unselectBt.addKeyListener(this);
        this.buildConstraints(gridBagConstraints, 3, 1, 1, 1, 10, 0);
        gridBagLayout.setConstraints(this.unselectBt, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        JLabel jLabel3 = new JLabel("Namespace (URI, or prefix ending with ':')");
        this.buildConstraints(gridBagConstraints, 1, 2, 1, 1, 40, 25);
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        container.add(jLabel3);
        JLabel jLabel4 = new JLabel("Name");
        this.buildConstraints(gridBagConstraints, 2, 2, 1, 1, 40, 0);
        gridBagLayout.setConstraints(jLabel4, gridBagConstraints);
        container.add(jLabel4);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        this.closeBt = new JButton("Close");
        this.buildConstraints(gridBagConstraints, 3, 2, 1, 1, 10, 0);
        gridBagLayout.setConstraints(this.closeBt, gridBagConstraints);
        this.closeBt.addActionListener(this);
        this.closeBt.addKeyListener(this);
        JLabel jLabel5 = new JLabel("Properties");
        this.buildConstraints(gridBagConstraints, 0, 3, 1, 1, 10, 25);
        gridBagLayout.setConstraints(jLabel5, gridBagConstraints);
        container.add(jLabel5);
        this.prpNS = new JTextField();
        this.buildConstraints(gridBagConstraints, 1, 3, 1, 1, 40, 0);
        gridBagLayout.setConstraints(this.prpNS, gridBagConstraints);
        this.prpLN = new JTextField();
        this.buildConstraints(gridBagConstraints, 2, 3, 1, 1, 40, 0);
        gridBagLayout.setConstraints(this.prpLN, gridBagConstraints);
        container.add(this.resURI);
        container.add(this.litVal);
        container.add(this.prpNS);
        container.add(this.prpLN);
        container.add(this.selectBt);
        container.add(this.unselectBt);
        container.add(this.closeBt);
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
            }
        };
        this.addWindowListener(windowAdapter);
        this.setTitle("Advanced Selection");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - 500) / 2, (dimension.height - 100) / 2);
        this.pack();
        this.setSize(600, this.getHeight());
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.selectBt) {
            this.application.selectResourcesMatching(this.resURI.getText());
            this.application.selectPropertiesMatching(this.prpNS.getText(), this.prpLN.getText());
            this.application.selectLiteralsMatching(this.litVal.getText());
        } else if (object == this.unselectBt) {
            this.application.unselectAll();
        } else if (object == this.closeBt) {
            this.dispose();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            Object object = keyEvent.getSource();
            if (object == this.selectBt) {
                this.application.selectResourcesMatching(this.resURI.getText());
                this.application.selectPropertiesMatching(this.prpNS.getText(), this.prpLN.getText());
                this.application.selectLiteralsMatching(this.litVal.getText());
            } else if (object == this.unselectBt) {
                this.application.unselectAll();
            } else if (object == this.closeBt) {
                this.dispose();
            }
        } else if (keyEvent.getKeyCode() == 127) {
            this.application.deleteSelectedEntities();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }
}

