/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.w3c.IsaViz.Editor;
import org.w3c.IsaViz.ILiteral;
import org.w3c.IsaViz.INode;
import org.w3c.IsaViz.IProperty;
import org.w3c.IsaViz.IResource;

class PropsPanel
extends JFrame {
    Editor application;
    JPanel mainPanel;

    PropsPanel(Editor editor, int n, int n2, int n3, int n4) {
        this.application = editor;
        Container container = this.getContentPane();
        this.mainPanel = new JPanel();
        container.add(this.mainPanel);
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PropsPanel.this.application.cmp.showPropsMn.setSelected(false);
            }

            public void windowActivated(WindowEvent windowEvent) {
                PropsPanel.this.application.alwaysUpdateViews(true);
            }
        };
        this.addWindowListener(windowAdapter);
        this.setTitle("Attributes");
        this.pack();
        this.setLocation(n, n2);
        this.setSize(n3, n4);
    }

    void updateDisplay(INode iNode) {
        if (iNode instanceof IResource) {
            this.showResourceProps((IResource)iNode);
        } else if (iNode instanceof ILiteral) {
            this.showLiteralProps((ILiteral)iNode);
        } else if (iNode instanceof IProperty) {
            this.showPropertyProps((IProperty)iNode);
        }
    }

    void reset() {
        this.mainPanel.removeAll();
        this.paintAll(this.getGraphics());
    }

    void showResourceProps(final IResource iResource) {
        if (iResource != null) {
            final JRadioButton jRadioButton = new JRadioButton("URI");
            final JRadioButton jRadioButton2 = new JRadioButton("ID");
            final JCheckBox jCheckBox = new JCheckBox("Anonymous", iResource.isAnon());
            String string = iResource.getIdent();
            final JTextField jTextField = new JTextField(string.startsWith(Editor.DEFAULT_NAMESPACE) ? string.substring(Editor.DEFAULT_NAMESPACE.length(), string.length()) : string);
            final JButton jButton = new JButton("Delete");
            final JButton jButton2 = new JButton("Show Properties");
            final JLabel jLabel = new JLabel(" ");
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() == jButton) {
                        PropsPanel.this.application.deleteResource(iResource);
                        PropsPanel.this.reset();
                    } else if (actionEvent.getSource() == jRadioButton) {
                        jLabel.setText(" ");
                        this.checkAndUpdateResource();
                    } else if (actionEvent.getSource() == jRadioButton2) {
                        jLabel.setText("Base URI='" + Editor.DEFAULT_NAMESPACE + " '");
                        this.checkAndUpdateResource();
                    } else if (actionEvent.getSource() == jButton2) {
                        PropsPanel.this.application.displayResOutgoingPredicates(iResource);
                    } else if (actionEvent.getSource() == jCheckBox) {
                        if (jCheckBox.isSelected()) {
                            jLabel.setText(" ");
                            jTextField.setEnabled(false);
                            jRadioButton.setEnabled(false);
                            jRadioButton2.setEnabled(false);
                            PropsPanel.this.application.makeAnonymous(iResource);
                            String string = iResource.getIdent();
                            jTextField.setText(iResource.getIdent());
                        } else {
                            jTextField.setText("");
                            jTextField.setEnabled(true);
                            jRadioButton.setEnabled(true);
                            jRadioButton.setSelected(true);
                            jRadioButton2.setEnabled(true);
                        }
                    }
                }

                void checkAndUpdateResource() {
                    if (jTextField.getText().length() > 0) {
                        if (!jTextField.getText().startsWith(Editor.ANON_NODE)) {
                            PropsPanel.this.application.changeResourceURI(iResource, jTextField.getText(), jRadioButton.isSelected());
                            String string = iResource.getIdent();
                            jTextField.setText(string.startsWith(Editor.DEFAULT_NAMESPACE) ? string.substring(Editor.DEFAULT_NAMESPACE.length(), string.length()) : string);
                        } else {
                            JOptionPane.showMessageDialog(PropsPanel.this.application.propsp, Editor.ANON_NODE + " is reserved for anonymous nodes.");
                        }
                    } else {
                        JOptionPane.showMessageDialog(PropsPanel.this.application.propsp, "You must provide an identifier.\nIf you want to make the resource anonymous, use the above checkbox.");
                    }
                }
            };
            KeyListener keyListener = new KeyListener(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10 && keyEvent.getSource() == jTextField) {
                        if (jTextField.getText().length() > 0) {
                            if (!jTextField.getText().startsWith(Editor.ANON_NODE)) {
                                PropsPanel.this.application.changeResourceURI(iResource, jTextField.getText(), jRadioButton.isSelected());
                                String string = iResource.getIdent();
                                jTextField.setText(string.startsWith(Editor.DEFAULT_NAMESPACE) ? string.substring(Editor.DEFAULT_NAMESPACE.length(), string.length()) : string);
                            } else {
                                JOptionPane.showMessageDialog(PropsPanel.this.application.propsp, Editor.ANON_NODE + " is reserved for anonymous nodes.");
                            }
                        } else {
                            JOptionPane.showMessageDialog(PropsPanel.this.application.propsp, "You must provide an identifier.\nIf you want to make the resource anonymous, use the above checkbox.");
                        }
                    }
                }

                public void keyReleased(KeyEvent keyEvent) {
                }

                public void keyTyped(KeyEvent keyEvent) {
                }
            };
            this.mainPanel.removeAll();
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.mainPanel.setLayout(gridBagLayout);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            ButtonGroup buttonGroup = new ButtonGroup();
            this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 34, 3);
            gridBagLayout.setConstraints(jRadioButton, gridBagConstraints);
            this.mainPanel.add(jRadioButton);
            buttonGroup.add(jRadioButton);
            this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 33, 0);
            gridBagLayout.setConstraints(jRadioButton2, gridBagConstraints);
            this.mainPanel.add(jRadioButton2);
            buttonGroup.add(jRadioButton2);
            if (iResource.getIdent().startsWith(Editor.DEFAULT_NAMESPACE)) {
                jRadioButton2.setSelected(true);
                jLabel.setText("Base URI='" + Editor.DEFAULT_NAMESPACE + " '");
            } else {
                jRadioButton.setSelected(true);
            }
            jRadioButton.addActionListener(actionListener);
            jRadioButton2.addActionListener(actionListener);
            gridBagConstraints.anchor = 13;
            jCheckBox.addActionListener(actionListener);
            this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 33, 0);
            gridBagLayout.setConstraints(jCheckBox, gridBagConstraints);
            this.mainPanel.add(jCheckBox);
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 1;
            this.buildConstraints(gridBagConstraints, 0, 1, 3, 1, 100, 3);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.mainPanel.add(jLabel);
            gridBagConstraints.fill = 2;
            jTextField.addKeyListener(keyListener);
            this.buildConstraints(gridBagConstraints, 0, 2, 3, 1, 100, 3);
            gridBagLayout.setConstraints(jTextField, gridBagConstraints);
            this.mainPanel.add(jTextField);
            if (iResource.isAnon()) {
                jTextField.setEnabled(false);
                jRadioButton.setEnabled(false);
                jRadioButton2.setEnabled(false);
            }
            jButton.addActionListener(actionListener);
            this.buildConstraints(gridBagConstraints, 0, 3, 3, 1, 100, 3);
            gridBagLayout.setConstraints(jButton, gridBagConstraints);
            this.mainPanel.add(jButton);
            jButton2.addActionListener(actionListener);
            this.buildConstraints(gridBagConstraints, 0, 4, 3, 1, 100, 3);
            gridBagLayout.setConstraints(jButton2, gridBagConstraints);
            this.mainPanel.add(jButton2);
            gridBagConstraints.fill = 1;
            JPanel jPanel = new JPanel();
            this.buildConstraints(gridBagConstraints, 0, 5, 3, 1, 100, 88);
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            this.mainPanel.add(jPanel);
            this.paintAll(this.getGraphics());
        }
    }

    void showLiteralProps(final ILiteral iLiteral) {
        if (iLiteral != null) {
            final JCheckBox jCheckBox = new JCheckBox("Escape special XML chars", iLiteral.escapesXMLChars());
            final JTextField jTextField = new JTextField(iLiteral.getLang() != null ? iLiteral.getLang() : "");
            final JTextArea jTextArea = new JTextArea(iLiteral.getValue() != null ? iLiteral.getValue() : "");
            final JButton jButton = new JButton("Delete");
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() == jButton) {
                        PropsPanel.this.application.deleteLiteral(iLiteral);
                        PropsPanel.this.reset();
                    } else if (actionEvent.getSource() == jCheckBox) {
                        iLiteral.setEscapeXMLChars(jCheckBox.isSelected());
                    }
                }
            };
            KeyListener keyListener = new KeyListener(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10 && keyEvent.getSource() == jTextField) {
                        iLiteral.setLanguage(jTextField.getText().length() > 0 ? jTextField.getText() : null);
                    }
                }

                public void keyReleased(KeyEvent keyEvent) {
                }

                public void keyTyped(KeyEvent keyEvent) {
                }
            };
            FocusListener focusListener = new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                }

                public void focusLost(FocusEvent focusEvent) {
                    if (focusEvent.getSource() == jTextField) {
                        iLiteral.setLanguage(jTextField.getText().length() > 0 ? jTextField.getText() : null);
                    } else if (focusEvent.getSource() == jTextArea) {
                        PropsPanel.this.application.setLiteralValue(iLiteral, jTextArea.getText());
                    }
                }
            };
            this.mainPanel.removeAll();
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.mainPanel.setLayout(gridBagLayout);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            JLabel jLabel = new JLabel("lang:");
            this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 33, 3);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.mainPanel.add(jLabel);
            jTextField.addKeyListener(keyListener);
            jTextField.addFocusListener(focusListener);
            this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 33, 0);
            gridBagLayout.setConstraints(jTextField, gridBagConstraints);
            this.mainPanel.add(jTextField);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            jCheckBox.addActionListener(actionListener);
            this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 34, 0);
            gridBagLayout.setConstraints(jCheckBox, gridBagConstraints);
            this.mainPanel.add(jCheckBox);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 10;
            jButton.addActionListener(actionListener);
            this.buildConstraints(gridBagConstraints, 0, 1, 3, 1, 100, 3);
            gridBagLayout.setConstraints(jButton, gridBagConstraints);
            this.mainPanel.add(jButton);
            gridBagConstraints.fill = 1;
            jTextArea.addFocusListener(focusListener);
            JScrollPane jScrollPane = new JScrollPane(jTextArea);
            jScrollPane.setVerticalScrollBarPolicy(20);
            jScrollPane.setHorizontalScrollBarPolicy(30);
            this.buildConstraints(gridBagConstraints, 0, 2, 3, 1, 100, 94);
            gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
            this.mainPanel.add(jScrollPane);
            this.paintAll(this.getGraphics());
        }
    }

    void showPropertyProps(final IProperty iProperty) {
        if (iProperty != null) {
            final JButton jButton = new JButton("Delete");
            Vector vector = this.application.getAllPropertyNS();
            final JComboBox jComboBox = new JComboBox(vector);
            String string = this.application.getNSBinding(iProperty.getNamespace());
            jComboBox.setSelectedItem(string != null ? string : iProperty.getNamespace());
            final JComboBox jComboBox2 = new JComboBox(this.application.getProperties4NS(iProperty.getNamespace()));
            jComboBox2.setSelectedItem(iProperty.getLocalname());
            jComboBox.setMaximumRowCount(10);
            jComboBox2.setMaximumRowCount(10);
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() == jButton) {
                        PropsPanel.this.application.deleteProperty(iProperty);
                        PropsPanel.this.reset();
                    }
                }
            };
            ItemListener itemListener = new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getSource() == jComboBox) {
                        if (itemEvent.getStateChange() == 1) {
                            jComboBox2.removeAllItems();
                            Vector vector = PropsPanel.this.application.getProperties4NS((String)itemEvent.getItem());
                            int n = 0;
                            while (n < vector.size()) {
                                jComboBox2.addItem(vector.elementAt(n));
                                ++n;
                            }
                        }
                    } else if (itemEvent.getStateChange() == 1) {
                        PropsPanel.this.application.changePropertyURI(iProperty, (String)jComboBox.getSelectedItem(), (String)jComboBox2.getSelectedItem());
                    }
                }
            };
            this.mainPanel.removeAll();
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.mainPanel.setLayout(gridBagLayout);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 10;
            jButton.addActionListener(actionListener);
            this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 5);
            gridBagLayout.setConstraints(jButton, gridBagConstraints);
            this.mainPanel.add(jButton);
            JLabel jLabel = new JLabel("Namespace");
            this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 100, 5);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.mainPanel.add(jLabel);
            jComboBox.addItemListener(itemListener);
            this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 100, 5);
            gridBagLayout.setConstraints(jComboBox, gridBagConstraints);
            this.mainPanel.add(jComboBox);
            JLabel jLabel2 = new JLabel("Property");
            this.buildConstraints(gridBagConstraints, 0, 3, 1, 1, 100, 5);
            gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
            this.mainPanel.add(jLabel2);
            jComboBox2.addItemListener(itemListener);
            this.buildConstraints(gridBagConstraints, 0, 4, 1, 1, 100, 5);
            gridBagLayout.setConstraints(jComboBox2, gridBagConstraints);
            this.mainPanel.add(jComboBox2);
            gridBagConstraints.fill = 1;
            JPanel jPanel = new JPanel();
            this.buildConstraints(gridBagConstraints, 0, 5, 1, 1, 100, 75);
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            this.mainPanel.add(jPanel);
            this.paintAll(this.getGraphics());
        }
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }
}

