/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.engine.VirtualSpace;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.VEllipse;
import com.xerox.VTM.glyphs.VPath;
import com.xerox.VTM.glyphs.VRectangle;
import com.xerox.VTM.glyphs.VSegment;
import com.xerox.VTM.glyphs.VText;
import com.xerox.VTM.glyphs.VTriangleOr;
import java.awt.Color;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import org.w3c.IsaViz.ControlPoint;
import org.w3c.IsaViz.Editor;
import org.w3c.IsaViz.ILiteral;
import org.w3c.IsaViz.INode;
import org.w3c.IsaViz.IProperty;
import org.w3c.IsaViz.IResource;
import org.w3c.IsaViz.ISVCommand;
import org.w3c.IsaViz.ISVGeom;
import org.w3c.IsaViz.LitResizer;
import org.w3c.IsaViz.PathSegment;
import org.w3c.IsaViz.PropResizer;
import org.w3c.IsaViz.ResResizer;
import org.w3c.IsaViz.Resizer;
import org.w3c.IsaViz.Utils;

class GeometryManager {
    Editor application;
    Resizer lastResizer;

    GeometryManager(Editor editor) {
        this.application = editor;
    }

    void resetLastResizer() {
        this.lastResizer = null;
    }

    void adjustPaths(INode iNode) {
        Vector<PathSegment> vector = new Vector<PathSegment>();
        double[] dArray = new double[6];
        if (iNode instanceof IResource) {
            Point2D point2D;
            Point2D point2D2;
            int n;
            PathIterator pathIterator;
            VPath vPath;
            int n2;
            IResource iResource = (IResource)iNode;
            VEllipse vEllipse = (VEllipse)iNode.getGlyph();
            Ellipse2D.Double double_ = new Ellipse2D.Double(vEllipse.vx - vEllipse.getWidth(), vEllipse.vy - vEllipse.getHeight(), vEllipse.getWidth() * 2L, vEllipse.getHeight() * 2L);
            Vector vector2 = iResource.getOutgoingPredicates();
            if (vector2 != null) {
                n2 = 0;
                while (n2 < vector2.size()) {
                    vPath = (VPath)((IProperty)vector2.elementAt(n2)).getGlyph();
                    pathIterator = vPath.getJava2DPathIterator();
                    vector.removeAllElements();
                    while (!pathIterator.isDone()) {
                        n = pathIterator.currentSegment(dArray);
                        vector.add(new PathSegment(dArray, n));
                        pathIterator.next();
                    }
                    point2D2 = ((PathSegment)vector.firstElement()).getMainPoint();
                    if (double_.contains(point2D2)) {
                        point2D = Utils.computeStepValue(vEllipse.vx, vEllipse.vy, point2D2.getX(), point2D2.getY());
                        while (double_.contains(point2D2)) {
                            point2D2.setLocation(point2D2.getX() + point2D.getX(), point2D2.getY() + point2D.getY());
                        }
                    } else {
                        point2D = Utils.computeStepValue(point2D2.getX(), point2D2.getY(), vEllipse.vx, vEllipse.vy);
                        while (!double_.contains(point2D2)) {
                            point2D2.setLocation(point2D2.getX() + point2D.getX(), point2D2.getY() + point2D.getY());
                        }
                    }
                    ((PathSegment)vector.firstElement()).setMainPoint(point2D2);
                    this.reconstructVPathFromPathSegments(vPath, vector);
                    ++n2;
                }
            }
            if ((vector2 = iResource.getIncomingPredicates()) != null) {
                n2 = 0;
                while (n2 < vector2.size()) {
                    vPath = (VPath)((IProperty)vector2.elementAt(n2)).getGlyph();
                    pathIterator = vPath.getJava2DPathIterator();
                    vector.removeAllElements();
                    while (!pathIterator.isDone()) {
                        n = pathIterator.currentSegment(dArray);
                        vector.add(new PathSegment(dArray, n));
                        pathIterator.next();
                    }
                    point2D2 = ((PathSegment)vector.lastElement()).getMainPoint();
                    if (double_.contains(point2D2)) {
                        point2D = Utils.computeStepValue(vEllipse.vx, vEllipse.vy, point2D2.getX(), point2D2.getY());
                        while (double_.contains(point2D2)) {
                            point2D2.setLocation(point2D2.getX() + point2D.getX(), point2D2.getY() + point2D.getY());
                        }
                    } else {
                        point2D = Utils.computeStepValue(point2D2.getX(), point2D2.getY(), vEllipse.vx, vEllipse.vy);
                        while (!double_.contains(point2D2)) {
                            point2D2.setLocation(point2D2.getX() + point2D.getX(), point2D2.getY() + point2D.getY());
                        }
                    }
                    ((PathSegment)vector.lastElement()).setMainPoint(point2D2);
                    this.reconstructVPathFromPathSegments(vPath, vector);
                    VTriangleOr vTriangleOr = ((IProperty)vector2.elementAt(n2)).getGlyphHead();
                    double[] dArray2 = this.getLastTwoVPathPoints(vector);
                    Utils.createPathArrowHead(dArray2[0], dArray2[1], dArray2[2], dArray2[3], vTriangleOr);
                    ++n2;
                }
            }
        } else {
            ILiteral iLiteral = (ILiteral)iNode;
            VRectangle vRectangle = (VRectangle)iNode.getGlyph();
            Rectangle2D.Double double_ = new Rectangle2D.Double(vRectangle.vx - vRectangle.getWidth(), vRectangle.vy - vRectangle.getHeight(), vRectangle.getWidth() * 2L, vRectangle.getHeight() * 2L);
            if (iLiteral.getIncomingPredicate() != null) {
                VPath vPath = (VPath)iLiteral.getIncomingPredicate().getGlyph();
                PathIterator pathIterator = vPath.getJava2DPathIterator();
                vector.removeAllElements();
                while (!pathIterator.isDone()) {
                    int n = pathIterator.currentSegment(dArray);
                    vector.add(new PathSegment(dArray, n));
                    pathIterator.next();
                }
                Point2D point2D = ((PathSegment)vector.lastElement()).getMainPoint();
                if (double_.contains(point2D)) {
                    Point2D point2D3 = Utils.computeStepValue(vRectangle.vx, vRectangle.vy, point2D.getX(), point2D.getY());
                    while (double_.contains(point2D)) {
                        point2D.setLocation(point2D.getX() + point2D3.getX(), point2D.getY() + point2D3.getY());
                    }
                } else {
                    Point2D point2D4 = Utils.computeStepValue(point2D.getX(), point2D.getY(), vRectangle.vx, vRectangle.vy);
                    while (!double_.contains(point2D)) {
                        point2D.setLocation(point2D.getX() + point2D4.getX(), point2D.getY() + point2D4.getY());
                    }
                }
                ((PathSegment)vector.lastElement()).setMainPoint(point2D);
                this.reconstructVPathFromPathSegments(vPath, vector);
                VTriangleOr vTriangleOr = iLiteral.getIncomingPredicate().getGlyphHead();
                double[] dArray3 = this.getLastTwoVPathPoints(vector);
                Utils.createPathArrowHead(dArray3[0], dArray3[1], dArray3[2], dArray3[3], vTriangleOr);
            }
        }
        Editor.vsm.repaintNow();
    }

    void adjustResourceTextAndEllipse(IResource iResource, String string) {
        VText vText = iResource.getGlyphText();
        if (string != null) {
            vText.setText(string);
        }
        Rectangle2D rectangle2D = Editor.vsm.getView("Graph").getGraphicsContext().getFontMetrics().getStringBounds(vText.getText(), Editor.vsm.getView("Graph").getGraphicsContext());
        VEllipse vEllipse = (VEllipse)iResource.getGlyph();
        vEllipse.setWidth(Math.round(0.6 * rectangle2D.getWidth()));
        if ((double)vEllipse.getWidth() < 1.5 * (double)vEllipse.getHeight()) {
            vEllipse.setWidth(Math.round(1.5 * (double)vEllipse.getHeight()));
        }
        vText.moveTo(vEllipse.vx - (long)rectangle2D.getWidth() / 2L, vEllipse.vy - (long)rectangle2D.getHeight() / 4L);
        this.adjustPaths(iResource);
    }

    void correctResourceTextAndShape(IResource iResource) {
        VText vText = iResource.getGlyphText();
        VEllipse vEllipse = (VEllipse)iResource.getGlyph();
        Rectangle2D rectangle2D = Editor.vsm.getView("Graph").getGraphicsContext().getFontMetrics().getStringBounds(vText.getText(), Editor.vsm.getView("Graph").getGraphicsContext());
        vEllipse.setWidth(Math.round(0.6 * rectangle2D.getWidth()));
        if ((double)vEllipse.getWidth() < 1.5 * (double)vEllipse.getHeight()) {
            vEllipse.setWidth(Math.round(1.5 * (double)vEllipse.getHeight()));
        }
        vText.moveTo(vEllipse.vx - (long)rectangle2D.getWidth() / 2L, vEllipse.vy - (long)rectangle2D.getHeight() / 4L);
        this.adjustPaths(iResource);
    }

    void correctLiteralTextAndShape(ILiteral iLiteral) {
        VText vText = iLiteral.getGlyphText();
        if (vText != null && vText.getText().length() > 0) {
            VRectangle vRectangle = (VRectangle)iLiteral.getGlyph();
            Rectangle2D rectangle2D = Editor.vsm.getView("Graph").getGraphicsContext().getFontMetrics().getStringBounds(vText.getText(), Editor.vsm.getView("Graph").getGraphicsContext());
            vRectangle.setWidth(Math.round(0.6 * rectangle2D.getWidth()));
            if ((double)vRectangle.getWidth() < 1.5 * (double)vRectangle.getHeight()) {
                vRectangle.setWidth(Math.round(1.5 * (double)vRectangle.getHeight()));
            }
            vText.moveTo(vRectangle.vx - (long)rectangle2D.getWidth() / 2L, vRectangle.vy - (long)rectangle2D.getHeight() / 4L);
            this.adjustPaths(iLiteral);
        }
    }

    void adjustResourceText(IResource iResource) {
        VText vText = iResource.getGlyphText();
        Glyph glyph = iResource.getGlyph();
        LongPoint longPoint = vText.getBounds(Editor.vsm.getActiveCamera().getIndex());
        vText.moveTo(glyph.vx - longPoint.x / 2L, glyph.vy - longPoint.y / 4L);
    }

    void adjustLiteralText(ILiteral iLiteral) {
        VText vText = iLiteral.getGlyphText();
        if (vText != null) {
            Glyph glyph = iLiteral.getGlyph();
            LongPoint longPoint = vText.getBounds(Editor.vsm.getActiveCamera().getIndex());
            vText.moveTo(glyph.vx - longPoint.x / 2L, glyph.vy - longPoint.y / 4L);
        }
    }

    void initResourceResizer(IResource iResource) {
        Object object;
        this.destroyLastResizer();
        Vector<IResource> vector = new Vector<IResource>();
        vector.add(iResource);
        Vector vector2 = new Vector();
        if (iResource.getIncomingPredicates() != null) {
            object = iResource.getIncomingPredicates().elements();
            while (object.hasMoreElements()) {
                vector2.add(object.nextElement());
            }
        }
        if (iResource.getOutgoingPredicates() != null) {
            object = iResource.getOutgoingPredicates().elements();
            while (object.hasMoreElements()) {
                vector2.add(object.nextElement());
            }
        }
        object = new ISVGeom(this.application, vector2, vector, new Vector());
        this.application.addCmdToUndoStack((ISVCommand)object);
        iResource.displayOnTop();
        this.lastResizer = new ResResizer(iResource);
        if (iResource.getGlyphText() != null) {
            Editor.vsm.stickToGlyph((Glyph)iResource.getGlyphText(), iResource.getGlyph());
        }
    }

    void initLiteralResizer(ILiteral iLiteral) {
        this.destroyLastResizer();
        Vector<ILiteral> vector = new Vector<ILiteral>();
        vector.add(iLiteral);
        Vector<IProperty> vector2 = new Vector<IProperty>();
        if (iLiteral.getIncomingPredicate() != null) {
            vector2.add(iLiteral.getIncomingPredicate());
        }
        ISVGeom iSVGeom = new ISVGeom(this.application, vector2, new Vector(), vector);
        this.application.addCmdToUndoStack(iSVGeom);
        iLiteral.displayOnTop();
        this.lastResizer = new LitResizer(iLiteral);
        if (iLiteral.getGlyphText() != null) {
            Editor.vsm.stickToGlyph((Glyph)iLiteral.getGlyphText(), iLiteral.getGlyph());
        }
    }

    void initPropertyResizer(IProperty iProperty) {
        this.destroyLastResizer();
        Vector<IProperty> vector = new Vector<IProperty>();
        vector.add(iProperty);
        ISVGeom iSVGeom = new ISVGeom(this.application, vector, new Vector(), new Vector());
        this.application.addCmdToUndoStack(iSVGeom);
        iProperty.displayOnTop();
        this.lastResizer = new PropResizer(iProperty);
    }

    void destroyLastResizer() {
        if (this.lastResizer != null) {
            this.lastResizer.destroy();
            this.lastResizer = null;
        }
    }

    void resize(Glyph glyph) {
        try {
            this.lastResizer.updateMainGlyph(glyph);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    void endResize() {
        Editor.vsm.unstickFromMouse();
        Object object = this.lastResizer.getMainGlyph().getOwner();
        if (object instanceof IResource) {
            this.adjustResourceText((IResource)object);
            this.adjustPaths((INode)object);
        } else if (object instanceof ILiteral) {
            this.adjustLiteralText((ILiteral)object);
            this.adjustPaths((INode)object);
        }
    }

    void move(Glyph glyph) {
        try {
            this.lastResizer.updateHandles();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    void endMove() {
        try {
            Editor.vsm.unstickFromGlyph((Glyph)((INode)this.lastResizer.getMainGlyph().getOwner()).getGlyphText(), this.lastResizer.getMainGlyph());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Editor.vsm.unstickFromMouse();
        this.adjustPaths((INode)this.lastResizer.getMainGlyph().getOwner());
    }

    void updatePathAfterResize() {
        try {
            this.lastResizer.updateMainGlyph(null);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    void reconstructVPathFromPathSegments(VPath vPath, Vector vector) {
        vPath.resetPath();
        int n = 0;
        while (n < vector.size()) {
            PathSegment pathSegment = (PathSegment)vector.elementAt(n);
            double[] dArray = pathSegment.getCoords();
            switch (pathSegment.getType()) {
                case 3: {
                    vPath.addCbCurve((long)dArray[4], (long)dArray[5], (long)dArray[0], (long)dArray[1], (long)dArray[2], (long)dArray[3], true);
                    break;
                }
                case 2: {
                    vPath.addQdCurve((long)dArray[2], (long)dArray[3], (long)dArray[0], (long)dArray[1], true);
                    break;
                }
                case 1: {
                    vPath.addSegment((long)dArray[0], (long)dArray[1], true);
                    break;
                }
                case 0: {
                    vPath.jump((long)dArray[0], (long)dArray[1], true);
                }
            }
            ++n;
        }
    }

    double[] getLastTwoVPathPoints(Vector vector) {
        double[] dArray = new double[4];
        double[] dArray2 = ((PathSegment)vector.lastElement()).getCoords();
        int n = ((PathSegment)vector.lastElement()).getType();
        if (n == 1) {
            Point2D point2D = ((PathSegment)vector.elementAt(vector.size() - 2)).getMainPoint();
            dArray[0] = point2D.getX();
            dArray[1] = point2D.getY();
            dArray[2] = dArray2[0];
            dArray[3] = dArray2[1];
        } else if (n == 3) {
            dArray[0] = dArray2[2];
            dArray[1] = dArray2[3];
            dArray[2] = dArray2[4];
            dArray[3] = dArray2[5];
        } else if (n == 2) {
            dArray[0] = dArray2[0];
            dArray[1] = dArray2[1];
            dArray[2] = dArray2[2];
            dArray[3] = dArray2[3];
        } else {
            System.err.println("Error: Editor.getLastTwoVPathPoints: bad segment type " + n);
        }
        return dArray;
    }

    void insertSegmentInPath(Glyph glyph) {
        ControlPoint controlPoint = (ControlPoint)glyph.getOwner();
        if (controlPoint.type < 2) {
            PropResizer propResizer = controlPoint.owner;
            ControlPoint controlPoint2 = (ControlPoint)controlPoint.nextHandle.getOwner();
            Editor.vsm.getVirtualSpace("rdfSpace").destroyGlyph((Glyph)controlPoint.s2);
            controlPoint.s2 = null;
            controlPoint2.s1 = null;
            LongPoint longPoint = new LongPoint((long)Math.round(controlPoint.handle.vx + (controlPoint2.handle.vx - controlPoint.handle.vx) / 3L), (long)Math.round(controlPoint.handle.vy + (controlPoint2.handle.vy - controlPoint.handle.vy) / 3L));
            LongPoint longPoint2 = new LongPoint((long)Math.round(controlPoint.handle.vx + (controlPoint2.handle.vx - controlPoint.handle.vx) * 2L / 3L), (long)Math.round(controlPoint.handle.vy + (controlPoint2.handle.vy - controlPoint.handle.vy) * 2L / 3L));
            VRectangle vRectangle = new VRectangle(longPoint.x, longPoint.y, 0.0f, 4L, 4L, Color.red);
            VRectangle vRectangle2 = new VRectangle(longPoint2.x, longPoint2.y, 0.0f, 4L, 4L, Color.black);
            Editor.vsm.addGlyph((Glyph)vRectangle, "rdfSpace");
            Editor.vsm.addGlyph((Glyph)vRectangle2, "rdfSpace");
            LongPoint longPoint3 = new LongPoint(controlPoint.handle.vx, controlPoint.handle.vy);
            LongPoint longPoint4 = new LongPoint(controlPoint2.handle.vx, controlPoint2.handle.vy);
            VSegment vSegment = new VSegment((longPoint3.x + longPoint.x) / 2L, (longPoint3.y + longPoint.y) / 2L, 0.0f, (longPoint.x - longPoint3.x) / 2L, (longPoint3.y - longPoint.y) / 2L, Color.red);
            VSegment vSegment2 = new VSegment((longPoint.x + longPoint2.x) / 2L, (longPoint.y + longPoint2.y) / 2L, 0.0f, (longPoint2.x - longPoint.x) / 2L, (longPoint.y - longPoint2.y) / 2L, Color.red);
            VSegment vSegment3 = new VSegment((longPoint2.x + longPoint4.x) / 2L, (longPoint2.y + longPoint4.y) / 2L, 0.0f, (longPoint4.x - longPoint2.x) / 2L, (longPoint2.y - longPoint4.y) / 2L, Color.red);
            Editor.vsm.addGlyph((Glyph)vSegment, "rdfSpace");
            Editor.vsm.addGlyph((Glyph)vSegment2, "rdfSpace");
            Editor.vsm.addGlyph((Glyph)vSegment3, "rdfSpace");
            controlPoint.setSecondSegment(vSegment, vRectangle);
            ControlPoint controlPoint3 = new ControlPoint(vRectangle, controlPoint.handle, vSegment, 3, propResizer);
            controlPoint3.setSecondSegment(vSegment2, vRectangle2);
            ControlPoint controlPoint4 = new ControlPoint(vRectangle2, vRectangle, vSegment2, 0, propResizer);
            controlPoint4.setSecondSegment(vSegment3, controlPoint2.handle);
            controlPoint2.prevHandle = vRectangle2;
            controlPoint2.s1 = vSegment3;
            ControlPoint[] controlPointArray = new ControlPoint[propResizer.cps.length + 2];
            int n = 0;
            ControlPoint controlPoint5 = propResizer.cps[n];
            while (n < controlPointArray.length - 1) {
                controlPointArray[n] = controlPoint5;
                controlPoint5 = (ControlPoint)controlPoint5.nextHandle.getOwner();
                ++n;
            }
            controlPointArray[n] = controlPoint5;
            propResizer.cps = controlPointArray;
            propResizer.updateMainGlyph(null);
        }
    }

    void deleteSegmentInPath(Glyph glyph) {
        ControlPoint controlPoint = (ControlPoint)glyph.getOwner();
        if (controlPoint.type == 0) {
            PropResizer propResizer = controlPoint.owner;
            ControlPoint controlPoint2 = (ControlPoint)controlPoint.prevHandle.getOwner();
            ControlPoint controlPoint3 = (ControlPoint)controlPoint.nextHandle.getOwner();
            VirtualSpace virtualSpace = Editor.vsm.getVirtualSpace("rdfSpace");
            virtualSpace.destroyGlyph((Glyph)controlPoint.handle);
            virtualSpace.destroyGlyph((Glyph)controlPoint.s1);
            virtualSpace.destroyGlyph((Glyph)controlPoint.s2);
            while (controlPoint3.type > 2) {
                virtualSpace.destroyGlyph((Glyph)controlPoint3.handle);
                virtualSpace.destroyGlyph((Glyph)controlPoint3.s2);
                controlPoint3 = (ControlPoint)controlPoint3.nextHandle.getOwner();
            }
            ControlPoint controlPoint4 = controlPoint3;
            LongPoint longPoint = new LongPoint(controlPoint2.handle.vx, controlPoint2.handle.vy);
            LongPoint longPoint2 = new LongPoint(controlPoint4.handle.vx, controlPoint4.handle.vy);
            VSegment vSegment = new VSegment((longPoint.x + longPoint2.x) / 2L, (longPoint.y + longPoint2.y) / 2L, 0.0f, (longPoint2.x - longPoint.x) / 2L, (longPoint.y - longPoint2.y) / 2L, Color.red);
            Editor.vsm.addGlyph((Glyph)vSegment, "rdfSpace");
            controlPoint2.setSecondSegment(vSegment, controlPoint4.handle);
            controlPoint4.prevHandle = controlPoint2.handle;
            controlPoint4.s1 = vSegment;
            Vector<ControlPoint> vector = new Vector<ControlPoint>();
            controlPoint3 = propResizer.cps[0];
            vector.add(controlPoint3);
            while (controlPoint3.nextHandle != null) {
                controlPoint3 = (ControlPoint)controlPoint3.nextHandle.getOwner();
                vector.add(controlPoint3);
            }
            propResizer.cps = vector.toArray(new ControlPoint[vector.size()]);
            propResizer.updateMainGlyph(null);
        }
    }
}

