/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.common;

import com.hp.hpl.mesa.rdf.jena.common.LiteralImpl;
import com.hp.hpl.mesa.rdf.jena.common.ModelMatcher;
import com.hp.hpl.mesa.rdf.jena.common.NodeIteratorFactory;
import com.hp.hpl.mesa.rdf.jena.common.NodeIteratorImpl;
import com.hp.hpl.mesa.rdf.jena.common.RDFReaderFImpl;
import com.hp.hpl.mesa.rdf.jena.common.RDFWriterFImpl;
import com.hp.hpl.mesa.rdf.jena.common.ResIteratorImpl;
import com.hp.hpl.mesa.rdf.jena.common.ResourceI;
import com.hp.hpl.mesa.rdf.jena.common.SelectorImpl;
import com.hp.hpl.mesa.rdf.jena.common.StatementImpl;
import com.hp.hpl.mesa.rdf.jena.common.StmtIteratorImpl;
import com.hp.hpl.mesa.rdf.jena.common.Store;
import com.hp.hpl.mesa.rdf.jena.model.Alt;
import com.hp.hpl.mesa.rdf.jena.model.Bag;
import com.hp.hpl.mesa.rdf.jena.model.ClosableIterator;
import com.hp.hpl.mesa.rdf.jena.model.Container;
import com.hp.hpl.mesa.rdf.jena.model.Literal;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.NodeIterator;
import com.hp.hpl.mesa.rdf.jena.model.NsIterator;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFError;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.RDFReader;
import com.hp.hpl.mesa.rdf.jena.model.RDFReaderF;
import com.hp.hpl.mesa.rdf.jena.model.RDFWriter;
import com.hp.hpl.mesa.rdf.jena.model.RDFWriterF;
import com.hp.hpl.mesa.rdf.jena.model.ResIterator;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.model.ResourceF;
import com.hp.hpl.mesa.rdf.jena.model.Selector;
import com.hp.hpl.mesa.rdf.jena.model.Seq;
import com.hp.hpl.mesa.rdf.jena.model.Statement;
import com.hp.hpl.mesa.rdf.jena.model.StmtIterator;
import com.hp.hpl.mesa.rdf.jena.vocabulary.RDF;
import java.io.Reader;
import java.io.Writer;
import java.util.AbstractList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public abstract class ModelCom
implements Model {
    protected Store store = null;
    protected RDFReaderF readerFactory = new RDFReaderFImpl();
    protected RDFWriterF writerFactory = new RDFWriterFImpl();

    public Resource getResource(String string, ResourceF resourceF) throws RDFException {
        try {
            return resourceF.createResource(this.getResource(string));
        }
        catch (Exception exception) {
            throw new RDFException(exception);
        }
    }

    public Model add(Resource resource, Property property, RDFNode rDFNode) throws RDFException {
        this.add(this.createStatement(resource, property, rDFNode));
        return this;
    }

    public Model add(Resource resource, Property property, boolean bl) throws RDFException {
        this.add(resource, property, new LiteralImpl(bl));
        return this;
    }

    public Model add(Resource resource, Property property, long l) throws RDFException {
        this.add(resource, property, new LiteralImpl(l));
        return this;
    }

    public Model add(Resource resource, Property property, char c) throws RDFException {
        this.add(resource, property, new LiteralImpl(c));
        return this;
    }

    public Model add(Resource resource, Property property, float f) throws RDFException {
        this.add(resource, property, new LiteralImpl(f));
        return this;
    }

    public Model add(Resource resource, Property property, double d) throws RDFException {
        this.add(resource, property, new LiteralImpl(d));
        return this;
    }

    public Model add(Resource resource, Property property, String string) throws RDFException {
        this.add(resource, property, new LiteralImpl(string));
        return this;
    }

    public Model add(Resource resource, Property property, String string, boolean bl) throws RDFException {
        this.add(resource, property, new LiteralImpl(string, bl));
        return this;
    }

    public Model add(Resource resource, Property property, String string, String string2, boolean bl) throws RDFException {
        this.add(resource, property, new LiteralImpl(string, string2, bl));
        return this;
    }

    public Model add(Resource resource, Property property, String string, String string2) throws RDFException {
        this.add(resource, property, new LiteralImpl(string, string2));
        return this;
    }

    public Model add(Resource resource, Property property, Object object) throws RDFException {
        if (object instanceof RDFNode) {
            this.add(resource, property, (RDFNode)object);
        } else {
            this.add(resource, property, new LiteralImpl(object));
        }
        return this;
    }

    public Model add(StmtIterator stmtIterator) throws RDFException {
        ModelCom modelCom;
        try {
            while (stmtIterator.hasNext()) {
                this.add(stmtIterator.next());
            }
            modelCom = this;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            stmtIterator.close();
            throw throwable;
        }
        stmtIterator.close();
        return modelCom;
    }

    public Model add(Model model) throws RDFException {
        return this.add(model.listStatements());
    }

    public RDFReader getReader() throws RDFException {
        return this.readerFactory.getReader();
    }

    public RDFReader getReader(String string) throws RDFException {
        return this.readerFactory.getReader(string);
    }

    public String setReaderClassName(String string, String string2) {
        return this.readerFactory.setReaderClassName(string, string2);
    }

    public Model read(String string) throws RDFException {
        this.readerFactory.getReader().read(this, string);
        return this;
    }

    public Model read(Reader reader, String string) throws RDFException {
        this.readerFactory.getReader().read(this, reader, string);
        return this;
    }

    public Model read(String string, String string2) throws RDFException {
        this.readerFactory.getReader(string2).read(this, string);
        return this;
    }

    public Model read(Reader reader, String string, String string2) throws RDFException {
        this.readerFactory.getReader(string2).read(this, reader, string);
        return this;
    }

    public RDFWriter getWriter() throws RDFException {
        return this.writerFactory.getWriter();
    }

    public RDFWriter getWriter(String string) throws RDFException {
        return this.writerFactory.getWriter(string);
    }

    public String setWriterClassName(String string, String string2) {
        return this.writerFactory.setWriterClassName(string, string2);
    }

    public Model write(Writer writer) throws RDFException {
        try {
            this.writerFactory.getWriter().write(this, writer, "");
            return this;
        }
        catch (Exception exception) {
            throw new RDFException(exception);
        }
    }

    public Model write(Writer writer, String string) throws RDFException {
        try {
            this.writerFactory.getWriter(string).write(this, writer, "");
            return this;
        }
        catch (Exception exception) {
            throw new RDFException(exception);
        }
    }

    public Model write(Writer writer, String string, String string2) throws RDFException {
        try {
            this.writerFactory.getWriter(string).write(this, writer, string2);
            return this;
        }
        catch (Exception exception) {
            throw new RDFException(exception);
        }
    }

    public Model remove(StmtIterator stmtIterator) throws RDFException {
        while (stmtIterator.hasNext()) {
            this.remove(stmtIterator.next());
        }
        return this;
    }

    public Model remove(Model model) throws RDFException {
        StmtIterator stmtIterator = model.listStatements();
        try {
            this.remove(stmtIterator);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            stmtIterator.close();
            throw throwable;
        }
        stmtIterator.close();
        return this;
    }

    public boolean contains(Resource resource, Property property, boolean bl) throws RDFException {
        return this.contains(resource, property, new LiteralImpl(bl));
    }

    public boolean contains(Resource resource, Property property, long l) throws RDFException {
        return this.contains(resource, property, new LiteralImpl(l));
    }

    public boolean contains(Resource resource, Property property, char c) throws RDFException {
        return this.contains(resource, property, new LiteralImpl(c));
    }

    public boolean contains(Resource resource, Property property, float f) throws RDFException {
        return this.contains(resource, property, new LiteralImpl(f));
    }

    public boolean contains(Resource resource, Property property, double d) throws RDFException {
        return this.contains(resource, property, new LiteralImpl(d));
    }

    public boolean contains(Resource resource, Property property, String string) throws RDFException {
        return this.contains(resource, property, new LiteralImpl(string));
    }

    public boolean contains(Resource resource, Property property, String string, String string2) throws RDFException {
        return this.contains(resource, property, new LiteralImpl(string, string2));
    }

    public boolean contains(Resource resource, Property property, Object object) throws RDFException {
        if (object instanceof RDFNode) {
            return this.contains(resource, property, (RDFNode)object);
        }
        return this.contains(resource, property, new LiteralImpl(object));
    }

    public boolean containsAny(StmtIterator stmtIterator) throws RDFException {
        while (stmtIterator.hasNext()) {
            if (!this.contains(stmtIterator.next())) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(StmtIterator stmtIterator) throws RDFException {
        while (stmtIterator.hasNext()) {
            if (this.contains(stmtIterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean containsAny(Model model) throws RDFException {
        boolean bl;
        StmtIterator stmtIterator = model.listStatements();
        try {
            bl = this.containsAny(stmtIterator);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            stmtIterator.close();
            throw throwable;
        }
        stmtIterator.close();
        return bl;
    }

    public boolean containsAll(Model model) throws RDFException {
        boolean bl;
        StmtIterator stmtIterator = model.listStatements();
        try {
            bl = this.containsAll(stmtIterator);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            stmtIterator.close();
            throw throwable;
        }
        stmtIterator.close();
        return bl;
    }

    public ResIterator listSubjectsWithProperty(Property property, boolean bl) throws RDFException {
        return this.listSubjectsWithProperty(property, new LiteralImpl(bl));
    }

    public ResIterator listSubjectsWithProperty(Property property, long l) throws RDFException {
        return this.listSubjectsWithProperty(property, new LiteralImpl(l));
    }

    public ResIterator listSubjectsWithProperty(Property property, char c) throws RDFException {
        return this.listSubjectsWithProperty(property, new LiteralImpl(c));
    }

    public ResIterator listSubjectsWithProperty(Property property, float f) throws RDFException {
        return this.listSubjectsWithProperty(property, new LiteralImpl(f));
    }

    public ResIterator listSubjectsWithProperty(Property property, double d) throws RDFException {
        return this.listSubjectsWithProperty(property, new LiteralImpl(d));
    }

    public ResIterator listSubjectsWithProperty(Property property, String string) throws RDFException {
        return this.listSubjectsWithProperty(property, new LiteralImpl(string));
    }

    public ResIterator listSubjectsWithProperty(Property property, String string, String string2) throws RDFException {
        return this.listSubjectsWithProperty(property, new LiteralImpl(string, string2));
    }

    public ResIterator listSubjectsWithProperty(Property property, Object object) throws RDFException {
        if (object instanceof RDFNode) {
            return this.listSubjectsWithProperty(property, (RDFNode)object);
        }
        return this.listSubjectsWithProperty(property, new LiteralImpl(object));
    }

    public Resource createResource(Resource resource) throws RDFException {
        return this.createResource().addProperty(RDF.type, resource);
    }

    public Resource createResource(String string, Resource resource) throws RDFException {
        return this.getResource(string).addProperty(RDF.type, resource);
    }

    public Resource createResource(ResourceF resourceF) throws RDFException {
        return this.createResource(null, resourceF);
    }

    public Resource createResource(String string, ResourceF resourceF) throws RDFException {
        try {
            return resourceF.createResource(this.createResource(string));
        }
        catch (Exception exception) {
            throw new RDFException(10, exception);
        }
    }

    public Literal createLiteral(boolean bl) throws RDFException {
        return this.createLiteral(String.valueOf(bl), "");
    }

    public Literal createLiteral(long l) throws RDFException {
        return this.createLiteral(String.valueOf(l), "");
    }

    public Literal createLiteral(char c) throws RDFException {
        return this.createLiteral(String.valueOf(c), "");
    }

    public Literal createLiteral(float f) throws RDFException {
        return this.createLiteral(String.valueOf(f), "");
    }

    public Literal createLiteral(double d) throws RDFException {
        return this.createLiteral(String.valueOf(d), "");
    }

    public Literal createLiteral(String string) throws RDFException {
        return this.createLiteral(string, "");
    }

    public Literal createLiteral(String string, String string2) throws RDFException {
        return new LiteralImpl(string, string2);
    }

    public Literal createLiteral(String string, String string2, boolean bl) {
        return new LiteralImpl(string, string2, bl);
    }

    public Literal createLiteral(Object object) throws RDFException {
        return this.createLiteral(object.toString(), "");
    }

    public Statement createStatement(Resource resource, Property property, boolean bl) throws RDFException {
        return this.createStatement(resource, property, this.createLiteral(bl));
    }

    public Statement createStatement(Resource resource, Property property, long l) throws RDFException {
        return this.createStatement(resource, property, this.createLiteral(l));
    }

    public Statement createStatement(Resource resource, Property property, char c) throws RDFException {
        return this.createStatement(resource, property, this.createLiteral(c));
    }

    public Statement createStatement(Resource resource, Property property, float f) throws RDFException {
        return this.createStatement(resource, property, this.createLiteral(f));
    }

    public Statement createStatement(Resource resource, Property property, double d) throws RDFException {
        return this.createStatement(resource, property, this.createLiteral(d));
    }

    public Statement createStatement(Resource resource, Property property, String string) throws RDFException {
        return this.createStatement(resource, property, this.createLiteral(string));
    }

    public Statement createStatement(Resource resource, Property property, Object object) throws RDFException {
        if (object instanceof RDFNode) {
            return this.createStatement(resource, property, (RDFNode)object);
        }
        return this.createStatement(resource, property, this.createLiteral(object));
    }

    public Statement createStatement(Resource resource, Property property, String string, boolean bl) throws RDFException {
        return this.createStatement(resource, property, new LiteralImpl(string, bl));
    }

    public Statement createStatement(Resource resource, Property property, String string, String string2) throws RDFException {
        return this.createStatement(resource, property, new LiteralImpl(string, string2));
    }

    public Statement createStatement(Resource resource, Property property, String string, String string2, boolean bl) throws RDFException {
        return this.createStatement(resource, property, new LiteralImpl(string, string2, bl));
    }

    public Bag createBag() throws RDFException {
        return this.createBag(null);
    }

    public Alt createAlt() throws RDFException {
        return this.createAlt(null);
    }

    public Seq createSeq() throws RDFException {
        return this.createSeq(null);
    }

    public Resource getResource(String string) throws RDFException {
        return this.store.getResource(string, this);
    }

    public Property getProperty(String string) throws RDFException {
        return this.store.getProperty(string, this);
    }

    public Property getProperty(String string, String string2) throws RDFException {
        return this.store.getProperty(string, string2, this);
    }

    public Bag getBag(String string) throws RDFException {
        return this.store.getBag(string, (Model)this);
    }

    public Bag getBag(Resource resource) throws RDFException {
        return this.store.getBag(resource, (Model)this);
    }

    public Alt getAlt(String string) throws RDFException {
        return this.store.getAlt(string, (Model)this);
    }

    public Alt getAlt(Resource resource) throws RDFException {
        return this.store.getAlt(resource, (Model)this);
    }

    public Seq getSeq(String string) throws RDFException {
        return this.store.getSeq(string, (Model)this);
    }

    public Seq getSeq(Resource resource) throws RDFException {
        return this.store.getSeq(resource, (Model)this);
    }

    public long size() throws RDFException {
        return this.store.size();
    }

    public ResIterator listSubjects() throws RDFException {
        return this.store.listSubjects();
    }

    public NsIterator listNameSpaces() throws RDFException {
        return this.store.listNameSpaces();
    }

    public StmtIterator listStatements() throws RDFException {
        return new StmtIteratorImpl(this.store.list(), null);
    }

    public StmtIterator listReifiedStatements() throws RDFException {
        Vector<Resource> vector = new Vector<Resource>();
        Iterator iterator = this.store.list();
        while (iterator.hasNext()) {
            Resource resource = ((Statement)iterator.next()).getSubject();
            if (!(resource instanceof Statement)) continue;
            vector.add(resource);
        }
        if (iterator instanceof ClosableIterator) {
            ((ClosableIterator)iterator).close();
        }
        return new StmtIteratorImpl(((AbstractList)vector).iterator(), vector);
    }

    public Model add(Statement statement) throws RDFException {
        if (!(statement instanceof StatementImpl) || ((StatementImpl)statement).getModel() != this) {
            statement = new StatementImpl(statement.getSubject(), statement.getPredicate(), statement.getObject(), this);
        }
        this.store.add(statement);
        return this;
    }

    public Model remove(Statement statement) throws RDFException {
        this.store.remove(statement);
        return this;
    }

    public boolean contains(Statement statement) throws RDFException {
        return this.store.contains(statement);
    }

    public boolean contains(Resource resource, Property property) throws RDFException {
        return this.store.contains(resource, property);
    }

    public boolean contains(Resource resource, Property property, RDFNode rDFNode) throws RDFException {
        return this.contains(new StatementImpl(resource, property, rDFNode));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isReified(Statement statement) throws RDFException {
        boolean bl;
        StmtIterator stmtIterator;
        block4: {
            boolean bl2;
            block3: {
                stmtIterator = null;
                try {
                    stmtIterator = this.listStatements(new SelectorImpl((Resource)statement, null, (RDFNode)null));
                    if (stmtIterator.hasNext()) {
                        bl2 = true;
                        Object var5_5 = null;
                        break block3;
                    }
                    stmtIterator = this.listStatements(new SelectorImpl(null, null, statement));
                    bl = stmtIterator.hasNext();
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    stmtIterator.close();
                    throw throwable;
                }
            }
            stmtIterator.close();
            return bl2;
        }
        Object var5_6 = null;
        stmtIterator.close();
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Statement getProperty(Resource resource, Property property) throws RDFException {
        Statement statement;
        StmtIterator stmtIterator = null;
        try {
            stmtIterator = this.listStatements(new SelectorImpl(resource, property, (RDFNode)null));
            if (!stmtIterator.hasNext()) throw new RDFException(6);
            statement = stmtIterator.next();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            stmtIterator.close();
            throw throwable;
        }
        stmtIterator.close();
        return statement;
    }

    public ResIterator listSubjectsWithProperty(Property property) throws RDFException {
        HashSet<Resource> hashSet = new HashSet<Resource>();
        Iterator iterator = this.store.listByPredicate(property);
        try {
            while (iterator.hasNext()) {
                Statement statement = (Statement)iterator.next();
                if (!statement.getPredicate().equals(property)) continue;
                hashSet.add(statement.getSubject());
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (iterator instanceof ClosableIterator) {
                ((ClosableIterator)iterator).close();
            }
            throw throwable;
        }
        if (iterator instanceof ClosableIterator) {
            ((ClosableIterator)iterator).close();
        }
        return new ResIteratorImpl(hashSet.iterator(), hashSet);
    }

    public ResIterator listSubjectsWithProperty(Property property, RDFNode rDFNode) throws RDFException {
        HashSet<Resource> hashSet = new HashSet<Resource>();
        Iterator iterator = this.store.listByPredicate(property);
        try {
            while (iterator.hasNext()) {
                Statement statement = (Statement)iterator.next();
                if (!statement.getPredicate().equals(property) || !statement.getObject().equals(rDFNode)) continue;
                hashSet.add(statement.getSubject());
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (iterator instanceof ClosableIterator) {
                ((ClosableIterator)iterator).close();
            }
            throw throwable;
        }
        if (iterator instanceof ClosableIterator) {
            ((ClosableIterator)iterator).close();
        }
        return new ResIteratorImpl(hashSet.iterator(), hashSet);
    }

    public NodeIterator listObjects() throws RDFException {
        HashSet<RDFNode> hashSet = new HashSet<RDFNode>();
        Iterator iterator = this.store.list();
        Object var3_3 = null;
        try {
            while (iterator.hasNext()) {
                hashSet.add(((Statement)iterator.next()).getObject());
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (iterator instanceof ClosableIterator) {
                ((ClosableIterator)iterator).close();
            }
            throw throwable;
        }
        if (iterator instanceof ClosableIterator) {
            ((ClosableIterator)iterator).close();
        }
        return new NodeIteratorImpl(hashSet.iterator(), hashSet);
    }

    public NodeIterator listObjectsOfProperty(Property property) throws RDFException {
        HashSet<RDFNode> hashSet = new HashSet<RDFNode>();
        Iterator iterator = this.store.listByPredicate(property);
        try {
            while (iterator.hasNext()) {
                Statement statement = (Statement)iterator.next();
                hashSet.add(statement.getObject());
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (iterator instanceof ClosableIterator) {
                ((ClosableIterator)iterator).close();
            }
            throw throwable;
        }
        if (iterator instanceof ClosableIterator) {
            ((ClosableIterator)iterator).close();
        }
        return new NodeIteratorImpl(hashSet.iterator(), hashSet);
    }

    public NodeIterator listObjectsOfProperty(Resource resource, Property property) throws RDFException {
        HashSet<RDFNode> hashSet = new HashSet<RDFNode>();
        Iterator iterator = this.store.list(resource, property, null);
        try {
            Statement statement = null;
            while (iterator.hasNext()) {
                statement = (Statement)iterator.next();
                if (!statement.getPredicate().equals(property)) continue;
                hashSet.add(statement.getObject());
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (iterator instanceof ClosableIterator) {
                ((ClosableIterator)iterator).close();
            }
            throw throwable;
        }
        if (iterator instanceof ClosableIterator) {
            ((ClosableIterator)iterator).close();
        }
        return new NodeIteratorImpl(hashSet.iterator(), hashSet);
    }

    public StmtIterator listStatements(Selector selector) throws RDFException {
        Iterator iterator;
        if (selector instanceof SelectorImpl) {
            SelectorImpl selectorImpl = (SelectorImpl)selector;
            iterator = this.store.list(selectorImpl.getSubject(), selectorImpl.getPredicate(), selectorImpl.getObject());
        } else {
            iterator = this.store.list();
        }
        if (iterator == null) {
            return new StmtIteratorImpl(new HashSet().iterator(), null);
        }
        return this.listStatements(selector, iterator);
    }

    protected StmtIterator listStatements(Selector selector, Iterator iterator) throws RDFException {
        Vector<Statement> vector = new Vector<Statement>();
        while (iterator.hasNext()) {
            Statement statement = (Statement)iterator.next();
            try {
                if (!selector.test(statement)) continue;
                vector.add(statement);
            }
            catch (Exception exception) {
                if (iterator instanceof ClosableIterator) {
                    ((ClosableIterator)iterator).close();
                }
                throw new RDFException(14, exception);
            }
        }
        return new StmtIteratorImpl(((AbstractList)vector).iterator(), vector);
    }

    public Model begin() throws RDFException {
        throw new RDFException(3);
    }

    public Model abort() throws RDFException {
        throw new RDFException(3);
    }

    public Model commit() throws RDFException {
        throw new RDFException(3);
    }

    public boolean independent() {
        return true;
    }

    public Resource createResource() throws RDFException {
        return this.store.createResource(this);
    }

    public Resource createResource(String string) throws RDFException {
        return this.store.createResource(string, this);
    }

    public Property createProperty(String string) throws RDFException {
        return this.store.createProperty(string, this);
    }

    public Property createProperty(String string, String string2) throws RDFException {
        return this.store.createProperty(string, string2, this);
    }

    public Statement createStatement(Resource resource, Property property, RDFNode rDFNode) throws RDFException {
        return new StatementImpl(resource, property, rDFNode, this);
    }

    public Bag createBag(String string) throws RDFException {
        Bag bag = this.store.createBag(string, this);
        bag.addProperty(RDF.type, RDF.Bag);
        return bag;
    }

    public Alt createAlt(String string) throws RDFException {
        Alt alt = this.store.createAlt(string, this);
        alt.addProperty(RDF.type, RDF.Alt);
        return alt;
    }

    public Seq createSeq(String string) throws RDFException {
        Seq seq = this.store.createSeq(string, this);
        seq.addProperty(RDF.type, RDF.Seq);
        return seq;
    }

    public NodeIterator listContainerMembers(Container container, NodeIteratorFactory nodeIteratorFactory) throws RDFException {
        Iterator iterator = this.store.listBySubject(container);
        String string = RDF.getURI();
        Vector<Statement> vector = new Vector<Statement>();
        int n = 0;
        while (iterator.hasNext()) {
            Statement statement = (Statement)iterator.next();
            int n2 = statement.getPredicate().getOrdinal();
            if (!statement.getSubject().equals(container) || n2 == 0) continue;
            if (n2 > n) {
                n = n2;
                vector.setSize(n2);
            }
            vector.setElementAt(statement, n2 - 1);
        }
        if (iterator instanceof ClosableIterator) {
            ((ClosableIterator)iterator).close();
        }
        try {
            return nodeIteratorFactory.createIterator(((AbstractList)vector).iterator(), vector, container);
        }
        catch (Exception exception) {
            throw new RDFException(exception);
        }
    }

    public int containerSize(Container container) throws RDFException {
        int n = 0;
        Iterator iterator = this.store.listBySubject(container);
        String string = RDF.getURI();
        while (iterator.hasNext()) {
            Statement statement = (Statement)iterator.next();
            Property property = statement.getPredicate();
            if (!statement.getSubject().equals(container) || property.getOrdinal() == 0) continue;
            ++n;
        }
        if (iterator instanceof ClosableIterator) {
            ((ClosableIterator)iterator).close();
        }
        return n;
    }

    public int containerIndexOf(Container container, RDFNode rDFNode) throws RDFException {
        int n = 0;
        Iterator iterator = this.store.listBySubject(container);
        String string = RDF.getURI();
        while (iterator.hasNext()) {
            Statement statement = (Statement)iterator.next();
            Property property = statement.getPredicate();
            if (!statement.getSubject().equals(container) || property.getOrdinal() == 0 || !rDFNode.equals(statement.getObject())) continue;
            n = property.getOrdinal();
            break;
        }
        if (iterator instanceof ClosableIterator) {
            ((ClosableIterator)iterator).close();
        }
        return n;
    }

    public boolean containerContains(Container container, RDFNode rDFNode) throws RDFException {
        return this.containerIndexOf(container, rDFNode) != 0;
    }

    public Resource convert(Resource resource) throws RDFException {
        if (resource.getModel() == this) {
            return resource;
        }
        return ((ResourceI)((Object)resource)).port(this);
    }

    public Property convert(Property property) throws RDFException {
        if (property.getModel() == this) {
            return property;
        }
        return (Property)((ResourceI)((Object)property)).port(this);
    }

    public RDFNode convert(RDFNode rDFNode) throws RDFException {
        if (rDFNode instanceof Property) {
            return this.convert((Property)rDFNode);
        }
        if (rDFNode instanceof Resource) {
            return this.convert((Resource)rDFNode);
        }
        return rDFNode;
    }

    public boolean equals(Object object) {
        try {
            if (object == null || !(object instanceof Model)) {
                return false;
            }
            return ModelMatcher.equals(this, (Model)object);
        }
        catch (RDFException rDFException) {
            throw new RDFError(rDFException);
        }
    }

    public void close() {
        this.store.close();
    }

    public abstract boolean supportsSetOperations();

    public abstract boolean supportsTransactions();

    public abstract Model difference(Model var1) throws RDFException;

    public abstract Model intersection(Model var1) throws RDFException;

    public abstract Model union(Model var1) throws RDFException;

    public abstract Model query(Selector var1) throws RDFException;
}

