/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.query.util;

import com.hp.hpl.jena.rdf.arp.JenaReader;
import com.hp.hpl.jena.rdf.query.Sys;
import com.hp.hpl.jena.util.Log;
import com.hp.hpl.mesa.rdf.jena.bdb.ModelBdb;
import com.hp.hpl.mesa.rdf.jena.bdb.StoreBdbF;
import com.hp.hpl.mesa.rdf.jena.mem.ModelMem;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;

public class ModelLoader {
    public static final String langXML = "RDF/XML";
    public static final String langXMLAbbrev = "RDF/XML-ABBREV";
    public static final String langNTriple = "N-TRIPLE";
    public static final String langN3 = "N3";
    public static final String langBDB = "RDF/BDB";
    public static String defaultLanguage = "RDF/XML";
    public static String basename = null;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$arp$JenaReader;

    public static Model loadModel(String string, String string2) {
        Object object;
        if (string2 == null && (object = ModelLoader.getFilenameExt(string)) != null && ((String)object).length() > 0) {
            if (((String)object).equalsIgnoreCase("rdf")) {
                string2 = langXML;
            } else if (((String)object).equalsIgnoreCase("nt")) {
                string2 = langNTriple;
            } else if (((String)object).equalsIgnoreCase("bdb")) {
                string2 = langBDB;
            }
        }
        if (string2 == null) {
            string2 = defaultLanguage;
        }
        if (string2.equals(langBDB)) {
            if (basename != null) {
                string = basename + File.separator + string;
            }
            if ((object = ModelLoader.getDirname(string)) == null || ((String)object).length() == 0) {
                object = ".";
            }
            string = ModelLoader.getBasename(string);
            Log.debug("file=" + string + ", dir=" + (String)object + ", basename=" + basename, "ModelLoader", "loadModel");
            try {
                ModelBdb modelBdb = new ModelBdb(new StoreBdbF((String)object, string));
                return modelBdb;
            }
            catch (RDFException rDFException) {
                Sys.unhandledException(rDFException, "ModelLoader", "loadModel");
                System.exit(1);
            }
        }
        object = new ModelMem();
        object.setReaderClassName(langXML, (class$com$hp$hpl$jena$rdf$arp$JenaReader == null ? (class$com$hp$hpl$jena$rdf$arp$JenaReader = ModelLoader.class$("com.hp.hpl.jena.rdf.arp.JenaReader")) : class$com$hp$hpl$jena$rdf$arp$JenaReader).getName());
        object.setReaderClassName(langXMLAbbrev, (class$com$hp$hpl$jena$rdf$arp$JenaReader == null ? (class$com$hp$hpl$jena$rdf$arp$JenaReader = ModelLoader.class$("com.hp.hpl.jena.rdf.arp.JenaReader")) : class$com$hp$hpl$jena$rdf$arp$JenaReader).getName());
        try {
            ModelLoader.loadModel((Model)object, string, string2);
        }
        catch (RDFException rDFException) {
            Log.warning("Error loading data source", "ModelLoader", "loadModel", rDFException);
            return null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.warning("No such data source: " + string, "ModelLoader", "loadModel", fileNotFoundException);
            return null;
        }
        return object;
    }

    public static void loadModel(Model model, String string, String string2) throws RDFException, FileNotFoundException {
        Object object;
        String string3 = "file://unknown.net/";
        BufferedReader bufferedReader = null;
        try {
            object = new URL(string);
            bufferedReader = new BufferedReader(new InputStreamReader(((URL)object).openStream()));
            string3 = string;
        }
        catch (MalformedURLException malformedURLException) {
            String string4 = string;
            File file = basename != null ? new File(basename, string4) : new File(string4);
            string3 = "file:///" + file.getAbsolutePath();
            FileReader fileReader = new FileReader(file);
            bufferedReader = new BufferedReader(fileReader);
        }
        catch (IOException iOException) {
            Log.severe("IOException: " + iOException, "ModelLoader", "loadModel", iOException);
            return;
        }
        object = model.getReader(string2);
        if (object instanceof JenaReader) {
            object.setProperty("error-mode", "lax");
        }
        object.read(model, bufferedReader, string3);
    }

    public static void setFileBase(String string) {
        basename = string;
    }

    private static String getFilenameExt(String string) {
        int n = 0;
        int n2 = 0;
        n = string.lastIndexOf(47);
        int n3 = string.lastIndexOf(92);
        if (n3 > n) {
            n = n3;
        }
        if ((n2 = string.lastIndexOf(46)) > n) {
            String string2 = string.substring(n2 + 1).toLowerCase();
            return string2;
        }
        return "";
    }

    private static String getDirname(String string) {
        File file = new File(string);
        return file.getParent();
    }

    private static String getBasename(String string) {
        File file = new File(string);
        return file.getName();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

