/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.query.test;

import com.hp.hpl.jena.rdf.query.Query;
import com.hp.hpl.jena.rdf.query.QueryEngine;
import com.hp.hpl.jena.rdf.query.QueryException;
import com.hp.hpl.jena.rdf.query.QueryResults;
import com.hp.hpl.jena.rdf.query.QueryResultsFormatter;
import com.hp.hpl.jena.rdf.query.util.ModelLoader;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.util.Log;
import com.hp.hpl.jena.util.tuple.TupleItem;
import com.hp.hpl.jena.util.tuple.TupleSet;
import com.hp.hpl.mesa.rdf.jena.mem.ModelMem;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;

public class QueryTest {
    public static String controlFilename = "_control_";
    public static String testDirectory = "modules/rdf/regression/testRDQL";
    static String basename = null;
    public static boolean printDetails = false;
    public static boolean displayTime = false;
    static Writer outputFile = null;

    public static Test suite() {
        String string = testDirectory + "/" + controlFilename;
        ModelLoader.setFileBase(testDirectory);
        basename = testDirectory;
        printDetails = false;
        TestSuite testSuite = new TestSuite();
        QueryTest.addTests(string, testSuite);
        return testSuite;
    }

    public static void doTests(String string, boolean bl, boolean bl2) {
        displayTime = bl2;
        printDetails = bl || bl2;
        QueryTest.init();
        TestSuite testSuite = new TestSuite();
        QueryTest.addTests(string, testSuite);
        TestResult testResult = new TestResult();
        Enumeration enumeration = testSuite.tests();
        while (enumeration.hasMoreElements()) {
            Test test = (Test)enumeration.nextElement();
            test.run(testResult);
        }
    }

    public static void addTests(String string, TestSuite testSuite) {
        PrintWriter printWriter = new PrintWriter(System.out);
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string), 1024);
            TupleSet tupleSet = new TupleSet(bufferedReader);
            while (tupleSet.hasNext()) {
                TupleItem tupleItem;
                List list = (List)tupleSet.next();
                if (list == null || list.size() != 3) {
                    Log.severe("QueryTest: error in test file, line " + tupleSet.lineNumber + "\n" + tupleSet.line);
                    System.exit(1);
                }
                if (!(tupleItem = (TupleItem)list.get(0)).isURI()) {
                    Log.warning("Not a URI: " + tupleItem.asQuotedString() + " :: " + tupleSet.line);
                    continue;
                }
                TupleItem tupleItem2 = (TupleItem)list.get(1);
                if (!tupleItem2.isURI()) {
                    Log.warning("Not a URI: " + tupleItem2.asQuotedString() + " :: " + tupleSet.line);
                    continue;
                }
                TupleItem tupleItem3 = (TupleItem)list.get(2);
                if (!tupleItem3.isURI()) {
                    Log.warning("Not a URI: " + tupleItem3.asQuotedString() + " :: " + tupleSet.line);
                    continue;
                }
                String string2 = tupleItem.get();
                int n = string2.lastIndexOf(47);
                String string3 = n <= 0 ? string2 : string2.substring(n + 1);
                testSuite.addTest((Test)new RDQLTest(printWriter, "RDQL:" + string3, tupleItem.get(), tupleItem2.get(), tupleItem3.get()));
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            Log.warning("Exception during control file processing", "rdf.query.Test", "doTests", iOException);
            return;
        }
    }

    private static void init() {
        String string = "SELECT * WHERE (?x, ?y, ?z)";
        Query query = new Query(string);
        query.setSource(new ModelMem());
        QueryEngine queryEngine = new QueryEngine(query);
        QueryResults queryResults = queryEngine.exec();
        QueryResultsFormatter queryResultsFormatter = new QueryResultsFormatter(queryResults);
        queryResultsFormatter.consume();
    }

    static String formatlong(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Long.toString(l));
        int n = stringBuffer.length();
        while (n < 4) {
            stringBuffer.append(" ");
            ++n;
        }
        return stringBuffer.toString();
    }

    static class RDQLTest
    extends TestCase {
        static int testCounter = 1;
        PrintWriter pw;
        int testNumber = testCounter++;
        String queryFile;
        String dataFile;
        String resultsFile;

        RDQLTest(PrintWriter printWriter, String string, String string2, String string3, String string4) {
            super(string);
            this.pw = printWriter;
            this.queryFile = string2;
            this.dataFile = string3;
            this.resultsFile = string4;
        }

        protected void runTest() throws Throwable {
            block20: {
                Query query = null;
                try {
                    block19: {
                        try {
                            if (printDetails) {
                                if (this.testNumber != 1) {
                                    this.pw.println();
                                    this.pw.println("------------------------------------------------------------------------");
                                    this.pw.println();
                                }
                                this.pw.println("Test " + this.testNumber + " :: QueryFile=" + this.queryFile + ", DataFile=" + this.dataFile + ", ResultsFile=" + this.resultsFile);
                            }
                            String string = basename == null ? this.queryFile : testDirectory + "/" + this.queryFile;
                            String string2 = FileUtils.readWholeFile(string);
                            if (printDetails) {
                                this.pw.println("Query:");
                                this.pw.println(string2);
                                if (!string2.endsWith("\n")) {
                                    this.pw.println();
                                }
                            }
                            long l = System.currentTimeMillis();
                            query = new Query(string2);
                            if (printDetails) {
                                this.pw.println("Parsed query:");
                                this.pw.println(query.toString());
                            }
                            if (this.dataFile != null && !this.dataFile.equals("")) {
                                long l2 = System.currentTimeMillis();
                                query.setSource(ModelLoader.loadModel(this.dataFile, null));
                                query.loadTime = System.currentTimeMillis() - l2;
                            }
                            QueryEngine queryEngine = new QueryEngine(query);
                            queryEngine.init();
                            QueryResults queryResults = queryEngine.exec();
                            QueryResultsFormatter queryResultsFormatter = new QueryResultsFormatter(queryResults);
                            if (printDetails) {
                                queryResultsFormatter.printAll(this.pw, " | ");
                                this.pw.println();
                                this.pw.println("Results: " + queryResultsFormatter.numRows());
                            } else {
                                queryResultsFormatter.consume();
                            }
                            long l3 = System.currentTimeMillis();
                            long l4 = l3 - l;
                            queryResultsFormatter.close();
                            queryResults.close();
                            if (printDetails && displayTime) {
                                this.pw.println();
                                this.pw.println("Query parse:     " + QueryTest.formatlong(query.parseTime) + " ms");
                                this.pw.println("Query build:     " + QueryTest.formatlong(query.buildTime) + " ms");
                                this.pw.println("Data load time:  " + QueryTest.formatlong(query.loadTime) + " ms");
                                this.pw.println("Query execute:   " + QueryTest.formatlong(query.executeTime) + " ms");
                                this.pw.println("Query misc:      " + QueryTest.formatlong(l4 - query.parseTime - query.buildTime - query.loadTime - query.executeTime) + " ms");
                                this.pw.println("Query total:     " + QueryTest.formatlong(l4) + " ms");
                            }
                            if (this.resultsFile == null || this.resultsFile.equals("")) break block19;
                            this.pw.flush();
                            Log.warning("Results checking not implemented", "QueryTest", "doOneTest");
                        }
                        catch (QueryException queryException) {
                            this.pw.flush();
                            throw queryException;
                        }
                        catch (IOException iOException) {
                            this.pw.println("IOException: " + iOException);
                            iOException.printStackTrace(this.pw);
                            Object var14_15 = null;
                            if (query.getSource() != null) {
                                query.getSource().close();
                            }
                            this.pw.flush();
                            break block20;
                        }
                        catch (Exception exception) {
                            this.pw.println("Exception: " + exception);
                            exception.printStackTrace(this.pw);
                            Object var14_16 = null;
                            if (query.getSource() != null) {
                                query.getSource().close();
                            }
                            this.pw.flush();
                        }
                    }
                    Object var14_14 = null;
                    if (query.getSource() != null) {
                        query.getSource().close();
                    }
                    this.pw.flush();
                }
                catch (Throwable throwable) {
                    Object var14_17 = null;
                    if (query.getSource() != null) {
                        query.getSource().close();
                    }
                    this.pw.flush();
                    throw throwable;
                }
            }
        }
    }
}

