/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.query;

import com.hp.hpl.jena.rdf.query.Environment;
import com.hp.hpl.jena.rdf.query.QueryResults;
import com.hp.hpl.jena.rdf.query.RDQL_InternalErrorException;
import com.hp.hpl.jena.rdf.query.Value;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;

public class QueryResultsFormatter {
    QueryResults queryResults;
    List all;
    int numRows = -2;
    int numCols = -2;
    int[] colWidths = null;
    static final String notThere = "<<unset>>";

    public QueryResultsFormatter(QueryResults queryResults) {
        this.queryResults = queryResults;
    }

    public int numColumns() {
        return this.queryResults.getResultVars().size();
    }

    public int numRows() {
        return this.numRows;
    }

    private void colWidths() {
        this.numCols = this.queryResults.getResultVars().size();
        this.numRows = 0;
        this.colWidths = new int[this.numCols];
        int n = 0;
        while (n < this.numCols) {
            this.colWidths[n] = ((String)this.queryResults.getResultVars().get(n)).length();
            ++n;
        }
        Iterator iterator = this.all.iterator();
        while (iterator.hasNext()) {
            ++this.numRows;
            Environment environment = (Environment)iterator.next();
            int n2 = -1;
            Iterator iterator2 = this.queryResults.resultVars.iterator();
            while (iterator2.hasNext()) {
                String string;
                String string2 = (String)iterator2.next();
                Value value = environment.getValue(string2);
                String string3 = string = value == null ? notThere : value.asQuotedString();
                if (this.colWidths[++n2] >= string.length()) continue;
                this.colWidths[n2] = string.length();
            }
        }
    }

    public void close() {
        if (this.all == null) {
            this.all = this.queryResults.getAll();
        }
        this.queryResults.close();
        this.queryResults = null;
        this.all = null;
        this.colWidths = null;
    }

    public void dump(PrintWriter printWriter, boolean bl) {
        if (this.queryResults.resultVars.size() == 0) {
            printWriter.println("# ==== No variables ====");
            printWriter.flush();
            return;
        }
        if (bl) {
            this.dumpAligned(printWriter);
        } else {
            this.dumpRaw(printWriter);
        }
    }

    private void dumpRaw(PrintWriter printWriter) {
        this.numCols = this.queryResults.resultVars.size();
        QueryResults queryResults = this.queryResults;
        while (queryResults.hasNext()) {
            Environment environment = (Environment)queryResults.next();
            int n = 0;
            while (n < this.numCols) {
                String string = (String)this.queryResults.resultVars.get(n);
                Value value = environment.getValue(string);
                String string2 = value == null ? notThere : value.asQuotedString();
                printWriter.print("\"");
                printWriter.print(string);
                printWriter.print("\"");
                printWriter.print(" ");
                printWriter.print(string2);
                printWriter.print(" ");
                ++n;
            }
            printWriter.println(".");
        }
    }

    private void dumpAligned(PrintWriter printWriter) {
        Object object;
        if (this.all == null) {
            this.all = this.queryResults.getAll();
        }
        if (this.colWidths == null) {
            this.colWidths();
        }
        String[] stringArray = new String[this.numCols];
        int n = 0;
        int n2 = 0;
        while (n2 < this.numCols) {
            stringArray[n2] = object = (String)this.queryResults.resultVars.get(n2);
            n += this.colWidths[n2];
            ++n2;
        }
        object = this.all.iterator();
        while (object.hasNext()) {
            Environment environment = (Environment)object.next();
            int n3 = 0;
            while (n3 < this.numCols) {
                StringBuffer stringBuffer = new StringBuffer(120);
                String string = (String)this.queryResults.resultVars.get(n3);
                stringBuffer.append('\"');
                stringBuffer.append(string);
                stringBuffer.append('\"');
                stringBuffer.append(' ');
                Value value = environment.getValue(string);
                String string2 = value == null ? notThere : value.asQuotedString();
                int n4 = this.colWidths[n3];
                stringBuffer.append(string2);
                int n5 = 0;
                while (n5 < n4 - string2.length()) {
                    stringBuffer.append(' ');
                    ++n5;
                }
                stringBuffer.append(' ');
                printWriter.print(stringBuffer);
                ++n3;
            }
            printWriter.println(" .");
        }
        printWriter.flush();
    }

    public void printAll(PrintWriter printWriter, String string) {
        this.printAll(printWriter, string, null);
    }

    public void printAll(PrintWriter printWriter, String string, String string2) {
        if (this.queryResults.resultVars.size() == 0) {
            printWriter.println("==== No variables ====");
            printWriter.flush();
            return;
        }
        if (this.all == null) {
            this.all = this.queryResults.getAll();
        }
        if (this.colWidths == null) {
            this.colWidths();
        }
        String[] stringArray = new String[this.numCols];
        int n = 0;
        int n2 = 0;
        while (n2 < this.numCols) {
            String string3;
            stringArray[n2] = string3 = (String)this.queryResults.resultVars.get(n2);
            n += this.colWidths[n2];
            if (n2 > 0) {
                n += string.length();
            }
            ++n2;
        }
        this.printRow(printWriter, stringArray, string, string2);
        int n3 = 0;
        while (n3 < n) {
            printWriter.print('=');
            ++n3;
        }
        printWriter.println();
        Iterator iterator = this.all.iterator();
        while (iterator.hasNext()) {
            Environment environment = (Environment)iterator.next();
            int n4 = 0;
            while (n4 < this.numCols) {
                String string4;
                String string5 = (String)this.queryResults.resultVars.get(n4);
                Value value = environment.getValue(string5);
                stringArray[n4] = string4 = value == null ? notThere : value.asQuotedString();
                ++n4;
            }
            this.printRow(printWriter, stringArray, string, string2);
        }
        printWriter.flush();
    }

    private void printRow(PrintWriter printWriter, String[] stringArray, String string, String string2) {
        if (stringArray.length != this.numCols) {
            throw new RDQL_InternalErrorException("QueryResultsFormatter.printRow: Row length (" + stringArray.length + ") != numCols (" + this.numCols + ")");
        }
        int n = 0;
        while (n < this.numCols) {
            String string3 = stringArray[n];
            int n2 = this.colWidths[n];
            StringBuffer stringBuffer = new StringBuffer(120);
            if (n > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(string3);
            int n3 = 0;
            while (n3 < n2 - string3.length()) {
                stringBuffer.append(' ');
                ++n3;
            }
            printWriter.print(stringBuffer);
            ++n;
        }
        if (string2 != null) {
            printWriter.print(string2);
        }
        printWriter.println();
    }

    public void printHTML(PrintWriter printWriter) {
        Object object;
        if (this.all == null) {
            this.all = this.queryResults.getAll();
            this.numRows = this.all.size();
        }
        printWriter.println("<table>");
        printWriter.println("  <tr>");
        int n = 0;
        while (n < this.queryResults.getResultVars().size()) {
            object = (String)this.queryResults.getResultVars().get(n);
            printWriter.print("    <th>");
            printWriter.print((String)object);
            printWriter.print("</th>");
            printWriter.println();
            ++n;
        }
        printWriter.println("  </tr>");
        object = this.all.iterator();
        while (object.hasNext()) {
            printWriter.println("  <tr>");
            Environment environment = (Environment)object.next();
            int n2 = 0;
            while (n2 < this.queryResults.getResultVars().size()) {
                String string = (String)this.queryResults.resultVars.get(n2);
                Value value = environment.getValue(string);
                String string2 = value == null ? notThere : value.toString();
                printWriter.print("    <td>");
                printWriter.print(string2);
                printWriter.print("</td>");
                printWriter.println();
                ++n2;
            }
            printWriter.println("  </tr>");
        }
        printWriter.println("</table>");
        printWriter.flush();
    }

    public void consume() {
        this.numRows = 0;
        this.numCols = this.queryResults.getResultVars().size();
        QueryResults queryResults = this.queryResults;
        while (queryResults.hasNext()) {
            ++this.numRows;
            Environment environment = (Environment)queryResults.next();
            int n = 0;
            while (n < this.numCols) {
                String string = (String)this.queryResults.getResultVars().get(n);
                Value value = environment.getValue(string);
                String string2 = value == null ? null : value.toString();
                ++n;
            }
        }
    }
}

