/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.query;

import com.hp.hpl.jena.rdf.query.Environment;
import com.hp.hpl.jena.rdf.query.QueryEngine;
import com.hp.hpl.jena.rdf.query.Value;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class QueryResults
implements Iterator {
    Iterator queryEngineIter;
    QueryEngine queryEngine;
    List resultVars;
    Environment currentEnv;
    int rowNumber;
    volatile boolean finished = false;

    QueryResults(List list, QueryEngine queryEngine, Iterator iterator) {
        this.queryEngineIter = iterator;
        this.queryEngine = queryEngine;
        this.resultVars = list;
        this.currentEnv = null;
        this.rowNumber = 0;
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("com.hp.hpl.jena.rdf.query.QueryResults.remove");
    }

    public boolean hasNext() {
        return this.queryEngineIter.hasNext();
    }

    public Object next() {
        this.currentEnv = (Environment)this.queryEngineIter.next();
        if (this.currentEnv != null) {
            ++this.rowNumber;
        }
        return this.currentEnv;
    }

    public void close() {
        if (!this.finished) {
            this.queryEngine.stop();
            this.finished = true;
        }
    }

    public String getBinding(String string) {
        return this.getBindingWorker(string, false);
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public List getResultVars() {
        return this.resultVars;
    }

    public List getAll() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (this.hasNext()) {
            arrayList.add(this.next());
        }
        return arrayList;
    }

    private String getBindingWorker(String string, boolean bl) {
        if (!bl || this.resultVars.contains(string)) {
            Value value = this.currentEnv.getValue(string);
            if (value == null) {
                return null;
            }
            return value.toString();
        }
        return null;
    }
}

