/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.rdf.arp.ARPErrorNumbers;
import com.hp.hpl.jena.rdf.arp.ARPFilter;
import com.hp.hpl.jena.rdf.arp.ARPQname;
import com.hp.hpl.jena.rdf.arp.ARPResource;
import com.hp.hpl.jena.rdf.arp.BadURIReference;
import com.hp.hpl.jena.rdf.arp.Location;
import com.hp.hpl.jena.rdf.arp.ParseException;
import com.hp.hpl.jena.rdf.arp.RDFParserConstants;
import com.hp.hpl.jena.rdf.arp.StrToken;
import com.hp.hpl.jena.rdf.arp.Token;
import com.hp.hpl.jena.rdf.arp.URIReference;
import com.hp.hpl.jena.rdf.arp.XMLContext;
import com.hp.hpl.jena.rdf.arp.lang.LanguageTag;
import com.hp.hpl.jena.rdf.arp.lang.LanguageTagCodes;
import com.hp.hpl.jena.rdf.arp.lang.LanguageTagSyntaxException;
import com.hp.hpl.jena.util.URIref;
import java.util.HashMap;
import java.util.Map;
import org.apache.xerces.utils.URI;
import org.apache.xerces.utils.XMLCharacterProperties;

class ParserSupport
implements ARPErrorNumbers,
RDFParserConstants,
LanguageTagCodes {
    Map idsUsed = new HashMap();
    ARPFilter arp;

    ParserSupport(ARPFilter aRPFilter) {
        this.arp = aRPFilter;
    }

    void checkWhite(StrToken strToken) throws ParseException {
        String string = strToken.value;
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            switch (string.charAt(n2++)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    throw new ParseException(202, strToken.location, "Expected whitespace found: '" + string + "'.");
                }
            }
        }
    }

    void checkIdSymbol(XMLContext xMLContext, StrToken strToken) throws ParseException {
        Location location = (Location)this.idsUsed.get(strToken.value);
        if (location != null) {
            this.arp.parseWarning(105, strToken.location, "Redefinition of ID: " + strToken.value);
            this.arp.parseWarning(105, location, "Previous definition of '" + strToken.value + "'.");
        } else {
            this.idsUsed.put(strToken.value, strToken.location);
        }
        if (!xMLContext.isSameAsDocument()) {
            this.arp.parseWarning(3, strToken.location, "The use of xml:base changes the meaning of ID '" + strToken.value + "'.");
        }
        this.checkXMLName(strToken, strToken.value);
    }

    private void checkXMLName(StrToken strToken, String string) throws ParseException {
        if (!XMLCharacterProperties.validName((String)string)) {
            this.arp.parseWarning(108, strToken.location, "Not an XML Name: '" + string + "'");
        }
    }

    void checkXMLLang(StrToken strToken) throws ParseException {
        String string = strToken.value;
        try {
            LanguageTag languageTag = new LanguageTag(string);
            int n = languageTag.tagType();
            if (n == 32768) {
                this.arp.parseWarning(116, strToken.location, languageTag.errorMessage());
            }
            if ((n & 0x200) == 512) {
                this.arp.parseWarning(116, strToken.location, "Unnecessary use of language tag \"und\" prohibited by RFC3066");
            }
            if ((n & 0x2000) == 8192) {
                this.arp.parseWarning(117, strToken.location, "Use of deprecated language tag \"" + string + "\".");
            }
            if ((n & 2) == 2) {
                this.arp.parseWarning(1, strToken.location, "Use of (IANA) private language tag \"" + string + "\".");
            } else if ((n & 0x800) == 2048) {
                this.arp.parseWarning(1, strToken.location, "Use of (ISO639-2) local use language tag \"" + string + "\".");
            } else if ((n & 0x80) == 128) {
                this.arp.parseWarning(1, strToken.location, "Use of additional private subtags on language \"" + string + "\".");
            }
        }
        catch (LanguageTagSyntaxException languageTagSyntaxException) {
            this.arp.parseWarning(115, strToken.location, languageTagSyntaxException.getMessage());
        }
    }

    private String truncateXMLBase(StrToken strToken) {
        return ParserSupport.truncateXMLBase(strToken.value);
    }

    static String truncateXMLBase(String string) {
        int n = string.indexOf(35);
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    XMLContext changeXMLBase(XMLContext xMLContext, Token token) throws ParseException {
        this.arp.parseWarning(2, token.location, "Use of attribute xml:base is not envisaged in RDF Model&Syntax.");
        StrToken strToken = (StrToken)token;
        String string = URIref.encode(this.truncateXMLBase(strToken));
        try {
            xMLContext = xMLContext.withBase(string);
        }
        catch (URI.MalformedURIException malformedURIException) {
            this.arp.parseWarning(107, token.location, "Bad URI: " + malformedURIException.getMessage());
            xMLContext = xMLContext.revertToDocument();
        }
        return xMLContext;
    }

    URIReference makeURIReference(XMLContext xMLContext, Token token) throws ParseException {
        StrToken strToken = (StrToken)token;
        String string = URIref.encode(strToken.value);
        try {
            URIReference uRIReference;
            URIReference uRIReference2 = new URIReference(xMLContext, string);
            if (string.indexOf(58) == -1 && !xMLContext.isSameAsDocument() && !(uRIReference = new URIReference(xMLContext.getDocument(), string)).equals(uRIReference2)) {
                this.arp.parseWarning(3, token.location, "Use of attribute xml:base changes interpretation of relative URI: \"" + string + "\".");
            }
            return uRIReference2;
        }
        catch (URI.MalformedURIException malformedURIException) {
            this.arp.parseWarning(107, token.location, "Bad URI: " + malformedURIException.getMessage());
            return new BadURIReference(string);
        }
    }

    void createTriple(ARPResource aRPResource, Token token, Object object, String string) throws ParseException {
        switch (token.kind) {
            case 13: {
                aRPResource.setPredicateObject(((ARPQname)token).asURIReference(this.arp), object, string);
                break;
            }
            case 14: {
                aRPResource.setLiObject(object, string);
                break;
            }
            case 15: {
                aRPResource.setMemberObject(((ARPQname)token).asURIReference(this.arp), object, string);
                break;
            }
            default: {
                throw new RuntimeException("Assertion failure in ParserSupport.createTriple");
            }
        }
    }

    private Map checkNameSpace(StringBuffer stringBuffer, ARPQname aRPQname, Map map) {
        String string = aRPQname.qName;
        int n = string.indexOf(58);
        String string2 = n == -1 ? "" : string.substring(0, n);
        String string3 = (String)map.get(string2);
        if (string3 == null || !string3.equals(aRPQname.nameSpace)) {
            HashMap<String, String> hashMap = new HashMap<String, String>(map);
            hashMap.put(string2, aRPQname.nameSpace);
            if (string2.length() == 0) {
                stringBuffer.append(" xmlns=\"" + aRPQname.nameSpace + "\"");
            } else {
                stringBuffer.append(" xmlns:" + string2 + "=\"" + aRPQname.nameSpace + "\"");
            }
            return hashMap;
        }
        return map;
    }

    Map startLitEnt(StringBuffer stringBuffer, Token token, Map map) {
        ARPQname aRPQname = (ARPQname)token;
        stringBuffer.append("<" + aRPQname.qName);
        return this.checkNameSpace(stringBuffer, aRPQname, map);
    }

    void endLitEnt(StringBuffer stringBuffer, Token token) {
        String string = ((ARPQname)token).qName;
        stringBuffer.append("</" + string + ">");
    }

    Map litAttrName(StringBuffer stringBuffer, Token token, Map map) {
        ARPQname aRPQname = (ARPQname)token;
        Map map2 = this.checkNameSpace(stringBuffer, aRPQname, map);
        stringBuffer.append(" " + aRPQname.qName);
        return map;
    }

    void litAttrValue(StringBuffer stringBuffer, Token token) {
        stringBuffer.append("=\"" + ParserSupport.encodeAttr(((StrToken)token).value) + "\"");
    }

    void litText(StringBuffer stringBuffer, Token token) {
        stringBuffer.append(ParserSupport.encodeText(((StrToken)token).value));
    }

    Map xmlNameSpace() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("xml", ARPFilter.xmlns);
        return hashMap;
    }

    private static String encodeAttr(String string) {
        string = ParserSupport.replace(string, "&", "&amp;");
        string = ParserSupport.replace(string, "<", "&lt;");
        string = ParserSupport.replace(string, "\"", "&quot;");
        string = ParserSupport.replace(string, "\t", "&#x9;");
        string = ParserSupport.replace(string, "\n", "&#xA;");
        string = ParserSupport.replace(string, "\r", "&#xD;");
        return string;
    }

    private static String encodeText(String string) {
        string = ParserSupport.replace(string, "&", "&amp;");
        string = ParserSupport.replace(string, "<", "&lt;");
        string = ParserSupport.replace(string, ">", "&gt;");
        string = ParserSupport.replace(string, "\r", "&#xD;");
        return string;
    }

    private static String replace(String string, String string2, String string3) {
        String string4 = "";
        int n = string2.length();
        int n2 = string.indexOf(string2);
        int n3 = 0;
        while (n2 >= 0) {
            string4 = string4 + string.substring(n3, n2) + string3;
            n3 = n2 + n;
            n2 = string.indexOf(string2, n3);
        }
        return string4 + string.substring(n3, string.length());
    }
}

