/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.rdf.arp.ALiteral;
import com.hp.hpl.jena.rdf.arp.ARPErrorNumbers;
import com.hp.hpl.jena.rdf.arp.ARPFilter;
import com.hp.hpl.jena.rdf.arp.ARPResource;
import com.hp.hpl.jena.rdf.arp.AResource;
import com.hp.hpl.jena.rdf.arp.SaxErrorHandler;
import com.hp.hpl.jena.rdf.arp.StatementHandler;
import com.hp.hpl.mesa.rdf.jena.common.LiteralImpl;
import com.hp.hpl.mesa.rdf.jena.common.PropertyImpl;
import com.hp.hpl.mesa.rdf.jena.common.RDFDefaultErrorHandler;
import com.hp.hpl.mesa.rdf.jena.common.ResourceImpl;
import com.hp.hpl.mesa.rdf.jena.mem.ModelMem;
import com.hp.hpl.mesa.rdf.jena.model.Literal;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFErrorHandler;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFReader;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.URL;
import org.apache.xerces.utils.URI;
import org.xml.sax.InputSource;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class JenaReader
implements RDFReader,
ARPErrorNumbers {
    private static final String saxFeaturesURL = "http://xml.org/sax/features/";
    private static final String saxPropertiesURL = "http://xml.org/sax/properties/";
    private static final String apacheFeaturesURL = "http://apache.org/xml/features/";
    private static final String apachePropertiesURL = "http://apache.org/xml/properties/";
    private static final String arpPropertiesURL = "http://jena.hpl.hp.com/arp/properties/";
    private static final int arpPropertiesURLLength = "http://jena.hpl.hp.com/arp/properties/".length();
    private ARPFilter arpf;
    RDFErrorHandler errorHandler = new RDFDefaultErrorHandler();
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$arp$JenaReader;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$arp$ARPErrorNumbers;

    public static void useMe(Model model) {
        model.setReaderClassName("RDF/XML", (class$com$hp$hpl$jena$rdf$arp$JenaReader == null ? (class$com$hp$hpl$jena$rdf$arp$JenaReader = JenaReader.class$("com.hp.hpl.jena.rdf.arp.JenaReader")) : class$com$hp$hpl$jena$rdf$arp$JenaReader).getName());
        model.setReaderClassName("RDF/XML-ABBREV", (class$com$hp$hpl$jena$rdf$arp$JenaReader == null ? (class$com$hp$hpl$jena$rdf$arp$JenaReader = JenaReader.class$("com.hp.hpl.jena.rdf.arp.JenaReader")) : class$com$hp$hpl$jena$rdf$arp$JenaReader).getName());
    }

    public JenaReader() {
        this.arpf = new ARPFilter();
    }

    public void read(Model model, String string) throws RDFException {
        try {
            this.read(model, new InputStreamReader(new URL(string).openStream()), string);
        }
        catch (RDFException rDFException) {
            throw rDFException;
        }
        catch (Exception exception) {
            throw new RDFException(exception);
        }
    }

    public static Literal translate(ALiteral aLiteral) {
        return new LiteralImpl(aLiteral.toString(), aLiteral.getLang(), aLiteral.isWellFormedXML());
    }

    public static Resource translate(AResource aResource) {
        if (aResource.isAnonymous()) {
            String string = aResource.getAnonymousID();
            Resource resource = (Resource)aResource.getUserData();
            if (resource == null) {
                resource = new ResourceImpl();
                aResource.setUserData(resource);
            }
            return resource;
        }
        return new ResourceImpl(aResource.getURI());
    }

    public static Property translatePred(AResource aResource) throws RDFException {
        return new PropertyImpl(aResource.getURI());
    }

    public synchronized void read(final Model model, Reader reader, String string) throws RDFException {
        try {
            InputSource inputSource = new InputSource(reader);
            if (string == null) {
                string = ARPResource.dummy;
                this.errorHandler.error(new NullPointerException("A document base URI must be specified."));
            }
            if (!string.equals("")) {
                try {
                    URI uRI = new URI(string);
                }
                catch (URI.MalformedURIException malformedURIException) {
                    this.errorHandler.error((Exception)((Object)malformedURIException));
                }
            } else {
                string = ARPResource.dummy;
            }
            inputSource.setSystemId(string);
            this.arpf.setStatementHandler(new StatementHandler(){

                public void statement(AResource aResource, AResource aResource2, AResource aResource3) {
                    try {
                        model.add(JenaReader.translate(aResource), JenaReader.translatePred(aResource2), JenaReader.translate(aResource3));
                    }
                    catch (RDFException rDFException) {
                        JenaReader.this.errorHandler.error(rDFException);
                    }
                }

                public void statement(AResource aResource, AResource aResource2, ALiteral aLiteral) {
                    try {
                        model.add(JenaReader.translate(aResource), JenaReader.translatePred(aResource2), JenaReader.translate(aLiteral));
                    }
                    catch (RDFException rDFException) {
                        JenaReader.this.errorHandler.error(rDFException);
                    }
                }
            });
            if (model.size() == 0L) {
                // empty if block
            }
            this.arpf.setErrorHandler(new SaxErrorHandler(this.errorHandler));
            this.arpf.parse(inputSource);
        }
        catch (Exception exception) {
            throw new RDFException(exception);
        }
    }

    public RDFErrorHandler setErrorHandler(RDFErrorHandler rDFErrorHandler) {
        RDFErrorHandler rDFErrorHandler2 = this.errorHandler;
        this.errorHandler = rDFErrorHandler;
        return rDFErrorHandler2;
    }

    public Object setProperty(String string, Object object) throws RDFException {
        Object object2 = object;
        if (string.startsWith("http:")) {
            if (string.startsWith(arpPropertiesURL)) {
                return this.setArpProperty(string.substring(arpPropertiesURLLength), object2);
            }
            if (string.startsWith(saxPropertiesURL) || string.startsWith(apachePropertiesURL)) {
                Object object3;
                try {
                    object3 = this.arpf.getProperty(string);
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    object3 = null;
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    this.errorHandler.error(new RDFException(22));
                    return null;
                }
                try {
                    this.arpf.setProperty(string, object2);
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    this.errorHandler.error(new RDFException(sAXNotSupportedException));
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    this.errorHandler.error(new RDFException(22));
                    return null;
                }
                return object3;
            }
            if (string.startsWith(saxFeaturesURL) || string.startsWith(apacheFeaturesURL)) {
                Boolean bl;
                try {
                    bl = new Boolean(this.arpf.getFeature(string));
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    bl = null;
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    this.errorHandler.error(new RDFException(22));
                    return null;
                }
                try {
                    this.arpf.setFeature(string, (Boolean)object2);
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    this.errorHandler.error(new RDFException(sAXNotSupportedException));
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    this.errorHandler.error(new RDFException(22));
                    return null;
                }
                catch (ClassCastException classCastException) {
                    this.errorHandler.error(new RDFException(new SAXNotSupportedException("Feature: '" + string + "' can only have a boolean value.")));
                }
                return bl;
            }
        }
        return this.setArpProperty(string, object2);
    }

    private int getValue(String string) {
        Class clazz = class$com$hp$hpl$jena$rdf$arp$ARPErrorNumbers == null ? (class$com$hp$hpl$jena$rdf$arp$ARPErrorNumbers = JenaReader.class$("com.hp.hpl.jena.rdf.arp.ARPErrorNumbers")) : class$com$hp$hpl$jena$rdf$arp$ARPErrorNumbers;
        try {
            Field field = clazz.getField(string);
            return field.getInt(null);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private Object setArpProperty(String string, Object object) {
        int n;
        string = string.toUpperCase();
        if (object == null) {
            object = "";
        }
        if (object instanceof String) {
            object = ((String)object).toUpperCase();
        }
        if (string.equals("ERROR-MODE")) {
            if (object instanceof String) {
                String string2 = (String)object;
                if (string2.equals("LAX")) {
                    this.arpf.setLaxErrorMode();
                    return null;
                }
                if (string2.equals("DEFAULT")) {
                    this.arpf.setDefaultErrorMode();
                    return null;
                }
                if (string2.equals("STRICT")) {
                    this.arpf.setStrictErrorMode();
                    return null;
                }
                if (string2.equals("STRICT-WARNING")) {
                    this.arpf.setStrictErrorMode(1);
                    return null;
                }
                if (string2.equals("STRICT-FATAL")) {
                    this.arpf.setStrictErrorMode(3);
                    return null;
                }
                if (string2.equals("STRICT-IGNORE")) {
                    this.arpf.setStrictErrorMode(0);
                    return null;
                }
                if (string2.equals("STRICT-ERROR")) {
                    this.arpf.setStrictErrorMode(2);
                    return null;
                }
            }
            this.errorHandler.error(new IllegalArgumentException("Property \"ERROR-MODE\" takes the following values: \"default\", \"lax\", \"strict\", \"strict-ignore\", \"strict-warning\", \"strict-error\", \"strict-fatal\"."));
            return null;
        }
        if (string.equals("EMBEDDING")) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            if (!(object instanceof Boolean)) {
                this.errorHandler.error(new IllegalArgumentException("Property \"EMBEDDING\" requires a boolean value."));
                boolean bl = this.arpf.setEmbedding(false);
                this.arpf.setEmbedding(bl);
                return new Boolean(bl);
            }
            return new Boolean(this.arpf.setEmbedding((Boolean)object));
        }
        if ((string.startsWith("ERR_") || string.startsWith("IGN_") || string.startsWith("WARN_")) && (n = this.getValue(string)) != -1) {
            int n2;
            if (object instanceof String) {
                if (((String)object).startsWith("EM_") && (n2 = this.getValue((String)object)) != -1) {
                    int n3 = this.arpf.setErrorMode(n, n2);
                    return new Integer(n3);
                }
            } else if (object instanceof Integer) {
                n2 = (Integer)object;
                switch (n2) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        int n4 = this.arpf.setErrorMode(n, n2);
                        return new Integer(n4);
                    }
                }
            }
            this.errorHandler.error(new IllegalArgumentException("Property \"" + string + "\" cannot have value: " + object.toString()));
            n2 = this.arpf.setErrorMode(n, 2);
            this.arpf.setErrorMode(n, n2);
            return new Integer(n2);
        }
        this.errorHandler.error(new RDFException(22));
        return null;
    }

    public static Model memModel() {
        ModelMem modelMem = new ModelMem();
        JenaReader.useMe(modelMem);
        return modelMem;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

