/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.daml.test;

import com.hp.hpl.jena.daml.DAMLClass;
import com.hp.hpl.jena.daml.DAMLCommon;
import com.hp.hpl.jena.daml.DAMLDataInstance;
import com.hp.hpl.jena.daml.DAMLInstance;
import com.hp.hpl.jena.daml.DAMLList;
import com.hp.hpl.jena.daml.DAMLModel;
import com.hp.hpl.jena.daml.DAMLObjectProperty;
import com.hp.hpl.jena.daml.DAMLProperty;
import com.hp.hpl.jena.daml.common.DAMLModelImpl;
import com.hp.hpl.jena.util.Log;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.ResIterator;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.vocabulary.RDF;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class DAMLTest
extends TestCase {
    static /* synthetic */ Class class$java$lang$String;

    public DAMLTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest((Test)new DAMLTest("testLoadOntology"));
        testSuite.addTest((Test)new DAMLTest("testRDFType"));
        testSuite.addTest((Test)new DAMLTest("testClass"));
        testSuite.addTest((Test)new DAMLTest("testEquivalence"));
        testSuite.addTest((Test)new DAMLTest("testProperty"));
        testSuite.addTest((Test)new DAMLTest("testList"));
        testSuite.addTest((Test)new DAMLTest("testDatatype"));
        return testSuite;
    }

    public void setUp() {
        try {
            Log.getInstance().setDefaultFileHandler(true);
        }
        catch (IOException iOException) {
            System.err.println("Could not open log file " + iOException);
        }
        Log.finest("Test suite setting up");
    }

    public void tearDown() {
        Log.debug("Test suite tearing down");
    }

    public void testLoadOntology() throws RDFException {
        Log.debug("Starting loadOntology tests");
        DAMLModelImpl dAMLModelImpl = new DAMLModelImpl();
        Log.debug("Test: loading (2000/12, import, standard block)");
        dAMLModelImpl.read("file:modules/rdf/regression/testDAML/daml_oil_2000_12/daml+oil-ex.daml", "http://www.daml.org/2000/12/daml+oil-ex", null);
        Assert.assertTrue((String)"Load success status should be true", (boolean)dAMLModelImpl.getLoadSuccessful());
        Assert.assertEquals((String)"Count of number of classes in daml store", (int)36, (int)this.countClasses(dAMLModelImpl));
        Assert.assertEquals((String)"Count of number of properties in daml store", (int)44, (int)this.countProperties(dAMLModelImpl));
        Log.debug("Test: loading (2000/12, no import)");
        dAMLModelImpl = new DAMLModelImpl();
        dAMLModelImpl.getLoader().setLoadImportedOntologies(false);
        dAMLModelImpl.read("file:modules/rdf/regression/testDAML/daml_oil_2000_12/daml+oil-ex.daml", "http://www.daml.org/2000/12/daml+oil-ex", null);
        Assert.assertTrue((String)"Load success status should be true", (boolean)dAMLModelImpl.getLoadSuccessful());
        Assert.assertEquals((String)"Count of number of classes in daml store (2000/12, no import)", (int)20, (int)this.countClasses(dAMLModelImpl));
        Assert.assertEquals((String)"Count of number of properties in daml store (2000/12, no import)", (int)8, (int)this.countProperties(dAMLModelImpl));
        Log.debug("Test: loading (2000/12, import, added to block list)");
        dAMLModelImpl = new DAMLModelImpl();
        dAMLModelImpl.getLoader().addImportBlock("file:modules/rdf/regression/testDAML/daml_oil_2000_12/daml-local-ex.daml");
        dAMLModelImpl.read("file:modules/rdf/regression/testDAML/daml_oil_2000_12/daml+oil-ex.daml", "http://www.daml.org/2000/12/daml+oil-ex", null);
        Assert.assertTrue((String)"Load success status should be true", (boolean)dAMLModelImpl.getLoadSuccessful());
        Assert.assertEquals((String)"Count of number of classes in daml store (2000/12, import block)", (int)34, (int)this.countClasses(dAMLModelImpl));
        Assert.assertEquals((String)"Count of number of properties in daml store (2000/12, import block)", (int)44, (int)this.countProperties(dAMLModelImpl));
        Log.debug("Test: loading (2001/03, import, standard block)");
        dAMLModelImpl = new DAMLModelImpl();
        dAMLModelImpl.read("file:modules/rdf/regression/testDAML/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        Assert.assertTrue((String)"Load success status should be true", (boolean)dAMLModelImpl.getLoadSuccessful());
        Assert.assertEquals((String)"Count of number of classes in daml store (2001/03, import)", (int)43, (int)this.countClasses(dAMLModelImpl));
        Assert.assertEquals((String)"Count of number of properties in daml store (2001/03, import) ", (int)50, (int)this.countProperties(dAMLModelImpl));
        Log.debug("Test: loading (2001/03, no import)");
        dAMLModelImpl = new DAMLModelImpl();
        dAMLModelImpl.getLoader().setLoadImportedOntologies(false);
        dAMLModelImpl.read("file:modules/rdf/regression/testDAML/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        Assert.assertTrue((String)"Load success status should be true", (boolean)dAMLModelImpl.getLoadSuccessful());
        Assert.assertEquals((String)"Count of number of classes in daml store (2001/03, no import)", (int)28, (int)this.countClasses(dAMLModelImpl));
        Assert.assertEquals((String)"Count of number of properties in daml store (2001/03, no import)", (int)12, (int)this.countProperties(dAMLModelImpl));
        if (System.getProperty("proxySet") != null && System.getProperty("proxySet").equals("true")) {
            Log.debug("Test: loading (2001/03, http)");
            dAMLModelImpl = new DAMLModelImpl();
            dAMLModelImpl.read("http://www.daml.org/2001/03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
            Assert.assertTrue((String)"Load success status should be true", (boolean)dAMLModelImpl.getLoadSuccessful());
            Assert.assertEquals((String)"Count of number of classes in daml store (2001/03, http)", (int)28, (int)this.countClasses(dAMLModelImpl));
            Assert.assertEquals((String)"Count of number of properties in daml store (2001/03, http)", (int)12, (int)this.countProperties(dAMLModelImpl));
        } else {
            Log.finest("HTTP proxy is not set, so skipping HTTP read test 1");
        }
        if (System.getProperty("proxySet") != null) {
            Log.debug("Test: loading (2001/03, http, block removed)");
            dAMLModelImpl = new DAMLModelImpl();
            dAMLModelImpl.getLoader().removeImportBlock("http://www.daml.org/2001/03/daml+oil");
            dAMLModelImpl.read("http://www.daml.org/2001/03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
            Assert.assertTrue((String)"Load success status should be true", (boolean)dAMLModelImpl.getLoadSuccessful());
            Assert.assertEquals((String)"Count of number of classes in daml store (2001/03, http, block removed)", (int)43, (int)this.countClasses(dAMLModelImpl));
            Assert.assertEquals((String)"Count of number of properties in daml store (2001/03, http, block removed)", (int)50, (int)this.countProperties(dAMLModelImpl));
        } else {
            Log.finest("HTTP proxy is not set, so skipping HTTP read test 2");
        }
    }

    public void testRDFType() throws RDFException {
        String string = "http://dickinson-i-4/daml/tests/test-cases.daml#";
        Log.debug("Starting rdf:type tests");
        DAMLModelImpl dAMLModelImpl = new DAMLModelImpl();
        dAMLModelImpl.getLoader().setLoadImportedOntologies(false);
        dAMLModelImpl.read("file:modules/rdf/regression/testDAML/test-cases.daml", "http://dickinson-i-4/daml/tests/test-cases.daml", null);
        DAMLInstance dAMLInstance = (DAMLInstance)dAMLModelImpl.getDAMLValue(string + "fido");
        Assert.assertNotNull((String)"fido instance should not be null", (Object)dAMLInstance);
        DAMLClass dAMLClass = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "Dog");
        Assert.assertNotNull((String)"Dog class should not be null", (Object)dAMLClass);
        DAMLClass dAMLClass2 = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "Vertebrate");
        Assert.assertNotNull((String)"Vertebrate class should not be null", (Object)dAMLClass2);
        DAMLClass dAMLClass3 = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "Pet");
        Assert.assertNotNull((String)"Pet class should not be null", (Object)dAMLClass3);
        Assert.assertTrue((String)"fido should be member of class Dog", (boolean)dAMLInstance.hasRDFType(dAMLClass));
        Assert.assertTrue((String)"fido should be member of class Vertebrate", (boolean)dAMLInstance.hasRDFType(dAMLClass2));
        Assert.assertTrue((String)"fido should be member of class Vertebrate (by URL)", (boolean)dAMLInstance.hasRDFType(string + "Vertebrate"));
        Assert.assertTrue((String)"fido should be member of class Pet", (boolean)dAMLInstance.hasRDFType(dAMLClass3));
        Assert.assertTrue((String)"fido should not be a class", (!dAMLInstance.hasRDFType(DAML_OIL.Class) ? 1 : 0) != 0);
        Assert.assertTrue((String)"fido should be a companion", (boolean)dAMLInstance.hasRDFType(string + "Companion"));
        Assert.assertTrue((String)"fido should be a thing", (boolean)dAMLInstance.hasRDFType(DAML_OIL.Thing));
        DAMLClass dAMLClass4 = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "A");
        Assert.assertNotNull((String)"Class A should not be null", (Object)dAMLClass4);
        DAMLClass dAMLClass5 = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "B");
        Assert.assertNotNull((String)"Class B should not be null", (Object)dAMLClass5);
        DAMLInstance dAMLInstance2 = (DAMLInstance)dAMLModelImpl.getDAMLValue(string + "ab");
        Assert.assertNotNull((String)"Instance ab should not be null", (Object)dAMLInstance2);
        Assert.assertTrue((String)"ab should be an A", (boolean)dAMLInstance2.hasRDFType(dAMLClass4));
        Assert.assertTrue((String)"ab should be a B", (boolean)dAMLInstance2.hasRDFType(dAMLClass5));
        Assert.assertEquals((String)"Number of classes fido belongs to (closure) should be 7", (int)7, (int)this.countIteration(dAMLInstance.getRDFTypes(true), true, "fido member of class "));
        Assert.assertEquals((String)"Number of classes fido belongs to (non-closure) should be 2", (int)2, (int)this.countIteration(dAMLInstance.getRDFTypes(false), true, "fido member of non-closed class "));
        DAMLProperty dAMLProperty = (DAMLProperty)dAMLModelImpl.getDAMLValue(string + "queen-of");
        Assert.assertNotNull((String)"queen-of property should be defined", (Object)dAMLProperty);
        Assert.assertTrue((String)"an UnabmbiguousProperty should be an ObjectProperty", (boolean)dAMLProperty.hasRDFType(DAML_OIL.UnambiguousProperty));
        Assert.assertTrue((String)"an UnabmbiguousProperty should be an ObjectProperty", (boolean)dAMLProperty.hasRDFType(DAML_OIL.ObjectProperty));
        Assert.assertTrue((String)"an UnabmbiguousProperty should be an rdf:Property", (boolean)dAMLProperty.hasRDFType(RDF.Property));
    }

    public void testClass() throws RDFException {
        Log.debug("Starting DAML class tests");
        DAMLModelImpl dAMLModelImpl = new DAMLModelImpl();
        dAMLModelImpl.read("file:modules/rdf/regression/testDAML/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        Assert.assertTrue((String)"loadStatus should be true for successful load", (boolean)dAMLModelImpl.getLoadSuccessful());
        String string = "http://www.daml.org/2001/03/daml+oil-ex#";
        DAMLClass dAMLClass = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "Person");
        Assert.assertNotNull((String)"Person class should not be null", (Object)dAMLClass);
        Assert.assertTrue((String)"Person should be a named class", (boolean)dAMLClass.isNamedClass());
        int n = this.countIteration(dAMLClass.prop_subClassOf().getAll(true), true, "super-class of Person (prop_subClassOf) ");
        int n2 = this.countIteration(dAMLClass.getSuperClasses(), true, "super-class of Person (getSuperClasses) ");
        Assert.assertEquals((String)"person should have 7 super-classes (by prop_subClassOf)", (int)7, (int)n);
        Assert.assertEquals((String)"person should have 9 super-classes (by getSuperClasses)", (int)9, (int)n2);
        Assert.assertEquals((String)"person should have 2 sub-classes", (int)2, (int)this.countIteration(dAMLClass.getSubClasses(), true, "Person super-class of: "));
        Assert.assertTrue((String)"Person should be a disjoint union", (boolean)dAMLClass.isDisjointUnion());
        DAMLList dAMLList = (DAMLList)dAMLClass.prop_disjointUnionOf().get();
        Assert.assertNotNull((String)"Value of disjoint union should not be null", (Object)dAMLList);
        Assert.assertEquals((String)"Person should be a disjoint union of size 2", (int)2, (int)dAMLList.getCount());
        DAMLClass dAMLClass2 = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "Female");
        Assert.assertNotNull((String)"Class Female should not be null", (Object)dAMLClass2);
        DAMLClass dAMLClass3 = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "Male");
        Assert.assertNotNull((String)"Class Male should not be null", (Object)dAMLClass3);
        Assert.assertTrue((String)"Female should be disjoint with male", (boolean)dAMLClass2.prop_disjointWith().hasValue(dAMLClass3));
        DAMLClass dAMLClass4 = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "HumanBeing");
        Assert.assertNotNull((String)"Class humanBeing should not be null", (Object)dAMLClass4);
        Assert.assertTrue((String)"Person should be same class as HumanBeing", (boolean)dAMLClass4.prop_sameClassAs().hasValue(dAMLClass));
        DAMLClass dAMLClass5 = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "TallMan");
        Assert.assertNotNull((String)"Class TallMan should not be null", (Object)dAMLClass5);
        DAMLList dAMLList2 = (DAMLList)dAMLClass5.prop_intersectionOf().get();
        Assert.assertNotNull((String)"Value of intersection should not be null", (Object)dAMLList2);
        Assert.assertEquals((String)"Tall man should be an intersection of size 2", (int)2, (int)dAMLList2.getCount());
        DAMLClass dAMLClass6 = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "Car");
        Assert.assertNotNull((String)"Class Car should not be null", (Object)dAMLClass6);
        DAMLClass dAMLClass7 = (DAMLClass)dAMLClass6.getSuperClasses().next();
        Assert.assertNotNull((String)"Car should have a super-class", (Object)dAMLClass7);
        Assert.assertTrue((String)"Car super-class should be a complement", (boolean)dAMLClass7.isComplement());
        Assert.assertTrue((String)"Car super-class should be a complement of Person", (boolean)dAMLClass7.prop_complementOf().hasValue(dAMLClass));
        DAMLClass dAMLClass8 = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "Height");
        Assert.assertNotNull((String)"Class Height should not be null", (Object)dAMLClass8);
        Assert.assertTrue((String)"Height should be an enumeration", (boolean)dAMLClass8.isEnumeration());
        Assert.assertEquals((String)"Height should be an enumeration of 3 elements", (int)3, (int)((DAMLList)dAMLClass8.prop_oneOf().get()).getCount());
    }

    public void testEquivalence() throws RDFException {
        String string = "http://dickinson-i-4/daml/tests/test-cases.daml#";
        Log.debug("Starting equivalence tests");
        DAMLModelImpl dAMLModelImpl = new DAMLModelImpl();
        dAMLModelImpl.getLoader().setLoadImportedOntologies(false);
        dAMLModelImpl.read("file:modules/rdf/regression/testDAML/test-cases.daml", "http://dickinson-i-4/daml/tests/test-cases.daml", null);
        DAMLInstance dAMLInstance = (DAMLInstance)dAMLModelImpl.getDAMLValue(string + "x0");
        Assert.assertNotNull((String)"Instance x0 should not be null", (Object)dAMLInstance);
        Assert.assertEquals((String)"Number of elements in equivalence class should be 4", (int)4, (int)this.countIteration(dAMLInstance.getEquivalentValues(), true, "Member of equivalence class to x0: "));
        DAMLClass dAMLClass = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "C0");
        Assert.assertNotNull((String)"Class C0 should not be null", (Object)dAMLClass);
        Assert.assertEquals((String)"Number of elements in equivalence class should be 4", (int)4, (int)this.countIteration(dAMLClass.getSameClasses(), true, "sameClass as C0: "));
        DAMLProperty dAMLProperty = (DAMLProperty)dAMLModelImpl.getDAMLValue(string + "p0");
        Assert.assertNotNull((String)"Property p0 should not be null", (Object)dAMLProperty);
        Assert.assertEquals((String)"Number of elements in equivalence class should be 4", (int)4, (int)this.countIteration(dAMLProperty.getSameProperties(), true, "sameProperty as p0: "));
        Resource resource = dAMLModelImpl.getResource(string + "CDaml");
        Assert.assertNotNull((String)"Resource dClass should not be null", (Object)resource);
        Assert.assertTrue((String)"Resource dClass should be a daml class", (boolean)(resource instanceof DAMLClass));
        DAMLClass dAMLClass2 = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "D0");
        DAMLClass dAMLClass3 = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "D1");
        DAMLInstance dAMLInstance2 = (DAMLInstance)dAMLModelImpl.getDAMLValue(string + "d1");
        Assert.assertNotNull((String)"Class D0 should not be null", (Object)dAMLClass2);
        Assert.assertNotNull((String)"Class D1 should not be null", (Object)dAMLClass3);
        Assert.assertNotNull((String)"Instance d1 should not be null", (Object)dAMLInstance2);
        Assert.assertTrue((String)"Instance d1 should have class D1", (boolean)dAMLInstance2.hasRDFType(dAMLClass3));
        Assert.assertTrue((String)"Instance d1 should have class D0", (boolean)dAMLInstance2.hasRDFType(dAMLClass2));
        DAMLProperty dAMLProperty2 = (DAMLProperty)dAMLModelImpl.getDAMLValue(string + "pd0");
        DAMLProperty dAMLProperty3 = (DAMLProperty)dAMLModelImpl.getDAMLValue(string + "pd1");
        Assert.assertNotNull((String)"Property pd0 should not be null", (Object)dAMLProperty2);
        Assert.assertNotNull((String)"Property pd1 should not be null", (Object)dAMLProperty3);
        DAMLInstance dAMLInstance3 = (DAMLInstance)dAMLModelImpl.getDAMLValue(string + "d2");
        Assert.assertNotNull((String)"Instance d2 should not be null", (Object)dAMLInstance3);
        Assert.assertTrue((String)"d2 should have d1 as a value for pd0", (boolean)dAMLInstance3.accessProperty(dAMLProperty2).hasValue(dAMLInstance2));
        Assert.assertTrue((String)"d2 should have d1 as a value for pd1", (boolean)dAMLInstance3.accessProperty(dAMLProperty3).hasValue(dAMLInstance2));
        DAMLProperty dAMLProperty4 = (DAMLProperty)dAMLModelImpl.getDAMLValue(string + "pd2");
        DAMLProperty dAMLProperty5 = (DAMLProperty)dAMLModelImpl.getDAMLValue(string + "pd3");
        Assert.assertNotNull((String)"Property pd2 should not be null", (Object)dAMLProperty4);
        Assert.assertNotNull((String)"Property pd3 should not be null", (Object)dAMLProperty5);
        Assert.assertTrue((String)"d2 should have d1 as a value for pd3", (boolean)dAMLInstance3.accessProperty(dAMLProperty5).hasValue(dAMLInstance2));
        Assert.assertTrue((String)"d2 should have d1 as a value for pd2", (boolean)dAMLInstance3.accessProperty(dAMLProperty4).hasValue(dAMLInstance2));
    }

    public void testProperty() throws RDFException {
        Object object;
        Log.debug("Starting DAML property tests");
        DAMLModelImpl dAMLModelImpl = new DAMLModelImpl();
        dAMLModelImpl.read("file:modules/rdf/regression/testDAML/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        Assert.assertTrue((String)"loadStatus should be true for successful load", (boolean)dAMLModelImpl.getLoadSuccessful());
        String string = "http://www.daml.org/2001/03/daml+oil-ex#";
        DAMLProperty dAMLProperty = (DAMLProperty)dAMLModelImpl.getDAMLValue(string + "hasMother");
        Assert.assertNotNull((String)"hasMother property should not be null", (Object)dAMLProperty);
        Assert.assertTrue((String)"hasMother property should be a unique property", (boolean)dAMLProperty.isUnique());
        DAMLProperty dAMLProperty2 = (DAMLProperty)dAMLModelImpl.getDAMLValue(string + "hasParent");
        Assert.assertNotNull((String)"hasParent property should not be null", (Object)dAMLProperty2);
        DAMLClass dAMLClass = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "Female");
        Assert.assertNotNull((String)"Class Female should not be null", (Object)dAMLClass);
        DAMLClass dAMLClass2 = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "Animal");
        Assert.assertNotNull((String)"Class Animal should not be null", (Object)dAMLClass2);
        DAMLClass dAMLClass3 = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "Person");
        Assert.assertNotNull((String)"Class Person should not be null", (Object)dAMLClass3);
        Assert.assertTrue((String)"Mother should have Female as range", (boolean)dAMLProperty.prop_range().hasValue(dAMLClass));
        Assert.assertTrue((String)"Mother should not have Animal as local domain (prop_domain)", (!dAMLProperty.prop_domain().hasValue(dAMLClass2) ? 1 : 0) != 0);
        boolean bl = false;
        Iterator iterator = dAMLProperty.getDomainClasses();
        while (!bl && iterator.hasNext()) {
            object = iterator.next();
            bl = ((DAMLClass)object).equals(dAMLClass2);
        }
        Assert.assertTrue((String)"Mother should have Animal as domain (getDomainClasses)", (boolean)bl);
        object = (DAMLObjectProperty)dAMLModelImpl.getDAMLValue(string + "hasAncestor");
        Assert.assertNotNull((String)"hasAncestor should not be null", object);
        Assert.assertTrue((String)"hasAncestor should be transitive", (boolean)object.isTransitive());
    }

    public void testList() throws RDFException {
        Log.debug("Starting DAML list tests");
        DAMLModelImpl dAMLModelImpl = new DAMLModelImpl();
        dAMLModelImpl.read("file:modules/rdf/regression/testDAML/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        Assert.assertTrue((String)"loadStatus should be true for successful load", (boolean)dAMLModelImpl.getLoadSuccessful());
        String string = "http://www.daml.org/2001/03/daml+oil-ex#";
        DAMLClass dAMLClass = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "Person");
        Assert.assertNotNull((String)"Person class should not be null", (Object)dAMLClass);
        DAMLClass dAMLClass2 = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "Man");
        Assert.assertNotNull((String)"Man class should not be null", (Object)dAMLClass2);
        DAMLClass dAMLClass3 = (DAMLClass)dAMLModelImpl.getDAMLValue(string + "Woman");
        Assert.assertNotNull((String)"Woman class should not be null", (Object)dAMLClass3);
        DAMLList dAMLList = (DAMLList)dAMLClass.prop_disjointUnionOf().get();
        Assert.assertNotNull((String)"union should not be null", (Object)dAMLList);
        Assert.assertEquals((String)"union should have two values", (int)2, (int)dAMLList.getCount());
        DAMLCommon dAMLCommon = dAMLList.getFirst();
        Assert.assertEquals((String)"Man should be the first element in the list", (Object)dAMLClass2, (Object)dAMLCommon);
        DAMLList dAMLList2 = dAMLList.getRest();
        Assert.assertNotNull((String)"Tail of list should not be null", (Object)dAMLList2);
        DAMLCommon dAMLCommon2 = dAMLList2.getFirst();
        Assert.assertNotNull((String)"head of tail should not be null", (Object)dAMLCommon2);
        Assert.assertEquals((String)"Woman should be the first element in the tail of the list", (Object)dAMLClass3, (Object)dAMLCommon2);
        DAMLList dAMLList3 = dAMLList2.getRest();
        Assert.assertNotNull((String)"Tail of tail should not be null", (Object)dAMLList3);
        Assert.assertTrue((String)"Remainder of list should be empty", (boolean)dAMLList3.isEmpty());
    }

    public static void dumpModel(Model model) {
        DAMLTest.dumpModel(model, "model-out.rdf");
    }

    public static void dumpModel(Model model, String string) {
        Log.debug("Dumping model to " + string);
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(string));
            model.write(printWriter, "RDF/XML-ABBREV");
            printWriter.close();
        }
        catch (Exception exception) {
            Log.severe("Exception while dumping model: " + exception, exception);
        }
    }

    public void testDatatype() throws RDFException {
        Log.debug("Starting DAML datatype tests");
        DAMLModelImpl dAMLModelImpl = new DAMLModelImpl();
        dAMLModelImpl.read("file:modules/rdf/regression/testDAML/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        Assert.assertTrue((String)"loadStatus should be true for successful load", (boolean)dAMLModelImpl.getLoadSuccessful());
        String string = "http://www.daml.org/2001/03/daml+oil-ex#";
        DAMLInstance dAMLInstance = (DAMLInstance)dAMLModelImpl.getDAMLValue(string + "Ian");
        Assert.assertNotNull((String)"Instance Ian should not be null", (Object)dAMLInstance);
        DAMLProperty dAMLProperty = (DAMLProperty)dAMLModelImpl.getDAMLValue(string + "shirtsize");
        Assert.assertNotNull((String)"Property shirtsize should not be null", (Object)dAMLProperty);
        DAMLProperty dAMLProperty2 = (DAMLProperty)dAMLModelImpl.getDAMLValue(string + "shoesize");
        Assert.assertNotNull((String)"Property shoesize should not be null", (Object)dAMLProperty2);
        DAMLDataInstance dAMLDataInstance = (DAMLDataInstance)dAMLInstance.getProperty(dAMLProperty).getObject();
        Assert.assertNotNull((String)"Object ian should have a shirtsize", (Object)dAMLDataInstance);
        Object object = dAMLDataInstance.getValue();
        Assert.assertNotNull((String)"Value of shirtsize should not be null", (Object)object);
        Assert.assertEquals((String)"Shirt size should be a string", (Object)(class$java$lang$String == null ? (class$java$lang$String = DAMLTest.class$("java.lang.String")) : class$java$lang$String), object.getClass());
        Assert.assertEquals((String)"Shirt size should be \"12\"", (Object)"12", (Object)object);
    }

    private int countIteration(Iterator iterator, boolean bl, String string) {
        int n = 0;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (bl) {
                Log.finest("counting iteration, " + string + e);
            }
            ++n;
        }
        return n;
    }

    private int countIteration(ResIterator resIterator, boolean bl, String string) {
        int n = 0;
        try {
            while (resIterator.hasNext()) {
                Resource resource = resIterator.next();
                if (bl) {
                    Log.finest("counting iteration, " + string + resource);
                }
                ++n;
            }
        }
        catch (RDFException rDFException) {
            Log.severe("RDF exception: " + rDFException, rDFException);
        }
        return n;
    }

    private int countClasses(DAMLModel dAMLModel) {
        return this.countIteration(dAMLModel.listDAMLClasses(), false, null);
    }

    private int countProperties(DAMLModel dAMLModel) {
        return this.countIteration(dAMLModel.listDAMLProperties(), false, null);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

