/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.extension.svg;

import org.apache.batik.css.svg.OpacityFactory;
import org.apache.batik.css.svg.SimpleColorFactory;
import org.apache.batik.css.value.DefaultSystemColorResolver;
import org.apache.batik.css.value.SystemColorResolver;
import org.apache.batik.css.value.ValueFactory;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.svg.DomExtension;
import org.apache.batik.dom.svg.ExtensibleSVGDOMImplementation;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.extension.svg.BatikExtConstants;
import org.apache.batik.extension.svg.BatikHistogramNormalizationElement;
import org.apache.batik.extension.svg.BatikRegularPolygonElement;
import org.apache.batik.extension.svg.BatikStarElement;
import org.apache.batik.extension.svg.ColorSwitchElement;
import org.apache.batik.extension.svg.SolidColorElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BatikDomExtension
implements DomExtension,
BatikExtConstants {
    public float getPriority() {
        return 1.0f;
    }

    public String getAuthor() {
        return "Thomas DeWeese";
    }

    public String getContactAddress() {
        return "deweese@apache.org";
    }

    public String getURL() {
        return "http://xml.apache.org/batik";
    }

    public String getDescription() {
        return "Example extension to standard SVG shape tags";
    }

    public void registerTags(ExtensibleSVGDOMImplementation extensibleSVGDOMImplementation) {
        extensibleSVGDOMImplementation.registerCustomElementFactory("http://xml.apache.org/batik/ext", "regularPolygon", (SVGDOMImplementation.ElementFactory)new BatikRegularPolygonElementFactory());
        extensibleSVGDOMImplementation.registerCustomElementFactory("http://xml.apache.org/batik/ext", "star", (SVGDOMImplementation.ElementFactory)new BatikStarElementFactory());
        extensibleSVGDOMImplementation.registerCustomElementFactory("http://xml.apache.org/batik/ext", "histogramNormalization", (SVGDOMImplementation.ElementFactory)new BatikHistogramNormalizationElementFactory());
        extensibleSVGDOMImplementation.registerCustomElementFactory("http://xml.apache.org/batik/ext", "solidColor", (SVGDOMImplementation.ElementFactory)new SolidColorElementFactory());
        extensibleSVGDOMImplementation.registerCustomCSSValueFactory((ValueFactory)new SimpleColorFactory(null, "solid-color", (SystemColorResolver)new DefaultSystemColorResolver()));
        extensibleSVGDOMImplementation.registerCustomCSSValueFactory((ValueFactory)new OpacityFactory(null, "solid-opacity"));
        extensibleSVGDOMImplementation.registerCustomElementFactory("http://xml.apache.org/batik/ext", "colorSwitch", (SVGDOMImplementation.ElementFactory)new ColorSwitchElementFactory());
    }

    protected static class ColorSwitchElementFactory
    implements SVGDOMImplementation.ElementFactory {
        public Element create(String string, Document document) {
            return new ColorSwitchElement(string, (AbstractDocument)document);
        }
    }

    protected static class SolidColorElementFactory
    implements SVGDOMImplementation.ElementFactory {
        public Element create(String string, Document document) {
            return new SolidColorElement(string, (AbstractDocument)document);
        }
    }

    protected static class BatikHistogramNormalizationElementFactory
    implements SVGDOMImplementation.ElementFactory {
        public Element create(String string, Document document) {
            return new BatikHistogramNormalizationElement(string, (AbstractDocument)document);
        }
    }

    protected static class BatikStarElementFactory
    implements SVGDOMImplementation.ElementFactory {
        public Element create(String string, Document document) {
            return new BatikStarElement(string, (AbstractDocument)document);
        }
    }

    protected static class BatikRegularPolygonElementFactory
    implements SVGDOMImplementation.ElementFactory {
        public Element create(String string, Document document) {
            return new BatikRegularPolygonElement(string, (AbstractDocument)document);
        }
    }
}

