// MICPProp.java
// $Id: MICPProp.java,v 1.1 1998/01/20 16:42:21 ylafon Exp $
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.www.protocol.http.micp;

import w3c.tools.store.*;
import w3c.jigsaw.http.*;
import w3c.jigsaw.resources.*;
import w3c.jigsaw.config.*;

import w3c.www.protocol.http.HttpManager;

public class MICPProp extends PropertySet {
    private static String title = "mICP properties";

    static {
	Class     c = null;
	Attribute a = null;

	try {
	    c = Class.forName("w3c.www.protocol.http.micp.MICPProp");
	} catch (Exception ex) {
	    ex.printStackTrace();
	    System.exit(1);
	}
	// port on which we will listen
	a = new IntegerAttribute(MICPFilter.PORT_P
				 , new Integer(2005)
				 , Attribute.EDITABLE);
	AttributeRegistry.registerAttribute(c, a);
	// the multicast address
	a = new StringAttribute(MICPFilter.ADDRESS_P
				, "224.0.2.67"
				, Attribute.EDITABLE);
	AttributeRegistry.registerAttribute(c, a);
        // the timeout, in ms
	a = new IntegerAttribute(MICPFilter.TIMEOUT_P
				 , new Integer(300)
				 , Attribute.EDITABLE);
	AttributeRegistry.registerAttribute(c, a);
	// disable cache
	a = new BooleanAttribute(MICPFilter.DISABLE_CACHE_P
				 , new Boolean(false)
				 , Attribute.EDITABLE);
	AttributeRegistry.registerAttribute(c, a);
	// debug?
	a = new BooleanAttribute(MICPFilter.DEBUG_P
				 , new Boolean(false)
				 , Attribute.EDITABLE);
	AttributeRegistry.registerAttribute(c, a);
    }

    /**
     * Get this property set title.
     * @return A String encoded title.
     */

    public String getTitle() {
	return title;
    }
   
    public MICPProp(String name, httpd server) {
	super(name, server);
    }
}
