/*
 *  RatingValue.java
 *
 *  Copyright 1997 Massachusetts Institute of Technology.
 *  All Rights Reserved.
 *
 *  Author: Ora Lassila
 *
 *  $Id: RatingValue.java,v 1.1 1997/05/30 13:23:54 bmahe Exp $
 */

package w3c.www.pics;

import java.util.Vector;

public class RatingValue {

  private double values[];
  private boolean isSingle;

  public RatingValue(double value)
  {
    this.values = new double[1];
    this.values[0] = value;
    this.isSingle = true;
  }

  public RatingValue(double values[])
  {
    this.values = values;
    this.isSingle = false;
  }

  public RatingValue(Vector data)
  {
    this.values = new double[data.size()];
    for (int i = 0; i < data.size(); i++)
      this.values[i] = ((Number)data.elementAt(i)).doubleValue();
    this.isSingle = false;
  }

  public boolean isSingleNumber()
  {
    return isSingle;
  }

  public boolean allInRange(double lo, double hi)
  {
    for (int i = 0; i < values.length; i++) {
      double v = values[i];
      if (lo > v || v > hi)
    	return false;
    }
    return true;
  }

  public boolean anyInRange(double lo, double hi)
  {
    for (int i = 0; i < values.length; i++) {
      double v = values[i];
      if (lo <= v && v <= hi)
      return true;
    }
    return false;
  }

  public double[] getValues()
  {
    return values;
  }

  public double getValue() throws MultipleValueAccessException
  {
    if (isSingle || values.length == 1)
      return values[0];
    else
      throw new MultipleValueAccessException();
  }

}
