// RealResource.java
// $Id: RealResource.java,v 1.4 1997/07/30 14:10:22 ylafon Exp $  
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.tools.resources.tests;

// A resource that really has a nice set of properties

import java.io.*;
import w3c.tools.resources.impl.*;

public class RealResource extends ResourceImpl {

    protected File    file      = null;
    protected long    fileStamp = -1;
    protected boolean putable   = false;
    protected String  icon      = null;

    public File getFile() {
	return (File) holder.protectedGetValue("file");
    }

    public void setFile(File file) {
	holder.protectedSetValue("file", file);
    }

    public File igetFile() {
	return file;
    }

    public void isetFile(File file) {
	this.file = file;
    }

    public void setFileStamp(long l) {
	holder.protectedSetValue("fileStamp", new Long(l));
    }

    public long getFileStamp() {
	return ((Long) holder.protectedGetValue("fileStamp")).longValue();
    }

    public long igetFileStamp() {
	return fileStamp;
    }

    public void isetFileStamp(long fileStamp) {
	this.fileStamp = fileStamp;
    }

    public boolean getPutable() {
	return ((Boolean) holder.protectedGetValue("putable")).booleanValue();
    }

    public void setPutable(boolean b) {
	holder.protectedSetValue("putable", b ? Boolean.TRUE : Boolean.FALSE);
    }
    
    public boolean igetPutable() {
	return putable;
    }

    public void isetPutable(boolean putable) {
	this.putable = putable;
    }

    public String getIcon() {
	return (String) holder.protectedGetValue("icon");
    }

    public void setIcon(String icon) {
	holder.protectedSetValue("icon", icon);
    }

    public String igetIcon() {
	return icon;
    }

    public void isetIcon(String icon) {
	this.icon = icon;
    }

    static final long serialVersionUID = 4364846078001015606L;
}
