// RealPropResource.java
// $Id: RealPropResource.java,v 1.5 1997/07/30 14:10:17 ylafon Exp $  
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.tools.resources.tests;

// A resource that really has a nice set of properties

import java.io.*;
import w3c.tools.resources.impl.*;
import w3c.tools.resources.property.*;

public class RealPropResource extends ResourceImpl {

    protected int     number    = 0;
    protected long    fileStamp = -1;
    protected boolean putable   = false;
    protected String  icon      = null;

    public int getNumber() {
	return ((Integer) holder.protectedGetValue("number")).intValue();
    }

    public void setNumber(int number) {
	holder.protectedSetValue("number", new Integer(number));
    }

    public int igetNumber() {
	return number;
    }

    public void isetNumber(int number) {
	this.number = number;
    }

    public void setFileStamp(long l) {
	holder.protectedSetValue("fileStamp", new Long(l));
    }

    public long getFileStamp() {
	return ((Long) holder.protectedGetValue("fileStamp")).longValue();
    }

    public long igetFileStamp() {
	return fileStamp;
    }

    public void isetFileStamp(long fileStamp) {
	this.fileStamp = fileStamp;
    }

    public boolean getPutable() {
	return ((Boolean) holder.protectedGetValue("putable")).booleanValue();
    }

    public void setPutable(boolean b) {
	holder.protectedSetValue("putable", b ? Boolean.TRUE : Boolean.FALSE);
    }
    
    public boolean igetPutable() {
	return putable;
    }

    public void isetPutable(boolean putable) {
	this.putable = putable;
    }

    public String getIcon() {
	return (String) holder.protectedGetValue("icon");
    }

    public void setIcon(String icon) {
	holder.protectedSetValue("icon", icon);
    }

    public String igetIcon() {
	return icon;
    }

    public void isetIcon(String icon) {
	this.icon = icon;
    }

    static final long serialVersionUID = 4364846078001015606L;
}
