// TreeMain.java
// $Id: TreeMain.java,v 1.3 1997/07/30 14:09:34 ylafon Exp $  
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.tools.resources.rmi;

import java.awt.*;
import java.rmi.*;
import java.util.*;

import marimba.gui.*;
import marimba.persist.*;

class StringValueEditor extends TextBoxWidget {
    RemoteResource resource = null;
    String propname = null;

    public void action() {
	System.out.println("action: "+propname+"="+getText());
	try {
	    resource.setValue(propname, getText());
	} catch (Exception ex) {
	    ex.printStackTrace();
	}
    }

    public StringValueEditor(RemoteResource resource
			     , String propname
			     , String value) {
	this.resource = resource;
	this.propname = propname;
	setText(value);
	setBackground(Color.green);
    }

}
class ResourceEditor extends PlayerFrame {
    RemoteResource target = null;

    public static ResourceEditor edit(RemoteResource resource) {
	return new ResourceEditor(resource);
    }

    public void init() {
	Hashtable props = new Hashtable(11);
	RemotePropertyDescriptor ps[] = null;
	String names[] = null;
	Object values[] = null;
	try {
	    // Get prop descriptors:
	    ps = target.getProperties();
	    names = new String[ps.length];
	    for (int i = 0 ; i < ps.length ; i++) {
		props.put(ps[i].getName(), ps[i]);
		names[i] = ps[i].getName();
	    }
	    // Get all prop values:
	    values = target.getValues(names);
	} catch (Exception ex) {
	    ex.printStackTrace();
	} catch (Error er) {
	    er.printStackTrace();
	}
	try {
	// Do whatever to edit these stuff
	Presentation             p = new Presentation();
	ScrollingContainerWidget c = new ScrollingContainerWidget();
	int y = 20;
	int x = 10;
	int width  = 100;
	int height = 20;
	for (int i = 0 ; i < names.length ; i++) {
	    TextBoxWidget label = new TextBoxWidget(names[i]);
	    TextBoxWidget value = null;
	    label.setEditable(false);
	    label.setAlign(label.CENTER);
	    label.reshape(x, y, width, height);
	    // label.setAttach(y, label.DETACHED, label.DETACHED, 10);
	    if (ps[i].getPropertyType().equals(String.class)) {
		value = new StringValueEditor(target
					      , names[i]
					      , (String) values[i]);
	    } else {
		value = new TextBoxWidget();
		value.setText((values[i]==null) ? "" :values[i].toString());
	    }
	    value.setText(values[i] != null ? values[i].toString() : "null");
	    value.setStyle(value.BOXED);
	    value.reshape(x+width+10, y, width, height);
	    // value.setAttach(y, value.DETACHED, value.DETACHED, 200);
	    c.add(label);
	    c.add(value);
	    y += height;
	}
	p.reshape(0, 0, 400, 400);
	c.reshape(10, 10, 380, 380);
	p.add(c);
	// Display all that:
	player.setPresentation(p);
	show();
	} catch (Exception ex) {
	    ex.printStackTrace();
	} catch (Error er) {
	    er.printStackTrace();
	}
    }

    protected ResourceEditor(RemoteResource target) {
	this.target = target;
	init();
    }

}

class ResourceWidgetNode extends TreeNodeWidget {
    public static String UNCOLLAPSED_IMG
    = "file://localhost/u/koala/0/koala/leon/dev/java/classes/koala/images/diropened.gif";
    public static String COLLAPSED_IMG 
    = "file://localhost/u/koala/0/koala/leon/dev/java/classes/koala/images/dir.gif";
    public static String RESOURCE_IMG 
    = "file://localhost/u/koala/0/koala/leon/dev/java/classes/koala/images/file.gif";
    protected RemoteResource target = null;
    protected boolean        filled = false;
    protected boolean        container = false;

    public static Object getTargetValue(RemoteResource r, String name) {
	try {
	    // Get prop descriptors:
	    RemotePropertyDescriptor ps[] = r.getProperties();
	    for (int i = 0 ; i < ps.length ; i++) {
		if (ps[i].getName().equals(name))
		    return r.getValue(name);
	    }	    
	} catch (Exception ex) {
	    ex.printStackTrace();
	}
	return null;
    }

    public static ResourceWidgetNode makeNode(RemoteResource target) {
	String  name      = null;
	boolean container = false;	
	RemoteResource delegatees[] = null;

	try {
	    name       = (String) target.getValue("name");
	    container  = (target instanceof RemoteResourceContainer);
	    delegatees = target.getDelegatees();
	} catch (Exception ex) {
	    ex.printStackTrace();
	    name = "*ERRRED*";
	}
	ResourceWidgetNode wrn = new ResourceWidgetNode(name);
	wrn.target = target;
	if ( container ) {
	    wrn.container = true;
	    wrn.setImage(UNCOLLAPSED_IMG);
	    wrn.collapse(true);
	} else {
	    // Maybe we do handle an icon attribute ?
	    String src = (String) wrn.getTargetValue(target, "icon");
	    if ( src == null )
		src = RESOURCE_IMG;
	    wrn.setImage(src);
	}
	// One icon per delegatee:
	for (int nd = 0 ; nd < delegatees.length ; nd++) {
	    RemoteResource d = delegatees[nd];
	    String di = (String) ResourceWidgetNode.getTargetValue(d, "icon");
	    if ( di == null )
		continue;
	    Widget w = new ImageWidget();
	    w.setValue(di);
	    w.reshape(120+nd*30, 0, 30, 30);
	    wrn.add(w);
	}
	return wrn;
    }

    public ResourceWidgetNode(String name) {
	super(name);
    }

    public void collapse(boolean collapsed) {
	if ( collapsed ) 
	    setImage(COLLAPSED_IMG);
	else 
	    setImage(UNCOLLAPSED_IMG);
	super.collapse(collapsed);
    }
    
    protected void fill() {
	if ( filled || ! container )
	    return;
	// Fill in the node !
	try {
	    RemoteResourceContainer rrc = (RemoteResourceContainer) target;
	    String children[] = rrc.listChildNames();
	    for (int i = 0 ; i < children.length ; i++) 
		add(ResourceWidgetNode.makeNode(rrc.resolve(children[i])));
	} catch (Exception ex) {
	    ex.printStackTrace();
	}
	filled = true;
    }

    public void action() {
	// We know we're about to expand...(that's bad);
	if (collapsed && ! filled ) 
	    fill();
	super.action();
    }

    public boolean handleEvent(Event evt) {
	if ( evt.id == Event.KEY_PRESS && evt.key == 'e' ) {
	    try {
		System.out.println("edit "+target.getValue("name"));
		ResourceEditor.edit(target);
		return true;
	    } catch (Exception ex) {
	    }
	}
	return super.handleEvent(evt);
    }

}

class TreeView extends PlayerFrame {
    RemoteResourceSpace space = null;
    TreeWidget tree = null;

    public void init() {
	Presentation p = new Presentation();
	p.reshape(0, 0, 400, 400);
	
	this.tree = new TreeWidget();
	tree.setName("TreeView");
	tree.reshape(10, 10, 380, 380);
	p.add(tree);

	try {
	    RemoteResource root = space.resolve("/");
	    ResourceWidgetNode node = ResourceWidgetNode.makeNode(root);
	    tree.add(node);
	} catch (Exception ex) {
	    ex.printStackTrace();
	}


	// Display all that:
	player.setPresentation(p);
	show();
    }

    public TreeView(RemoteResourceSpace space) {
	this.space = space;
	init();
    }

}

public class TreeMain extends PlayerFrame {

    public static void main(String args[]) {
	String server = args[0];
	String name   = args[1];
	try {
	    RemoteResourceSpace space = ((RemoteResourceSpace)
					 Naming.lookup("//"+server+"/"+name));
	    TreeView tree = new TreeView(space);
	} catch (Exception ex) {
	    ex.printStackTrace();
	}
    }

}
