// RemoteResourceImpl.java
// $Id: RemoteResourceImpl.java,v 1.3 1997/07/30 14:09:19 ylafon Exp $  
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.tools.resources.rmi;

import java.util.*;
import java.beans.PropertyDescriptor;

import w3c.tools.resources.*;

public class RemoteResourceImpl
    extends java.rmi.server.UnicastRemoteObject 
    implements RemoteResource
{
    protected transient ResourceReference       rr    = null;
    protected transient RemoteResourceSpaceImpl space = null;
    
    public RemotePropertyDescriptor[] getProperties() 
	throws java.rmi.RemoteException
    {
	Enumeration enum = null;
	try {
	    Resource r = rr.lock();
	    enum = r.getProperties();
	} finally {
	    rr.unlock();
	}
	Vector v = new Vector();
	while ( enum.hasMoreElements() ) {
	    PropertyDescriptor prop = (PropertyDescriptor) enum.nextElement();
	    v.addElement(new RemotePropertyDescriptor(prop));
	}
	RemotePropertyDescriptor rp[] = new RemotePropertyDescriptor[v.size()];
	v.copyInto(rp);
	return rp;
    }

    public Object getValue(String name) 
	throws IllegalAccessException, IllegalArgumentException
    {
	try {
	    Resource r = rr.lock();
	    return r.getValue(name);
	} finally {
	    rr.unlock();
	}
    }

    public Object[] getValues(String names[]) 
	throws IllegalAccessException, IllegalArgumentException
    {
	try {
	    Resource r = rr.lock();
	    return r.getValues(names);
	} finally {
	    rr.unlock();
	}
    }

    public void setValue(String name, Object value) 
	throws IllegalAccessException, IllegalArgumentException
    {
	try {
	    Resource r = rr.lock();
	    r.setValue(name, value);
	} finally {
	    rr.unlock();
	}
    }

    public void setValues(String names[], Object values[]) 
	throws IllegalAccessException, IllegalArgumentException
    {
	try {
	    Resource r = rr.lock();
	    r.setValues(names, values);
	} finally {
	    rr.unlock();
	}
    }

    public void destroy() {
	try {
	    Resource r = rr.lock();
	    r.destroy();
	} finally {
	    rr.unlock();
	}
    }

    public RemoteResource resolve(String path) 
	throws java.rmi.RemoteException 
    {
	LookupState state = new LookupState(space.space, path);
	try {
	    Resource          r     = rr.lock();
	    ResourceReference child = r.resolve(state);
	    return (child != null) ? space.makeRemoteResource(child) : null;
	} finally {
	    rr.unlock();
	}
    }

    public RemoteResource[] getDelegatees() 
	throws java.rmi.RemoteException
    {
	try {
	    Resource          r         = rr.lock();
	    ResourceReference delegatee[] = r.getDelegatees();
	    RemoteResource    result[]  = new RemoteResource[delegatee.length];
	    for (int i = 0 ; i < delegatee.length ; i++)
		result[i] = space.makeRemoteResource(delegatee[i]);
System.out.println("returns: "+result);
	    return result;
	} catch (Exception ex) {
	    ex.printStackTrace();
	} finally {
	    rr.unlock();
	}
	return null;
    }
	
    protected RemoteResourceImpl(RemoteResourceSpaceImpl space
				 , ResourceReference rr) 
	throws java.rmi.RemoteException
    {
	this.space = space;
	this.rr    = rr;
    }

}
