// RemoteResourceContainerImpl.java
// $Id: RemoteResourceContainerImpl.java,v 1.3 1997/07/30 14:09:14 ylafon Exp $  
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.tools.resources.rmi;

import java.rmi.*;
import java.util.*;

import w3c.tools.resources.*;

public class RemoteResourceContainerImpl 
    extends RemoteResourceImpl
    implements RemoteResourceContainer
{

    public void registerChild(Resource resource, ResourceContext ctxt)
	throws RemoteException
             , ChildNotSupportedException
             , ResourceInitException 
    {
	try {
	    ResourceContainer r = (ResourceContainer) rr.lock();
	    r.registerChild(resource, ctxt);
	} finally {
	    rr.unlock();
	}
    }


    public void deleteChild(Resource child)
	throws RemoteException
    {
	try {
	    ResourceContainer r = (ResourceContainer) rr.lock();
	    r.deleteChild(child);
	} finally {
	    rr.unlock();
	}
    }

    public void deleteChild(String name)
	throws RemoteException
    {
	try {
	    ResourceContainer r = (ResourceContainer) rr.lock();
	    r.deleteChild(name);
	} finally {
	    rr.unlock();
	}
    }

    public String[] listChildNames()
	throws RemoteException
    {
	try {
	    ResourceContainer r = (ResourceContainer) rr.lock();
	    Vector            v = new Vector();
	    Enumeration       e = r.listChildNames();
	    while ( e.hasMoreElements() ) 
		v.addElement(e.nextElement());
	    String names[] = new String[v.size()];
	    v.copyInto(names);
	    return names;
	} finally {
	    rr.unlock();
	}
    }

    public RemoteResource[] listChildren()
	throws RemoteException
    {
	try {
	    ResourceContainer r = (ResourceContainer) rr.lock();
	    Vector            v = new Vector();
	    Enumeration       e = r.listChildren();
	    while ( e.hasMoreElements() ) {
		ResourceReference c = (ResourceReference) e.nextElement();
		v.addElement(space.makeRemoteResource(c));
	    }
	    RemoteResource children[] = new RemoteResourceImpl[v.size()];
	    v.copyInto(children);
	    return children;
	} catch (Exception ex) {
	    ex.printStackTrace();
	    return null;
	} finally {
	    rr.unlock();
	}
    }

    protected RemoteResourceContainerImpl(RemoteResourceSpaceImpl space
					  , ResourceReference ref) 
	throws RemoteException
    {
	super(space, ref);
    }

}
