// ResourceIndexer.java
// $Id: ResourceIndexer.java,v 1.1 1997/06/10 11:48:18 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.tools.resources.indexer ;

import java.util.* ;
import java.io.* ;

//import w3c.tools.store.*;
import w3c.tools.resources.*;
import w3c.tools.resources.http.*;
//import w3c.jigsaw.resources.* ;
import w3c.jigsaw.http.*;
import w3c.www.mime.* ;

/**
 * Jigsaw indexer.
 * The indexer is an object that given some global configuration informations, 
 * tries to build default resources for files that the server doesn't know
 * about.
 * A ResourceIndexer <strong>must</strong> be a resource it is to be added
 * permanently to the IndexersCatalog.
 * @see IndexerCatalogs
 */

public interface  ResourceIndexer {

  /**
   * When was this indexer configuration last modified.
   * @return The date at which that indexer was last modified, as 
   * a number of milliseconds since Java epoch.
   */

  abstract public long lastModified();

  /**
   * Try to create a resource for the given context.
   * This method makes its best efforts to try to build a default
   * resource out of a file. 
   */
  abstract public HTTPResource index(HTTPResourceContext context)
    throws ResourceInitException;
 
}
