// ResourceContextImpl.java
// $Id: ResourceContextImpl.java,v 1.5 1997/07/30 14:07:33 ylafon Exp $  
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.tools.resources.impl;

import w3c.tools.resources.*;

/**
 * A simple resource context implementation.
 */

public class ResourceContextImpl implements ResourceContext,
                                            java.lang.Cloneable
{
  protected ResourceSpace     space     = null;
  protected ResourceReference container = null;
  protected ResourceReference self      = null;
  protected String            names[]   = null;
  protected Object            values[]  = null;
  protected ResourceReference aggregate = null;
  protected ResourceContext parent = null;

  public ResourceContext getClone() {
    try {
      ResourceContextImpl clone = (ResourceContextImpl)clone();
      clone.parent = this;
      System.arraycopy(names,0,clone.names,0,names.length);
      System.arraycopy(values,0,clone.values,0,values.length);
      return clone;
    } catch (CloneNotSupportedException ex) {
      System.out.println(ex.getMessage());
      ex.printStackTrace();
      return null;
    }
  }

  public ResourceSpace getResourceSpace() {
    return space;
  }

  public ResourceReference getResourceReference() {
    return self;
  }

  public void setResourceReference(ResourceReference self) {
    this.self = self;
  }

  public ResourceReference getContainer() {
    return container;
  }

  public void setContainer(ResourceReference container) {
    this.container = container;
  }

  public String[] getPropertyNames() {
    return names;
  }

  public Object[] getPropertyValues() {
    return values;
  }

  public synchronized void addProperty(String name, Object value) {
    // Extremely ineffeicent
    int i = 0;
    while (i < names.length) {
      if (names[i].equals(name)) {
	values[i] = value;
	return;
      }
      i++;
    }
    String nn[] = new String[names.length+1];
    Object nv[] = new Object[values.length+1];
    System.arraycopy(names, 0, nn, 0, names.length);
    System.arraycopy(values, 0, nv, 0, values.length);
    nn[names.length] = name;
    nv[values.length] = value;
    names  = nn;
    values = nv;
  }

  public Object getProperty(String name) {
    int i = 0;
    while (i < names.length) {
      if (names[i].equals(name)) return values[i];
      i++;
    }
    return null;
  }

  public ResourceReference getAggregate() {
    return aggregate;
  }

  public void setAggregate(ResourceReference aggregate) {
    this.aggregate = aggregate;
  }

  public ResourceContextImpl(ResourceSpace space
			     , ResourceReference container) {
    this.space     = space;
    this.container = container;
    this.names     = new String[0];
    this.values    = new Object[0];
    this.aggregate = null;
  }
}
