// HTTPResourceContextImpl.java
// $Id: HTTPResourceContextImpl.java,v 1.3 1997/07/30 14:06:52 ylafon Exp $  
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.tools.resources.http;

import java.util.*;
import java.io.*;

import w3c.jigsaw.http.*;
import w3c.tools.resources.*;
import w3c.tools.resources.impl.*;
import w3c.tools.resources.indexer.*;

/**
 * The context that gets passed to create/init a HttpResource.
 */

public class HTTPResourceContextImpl extends ResourceContextImpl 
                                     implements HTTPResourceContext
{

  /**
   * Our parent context, if any.
   */
  protected ResourceIndexer indexer = null;

  protected String path = null;
  protected File file   = null;

  /**
   * The set of registered modules.
   */
  public Hashtable modules = null;
  /**
   * The server context of that resource context.
   */
  protected httpd server = null;

  public ResourceContext getClone() {
    try {
      HTTPResourceContextImpl clone = (HTTPResourceContextImpl)clone();
      clone.parent = this;
      if (file != null) clone.file = new File(file.getAbsolutePath());
      if (path != null) clone.path = new String(path);
      clone.names = new String[names.length];
      clone.values = new Object[values.length];
      System.arraycopy(names,0,clone.names,0,names.length);
      System.arraycopy(values,0,clone.values,0,values.length);
      return clone;
    } catch (CloneNotSupportedException ex) {
      System.out.println(ex.getMessage());
      ex.printStackTrace();
      return null;
    }
  }

  public String getPath(){
    return path;
  }

  public void setPath(String path){
    if (parent == null) 
      this.path = path;
    else
      this.path = ((HTTPResourceContext)parent).getPath().concat("/"+path);
  }

  public File getFile() {
    return file;
  }

  public void setFile(File file) {
    this.file = file;
    addProperty("file",file);
  }

  /**
   * Get the server this context is attached to.
   * @return An httpd instance (guaranteed not to be <strong>null</strong>.
   */

  public httpd getServer() {
    return server;
  }

  /**
   * Get that context's ancestor.
   * @return A ResourceContext instance, or <strong>null</strong>.
   */

  public ResourceContext getParent() {
    return parent;
  }

  /**
   * Register a module within that resource context.
   * @param name The module's name.
   * @param impl The module's implementation.
   */

  public synchronized void registerModule(String name, Object impl) {
    if ( modules == null )
      modules = new Hashtable(7);
    modules.put(name, impl);
  }

  /**
   * Lookup a module within that resource context.
   * @param name Name of the module to look for.
   * @param inherited Also look within the contexts hierarchy for an 
   * inherited module having that name.
   */

  public Object getModule(String name, boolean inherited) {
    Object impl = ((modules == null) ? null : modules.get(name));
    if (inherited && (parent != null) && (impl == null))
      impl = ((HTTPResourceContext)parent).getModule(name, true);
    return impl;
  }

  /**
   * Lookup a module within that context, and up the hierarchy of contexts.
   * @param name The module's name.
   * @return An object <em>implementing</em> that module.
   */

  public Object getModule(String name) {
    return getModule(name, true);
  }

  public ResourceIndexer getIndexer(String name) {
    return indexer;
  }

  public ResourceIndexer getIndexer() {
    return indexer;
  }
  

  public HTTPResourceContextImpl(HTTPResourceContext parent) {
    super(parent.getResourceSpace(),parent.getContainer());
    HTTPResourceContextImpl dad = (HTTPResourceContextImpl)parent;
    this.parent = dad;
    this.server = (dad != null) ? dad.getServer() : null;
    // FIXME
    this.indexer = new SampleResourceIndexer();
  }

  public HTTPResourceContextImpl(httpd server) {
    super(null,null);
    this.server = server;
    this.parent = null;
    // FIXME
    this.indexer = new SampleResourceIndexer();
  }

  // TESTING ONLY !!!
  public HTTPResourceContextImpl(ResourceSpace space
 				 , ResourceReference container) 
  {
    super(space,container);
    this.indexer = new SampleResourceIndexer();
    this.parent = null;
  }

}
