// HTTPResourceContext.java
// $Id: HTTPResourceContext.java,v 1.2 1997/07/30 14:06:47 ylafon Exp $  
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.tools.resources.http;

import java.io.*;

import w3c.tools.resources.ResourceContext;
import w3c.tools.resources.indexer.*;
import w3c.jigsaw.http.*;

/**
 * The context that gets passed to create/init a resource.
 */

public interface HTTPResourceContext extends ResourceContext {

  public ResourceContext getClone();

  public String getPath();

  public void setPath(String path);

  public File getFile();

  public void setFile(File file);

  public httpd getServer();

  public ResourceContext getParent();

  public void registerModule(String name, Object impl);

  public Object getModule(String name, boolean inherited);

  public Object getModule(String name);

  public ResourceIndexer getIndexer(String name);

  public ResourceIndexer getIndexer();

}
