// StructureChangedListener.java
// $Id: StructureChangedListener.java,v 1.3 1997/07/30 14:06:38 ylafon Exp $  
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.tools.resources.event;

import w3c.tools.resources.*;

public interface StructureChangedListener extends java.util.EventListener {
    
    /**
     * The space is about to unload some resource.
     * This handles the <code>RESOURCE_UNLOADED</code> kind of events.
     * @param evt The StructureChangeEvent.
     */

    public void resourceUnloaded(StructureChangedEvent evt);

    /**
     * The space has just loaded that resource.
     * This handles the <code>RESOURCE_INITED</code> kind of events.
     * @param evt The event describing the change.
     */

    public void resourceInited(StructureChangedEvent evt);

    /**
     * A new resource has been created in some space.
     * This handles the <code>RESOURCE_CREATED</code> kind of events.
     * @param evt The event describing the change.
     */

    public void resourceCreated(StructureChangedEvent evt);

    /**
     * A resource is about to be deleted.
     * This handles the <code>RESOURCE_DELETED</code> kind of events.
     * @param evt The event describing the change.
     */

    public void resourceDeleted(StructureChangedEvent evt);
     
}
