// Convert.java
// $Id: Convert.java,v 1.2 1997/07/30 14:05:06 ylafon Exp $  
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.tools.resources.converter;

/**
 * A converter provide two functionalities:
 * <ul>
 * <li> toString : Object to String convertion.
 * <li> toObject : String to Object Conversion.
 * </ul>
 */

public interface Convert {

  public void setInitialClass(Class c);

  public Object defaultValue();

  /**
   * Object to String convertion.
   * @param The Object to convert
   * @return The Object converted into String 
   */
  public String toString(Object O)
    throws NoSuchConverterException;

  /**
   * String to Object Conversion.
   * @param The String to convert
   * @return The String converted into Object 
   */
  public Object toObject(String S)
    throws NoSuchConverterException;
  
  /**
   * The class I'm able to convert.
   * @return The class I'm able to convert.
   */
  public Class classConverted();

}
