// TestAscii.java
// $Id: TestAscii.java,v 1.2 1997/07/30 14:04:18 ylafon Exp $  
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.tools.resources;

import java.io.*;
import java.util.*;
import java.net.URL;

import w3c.www.mime.*;
import w3c.tools.resources.event.*;
import w3c.tools.resources.impl.*;
import w3c.tools.resources.simple.*;
import w3c.tools.resources.ascii.*;
import w3c.tools.resources.property.*;
import w3c.tools.resources.http.*;
import w3c.tools.resources.tests.*;
import w3c.tools.resources.impl.ResourceContextImpl;

public class TestAscii {

  public static void main (String args[]) {
    Resource r   = null;
    File rootdir = new File("/u/www43/0/w3c/bmahe/Work/WWW/Jigsaw/src/classes/w3c/tools/resources/space");
    // make the space
    ResourceSpaceImpl space = new ResourceSpaceImpl();
    Properties P = new Properties();
    HTTPResourceContextImpl ctxt = new HTTPResourceContextImpl(space,null);
    ctxt.addProperty("directory", new File("/u/www43/0/w3c/bmahe/Work/WWW/Jigsaw/src/classes/w3c/tools/resources/space"));
    try {
      P.load(new FileInputStream("/u/www43/0/w3c/bmahe/Work/WWW/Jigsaw/src/classes/w3c/tools/resources/ascii.sp"));
      space.init(P,ctxt);
    } catch (Exception ex) {
      System.out.println(ex.getMessage());
      ex.printStackTrace();
    }
    ResourceReference targetref = space.resolve(new LookupState(space, "/"));
    if (targetref == null) {
      System.out.println("* not found '/'");
      System.exit(-1);
    }
    else {      
      try {
	r = targetref.lock();
 	System.out.println("* listChildren :");
 	Enumeration e = ((ResourceContainer)r).listChildren();
 	ResourceReference rr = null;
 	Resource r2 = null;
 	while (e.hasMoreElements()) {
 	  rr = (ResourceReference)e.nextElement();
 	  try {
 	    r2 = rr.lock();
 	    System.out.println("* child   : "+r2.getName());
	    System.out.println("* integer : "+r2.getValue("integer"));
	    System.out.println("* boolean : "+r2.getValue("boolean"));
	    System.out.println("* content : "+r2.getValue("content"));
 	  } finally {
 	    rr.unlock();
 	  }
	}
	System.out.println("registering");
	ResourceContainerImpl cont = (ResourceContainerImpl)r;
	ResourceContextImpl context = new ResourceContextImpl(space,targetref);
	context.addProperty("name","new1");
	//	context.addProperty("integer", new Integer(9999));
	Resource res = new HTTPResource();
        cont.registerChild( res, context);
	res.setValue("integer", new Integer(9999));
	System.out.println("done.");
 
	targetref.unlock();
	System.out.println("resolving foobar........");
	targetref = space.resolve(new LookupState(space, "/foobar"));
	if (targetref == null)
	  System.out.println("************* not found foobar");
	else {
	  r = targetref.lock();
	  System.out.println("* resolved foobar");
	  System.out.println("* name    : "+r.getName());
	  System.out.println("* integer : "+r.getValue("integer"));
	  System.out.println("* boolean : "+r.getValue("boolean"));
	  System.out.println("* content : "+r.getValue("content"));
	  System.out.println("* quality : "+r.getValue("quality"));
	  r.setValue("quality", new Integer(12));
	  System.out.println("* quality : "+r.getValue("quality"));
	  r.setValue("integer", new Integer(123));
	  System.out.println("* integer : "+r.getValue("integer"));
	  //	r.destroy();
	  // end of test
	}
      } catch (Exception ex) {
	System.out.println(ex.getMessage());
	ex.printStackTrace();
      } finally {
	if (targetref != null) targetref.unlock();
      }
      space.checkpoint();
    }
  }
}





