// Runner.java
// $Id: Runner.java,v 1.2 1997/07/30 14:04:09 ylafon Exp $  
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.tools.resources;

/**
 * Interface used by the property holder to access its delegator.
 * We don't want delegator property access methods to be public, instead
 * we rely on the delegator providing us a capacity (through the use of inner 
 * classes implementing that interface).
 * @see PropertyHolder
 */

public interface Runner {
    
    /**
     * Run the given method with given args from the delegator.
     * @param m The method to invoke.
     * @param args Arguments to the method.
     * @return The same as the <code>invoke</code> method.
     */

    public Object run(java.lang.reflect.Method m, Object args[])
	throws IllegalAccessException
               , java.lang.reflect.InvocationTargetException;
}
