// DirectoryResource.java
// $Id: ElseCommand.java,v 1.5 1997/07/08 07:01:25 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.ssi;

import java.util.*;

import w3c.www.http.*;
import w3c.jigsaw.http.*;
import w3c.jigsaw.resources.*;
import w3c.util.*;

/**
 * Implementation of the SSI <code>else</code> command.  
 * @author Benoit Mahe <bmahe@sophia.inria.fr>
 */

public class ElseCommand implements ControlCommand {
  private final static String  NAME  = "else";
  private final static boolean debug = true;
    
  private static final String keys[] = { "name" };

  protected static Hashtable elsestore = null;

  static {
    elsestore = new Hashtable(23);
  }

  protected static int getPosition(String name) 
    throws ControlCommandException    
  {
    Integer pos = (Integer)elsestore.get(name);
    if (pos == null)
      throw new ControlCommandException(NAME,"Position unknown.");
    else return pos.intValue();
  }

  public void setPosition(SSIResource resource,
			  CommandRegistry registry,
			  ArrayDictionary parameters,
			  Dictionary variables,
			  int position) 
  {
    Object values[] = parameters.getMany(keys);
    String name     = (String) values[0];
    if (name != null)
      elsestore.put(resource.getURLPath()+":"+name, new Integer(position));
  }
  
  public String getValue(Dictionary variables, String var) {
    return null;
  }

  public Reply execute(SSIResource resource
		       , Request request
		       , ArrayDictionary parameters
		       , Dictionary variables) 
  {
    return resource.createCommandReply(request, HTTP.OK);
  }

  public int jumpTo(SSIResource resource,
		    CommandRegistry registry,
		    ArrayDictionary parameters,
		    Dictionary variables)
    throws ControlCommandException
  {
    Object values[] = parameters.getMany(keys);
    String name     = (String) values[0];
    if (name != null)
      return (EndifCommand.getPosition(resource.getURLPath()+":"+name)+1);
    throw new ControlCommandException(NAME,"name not initialized.");
  }
  
  public String getName() {
    return NAME;
  }

}

