// Command.java
// $Id: ControlCommand.java,v 1.6 1997/07/28 12:49:45 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.ssi ;

import java.util.* ;

import w3c.util.* ;
import w3c.jigsaw.resources.* ;
import w3c.jigsaw.http.* ;

/**
 * This interface is used to supply implementations of SSI
 * commands. They have to be registered in a CommandRegistry, which in
 * turn is used by the SSIResource. A control command is a command 
 * like loop or if witch can modify the way to execute commands.
 * A control command have to register is position and to know the
 * next position. A position is an integer, witch can be an array
 * index.
 * @see w3c.jigsaw.ssi.CommandRegistry
 * @author Benoit Mahe <bmahe@sophia.inria.fr>
 */

public interface ControlCommand extends Command {

  /**
   * register the command position in the structure
   * witch store the SSIResource.
   */
  public void setPosition(SSIResource resource,
			  CommandRegistry registry,
			  ArrayDictionary parameters,
			  Dictionary variables,
			  int position);

  /**
   * Give the next position in the structure witch
   * store the SSIResource.
   */
  public int jumpTo(SSIResource resource,
		    CommandRegistry registry,
		    ArrayDictionary parameters,
		    Dictionary variables)
    throws ControlCommandException;

}

