// JigsawHttpServletReponse.java
// $Id: JigsawHttpServletResponse.java,v 1.9 1997/09/11 07:37:25 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.servlet;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.net.*;

import w3c.www.mime.*;
import w3c.www.http.*;
import w3c.jigsaw.http.*;

/**
 *  @author Alexandre Rafalovitch <alex@access.com.au>
 *  @author Anselm Baird-Smith <abaird@w3.org>
 */

public class JigsawHttpServletResponse implements HttpServletResponse 
{
    private final static int STATE_INITIAL = 0;
    private final static int STATE_HEADERS_DONE = 1;
    private final static int STATE_ALL_DONE = 2;
 
    public static final 
    String REMOVE_HEADER = "w3c.jigsaw.servlet.removeHeader";
   
    int   state = STATE_INITIAL;
    Reply reply = null;
    Request request = null;

    JigsawHttpServletResponse(Request request, Reply reply)
    {
	this.request = request;
	this.reply   = reply;
    }
    
    public void setContentLength(int i) {
	reply.setContentLength(i);
    }
    
    public void setContentType(String spec) {
	try {
	    MimeType type= new MimeType(spec);
	    reply.setContentType(type);
	} catch(MimeTypeFormatException ex) {
	    // FIXME what should I do?
	}
    }

    protected JigsawServletOutputStream output = null;

    public synchronized ServletOutputStream getOutputStream()
	throws IOException
    {
      if ( output != null )
	return output;
      
      if ( request.hasState(REMOVE_HEADER) )
	output = (new JigsawServletOutputStream
		  (this
		   , new DataOutputStream(reply.getOutputStream(false))));
      else
	output = (new JigsawServletOutputStream
		  (this
		   , new DataOutputStream(reply.getOutputStream())));
      return output;
    }
    
    public void setStatus(int i, String reason) {
	reply.setStatus(i);
	reply.setReason(reason);
    }
    
    public void setStatus(int i) {
	setStatus(i, reply.getStandardReason(i));
    }
    
    public void setHeader(String name, String value) {
	reply.setValue(name, value);
    }
    
    public void setIntHeader(String name, int value) {
	setHeader(name, String.valueOf(value));
    }
    
    public void setDateHeader(String name, long date) {
	setHeader(name, String.valueOf(date));
    }
    
    public void unsetHeader(String name) {
	setHeader(name, null);
    }
    
    public void sendError(int i, String msg) 
	throws IOException
    {
	setStatus(i);
	reply.setContent(msg);
	state = STATE_ALL_DONE;
    }
    
    public void sendError(int i)
        throws IOException
    {
	setStatus(i);
	reply.setContent(reply.getStandardReason(i));
	state = STATE_ALL_DONE;
    }
    
    public void sendRedirect(String url)
        throws IOException
    {
	URL loc = null;
	try {
	    loc = new URL(request.getURL(), url);
	    setStatus(SC_MOVED_TEMPORARILY);
	    reply.setLocation(loc);
	    state = STATE_ALL_DONE;
	} catch (Exception ex) {
	    ex.printStackTrace();
	}
    }

  // method added

  public boolean containsHeader(String header) {
    //    return request.hasHeader(header);
    return reply.hasHeader(header);
  }

}
