// HTTPResource.java
// $Id: RedirecterResource.java,v 1.2 1998/01/14 10:47:52 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.resources ;

import java.net.*;

import w3c.tools.store.*;
import w3c.www.http.*;
import w3c.jigsaw.http.*;


public class RedirecterResource extends FilteredResource {

  /**
   * Attributes index - The index for the target attribute.
   */
  protected static int ATTR_TARGET = -1 ;

  static {
    Attribute a   = null ;
    Class     cls = null ;
    // Get a pointer to our class:
    try {
      cls = Class.forName("w3c.jigsaw.resources.RedirecterResource") ;
    } catch (Exception ex) {
      ex.printStackTrace() ;
      System.exit(1) ;
    }
    a = new StringAttribute("target"
			    , null
			    , Attribute.EDITABLE);
    ATTR_TARGET = AttributeRegistry.registerAttribute(cls, a) ;
  }

  protected String getTarget() {
    return (String) getValue(ATTR_TARGET, null);
  }

  public Reply perform(Request request)
    throws HTTPException, ClientException
  {
    Reply        reply  = null;
    httpd        server = getServer();
    request.setReferer(getURLPath());
    try {
      request.setURL( new URL(server.getURL(), getTarget()));
    } catch (MalformedURLException ex) {
      Reply error = request.makeReply(HTTP.INTERNAL_SERVER_ERROR);
      error.setContent("<html><head><title>Server Error</title>"+
		       "</head><body><h1>Server misconfigured</h1>"+
		       "<p>The resource <b>"+getIdentifier()+"</b>"+
		       "has an invalid target attribute : <p><b>"+
		       getTarget()+"</b></body></html>");      
      throw new HTTPException (error);
    }
    return server.perform(request);
  }


}
