// LabelBureauFactory.java
// $Id: LabelBureauFactory.java,v 1.2 1997/05/21 12:55:09 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.pics ;

import java.io.File ;

import java.util.Hashtable ;
import java.util.StringTokenizer ;
/**
 * This class manages label bureau creation.
 * It follows the general pattern for creating interface objects.
 */

public class LabelBureauFactory {
    private static Hashtable bureaus = new Hashtable () ;

    public static LabelBureauInterface getLabelBureau (File identifier) {
      String name = identifier.getName();
      StringTokenizer st = new StringTokenizer(name,".");
      String tok = null;
      while (st.hasMoreTokens()) tok = st.nextToken();
      if (tok.equals("db")){
	DataBaseBureau b = (DataBaseBureau) bureaus.get (identifier) ;
	if ( b == null ) {
	    b =  new DataBaseBureau (identifier) ;
	    bureaus.put (identifier, b) ;
	}
	return b;
      }
      else{
	SampleLabelBureau b = (SampleLabelBureau) bureaus.get (identifier) ;
	if ( b == null ) {
	    b =  new SampleLabelBureau (identifier) ;
	    bureaus.put (identifier, b) ;
	}
	return b ;
      }
    }

}
