// DataBase.java
// $Id: DataBase.java,v 1.4 1997/07/28 12:49:05 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.pics ;


import java.util.*;
import java.io.* ;
import java.sql.*;

/**
 * A very simple interface to query a database via JDBC.
 * @author Benoit Mahe <bmahe@sophia.inria.fr>
 */

public class DataBase {

  /**
   * The property key relative to the name of the database.
   */
  public final static String 
  DB_NAME_P = "w3c.jigsaw.pics.DataBase.dbname";

  /**
   * The property key relative to the jdbc url of the database.
   */
  public final static String 
  DB_URL_P = "w3c.jigsaw.pics.DataBase.dburl";

  /**
   * The property key relative to the jdbc driver used to access the
   * database.
   */
  public final static String 
  JDBC_DRIVER_P = "w3c.jigsaw.pics.DataBase.jdbcdriver";

  /**
   * The property key relative to the user name.
   */
  public final static String 
  USER_NAME_P = "w3c.jigsaw.pics.DataBase.username";

  /**
   * The property key relative to the password of the user in the database.
   */
  public final static String 
  PASSWD_P = "w3c.jigsaw.pics.DataBase.passwd";

  private String realname = null;
  private String dburl = null;
  private String driver = null;
  private String user = null;
  private String passwd = null;

  private ResultSet rs = null;
  private Statement stmt = null;
  private Connection con = null;

  private boolean connected = false;
  
  /**
   * Get the database real name.
   */

  public String getRealName(){
    return realname;
  }

  /**
   * Start the connection with the database.
   * @return True if the connection succed.
   */

  public boolean connect(){
    try {
      Class.forName(driver);
      con = DriverManager.getConnection(dburl, user, "");
      stmt = con.createStatement();
      return (connected = true);
    } catch (Exception ex) {
      System.out.println(ex.getMessage());
      ex.printStackTrace();
      return false;
    }
  }

  /**
   * Stop the connection with the database.
   * @return True if the connection stopped.
   */ 

  public boolean closeConnection(){
    try{
      stmt.close();
      con.close();
      return true;
    } catch (Exception ex) {
      System.out.println(ex.getMessage());
      ex.printStackTrace();
      return false;
    }
  }

  /**
   * Execute an SQL request on the database that returns a result.
   * @param req The SQL request to execute.
   * @return True if there's a result.
   */

  public boolean request (String req){
    try {
      if (!connected) connect();
      rs = stmt.executeQuery(req);
      if (rs.next()) return true;
    } catch (Exception ex) {
      System.out.println(ex.getMessage());
      ex.printStackTrace();
    }
    return false;
  }

  /**
   * Execute a SQL INSERT, UPDATE or DELETE request on the database.
   * @param req The SQL request to execute.
   * @return True if the request was executed correctly.
   */

  public boolean insert (String req){
    try {
      if (!connected) connect();
      stmt.executeUpdate(req);
      return true;
    } catch (SQLException ex) {
      System.out.println(ex.getMessage());
    }
    return false;
  }

  /**
   * After a request execution, the current row is the first
   * row of the result, this method makes the next row the current row.
   * @return true if the new current row is valid; false if there are 
   * no more rows.
   */

  public boolean next(){
    try {
      return (rs.next());
    } catch (Exception ex) {
      System.out.println(ex.getMessage());
      ex.printStackTrace();
      return false;
    }
  }

  /**
   * Get the String value of a field.
   * @param col The field's name.
   * @return A String instance, being the field value.
   */

  public String getString(String col){
    try {
      return rs.getString(col);
    } catch (Exception ex) {
      System.out.println(ex.getMessage());
      ex.printStackTrace();
      return null;
    }
  }

  /**
   * Get the integer value of a field.
   * @param col The field's name.
   * @return An integer, being the field value.
   */

  public int getInt(String col){
    try {
      return rs.getInt(col);
    } catch (Exception ex) {
      System.out.println(ex.getMessage());
      ex.printStackTrace();
      return 0;
    }
  }

  /**
   * Get the Object value of a field.
   * @param col The field's name.
   * @return A Object instance, being the field value.
   */

  public Object getObject(String col){
    try {
      return rs.getObject(col);
    } catch (Exception ex) {
      System.out.println(ex.getMessage());
      ex.printStackTrace();
      return null;
    }
  }

  /**
   * @param P the properties must be:<p>
   * <ul><li>w3c.jigsaw.pics.DataBase.dbname : the database name
   * <li>w3c.jigsaw.pics.DataBase.dburl : the jdbc database url
   * <li>w3c.jigsaw.pics.DataBase.jdbcdriver : the jdbc driver
   * <li>w3c.jigsaw.pics.DataBase.username : the user name
   * <li>w3c.jigsaw.pics.DataBase.passwd : the password relative to the 
   * user name.</ul>
   */

  public DataBase (Properties P){
    this.realname = P.getProperty(DB_NAME_P);
    this.dburl = P.getProperty(DB_URL_P);
    this.driver = P.getProperty(JDBC_DRIVER_P);
    this.user = P.getProperty(USER_NAME_P);
    this.passwd = P.getProperty(PASSWD_P);
  }

  /**
   * @param name the database name
   * @param dburl the jdbc database url
   * @param driver the jdbc driver
   * @param user the user name
   * @param passwd the password relative to the user name.
   */

  public DataBase (String name, String dburl, String driver, String user,
		   String passwd){
    this.realname=name;
    this.dburl = dburl;
    this.driver = driver;
    this.user = user;
    this.passwd = passwd;
  }

}
