// HttpNgClient.java
// $Id: HttpNgClient.java,v 1.1 1997/11/21 00:49:16 veillard Exp $
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.httpng.test;

import java.lang.*;
import java.io.*;
import java.net.*;

import javastubs.iluhttp.*;

/**
 * The HttpNgClient is a simple test program using HTTP-NG
 * interfaces to access Jigsaw ressources.
 */

public class HttpNgClient {
    static String serverId = "httpng-server";
    static String ih = "server root";
    static xerox.ilu.IluClassRep iluClass;

    static void dumpResponse(Response rep) {
        System.out.println("Status: " + rep.status.value());
	for (int i = 0;i < rep.headers.length;i ++)
	    System.out.println(rep.headers[i].name + ": " +
	                       rep.headers[i].value);
	System.out.println(" --- ");
	String bodyStr = new String(rep.body);
        System.out.println(bodyStr);
	System.out.println(" --- ");
    }

    public static javastubs.iluhttp.Request buildRequest() {
        javastubs.iluhttp.Request req = new Request();
	javastubs.iluhttp.Header hdrs[] = new Header[5];
	byte body[] = new byte[1];

	req.headers = hdrs;
	req.body = body;

        req.URI = "/";
	hdrs[0] =  new Header();
	hdrs[0].name = "Date";
	hdrs[0].value = "Thu, 20 Nov 1997 00:48:57 GMT";
	hdrs[1] =  new Header();
	hdrs[1].name = "Accept";
	hdrs[1].value = "*/*";
	hdrs[2] =  new Header();
	hdrs[2].name = "Accept-Encoding";
	hdrs[2].value = "gzip";
	hdrs[3] =  new Header();
	hdrs[3].name = "Host";
	hdrs[3].value = "rufus.w3.org";
	hdrs[4] =  new Header();
	hdrs[4].name = "User-Agent";
	hdrs[4].value = "Amaya/V1.1c";

	return(req);
    }

    public static void main (String args[]) {
        javastubs.iluhttp.Resource remoteObject = null;
	javastubs.iluhttp.Request req;
	javastubs.iluhttp.Response rep;

        System.out.println("< client start");
	iluClass = ResourceStub.iluClass();
	System.out.println("< iluClass built");
	try {
	    remoteObject = (javastubs.iluhttp.Resource)
	        xerox.ilu.IluSimpleBinding.lookup(serverId, ih, iluClass);
	    System.out.println("< got Resource: " + remoteObject);
	} catch (Exception e) {
	    System.out.println("< exception for lookupObject " + e);
	    xerox.ilu.IluDebug.halt("exception...");
	}
        req = buildRequest();
	/*********
	System.out.println("< before calling GET");
	rep = remoteObject.GET(req);
	System.out.println("< returned from GET");
	dumpResponse(rep);
	 **********/
	/*
	    try {
	        Thread.sleep(100);
	    } catch (Exception ex) {
	    }
	 */
	for (int i = 0;i < 1000;i++) {
	    // System.out.println("< before calling GET");
	    rep = remoteObject.GET(req);
	    // dumpResponse(rep);
	    // System.out.println("< returned from GET");
	    System.out.print(".");
	}
    }
}

