// BooleanAttributeEditor.java
// $Id: BooleanAttributeEditor.java,v 1.3 1997/07/07 13:04:15 ylafon Exp $
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigadm.editors ;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import w3c.jigsaw.admin.*;
import w3c.tools.store.*;
import w3c.jigadm.*;
import w3c.jigadm.events.*;

public class BooleanAttributeEditor extends AttributeEditor {

    private boolean origb;
    Checkbox widget;

    /**
     * Tells if the edited value has changed
     * @return true if the value changed.
     */
 
    public boolean hasChanged() {
	return !(origb == widget.getState());
    }

    /**
     * set the current value to be the original value, ie: changed
     * must return <strong>false</strong> after a reset.
     */

    public void clearChanged() {
	origb = widget.getState();
    }

    /**
     * reset the changes (if any)
     */

    public void resetChanges() {
	widget.setState(origb);
    }
    
    /**
     * Get the current value of the edited value
     * @return an object or <strong>null</strong> if the object was not
     * initialized
     */

    public Object getValue() {
	return new Boolean(widget.getState());
    }

    /**
     * Set the value of the edited value
     * @param o the new value.
     */

    public void setValue(Object o) {
	if(o instanceof Boolean) {
	    origb = ((Boolean)o).booleanValue();
	    widget.setState(origb);
	}
    }

    /**
     * get the Component created by the editor.
     * @return a Component
     */

    public Component getComponent() {
	return widget;
    }

    /**
     * Initialize the filter
     * @param w the ResourceWrapper father of the attribute
     * @param a the Attribute we are editing
     * @param o the value of the above attribute
     * @param p some Properties, used to fine-tune the editor
     */

    public void initialize(RemoteResourceWrapper w, Attribute a, Object o, 
			   Properties p)
	throws RemoteAccessException
    {
	RemoteResource r = w.getResource();
	if(o == null) {
	    if(a instanceof BooleanAttribute) {
		Object oo = null;
		// FIXME
		oo = r.getValue(a.getName());
		
		if(oo != null) {
		    origb = ((Boolean)oo).booleanValue();
		} else {
		    if(a.getDefault() != null) {
			origb = ((Boolean)a.getDefault()).booleanValue();
		    }
		}
		widget.setState(origb);
	    }
	} else {
	    if(o instanceof Boolean) {
		origb = (((Boolean)o).booleanValue());
	    }
	}
	widget.setState(origb);
    }

    public BooleanAttributeEditor() {
	widget = new Checkbox();
	origb = false;
    }
}
