// CvsCommitHandler.java
// $Id: CvsCommitHandler.java,v 1.2 1997/07/30 13:58:07 ylafon Exp $  
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.cvs;

class CvsCommitHandler extends CommitHandler implements CVS {
    CvsDirectory cvs     = null;
    long         stamp   = -1;

    void notifyEntry(String filename, int status) {
	// Add an entry for the file:
	CvsEntry entry = cvs.getFileEntry(filename);
	if ( entry == null ) 
	    cvs.createFileEntry(stamp, filename, status);
	else
	    entry.setStatus(stamp, status);
    }

    CvsCommitHandler(CvsDirectory cvs) {
	this.cvs   = cvs;
	this.stamp = System.currentTimeMillis();
    }
}
