/**
 * This file was generated by the Objective Systems ASN1C Compiler
 * (http://www.obj-sys.com).  Version: 6.0A, Date: 21-Feb-2006.
 */
#include "asn1intl.h"
#include "XSD.h"
#include "rtxsrc/rtxCommon.h"

/**************************************************************/
/*                                                            */
/*  XMLCompatibleString                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XMLCompatibleString (OSCTXT* pctxt,
   XMLCompatibleString *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_utf8str (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  String                                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_String (OSCTXT* pctxt,
   String *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_XMLCompatibleString (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NormalizedString                                          */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_NormalizedString (OSCTXT* pctxt,
   NormalizedString *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_String (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  XMLStringWithNoCRLFHT                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XMLStringWithNoCRLFHT (OSCTXT* pctxt,
   XMLStringWithNoCRLFHT *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_utf8str (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AnyURI                                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_AnyURI (OSCTXT* pctxt,
   AnyURI *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_XMLStringWithNoCRLFHT (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Language                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_Language (OSCTXT* pctxt,
   XSD_Language *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_charstr (pctxt,
      pvalue,
      tagging, (TM_UNIV|TM_PRIM|26), length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DATE_TIME                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DATE_TIME (OSCTXT* pctxt,
   DATE_TIME *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_charstr (pctxt,
      pvalue,
      tagging, (TM_UNIV|TM_PRIM|26), length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DateTime                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_DateTime (OSCTXT* pctxt,
   XSD_DateTime *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_DATE_TIME (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Date                                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_Date (OSCTXT* pctxt,
   XSD_Date *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_DATE_TIME (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Time                                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Time (OSCTXT* pctxt,
   Time *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_DATE_TIME (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AnySimpleType                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_AnySimpleType (OSCTXT* pctxt,
   AnySimpleType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_XMLCompatibleString (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Base64Binary                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Base64Binary (OSCTXT* pctxt,
   Base64Binary *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_octstr (pctxt, &pvalue->data, &pvalue->numocts, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Boolean                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Boolean (OSCTXT* pctxt,
   Boolean *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_boolean (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Byte                                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Byte (OSCTXT* pctxt,
   Byte *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_int8 (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Decimal                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Decimal (OSCTXT* pctxt,
   Decimal *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_real (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Double                                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Double (OSCTXT* pctxt,
   Double *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_real (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DURATION                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DURATION (OSCTXT* pctxt,
   DURATION *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_charstr (pctxt,
      pvalue,
      tagging, (TM_UNIV|TM_PRIM|26), length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Duration                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Duration (OSCTXT* pctxt,
   Duration *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_DURATION (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Token                                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Token (OSCTXT* pctxt,
   Token *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_NormalizedString (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Name                                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XSD_Name (OSCTXT* pctxt,
   XSD_Name *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_Token (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NCName                                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_NCName (OSCTXT* pctxt,
   NCName *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_XSD_Name (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ENTITY                                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ENTITY (OSCTXT* pctxt,
   ENTITY *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_NCName (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Float                                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Float (OSCTXT* pctxt,
   Float *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_real (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  GDay                                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_GDay (OSCTXT* pctxt,
   GDay *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_DATE_TIME (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  GMonth                                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_GMonth (OSCTXT* pctxt,
   GMonth *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_DATE_TIME (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  GMonthDay                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_GMonthDay (OSCTXT* pctxt,
   GMonthDay *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_DATE_TIME (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  GYear                                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_GYear (OSCTXT* pctxt,
   GYear *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_DATE_TIME (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  GYearMonth                                                */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_GYearMonth (OSCTXT* pctxt,
   GYearMonth *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_DATE_TIME (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  HexBinary                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_HexBinary (OSCTXT* pctxt,
   HexBinary *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_octstr (pctxt, &pvalue->data, &pvalue->numocts, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ID                                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ID (OSCTXT* pctxt,
   ID *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_NCName (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IDREF                                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_IDREF (OSCTXT* pctxt,
   IDREF *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_NCName (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Int                                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Int (OSCTXT* pctxt,
   Int *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_integer (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Integer                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Integer (OSCTXT* pctxt,
   Integer *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_integer (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Long                                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Long (OSCTXT* pctxt,
   Long *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_int64 (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NegativeInteger                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_NegativeInteger (OSCTXT* pctxt,
   NegativeInteger *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_integer (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   if (!(*pvalue <= -1)) {
      rtxErrAddStrParm (pctxt, "NegativeInteger");
      rtxErrAddIntParm (pctxt, (int)*pvalue);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NMTOKEN                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_NMTOKEN (OSCTXT* pctxt,
   NMTOKEN *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_Token (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NonNegativeInteger                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_NonNegativeInteger (OSCTXT* pctxt,
   NonNegativeInteger *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_unsigned (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   if (!(*pvalue >= 0)) {
      rtxErrAddStrParm (pctxt, "NonNegativeInteger");
      rtxErrAddIntParm (pctxt, (int)*pvalue);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NonPositiveInteger                                        */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_NonPositiveInteger (OSCTXT* pctxt,
   NonPositiveInteger *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_integer (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   if (!(*pvalue <= 0)) {
      rtxErrAddStrParm (pctxt, "NonPositiveInteger");
      rtxErrAddIntParm (pctxt, (int)*pvalue);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  QName                                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_QName (OSCTXT* pctxt,
   QName *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   memset (&pvalue->m, 0, sizeof(pvalue->m));

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode uri */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_AnyURI (pctxt, 
               &pvalue->uri, ASN1IMPL, length);
            if (stat == 0) {
               pvalue->m.uriPresent = TRUE;
            }
         }
         break;

      case 1:
         /* decode name */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D_NCName (pctxt, 
               &pvalue->name, ASN1IMPL, length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

         }
         reqcnt++;
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_PRIM|0):
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_PRIM|1):
         case (TM_CTXT|TM_CONS|1):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 1) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NOTATION                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_NOTATION (OSCTXT* pctxt,
   NOTATION *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_QName (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  PositiveInteger                                           */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_PositiveInteger (OSCTXT* pctxt,
   PositiveInteger *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_unsigned (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   if (!(*pvalue >= 1)) {
      rtxErrAddStrParm (pctxt, "PositiveInteger");
      rtxErrAddIntParm (pctxt, (int)*pvalue);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Short                                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Short (OSCTXT* pctxt,
   Short *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_int16 (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnsignedByte                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UnsignedByte (OSCTXT* pctxt,
   UnsignedByte *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_uint8 (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnsignedInt                                               */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UnsignedInt (OSCTXT* pctxt,
   UnsignedInt *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_unsigned (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnsignedLong                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UnsignedLong (OSCTXT* pctxt,
   UnsignedLong *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_uint64 (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  UnsignedShort                                             */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_UnsignedShort (OSCTXT* pctxt,
   UnsignedShort *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_uint16 (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  XMLStringWithNoWhitespace                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_XMLStringWithNoWhitespace (OSCTXT* pctxt,
   XMLStringWithNoWhitespace *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = xd_utf8str (pctxt, pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  DateOnly                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_DateOnly (OSCTXT* pctxt,
   DateOnly *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_DATE_TIME (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Day                                                       */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Day (OSCTXT* pctxt,
   Day *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_DATE_TIME (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Month                                                     */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Month (OSCTXT* pctxt,
   Month *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_DATE_TIME (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  MonthDay                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_MonthDay (OSCTXT* pctxt,
   MonthDay *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_DATE_TIME (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  Year                                                      */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_Year (OSCTXT* pctxt,
   Year *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_DATE_TIME (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  YearMonth                                                 */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_YearMonth (OSCTXT* pctxt,
   YearMonth *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_DATE_TIME (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  TimeOnly                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_TimeOnly (OSCTXT* pctxt,
   TimeOnly *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;

   stat = asn1D_DATE_TIME (pctxt, 
      pvalue, tagging, length);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   return (stat);
}

/**************************************************************/
/*                                                            */
/*  _SeqOfString                                              */
/*                                                            */
/**************************************************************/

EXTERN int asn1D__SeqOfString (OSCTXT* pctxt,
   _SeqOfString *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int count;
   int xx1;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE OF or SET OF */

   stat = xd_count (pctxt, length, &count);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   pvalue->n = count;
   ALLOC_ASN1ARRAY (pctxt, pvalue, String);

   xx1 = 0;
   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      stat = asn1D_String (pctxt, 
         &pvalue->elem[xx1], ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      xx1++;
   }
   pvalue->n = xx1;

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  AnyType                                                   */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_AnyType (OSCTXT* pctxt,
   AnyType *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int reqcnt = 0;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE */

   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);
   ccb.seqx = 0;

   while (!XD_CHKEND (pctxt, &ccb)) {
      switch (ccb.seqx) {
      case 0:
         /* decode embed_values */
         if (XD_PEEKTAG (pctxt, 0x80)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D__SeqOfString (pctxt, 
               &pvalue->embed_values, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

         }
         reqcnt++;
         break;

      case 1:
         /* decode attr */
         if (XD_PEEKTAG (pctxt, 0x81)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D__SeqOfString (pctxt, 
               &pvalue->attr, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

         }
         reqcnt++;
         break;

      case 2:
         /* decode elem_list */
         if (XD_PEEKTAG (pctxt, 0x82)) {
            stat = xd_Tag1AndLen (pctxt, &length);
            if (stat != 0) return LOG_RTERR (pctxt, stat);

            stat = asn1D__SeqOfString (pctxt, 
               &pvalue->elem_list, ASN1IMPL, length);
            if (stat == 0) {
               if (length == ASN_K_INDEFLEN) {
                  if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
                  else return LOG_RTERR (pctxt, ASN_E_INVLEN);
               }
            }
            else return LOG_RTERR (pctxt, stat);

         }
         reqcnt++;
         break;

      default:
         { ASN1TAG tag;
         int len;
         stat = xd_tag_len (pctxt, &tag, &len, 0);
         if (stat != 0) return LOG_RTERR (pctxt, stat);
         switch (tag) {
         case (TM_CTXT|TM_CONS|0):
         case (TM_CTXT|TM_CONS|1):
         case (TM_CTXT|TM_CONS|2):
            stat = RTERR_SEQORDER;
            break;
         default:
            stat = RTERR_SEQOVFLW;
            break;
         }}
      }

      if (stat != 0) return LOG_RTERR (pctxt, stat);
      else ccb.seqx++;
   }

   if (reqcnt < 3) {
      return LOG_RTERR (pctxt, RTERR_SETMISRQ);
   }
   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  ENTITIES                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_ENTITIES (OSCTXT* pctxt,
   ENTITIES *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int count;
   int xx1;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE OF or SET OF */

   stat = xd_count (pctxt, length, &count);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   pvalue->n = count;
   ALLOC_ASN1ARRAY (pctxt, pvalue, ENTITY);

   xx1 = 0;
   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      if (xx1 >= count) return LOG_RTERR (pctxt, RTERR_SEQOVFLW);

      stat = asn1D_ENTITY (pctxt, 
         &pvalue->elem[xx1], ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      xx1++;
   }
   pvalue->n = xx1;

   if (!(pvalue->n >= 1)) {
      rtxErrAddStrParm (pctxt, "ENTITIES.n");
      rtxErrAddIntParm (pctxt, (int)pvalue->n);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  IDREFS                                                    */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_IDREFS (OSCTXT* pctxt,
   IDREFS *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int count;
   int xx1;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE OF or SET OF */

   stat = xd_count (pctxt, length, &count);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   pvalue->n = count;
   ALLOC_ASN1ARRAY (pctxt, pvalue, IDREF);

   xx1 = 0;
   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      if (xx1 >= count) return LOG_RTERR (pctxt, RTERR_SEQOVFLW);

      stat = asn1D_IDREF (pctxt, 
         &pvalue->elem[xx1], ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      xx1++;
   }
   pvalue->n = xx1;

   if (!(pvalue->n >= 1)) {
      rtxErrAddStrParm (pctxt, "IDREFS.n");
      rtxErrAddIntParm (pctxt, (int)pvalue->n);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

/**************************************************************/
/*                                                            */
/*  NMTOKENS                                                  */
/*                                                            */
/**************************************************************/

EXTERN int asn1D_NMTOKENS (OSCTXT* pctxt,
   NMTOKENS *pvalue, ASN1TagType tagging, int length)
{
   int stat = 0;
   int count;
   int xx1;
   ASN1CCB ccb;

   if (tagging == ASN1EXPL) {
      stat = xd_match1 (pctxt, 0x10, &length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);
   }

   /* decode SEQUENCE OF or SET OF */

   stat = xd_count (pctxt, length, &count);
   if (stat != 0) return LOG_RTERR (pctxt, stat);

   pvalue->n = count;
   ALLOC_ASN1ARRAY (pctxt, pvalue, NMTOKEN);

   xx1 = 0;
   ccb.len = length;
   ccb.ptr = OSRTBUFPTR(pctxt);

   while (!XD_CHKEND (pctxt, &ccb))
   {
      if (xx1 >= count) return LOG_RTERR (pctxt, RTERR_SEQOVFLW);

      stat = asn1D_NMTOKEN (pctxt, 
         &pvalue->elem[xx1], ASN1EXPL, length);
      if (stat != 0) return LOG_RTERR (pctxt, stat);

      xx1++;
   }
   pvalue->n = xx1;

   if (!(pvalue->n >= 1)) {
      rtxErrAddStrParm (pctxt, "NMTOKENS.n");
      rtxErrAddIntParm (pctxt, (int)pvalue->n);
      return LOG_RTERR (pctxt, RTERR_CONSVIO);
   }

   if (tagging == ASN1EXPL && ccb.len == ASN_K_INDEFLEN) {
      if (XD_MATCHEOC (pctxt)) XD_BUMPIDX (pctxt, 2);
      else return LOG_RTERR (pctxt, ASN_E_INVLEN);
   }
   return (stat);
}

